<?php

class cp_Movie
{
    public function __construct() {
        add_action( 'init', array($this,'create_posttype') );
        add_action( 'init', array($this,'custom_post_type'),0 );
        add_action( 'init', array($this,'create_order_taxonomies'),0 );
    }

    // Our custom post type function
    public function create_posttype() {

        register_post_type( 'movie',
            // CPT Options
            array(
                'labels' => array(
                    'name' => __( 'فیلم ها' ),
                    'singular_name' => __( 'movie' )
                ),
                'supports' => array(
                    'title',
                    'editor',
                    'post-formats'
                ),
                'public' => true,
                'has_archive' => true,
                'rewrite' => array('slug' => 'movie'),
            )
        );

    }

    /*
* Creating a function to create our CPT
*/

    public function custom_post_type() {

        // Set UI labels for Custom Post Type
        $labels = array(
            'name'                => __( 'order', 'Post Type General Name', 'twentythirteen' ),
            'singular_name'       => __( 'order', 'Post Type Singular Name', 'twentythirteen' ),
            'menu_name'           => __( 'order', 'twentythirteen' ),
            'parent_item_colon'   => __( 'Parent order', 'twentythirteen' ),
            'all_items'           => __( 'All order', 'twentythirteen' ),
            'view_item'           => __( 'View order', 'twentythirteen' ),
            'add_new_item'        => __( 'Add New order', 'twentythirteen' ),
            'add_new'             => __( 'Add order', 'twentythirteen' ),
            'edit_item'           => __( 'Edit order', 'twentythirteen' ),
            'update_item'         => __( 'Update order', 'twentythirteen' ),
            'search_items'        => __( 'Search order', 'twentythirteen' ),
            'not_found'           => __( 'Not Found', 'twentythirteen' ),
            'not_found_in_trash'  => __( 'Not found in Trash', 'twentythirteen' ),
        );

        // Set other options for Custom Post Type

        $args = array(
            'label'               => __( 'movie', 'twentythirteen' ),
            'description'         => __( 'order order and reviews', 'twentythirteen' ),
            'labels'              => $labels,
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields' ),
            // You can associate this CPT with a taxonomy or custom taxonomy.
            //'taxonomies'          => array( 'genres' ),
            /* A hierarchical CPT is like Pages and can have
            * Parent and child items. A non-hierarchical CPT
            * is like Posts.
            */
            'hierarchical'        => false,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'page'
        );

        // Registering your Custom Post Type
        register_post_type( 'movie', $args );

    }

    public function create_order_taxonomies() {
        // Add new taxonomy, make it hierarchical (like categories)
        $labels = array(
            'name'              => _x( 'دسته بندی ها', 'taxonomy general name', 'twentythirteen' ),
            'singular_name'     => _x( 'دسته بندی ها', 'taxonomy singular name', 'twentythirteen' ),
            'search_items'      => __( 'جستجو دسته بندی ها', 'twentythirteen' ),
            'all_items'         => __( 'همه دسته بندی ها', 'twentythirteen' ),
            'parent_item'       => __( 'مادر دسته بندی ها', 'twentythirteen' ),
            'parent_item_colon' => __( 'مادر دسته بندی ها:', 'twentythirteen' ),
            'edit_item'         => __( 'ویرایش دسته بندی ها', 'twentythirteen' ),
            'update_item'       => __( 'بروزرسانی دسته بندی ها', 'twentythirteen' ),
            'add_new_item'      => __( 'افزودن تازه دسته بندی ', 'twentythirteen' ),
            'new_item_name'     => __( 'افزودن دسته بندی نام', 'twentythirteen' ),
            'menu_name'         => __( 'دسته بندی ها', 'twentythirteen' ),
        );

        $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array( 'slug' => 'movies' ),
        );

        register_taxonomy( 'movie-category', array( 'movie' ), $args );

        // Add new taxonomy, NOT hierarchical (like tags)
        $labels = array(
            'name'                       => _x( 'برچسب ها', 'taxonomy general name', 'twentythirteen' ),
            'singular_name'              => _x( 'برچسب', 'taxonomy singular name', 'twentythirteen' ),
            'search_items'               => __( 'جستجوی برچسب ها', 'twentythirteen' ),
            'popular_items'              => __( 'برچسب های محبوب', 'twentythirteen' ),
            'all_items'                  => __( 'همه برچسب ها', 'twentythirteen' ),
            'parent_item'                => null,
            'parent_item_colon'          => null,
            'edit_item'                  => __( 'ویرایش برچسب', 'twentythirteen' ),
            'update_item'                => __( 'بروزرسانی برچسب', 'twentythirteen' ),
            'add_new_item'               => __( 'افزودن برچسب جدید', 'twentythirteen' ),
            'new_item_name'              => __( 'افزودن نام برچسب', 'twentythirteen' ),
            'separate_items_with_commas' => __( 'برچسب ها را با کاما از هم جدا کنید', 'twentythirteen' ),
            'add_or_remove_items'        => __( 'افزودن یا حذف برچسب', 'twentythirteen' ),
            'choose_from_most_used'      => __( 'انتخاب ار بیشترین برچسب های استفاده شده', 'twentythirteen' ),
            'not_found'                  => __( 'هیچ برچسبی یافت نشد.', 'twentythirteen' ),
            'menu_name'                  => __( 'برچسب ها', 'twentythirteen' ),
        );

        $args = array(
            'hierarchical'          => false,
            'labels'                => $labels,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var'             => true,
            'rewrite'               => array( 'slug' => 'movies-tags' ),
        );

        register_taxonomy( 'movie-tags', 'movie', $args );
    }

    /* Hook into the 'init' action so that the function
    * Containing our post type registration is not
    * unnecessarily executed.
    */
}