<?php
/**
 * Register a meta box using a class.
 */
class MetaBoxTheater {

    /**
     * Constructor.
     */
    public function __construct() {
        if ( is_admin() ) {
            add_action( 'load-post.php',     array( $this, 'init_metabox' ) );
            add_action( 'load-post-new.php', array( $this, 'init_metabox' ) );
        }

    }

    /**
     * Meta box initialization.
     */
    public function init_metabox() {
        add_action( 'add_meta_boxes', array( $this, 'add_metabox'  )        );
        add_action( 'save_post',      array( $this, 'save_metabox' ), 10, 2 );
    }

    /**
     * Adds the meta box.
     */
    public function add_metabox() {
        add_meta_box(
            'my-meta-box',
            __( 'جزییات', 'textdomain' ),
            array( $this, 'render_metabox' ),
            'theater',
            'advanced',
            'default'
        );

    }

    /**
     * Renders the meta box.
     */
    public function render_metabox( $post ) {
        // Add nonce for security and authentication.
        $video_link = get_post_meta($post->ID,"video_link",true);
        
        $news_link = get_post_meta($post->ID,"c_writer",true);
        $news_link_a = get_post_meta($post->ID,"c_director",true);
        $news_link_b = get_post_meta($post->ID,"c_actors",true);
        $news_link_c = get_post_meta($post->ID,"c_related",true);
        $c_title = get_post_meta($post->ID,"c_title",true);
        ?>
<!--        <p>عنوان نمایش</p>
        <input style="width: 100%;padding: 10px;" autocomplete="false" type="text" dir="rtl" align="right" name="c_title" value="<?php echo $c_title;?>">-->
        <p>نویسنده</p>
        <input style="width: 100%;padding: 10px;" autocomplete="false" type="text" dir="rtl" align="right" name="c_writer" value="<?php echo $news_link;?>">
        <p>کارگردان</p>
        <input style="width: 100%;padding: 10px;" autocomplete="false" type="text" dir="rtl" align="right" name="c_director" value="<?php echo $news_link_a;?>">
        <p>بازیگران</p>
        <input style="width: 100%;padding: 10px;" autocomplete="false" type="text" dir="rtl" align="right" name="c_actors" value="<?php echo $news_link_b;?>">
        <hr>
<!--        <p>تگ اخبار مرتبط</p>
        <input style="width: 100%;padding: 10px;" autocomplete="false" type="text" dir="rtl" align="right" name="c_related" value="<?php echo $news_link_c;?>">-->
        
<p>کد ویدیو مرتبط</p>
<textarea rows="5" cols="5" height="100" style="width: 100%;padding: 10px;" dir="ltr" align="left" name="video_link"><?php echo $video_link;?></textarea>
        <?php
    }

    /**
     * Handles saving the meta box.
     *
     * @param int     $post_id Post ID.
     * @param WP_Post $post    Post object.
     * @return null
     */
    public function save_metabox( $post_id, $post ) {
        // Add nonce for security and authentication.
        $video_link   = $_POST['video_link '];
        $news_link   = $_POST['news_link '];
        // Check if user has permissions to save data.
        $events_meta['video_link'] = $_POST['video_link'];
        $events_meta['c_writer'] = $_POST['c_writer'];
        $events_meta['c_director'] = $_POST['c_director'];
        $events_meta['c_actors'] = $_POST['c_actors'];
/*
        $events_meta['c_related'] = $_POST['c_related'];
*/
        $events_meta['c_title'] = $_POST['c_title'];
        // Add values of $events_meta as custom fields

        foreach ($events_meta as $key => $value) { // Cycle through the $events_meta array!
            if ($post->post_type == 'revision') return; // Don't store custom data twice
            $value = implode(',', (array)$value); // If $value is an array, make it a CSV (unlikely)
            if (get_post_meta($post->ID, $key, FALSE)) { // If the custom field already has a value
                update_post_meta($post->ID, $key, $value);
            } else { // If the custom field doesn't have a value
                add_post_meta($post->ID, $key, $value);
            }
            if (!$value) delete_post_meta($post->ID, $key); // Delete if blank
        }
    }
}

new MetaBoxTheater();