<?php
function replace_core_jquery_version() {
    wp_deregister_script( 'jquery' );
    // Change the URL if you want to load a local copy of jQuery from your own server.
    wp_register_script( 'jquery', "https://code.jquery.com/jquery-3.2.1.min.js", array(), '3.2.1', false );
}
add_action( 'wp_enqueue_scripts', 'replace_core_jquery_version',1 );
add_action( 'wp_enqueue_scripts', 'LoadStyles' );
function LoadStyles() {

    wp_enqueue_style( 'materialize', get_template_directory_uri() . '/assets/css/materialize.min.css');



    //wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.css');



    wp_enqueue_style( 'owl', get_template_directory_uri() . '/assets/dist/assets/owl.carousel.css');



    wp_enqueue_style( 'owl_theme', get_template_directory_uri() . '/assets/dist/assets/owl.theme.green.css');



    //wp_enqueue_style( 'menu', get_template_directory_uri() . '/assets/css/menu.css');



    wp_enqueue_style( 'style', get_template_directory_uri() . '/assets/css/style.css');

    wp_enqueue_style( 'single', get_template_directory_uri() . '/assets/css/single.css');

    wp_enqueue_style( 'menu', get_template_directory_uri() . '/assets/css/menu.css');

    wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css');
    //wp_enqueue_style( 'responsiveslides', get_template_directory_uri() . '/assets/css/responsiveslides.css');



    wp_enqueue_script( 'materialize', '//cdnjs.cloudflare.com/ajax/libs/materialize/0.100.2/js/materialize.min.js', array(), '1.0.0', true );

    wp_enqueue_script( 'Owl', get_template_directory_uri() . '/assets/dist/owl.carousel.min.js', array(), '1.0.0', true );

    wp_enqueue_script( 'ResizeSensor', get_template_directory_uri() . '/assets/dist/ResizeSensor.min.js', array(), '1.0.0', true );

    wp_enqueue_script( 'theia-sticky-sidebar', get_template_directory_uri() . '/assets/dist/theia-sticky-sidebar.js', array(), '1.0.0', true );
	wp_enqueue_style( 'mCustomScrollbar', 'https://cdn.rawgit.com/malihu/malihu-custom-scrollbar-plugin/5f1bb9d0/jquery.mCustomScrollbar.min.css', array(), '4.0.0' );

    wp_enqueue_script( 'script', get_template_directory_uri() . '/assets/js/script.js', array(), '1.0.0', true );
    //wp_enqueue_script( 'responsiveslides', get_template_directory_uri() . '/assets/js/responsiveslides.min.js', array(), '1.0.0', true );
    wp_enqueue_script( 'mCustomScrollbar', 'https://cdn.rawgit.com/malihu/malihu-custom-scrollbar-plugin/5f1bb9d0/jquery.mCustomScrollbar.concat.min.js', array(), '1.0.0', true );
    wp_enqueue_script( 'lazyloadjq-s', '//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.6/jquery.lazy.min.js', array(), '1.0.0', true );
    wp_enqueue_script( 'lazyloadjq', '//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.6/jquery.lazy.plugins.min.js', array(), '1.0.0', true );

}

add_theme_support( 'post-thumbnails' );

function is_mobile(){
    if( wp_is_mobile() ){
        return true;
    }else{
        return false;
    }
}

function widget_area_pd() {

    register_sidebar( array(

        'name'          => 'سایدبار صفحات داخلی',

        'id'            => 'single_sidebar',

        'before_widget' => '<div class="col l12 s12 m12 sidebar">',

        'after_widget'  => '</div></div>',

        'before_title'  => '<div class="pos_rev"><div class="back_block"></div><div class="text-accent-4 center main_title_block"><p class="text_org text_med">',

        'after_title'   => '</p></div></div><div class="row">',

    ) );



    register_sidebar( array(

        'name'          => 'سایدبار صفحه اصلی',

        'id'            => 'sidebar',

        'before_widget' => '<div class="col l12 s12 m12 sidebar">',

        'after_widget'  => '</div></div>',

        'before_title'  => '<div class="pos_rev"><div class="back_block"></div><div class="text-accent-4 center main_title_block"><p class="text_org text_med">',

        'after_title'   => '</p></div></div><div class="row">',

    ) );



    register_sidebar( array(

        'name'          => 'سایدبار تمام صفحه صفحه اول',

        'id'            => 'full_sidebar',

        'before_widget' => '<div class="col l4 m12 s12 side-special-block"><div class="row">',

        'after_widget'  => '</div></div>',

        'before_title'  => '<div class="side-block-title">',

        'after_title'   => '</div>',

    ) );



    register_sidebar( array(

        'name'          => 'جایگاه تبلیغاتی بخش هدر',

        'id'            => 'head_ads',

        'before_widget' => '',

        'after_widget'  => '',

        'before_title'  => '',

        'after_title'   => '',

    ) );



    register_sidebar( array(

        'name'          => 'جایگاه تبلیغاتی بخش بالای سایدبار',

        'id'            => 'sidebar_ads',

        'before_widget' => '',

        'after_widget'  => '',

        'before_title'  => '',

        'after_title'   => '',

    ) );



    register_sidebar( array(

        'name'          => 'جایگاه تبلیغاتی بخش پایین سایدبار',

        'id'            => 'sidebar_bottom_ads',

        'before_widget' => '',

        'after_widget'  => '',

        'before_title'  => '',

        'after_title'   => '',

    ) );



    register_sidebar( array(

        'name'          => 'جایگاه تبلیغاتی متنی',

        'id'            => 'sidebar_text_ads',

        'before_widget' => '',

        'after_widget'  => '',

        'before_title'  => '',

        'after_title'   => '',

    ) );



    register_sidebar( array(

        'name'          => 'جایگاه تبلیغاتی موبایل',

        'id'            => 'mobile_ads',

        'before_widget' => '',

        'after_widget'  => '',

        'before_title'  => '',

        'after_title'   => '',

    ) );



    register_sidebar( array(

        'name'          => 'جایگاه تبلیغاتی لایت باکس',

        'id'            => 'lightbox_ads',

        'before_widget' => '',

        'after_widget'  => '',

        'before_title'  => '',

        'after_title'   => '',

    ) );



    register_sidebar( array(

        'name'          => 'جایگاه تبلیغاتی بخش فوتر',

        'id'            => 'footer_ads',

        'before_widget' => '',

        'after_widget'  => '',

        'before_title'  => '',

        'after_title'   => '',

    ) );



    register_sidebar( array(

        'name'          => 'جایگاه تبلیغاتی بخش پایین مطالب صفح اصلی',

        'id'            => 'home_bottom_ads',

        'before_widget' => '',

        'after_widget'  => '',

        'before_title'  => '',

        'after_title'   => '',

    ) );



    register_sidebar( array(

        'name'          => 'جایگاه تبلیغاتی بخش بالای مطالب اصلی',

        'id'            => 'home_top_ads',

        'before_widget' => '',

        'after_widget'  => '',

        'before_title'  => '',

        'after_title'   => '',

    ) );

}

add_action( 'widgets_init', 'widget_area_pd' );

function register_my_menus() {

    register_nav_menus(

        array('primary' => __( 'منوی بالا' ) , 'primary_footer' => __( 'منوی فوتر' ))

    );

}

add_action( 'init', 'register_my_menus' );

require_once get_template_directory() . '/include/PostType.php';

new PostType();
require_once get_template_directory() . '/include/hooks.php';

require_once get_template_directory() . '/include/widgets/Widget.php';

require_once get_template_directory() . '/include/metaboxs/MetaBox.php';

if(!class_exists("ReduxFrameWork")){

    require_once get_template_directory() . '/include/framework/ReduxCore/framework.php';

}

if(!isset($redux_demo)){

    require_once get_template_directory() . '/include/framework/sample/admin-config.php';

};

function related_post_ajax(){

    if(isset($_GET["related_post"]) && $_GET["related_post"] === "true"){

        $outpost = '';

        $obj = $_GET["post"];

        $id = $_GET["id"];

        $base = $_GET["base"];

        if ($obj == "post"){

            if($base !== "post"){

                $args = array(

                    'post_type' => $obj,

                    'post_status' => 'publish',

                    'posts_per_page' => 10, // you may edit this number

                    'orderby' => 'rand',

                    'post__not_in' => array ($id),

                );

            }else{

                $tags = wp_get_post_tags($id);

                $first_tag = $tags[0]->term_id;

                $args = array(

                    'tag__in' => array($first_tag),

                    'post__not_in' => array($id),

                    'posts_per_page' => 6,

                    'caller_get_posts' => 1

                );

            }

        }else{

            $custom_taxterms = wp_get_object_terms( $id, $obj.'-category', array('fields' => 'ids') );

            $args = array(

                'post_type' => $obj,

                'post_status' => 'publish',

                'posts_per_page' => 10, // you may edit this number

                'orderby' => 'rand',

                'post__not_in' => array ($id),

            );

        }

        $my_query = new WP_Query($args);

        if ($my_query->have_posts()) {

            while ($my_query->have_posts()) : $my_query->the_post();

                $outpost .= '<a href="'.get_the_permalink().'"><div class="col m12 no-padding slide_block tooltipped" data-position="bottom" data-delay="50" data-tooltip="'.get_the_title().'"><img class="responsive-img" src="'.get_the_post_thumbnail_url(get_the_ID(), "thumbnail").'"></div></a>';

            endwhile;



        }

        wp_reset_query();



        echo '<div class="owl-carousel owl-theme" id="owl_related_slider">'.$outpost.'</div>';

        exit();

    }

}

related_post_ajax();

add_shortcode('gallery', 'my_gallery_shortcode');

function my_gallery_shortcode($attr) {

    $post = get_post();



    static $instance = 0;

    $instance++;



    if ( ! empty( $attr['ids'] ) ) {

        // 'ids' is explicitly ordered, unless you specify otherwise.

        if ( empty( $attr['orderby'] ) )

            $attr['orderby'] = 'post__in';

        $attr['include'] = $attr['ids'];

    }



    // Allow plugins/themes to override the default gallery template.

    $output = apply_filters('post_gallery', '', $attr);

    if ( $output != '' )

        return $output;



    // We're trusting author input, so let's at least make sure it looks like a valid orderby statement

    if ( isset( $attr['orderby'] ) ) {

        $attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );

        if ( !$attr['orderby'] )

            unset( $attr['orderby'] );

    }



    extract(shortcode_atts(array(

        'order'      => 'ASC',

        'orderby'    => 'menu_order ID',

        'id'         => $post->ID,

        'itemtag'    => 'li',

        'icontag'    => 'figure',

        'captiontag' => 'figcaption',

        'columns'    => 3,

        'size'       => 'thumbnail',

        'include'    => '',

        'exclude'    => ''

    ), $attr));



    $id = intval($id);

    if ( 'RAND' == $order )

        $orderby = 'none';



    if ( !empty($include) ) {

        $_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );



        $attachments = array();

        foreach ( $_attachments as $key => $val ) {

            $attachments[$val->ID] = $_attachments[$key];

        }

    } elseif ( !empty($exclude) ) {

        $attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

    } else {

        $attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

    }



    if ( empty($attachments) )

        return '';



    if ( is_feed() ) {

        $output = "\n";

        foreach ( $attachments as $att_id => $attachment )

            $output .= wp_get_attachment_link($att_id, $size, true) . "\n";

        return $output;

    }



    $itemtag = tag_escape($itemtag);

    $captiontag = tag_escape($captiontag);

    $icontag = tag_escape($icontag);

    $valid_tags = wp_kses_allowed_html( 'post' );

    if ( ! isset( $valid_tags[ $itemtag ] ) )

        $itemtag = 'li';

    if ( ! isset( $valid_tags[ $captiontag ] ) )

        $captiontag = 'figcaption';

    if ( ! isset( $valid_tags[ $icontag ] ) )

        $icontag = 'figure';



    $columns = intval($columns);

    $itemwidth = $columns > 0 ? floor(100/$columns) : 100;

    $float = is_rtl() ? 'right' : 'left';



    $selector = "gallery-{$instance}";



    $gallery_style = $gallery_div = '';

    if ( apply_filters( 'use_default_gallery_style', true ) )

        $gallery_style = "

	    <style type='text/css'>

	    </style>

	    <!-- see gallery_shortcode() in wp-includes/media.php -->";

    $size_class = sanitize_html_class( $size );

    $gallery_div = "<div class='row'><div class='slider'><ul class='slides gallery galleryid-{$id} gallery-columns-{$columns} gallery-size-{$size_class}' id='$selector'>";

    $output = apply_filters( 'gallery_style', $gallery_style . "\n\t\t" . $gallery_div );



    $i = 0;

    foreach ( $attachments as $id => $attachment ) {

        $link = isset($attr['link']) && 'file' == $attr['link'] ? wp_get_attachment_link($id, $size, false, false) : wp_get_attachment_link($id, $size, true, false);



        $output .= "<{$itemtag} class='gallery-item'>";

        $output .= "$link";

        if ( $captiontag && trim($attachment->post_excerpt) ) {

            $output .= "<{$captiontag} class='caption center-align'><h3>" . wptexturize($attachment->post_excerpt) . "</h3></{$captiontag}>";

        }

        $output .= "</{$itemtag}>";

        if ( $columns > 0 && ++$i % $columns == 0 )

            $output .= '';

    }



    $output .= "</ul></div></div>\n";



    return $output;

}

function c_title(){

    $thetitle = get_the_title(get_the_ID()); /* or you can use get_the_title() */

    $getlength = strlen($thetitle);

    $thelength = 30;

    echo substr($thetitle, 0, $thelength);

}



function magic_get_cat($_post_type,$_feed){

    global $redux_demo;

    $categories = get_terms( 'category', 'orderby=count&hide_empty=0' );

    $temp_cats = $redux_demo[$_post_type];

    if (array_search("post",$temp_cats) === false){

        $categories = get_terms( $temp_cats[0].'-category', 'orderby=count&hide_empty=0' );

    }

    $base_cats = $redux_demo[$_feed];

    $post_types = array();

    $post_ids = array('relation' => 'OR');

    for ($i = 0; $i < 4; $i++){

        foreach ($categories as $c){

            if(array_search($c->term_id,$base_cats) !== false){

                if (array_search($post_types[$i],$post_types) === false){

                    array_push($post_types,$c->taxonomy);

                    $temp = array(

                        'taxonomy' => $c->taxonomy,

                        'field'    => 'term_id', // term_id, slug

                        'terms'    => $c->term_id,

                    );

                    array_push($post_ids,$temp);

                }

            }

        }

        $categories = get_terms( $temp_cats[$i].'-category', 'orderby=count&hide_empty=0' );

    }

    $magic = $post_ids;

    return $magic;

}

function homepage_ajax(){

    global $redux_demo;

    $output = "";

    if (isset($_GET["home_post"]) && $_GET["home_post"] === "true") {

        $count = intval($_GET["count"]);

        $offset = intval($_GET["offset"]);

        $posts = $redux_demo["home_page_post"];

        $wpb_all_query = new WP_Query(array('ignore_sticky_posts' => 1, 'offset' => $offset, 'post_type' => $posts, 'post_status' => 'publish', 'posts_per_page' => $count, 'orderby' => 'date'));

        if ($wpb_all_query->have_posts()) :

            while ($wpb_all_query->have_posts()) : $wpb_all_query->the_post();
                $d = apply_filters("get_type_tag_f");
                $output .='

                <div class="col s6 m4 l4">

                    <div class="card hoverable">

                        <div class="card-image">

                            <img src="'.get_the_post_thumbnail_url(get_the_ID(), "thumbnail").'">'.$d.'

                        </div>

                        <div class="card-action center home-action">

                            <a title="'.get_the_title().'" href="'.get_the_permalink().'"><span

                                    class="card-title text_small">'.get_the_title().'</span></a>

                        </div>

                    </div>

                </div>';

            endwhile;

        endif;

        wp_reset_postdata();

        echo $output;

        exit();

    }

}

//homepage_ajax();
require_once(get_template_directory()."/include/custom_register.php");
function callback($buffer) {      
    $buffer = str_replace('<img src="//pd.sharethis.com','<img style="display:none;" src="//pd.sharethis.com',$buffer);
    
    return $buffer; 
}

function buffer_start() { ob_start("callback"); } 
function buffer_end() { ob_end_flush(); }

add_action('after_setup_theme', 'buffer_start');
add_action('shutdown', 'buffer_end');