<?php
/**
 * Developer : MahdiY
 * Web Site  : MahdiY.IR
 * E-Mail    : M@hdiY.IR
 */

class PWS_Dokan_Core {

	/**
	 * Shipping methods.
	 *
	 * @var array
	 */
	public static $methods = [];

	/**
	 * PWS_Core constructor.
	 */
	public function __construct() {

		self::$methods = [
			'PWS_Dokan_Method',
		];

		$this->init_hooks();
	}

	/**
	 * Hook into actions and filters.
	 */
	protected function init_hooks() {
		// Actions
		add_action( 'woocommerce_shipping_init', [ $this, 'load_shipping_init' ] );

		// Filters
		add_filter( 'woocommerce_shipping_methods', [ $this, 'add_shipping_method' ] );
	}

	// Actions

	public function load_shipping_init() {
		require_once 'dokan-method.php';
	}

	// Filters

	public function add_shipping_method( $methods ) {

		foreach ( self::$methods as $new_method ) {
			if ( class_exists( $new_method ) ) {
				$methods[ $new_method ] = $new_method;
			}
		}

		return $methods;
	}

}

new PWS_Dokan_Core();