<!doctype html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="/images/logos/fav.png">
    <link rel="alternate" hreflang="fa-IR" href="https://icworldco.com/" />

    <!--Flat Icons-->
    <?php echo SEOMeta::generate(); ?>

    <?php echo OpenGraph::generate(); ?>

    <?php echo Twitter::generate(); ?>

<!-- CSRF -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel='stylesheet' href='<?php echo e(asset('frontend/css/uicons-regular-rounded/css/uicons-regular-rounded.css')); ?>'>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo e(asset('/frontend/css/owl.carousel.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('/frontend/css/owl.theme.default.min.css')); ?>"/>
 	 <meta name="google-site-verification" content="9GX9f5RJFyb_V1LT17laHrRsRiuOJcFTcCRczPPMEzI" />
    <!--Main CSS-->
    <link rel="stylesheet" href="<?php echo e(asset('/frontend/css/app.css')); ?>">

    <?php echo $__env->yieldContent('head'); ?>
</head>

<body class="ts-body">

<!--Start Of Website Header-->
<header class="header header-shadow">
    <div class="d-flex align-items-center justify-content-center" style="    background: #ffca2c;
    color: #000 !important;">
        <p style="    color: #000;
    padding: 1rem 0;
    font-weight: 600;">
            به علت نوسانات نرخ ارز
            لطفا قبل از نهایی کردن سفارش جهت استعلام موجودی و قیمت دقیق با ما تماس بگیرید
        </p>
    </div>
    <!--Top Header-->
    <div class="header-top">
        <div class="container d-flex justify-content-between header-top-inner ">
            <div class="header-left">
                <span>به فروشگاه آنلاین <strong class="color-default">دنیای آی سی</strong> خوش آمدید</span>
            </div>
            <div class="header-right">
                     <span>
                    <i class="bi bi-telephone"></i>
                    شماره تماس: <a href="tel:02166721768" class="color-default">
                             <strong>66721768-021</strong>
                         </a>
                </span>
            </div>
            <div class="phone-profile">
                <svg xmlns="http://www.w3.org/2000/svg" id="Outline" viewBox="0 0 24 24" width="20" height="20"><path d="M12,12A6,6,0,1,0,6,6,6.006,6.006,0,0,0,12,12ZM12,2A4,4,0,1,1,8,6,4,4,0,0,1,12,2Z"/><path d="M12,14a9.01,9.01,0,0,0-9,9,1,1,0,0,0,2,0,7,7,0,0,1,14,0,1,1,0,0,0,2,0A9.01,9.01,0,0,0,12,14Z"/></svg>
                <div class="ts-mr-small">
                    <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(route('profile.index')); ?>">
                            مشاهده پروفایل
                        </a>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>">
                            ورود / ثبت نام
                        </a>
                    <?php endif; ?>

                </div>
            </div>

        </div>
    </div>
    <!--Top Header End-->
    <!--navbar-->
    <div class="header-middle d-flex flex-column">
        <div class="container d-flex justify-content-between align-items-center header-middle-inner">
            <a class="hamburger-menu">
                <i class="bi bi-list"></i>
            </a>
            <div class="header-right">
                <div class="brand-logo">
                    <a href="<?php echo e(route('index')); ?>">
                        <img src="/images/logos/logo.png" alt="دنیای آی سی">
                    </a>
                </div>
            </div>
            <div class="header-center position-relative">
                <div class="search">
                    <form action="<?php echo e(route('search.show')); ?>" method="get" class="header-search">
                        <?php echo method_field('get'); ?>
                        <input type="text" class="form-control search-control" name="search" id="search"
                               placeholder="جستجو در محصولات..." autocomplete="off">
                        <button type="submit" class="btn hover-color-inherit">
                            <i class="fi fi-rr-search line-height-0"></i>
                        </button>
                    </form>
                    <div class="ajax-search-wrapper" id="ajax-search-wrapper">
                        <div class="d-flex justify-content-center">
                            <div class="loading">
                                <div></div>
                                <div></div>
                            </div>
                        </div>
                        <div class="result">

                        </div>
                    </div>
                </div>
            </div>
            <div class="header-left">
                <div class="header-item cart-wrapper profile" id="cart-icon">
                    <div class="cart d-flex align-items-center justify-content-between">
                        <svg xmlns="http://www.w3.org/2000/svg" id="Outline" viewBox="0 0 24 24" width="20" height="20"><path d="M12,12A6,6,0,1,0,6,6,6.006,6.006,0,0,0,12,12ZM12,2A4,4,0,1,1,8,6,4,4,0,0,1,12,2Z"/><path d="M12,14a9.01,9.01,0,0,0-9,9,1,1,0,0,0,2,0,7,7,0,0,1,14,0,1,1,0,0,0,2,0A9.01,9.01,0,0,0,12,14Z"/></svg>
                        <div class="ts-mr-small hide-in-mobile">
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(route('profile.index')); ?>">
                                    <p>پروفایل</p>
                                    سلام!
                                </a>
                                <div class="profile-submenu">
                                    <ul>
                                        <li>
                                            <a href="<?php echo e(route('profile.index')); ?>">
                                                <i class="fi fi-rr-shop align-middle line-height-0"></i>
                                                مشاهده سفارشات
                                            </a>
                                        </li>
                                        <li>
                                            <form action="<?php echo e(route('logout')); ?>" method="post" id="log-out">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('post'); ?>
                                            </form>
                                            <a onclick="event.preventDefault(); $('#log-out').submit()" class="text-danger">
                                                <i class="fi fi-rr-sign-out-alt align-middle line-height-0"></i>
                                                خروج
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>">
                                    <p>پروفایل</p>
                                    ورود / ثبت نام
                                </a>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>

                <a href="<?php echo e(route('cart.show')); ?>">
                    <?php
                        $cart = Cart::instance('cart-ic-world')->all();
                    ?>
                    <div class="header-item cart-wrapper" id="cart-icon">
                        <div class="cart d-flex align-items-center justify-content-between">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 40 40" fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M36.7516 9.7701L39.1666 25.7551C40.1441 32.7509 35.3333 39.1143 28.8166 39.1718H11.0683C4.66662 39.1718 -0.201715 32.7509 0.833285 25.7551L3.24828 9.7701C3.82161 4.48465 8.17158 0.411636 13.4833 0.186768H26.5166C31.8283 0.411636 36.1783 4.48465 36.7516 9.7701ZM28.8741 36.2393C30.9321 36.2095 32.8732 35.2775 34.1833 33.6901C35.9403 31.6092 36.7031 28.8659 36.2724 26.1768L33.915 10.1918C33.5783 6.28998 30.4265 3.22799 26.5166 3.00427H13.4833C9.5734 3.22799 6.42159 6.28998 6.08495 10.1918L3.72745 26.1768C3.29679 28.8659 4.0596 31.6092 5.81662 33.6901C7.12668 35.2775 9.06779 36.2095 11.1258 36.2393H28.8741Z" fill="black"/>
                                <path d="M26.0374 10.1534C25.2435 10.1534 24.5999 10.797 24.5999 11.5909C24.5999 14.1315 22.5404 16.1909 19.9999 16.1909C17.4594 16.1909 15.3999 14.1315 15.3999 11.5909C15.3999 10.797 14.7563 10.1534 13.9624 10.1534C13.1685 10.1534 12.5249 10.797 12.5249 11.5909C12.5249 14.2615 13.9496 16.7292 16.2624 18.0645C18.5752 19.3998 21.4246 19.3998 23.7374 18.0645C26.0502 16.7292 27.4749 14.2615 27.4749 11.5909C27.4646 10.8013 26.827 10.1638 26.0374 10.1534V10.1534Z" fill="black"/>
                            </svg>
                            <div class="ts-mr-small hide-in-mobile">
                                <p>سبد خرید</p>
                                <?php echo e($cart->count()); ?>

                                محصول
                            </div>
                        </div>
                    </div>

                </a>
            </div>

        </div>
    </div>
    <!--navbar End-->

    <!--Header Bottom-->
    <nav class="header-bottom">
        <div class="container d-flex justify-content-between align-items-center header-bottom-inner">
            <div class="header-left">
                <!--start of categories menu-->
                <div class="header-categories-menu">
                    <a href="#" class="category-toggle">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 46 46" fill="none">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.77844 3.83334H16.7709C19.1527 3.83334 21.0834 5.76412 21.0834 8.14584V12.305C21.0834 14.6867 19.1527 16.6175 16.7709 16.6175H8.77844C6.39671 16.6175 4.46594 14.6867 4.46594 12.305V8.14584C4.46594 5.76412 6.39671 3.83334 8.77844 3.83334ZM16.7709 13.7425C17.5605 13.7322 18.1981 13.0946 18.2084 12.305V8.14584C18.1981 7.35625 17.5605 6.71867 16.7709 6.70834H8.77844C7.98885 6.71867 7.35127 7.35625 7.34094 8.14584V12.305C7.35127 13.0946 7.98885 13.7322 8.77844 13.7425H16.7709Z" fill="black"/>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M30.5133 3.83334H37.2217C39.6034 3.83334 41.5342 5.76412 41.5342 8.14584V21.2367C41.5342 23.6184 39.6034 25.5492 37.2217 25.5492H30.5133C29.368 25.5543 28.2682 25.1016 27.4583 24.2917C26.6484 23.4819 26.1957 22.382 26.2008 21.2367V8.14584C26.2008 5.76412 28.1316 3.83334 30.5133 3.83334ZM37.2217 22.6742C38.0156 22.6742 38.6592 22.0306 38.6592 21.2367V8.14584C38.6489 7.35625 38.0113 6.71867 37.2217 6.70834H30.5134C29.7195 6.70834 29.0759 7.35193 29.0759 8.14584V21.2367C29.0707 21.6195 29.2205 21.9882 29.4912 22.2589C29.7619 22.5296 30.1306 22.6794 30.5134 22.6742H37.2217Z" fill="black"/>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M30.5133 30.6667H37.2216C39.6034 30.6667 41.5341 32.5975 41.5341 34.9792V37.8542C41.5341 40.2359 39.6034 42.1667 37.2216 42.1667H30.5133C28.1316 42.1667 26.2008 40.2359 26.2008 37.8542V34.9792C26.2008 32.5975 28.1316 30.6667 30.5133 30.6667ZM37.2216 39.2917C38.0112 39.2814 38.6488 38.6438 38.6591 37.8542V34.9792C38.6488 34.1896 38.0112 33.552 37.2216 33.5417H30.5133C29.7194 33.5417 29.0758 34.1853 29.0758 34.9792V37.8542C29.0758 38.6481 29.7194 39.2917 30.5133 39.2917H37.2216Z" fill="black"/>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.77844 21.7159H16.7709C19.1527 21.7159 21.0834 23.6467 21.0834 26.0284V37.8542C21.0834 40.236 19.1527 42.1667 16.7709 42.1667H8.77844C6.39671 42.1667 4.46594 40.236 4.46594 37.8542V26.0284C4.46594 23.6467 6.39671 21.7159 8.77844 21.7159ZM16.7709 39.2917C17.5605 39.2814 18.1981 38.6438 18.2084 37.8542V26.0284C18.1981 25.2388 17.5605 24.6012 16.7709 24.5909H8.77844C7.98885 24.6012 7.35127 25.2388 7.34094 26.0284V37.8542C7.35127 38.6438 7.98885 39.2814 8.77844 39.2917H16.7709Z" fill="black"/>
                        </svg>
                        <span class="ts-mr-small">دسته بندی ها</span>
                    </a>

                    <div class="categories-menu">
                        <ul>
                            <?php echo $__env->make('frontend.layouts.partials.menu.category', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </ul>
                    </div>
                </div>
                <!--end of categories menu-->

                <!--Start of main menu-->
                <div class="position-relative">
                    <div class="menu-container">
                        <div class="canvas-overlay"></div>
                        <div class="menu-wrapper">
                            <form action="<?php echo e(route('search.show')); ?>" method="get" class="header-search d-lg-none m-2">
                                <?php echo method_field('get'); ?>
                                <input type="text" class="form-control search-control" name="search" id="search"
                                       placeholder="جستجو در محصولات..." autocomplete="off">
                                <button type="submit" class="btn hover-color-inherit">
                                    <i class="fi fi-rr-search"></i>
                                </button>
                            </form>
                            <ul class="menu hide-in-mobile-flex">
                                <?php echo $__env->make('frontend.layouts.partials.menu.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </ul>
                            <div class="tab tab-solid show-in-mobile mb-0">
                                <ul class="nav nav-tabs justify-content-around" id="myTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="tab-1" data-bs-toggle="tab"
                                                data-bs-target="#tab1" type="button" role="tab"
                                                aria-controls="tab1" aria-selected="true">
                                            دسته بندی ها
                                        </button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="tab-2" data-bs-toggle="tab"
                                                data-bs-target="#tab2" type="button" role="tab"
                                                aria-controls="tab2" aria-selected="false">
                                            منو
                                        </button>
                                    </li>
                                </ul>
                            </div>
                            <div class="tab-content show-in-mobile">
                                <div class="tab-pane fade active show" id="tab1" role="tabpanel" aria-labelledby="tab-1">
                                    <div class="categories-menu">
                                        <ul>
                                            <?php echo $__env->make('frontend.layouts.partials.menu.category', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </ul>
                                    </div>

                                </div>
                                <div class="tab-pane fade" id="tab2" role="tabpanel" aria-labelledby="tab-2">
                                    <ul class="menu">
                                        <?php echo $__env->make('frontend.layouts.partials.menu.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--end of main menu-->
            </div>
        </div>
    </nav>
    <!--Header Bottom End-->
</header>
<!-- End Of Website Header -->


<?php /**PATH /home/icworldco/core/resources/views/frontend/layouts/partials/header.blade.php ENDPATH**/ ?>