<?php

namespace App\Providers;

use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Modules\Main\Entities\Main;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $product_cards_style = 'style-1';
        $menus = \Modules\Menu\Entities\Menu::with('children')
            ->whereNull('parent_id')
            ->get();;
        $categories = \Modules\Category\Entities\Category::where('category_type', \Modules\Product\Entities\Product::class)
            ->with('children')
            ->whereNull('parent_id')
            ->get();
        View::share([
            'product_cards_style' => $product_cards_style,
            'menus' => $menus,
            'categories' => $categories
        ]);

        Paginator::useBootstrap();

    }
}
