<?php

namespace Modules\User\Http\Controllers\Front;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Address\Entities\Address;
use Modules\Address\Entities\City;
use Modules\Order\Entities\Order;
use Modules\User\Entities\User;

class UserController extends Controller
{
    use SEOTools;
    public function __construct()
    {
        $this->middleware('can:view,order')->only('orderDetails');
        $this->middleware('can:edit,user')->only('settingsUpdate');
        $this->middleware('can:edit,address')->only('addressUpdate');
        $this->middleware('can:view,address')->only('addressEdit');
    }

    public function index()
    {
        $this->seo()->setTitle('خلاصه فعالیت');
        return view('user::frontend.partials.content.home');
    }

    public function orders()
    {
        $orders = Order::where('user_id' , auth()->user()->id)->latest()->simplePaginate(10);
        $this->seo()->setTitle('سفارش های شما');
        return view('user::frontend.partials.content.orders' , compact('orders'));
    }

    public function settings()
    {
        $this->seo()->setTitle('ویرایش حساب');
        return view('user::frontend.partials.content.settings');
    }

    public function settingsUpdate(User $user , Request $request)
    {
        $validData = $request->validate([
            'name' => 'required',
            'last_name' => 'required',
        ]);
        $user->update($validData);
        alert()->success('موفق' , 'به روز رسانی با موفقیت انجام شد.');
        return back();
    }

    public function addresses()
    {
        $this->seo()->setTitle('آدرس های شما');

        $addresses = Address::where('user_id' , auth()->user()->id)->get();
        return view('user::frontend.partials.content.address' , compact('addresses'));

    }

    public function addressEdit(Address $address)
    {
        $this->seo()->setTitle('ویرایش آدرس');
        $cities = City::all();
        return view('user::frontend.partials.content.address-edit' , ['address' => $address , 'cities' => $cities]);
    }

    public function addressUpdate(Address $address , Request $request)
    {
        $validData = $request->validate([
           'city_id' => 'required',
           'postal_code' => 'required',
           'address' => 'required|min:10',
        ]);

        $address->update($validData);

        alert()->success('موفق' , 'عملیات با موفقیت انجام شد');

        return back();
    }

    public function orderDetails(Order $order)
    {
        $this->seo()->setTitle("جزئیات سفارش $order->order_code");
        return view('user::frontend.partials.content.order-details' , compact('order'));
    }
}
