<?php

namespace Modules\SiteMap\Http\Controllers\Front;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Category\Entities\Category;
use Modules\Post\Entities\Post;
use Modules\Product\Entities\Product;

class SiteMapController extends Controller
{

    protected Post $postModel;
    protected Category $categoryModel;
    protected Product $productModel;

    public function __construct()
    {
        $this->postModel = new Post();
        $this->categoryModel = new Category();
        $this->productModel = new Product();
    }

    public function index()
    {
        return response()->view('sitemap::index')->header('Content-Type', 'text/xml');
    }

    public function static()
    {
        return response()->view('sitemap::static')->header('Content-Type', 'text/xml');
    }

    public function post()
    {
        $posts = $this->postModel->where('status' , 1)->latest()->get();
        return response()->view('sitemap::post', compact('posts'))->header('Content-Type', 'text/xml');
    }


    public function product()
    {
        $products = $this->productModel->where('status' , 1)->latest()->get();
        return response()->view('sitemap::product', compact('products'))->header('Content-Type', 'text/xml');
    }

    public function productCategory()
    {
        $categories = $this->categoryModel->where('category_type' , Product::class)->get();
        return response()->view('sitemap::productCategory', compact('categories'))->header('Content-Type', 'text/xml');
    }

}
