<?php

namespace Modules\Main\Http\Controllers\Front;

use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Carbon;
use Modules\Product\Entities\Product;

class MainController extends Controller
{
    use SEOTools;
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $this->seo()
            ->setTitle('فروشگاه تخصصی قطعات الکترونیک')
            ->setDescription('فروشگاه آنلاین دنیای آی سی بزرگترین مرکز تخصصی فروش قطعات الکترونیکی در ایران میباشد. فروش آنلاین کانکتور، آی سی، خازن، مقاومت، بر الکترونیک، تجهیزات موبایل، ولوم، خرید سنسور و..');
        SEOMeta::addKeyword('فروش, قیمت, دنیای آی سی, کانکتور , کانکتور مخابراتی , کانکتور نظامی , خرید آردوینو, خرید رزبری پای, خرید ماژول, خرید سنسور, الکترونیک, خازن, مقاومت, تجهیزات موبایل, ابزار و تجهیزات, برد الکترونیک, کیت رباتیک, فروشگاه اینترنتی, خرید آی سی, قطعات الکترونیک ');
        return view('welcome');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('main::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('main::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('main::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
