# تغییرات پلاگین ووکامرس زرین‌پال

## نسخه جدید - ویژگی کسر کارمزد از خریدار

### ویژگی‌های جدید:

1. **انتخاب کسر کارمزد از پذیرنده یا خریدار**
   - در تنظیمات پلاگین، گزینه جدید "کسر کارمزد از" اضافه شده
   - دو گزینه موجود: "پذیرنده (پیش‌فرض)" و "خریدار"

2. **محاسبه خودکار کارمزد**
   - اگر "کسر کارمزد از خریدار" انتخاب شود، کارمزد به صورت خودکار محاسبه می‌شود
   - استفاده از API محاسبه کارمزد زرین‌پال (`feeCalculation.json`)

3. **نمایش کارمزد در صفحه چک‌اوت**
   - کارمزد به عنوان یک ردیف جداگانه در صورت‌حساب نمایش داده می‌شود
   - نمایش پیام اطلاع‌رسانی برای کاربر

4. **پرداخت با مبلغ پیشنهادی**
   - استفاده از `suggested_amount` برای ارسال به درگاه
   - تضمین دریافت مبلغ دقیق پس از کسر کارمزد

5. **تأیید پرداخت با مبلغ صحیح**
   - تأیید تراکنش با `suggested_amount` در صورت کسر کارمزد از خریدار
   - حفظ سازگاری با روش‌های قبلی

6. **نمایش بهتر کارمزد در checkout**
   - نمایش مجزای کارمزد در خلاصه سفارش
   
7. **تشخیص خودکار نوع کسر کارمزد**
   - بعد از نصب/آپدیت پلاگین، تشخیص خودکار نوع کسر کارمزد
   - سینک شدن با تنظیمات حساب زرین‌پال

### تغییرات فنی:

- **ZarinpalHelperClass.php**: اضافه شدن متد `calculateFee()`
- **class-wc-gateway-zarinpal.php**: 
  - اضافه شدن فیلد تنظیمات `fee_payer`
  - متدهای `add_zarinpal_fee()` و `add_fee_notice()`
  - تغییر منطق ارسال و تأیید پرداخت
- **assets/js/index.js**: اضافه شدن JavaScript برای مدیریت تغییرات checkout

### نحوه استفاده:

1. به تنظیمات پلاگین زرین‌پال بروید
2. در بخش "تنظیمات عملیات پرداخت"، گزینه "کسر کارمزد از" را پیدا کنید
3. "خریدار" را انتخاب کنید
4. تنظیمات را ذخیره کنید

از این پس، کارمزد تراکنش به صورت‌حساب مشتری اضافه خواهد شد.

### نکات مهم:

- کارمزد فقط زمانی محاسبه می‌شود که روش پرداخت زرین‌پال انتخاب شده باشد
- محاسبه کارمزد با استفاده از API رسمی زرین‌پال انجام می‌شود
- در صورت خطا در محاسبه کارمزد، فرآیند خرید متوقف نمی‌شود
- داده‌های کارمزد در متادیتای سفارش ذخیره می‌شوند

### ویژگی‌های امنیتی:

- **عدم کش کردن**: هیچ داده‌ای در session کش نمی‌شود تا از دستکاری جلوگیری شود
- **محاسبه لحظه‌ای**: کارمزد دقیقاً قبل از ارسال به درگاه محاسبه می‌شود
- **اعتبارسنجی مبلغ**: حداکثر 10% افزایش مبلغ مجاز است
- **Timestamp امنیتی**: داده‌های کارمزد حداکثر 1 ساعت معتبر هستند
- **تطبیق مبلغ**: مبلغ اصلی با مبلغ ذخیره شده تطبیق داده می‌شود
- **ذخیره سمت سرور**: تمام داده‌ها در متادیتای سفارش (سمت سرور) ذخیره می‌شوند 