@component('user::frontend.partials.content')
    <div class="single-product">
        <h3>اطلاعات حساب کاربری</h3>
        <div class="row">
            <form method="post" action="{{route('profile.user.update' , auth()->user())}}" id="store">
                @csrf
                @method('patch')
            </form>
            <div class="col-md-6">
                <label for="name">نام</label>
                <input form="store" type="text" id="name" name="name"
                       class="form-control br-small @error('name') is-invalid @enderror" value="{{old('name' , auth()->user()->name)}}">
                @error('name')
                <span class="invalid-feedback">
                    <strong>
                        {{$message}}
                    </strong>
                </span>
                @enderror
            </div>
            <div class="col-md-6">
                <label for="last_name">نام خانوادگی</label>
                <input form="store" type="text" id="last_name" name="last_name"
                       class="form-control br-small @error('last_name') is-invalid @enderror" value="{{old('last_name' , auth()->user()->last_name)}}">
            @error('last_name')
                <span class="invalid-feedback">
                    <strong>
                        {{$message}}
                    </strong>
                </span>
            @enderror
            </div>
            <div class="col-md-6 mt-4">
                <label for="phone">
                    موبایل (غیر قابل تغییر)
                    <i class="fi fi-rr-shield-check align-middle line-height-0 text-success"></i>
                    <span class="text-success">تایید شده</span>
                </label>
                <input type="text" id="phone" name="phone" class="form-control br-small" value="{{auth()->user()->phone}}" disabled>
            </div>

        </div>
        <a onclick="event.preventDefault(); $('#store').submit()" class="btn btn-outline-primary br-1 mt-2">به روز رسانی</a>

    </div>
@endcomponent
