@component('backend.layouts.components.main',['title' => 'مدیریت کاربران','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">افزودن کاربر جدید</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">جزئیات کاربر</h4>
            </div>
            <div class="card-body">
                <div class="basic-form">
                    <form action="{{route('admin.users.store')}}" method="post" id="store">
                        @csrf
                        @method('post')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">نام</label>
                            <div class="col-sm-9">
                                <input name="name" type="text"
                                       class="form-control input-rounded @error('name') is-invalid @enderror"
                                       placeholder="نام" value="{{old('name')}}">
                                @error('name')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">نقش</label>
                            <div class="col-sm-9">
                                <div class="dropdown bootstrap-select form-control default-select dropup">
                                    <select name="role"
                                            class="form-control default-select input-rounded @error('role') is-invalid @enderror" id="sel1" tabindex="-98">
                                        <option value="">انتخاب کنید</option>
                                        @foreach($roles as $role)
                                            <option value="{{$role->id}}" @if($role->id==5)selected @endif>{{$role->label}}</option>
                                        @endforeach
                                    </select>
                                    @error('role')
                                    <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>

                                    @enderror
                                </div>

                            </div>

                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">رمز عبور (فقط در صورتی که کاربر ادمین باشد)</label>
                            <div class="col-sm-9">
                                <input name="password" type="password"
                                       class="mt-2 form-control input-rounded @error('password') is-invalid @enderror"
                                       placeholder="رمز عبور">
                                @error('password')
                                <span class="invalid-feedback">
                                    <strong>
                                        {{$message}}
                                    </strong>
                                </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">موبایل</label>
                            <div class="col-sm-9">
                                <input name="phone" type="text"
                                       class="mt-2 form-control input-rounded @error('phone') is-invalid @enderror"
                                       placeholder="موبایل" value="{{old('phone')}}">
                                @error('phone')
                                <span class="invalid-feedback">
                                    <strong>
                                        {{$message}}
                                    </strong>
                                </span>
                                @enderror
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.users.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای ایجاد کاربر جدید، روی دکمه "ساختن" کلیک کنید.
                </p>
                <div class="row">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-save"></i>
                            ساختن
                        </button>
                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}
    <script>

    </script>
@endcomponent
