<?php

if (!defined('ABSPATH')) {
    exit;
}


function digits_box_footer($style)
{

    ?>
    <div class="digits_site_footer_box">
        <?php
        if (!empty($style['dark_logo']) && !empty($style['light_logo']) && !isset($style['no_logo'])) {
            ?>
            <div class="digits_site_logo">
                <picture>
                    <?php
                    if (!empty($style['dark_logo'])) {
                        $logo = esc_attr($style['dark_logo']);
                        ?>
                        <source srcset="<?php echo esc_attr($logo); ?>" media="(prefers-color-scheme:dark)">
                        <?php
                    }
                    $logo = esc_attr($style['light_logo']);
                    ?>
                    <img src="<?php echo esc_attr($logo); ?>">
                </picture>
            </div>
            <?php
        }
        if (show_protected_by_digits()) {
            ?>
            <div class="protected_by_digits">
                <span class="protected_by_digits_text"><?php esc_attr_e('Protected by', 'digits'); ?>&nbsp;</span>
                <span class="protected_by_digits_logo">
                   <a href="https://digits.unitedover.com/" target="_blank">دیجیتس</a>
                </span>
            </div>
            <?php
        }
        ?>
    </div>
    <?php
}

add_action('digits_box_wrapper', 'digits_box_footer');
