<?php
/* Template Name: About Us*/
get_header();
$post_thumbnail_id = get_post_thumbnail_id( get_the_ID() );
$post_thumbnail_url = wp_get_attachment_image_url( $post_thumbnail_id, 'full' );
$image = get_field('about_img');
$goal_img = get_field('goal_img');
$about_goal = get_field('about_goal');
?>
<div class="page-header" style="background:transparent url(<?php echo $post_thumbnail_url;?>) center no-repeat">
    <div class="page-header-overlay"></div>
    <div class="container">
        <div class="row">
            <div class="col-12 page-head">
                <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                    <?php echo get_the_title(); ?>
                </h1>
                <?php get_template_part('templates/content/breadcrumb'); ?>
            </div>
        </div>
    </div>
</div>
<div class="page-wrap about-page">
    <div class="bg-shape abs-shape"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/pattern-4.svg" alt=""></div>
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-7">
                <article class="page-article pt-5">
                    <div class="about-title">
                        <span class="top-title">Royal Sterling</span>
                        <h2 class="title">About Company</h2>
                    </div>
                    <div class="text"><?php the_content(); ?></div>
                </article>
            </div>
            <div class="col-12 col-md-5">
                <?php if ($image) { ?>
                    <div class="image radius">
                        <img
                            src="<?php echo $image['url']; ?>"
                            width="<?php echo $image['width']; ?>"
                            height="<?php echo $image['height']; ?>"
                            alt="<?php echo $image['alt']; ?>" />
                    </div>
                <?php } ?>
            </div>
        </div>
        <div class="row goal-section position-relative">
      
            <div class="col-12 col-md-6">
                <?php if ($goal_img) { ?>
                    <div class="image radius">
                        <img
                            src="<?php echo $goal_img['url']; ?>"
                            width="<?php echo $goal_img['width']; ?>"
                            height="<?php echo $goal_img['height']; ?>"
                            alt="<?php echo $goal_img['alt']; ?>" />
                    </div>
                <?php } ?>
            </div>
            <div class="col-12 col-md-6">
                <div class="about-content goal">
                    <div class="about-title">
                        <span class="top-title">Our Goals</span>
                        <h2 class="title">Company Goals</h2>
                    </div>
                    
                    <div class="text">
                        <?php echo $about_goal; ?>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php get_footer(); ?>
