<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action('woocommerce_before_single_product');

if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}

?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class('', $product); ?>>
    <section class="single-product-top pb-48">
        <div class="row">
            <div class="col-12 col-md-6 col-lg-5">
                <div class="swiper-container-wrapper">
                    <?php
                    /**
                     * Hook: woocommerce_before_single_product_summary.
                     *
                     * @hooked woocommerce_show_product_sale_flash - 10
                     * @hooked woocommerce_show_product_images - 20
                     */
                    do_action('woocommerce_before_single_product_summary');
                    ?>
                </div>
            </div>
            <div class="col-12 col-md-6 col-lg-4">
                <div class="summary entry-summary">
                    <?php
                    /**
                     * Hook: woocommerce_single_product_summary.
                     *
                     * @hooked woocommerce_template_single_title - 5
                     * @hooked woocommerce_template_single_rating - 10
                     * @hooked woocommerce_template_single_price - 10
                     * @hooked woocommerce_template_single_excerpt - 20
                     * @hooked woocommerce_template_single_add_to_cart - 30
                     * @hooked woocommerce_template_single_meta - 40
                     * @hooked woocommerce_template_single_sharing - 50
                     * @hooked WC_Structured_Data::generate_product_data() - 60
                     */
                    do_action('woocommerce_single_product_summary');
                    ?>
                </div>
            </div>
            <div class="col-12 col-md-3 mobile-sticky">
                <div class="single-product-gray_box">
                    <?php if (have_rows('add_attr_product', 'option')): ?>
                        <ul class="single-product-advantages d-none d-lg-block">
                            <?php
                            $i = 0.25;
                            while (have_rows('add_attr_product', 'option')) : the_row();
                                $text = get_sub_field('text', 'option');
                                $icon = get_sub_field('icon', 'option');
                                ?>
                                <li class="d-flex align-items-center advantage-item">
                                    <figure>
                                        <img src="<?php echo $icon['url']; ?>"
                                             width="<?php echo $icon['width']; ?>"
                                             height="<?php echo $icon['height']; ?>"
                                             alt="<?php echo $icon['alt']; ?>">
                                    </figure>
                                    <span class="text"><?php echo $text; ?></span>
                                </li>
                                <?php $i += 0.25; endwhile; ?>
                        </ul>
                    <?php endif; ?>
                    <div class="d-flex mb-lg-4 justify-content-between align-items-end position-relative">
                        <?php woocommerce_template_single_price(); ?>
                        <?php woocommerce_show_product_sale_flash(); ?>
                    </div>
                    <div class="add-toCart-btn">
                        <a class="theme-btn btn-hover large" href="tel:<?php echo get_field('add_cart_phone', 'option'); ?>">
                            <span>
                                <i class="icon-phone"></i>
                                ثبت سفارش
                            </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php
    /**
     * Hook: woocommerce_after_single_product_summary.
     *
     * @hooked woocommerce_output_product_data_tabs - 10
     * @hooked woocommerce_upsell_display - 15
     * @hooked woocommerce_output_related_products - 20
     */
    do_action('woocommerce_after_single_product_summary');

    ?>

</div>

<?php do_action('woocommerce_after_single_product'); ?>
