<div id="product-<?php the_ID(); ?>" <?php wc_product_class('product-page-mode4-style', $product); ?>>

    <div class="single-product-wrap">
        <div class="product-details-container">
            <?php woocommerce_template_single_title(); ?>
            <div class="product-meta">
                <?php if($product->get_rating_count()): ?>
                    <div class="product-star-rate">
                        <?php echo wc_get_rating_html($product->get_average_rating(), $product->get_rating_count()); ?>
                        <span class="buyers-point">
                            <?php echo sprintf(__('(%d Buyers Points)', 'ahura'), $product->get_review_count()) ?>
                        </span>
                    </div>
                <?php endif; ?>
                <?php if ($product->get_sku()) : ?>
                    <span class="product-sku">
                        <span class="sku-title"><?php echo __('SKU value: ', 'ahura'); ?></span>
                        <span class="sku-value"><?php echo $product->get_sku(); ?></span>
                    </span>
                <?php endif; ?>
            </div>
            <?php woocommerce_template_single_excerpt(); ?>
            <?php if (!empty(\ahura\app\mw_options::get_single_product_before_price_custom_section_id()) && \ahura\app\mw_options::get_single_product_before_price_custom_section_id()) { ?>
                
                <div class="product-custom-area_before">
                    <?php echo ahura_render_elementor_builder_content(\ahura\app\mw_options::get_single_product_before_price_custom_section_id()); ?>
                </div>
            <?php } ?>
            <?php if($product->is_in_stock()): ?>
                <div class="product-single-inner-box product-single-cart-details-box">
                    <?php
                    \ahura\app\woocommerce::reset_and_render_single_product_summary();
                    echo '<div class="add-cart-area">';
                        woocommerce_template_single_add_to_cart();
                    echo '</div>';
                    ?>
                </div>
            <?php endif; ?>
            <?php if (!empty(\ahura\app\mw_options::get_single_product_after_price_custom_section_id()) && \ahura\app\mw_options::get_single_product_after_price_custom_section_id()) { ?>
                
                <div class="product-custom-area_after">
                    <?php echo ahura_render_elementor_builder_content(\ahura\app\mw_options::get_single_product_after_price_custom_section_id()); ?>
                </div>
            <?php } ?>
        </div>
        <div class="product-gallery-container">
            <?php woocommerce_show_product_sale_flash(); ?>
            <?php woocommerce_show_product_images(); ?>
        </div>
    </div>

    <div class="single-product-upsell">
        <?php woocommerce_upsell_display(); ?>
    </div>
    <div class="single-product-bottom-wrap">
        <?php woocommerce_output_product_data_tabs(); ?>
    </div>
    <div class="single-product-related">
        <?php woocommerce_output_related_products(); ?>
    </div>
</div>