<?php
/**
 *
 * woocommerce::handle_shop_sub_categories_template
 *
 */
?>
<div class="shop-sub-categories">
    <h3><?php echo __('Categories', 'ahura') ?></h3>
    <div class="swiper product-cats">
        <div class="swiper-wrapper">
            <?php foreach ($terms as $term): ?>
                <div class="swiper-slide">
                    <div class="product-category product-cat-<?php echo esc_attr($term->slug) ?>">
                        <a href="<?php echo esc_url(get_term_link($term)) ?>">
                            <?php if ($term->count): ?>
                                <span class="cat-count"><?php echo $term->count ?></span>
                            <?php endif; ?>
                            <?php woocommerce_subcategory_thumbnail($term); ?>
                            <h4 class="cat-title">
                                <?php echo $term->name; ?>
                            </h4>
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>