<?php

$attributes = $product->get_attributes();

if ( ! empty( $attributes ) ) : ?>
    <div class="product-attributes">
        <ul>
            <?php 
            $count = 0;
            foreach ( $attributes as $attribute ) :
                if ( $count >= 3 ) break;

                $label = wc_attribute_label( $attribute->get_name() );

                if ( $attribute->is_taxonomy() ) {
                    $values = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'names' ) );
                    $value = implode( ', ', $values );
                } else {
                    $value = $attribute->get_options();
                    $value = implode( ', ', $value );
                }
                ?>
                <li>
                    <svg xmlns="http://www.w3.org/2000/svg" width="1.2em" height="1.2em" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" d="M6 13.295L10.913 18L18 6"/></svg>
                    <span class="attr-title"><?php echo esc_html( $label ); ?>:</span><span class="attr-value"><?php echo esc_html( $value ); ?></span>
                </li>
                <?php 
                $count++;
            endforeach; ?>
        </ul>
    </div>
<?php endif;