<div class="related-posts related-posts-3">
    <span class="related-posts-title"><?php echo __( 'Related Articles', 'ahura' ); ?></span>
    <div class="row">
        <?php
        if ( $related ):
            foreach ( $related as $post ) {
                setup_postdata($post);
                $thumb_id = get_post_thumbnail_id();
                ?>
                <div class="col-12 col-md-6 mb-2">
                    <article class="post-item">
                        <a href="<?php the_permalink(); ?>">
                            <div class="post-cover">
                                <?php
                                if(has_post_thumbnail()){
                                    echo wp_get_attachment_image($thumb_id, 'full');
                                } else {
                                    ahura_placeholder_image();
                                }
                                ?>
                            </div>
                            <div class="post-det">
                                <h3 class="post-title"><?php the_title(); ?></h3>
                                <div>
                                    <span><?php the_date() ?></span>
                                </div>
                            </div>
                        </a>
                    </article>
                </div>
                <?php
            }
            wp_reset_postdata();
        else:
            ?>
            <div class="col-12">
                <?php \ahura\app\Ahura_Alert::frontNotice(__('Sorry, related posts could not be found.', 'ahura'), \ahura\app\Ahura_Alert::WARNING); ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="clear"></div>
</div>
