<?php global $post; ?>
<div class="related-posts related-posts-2">
    <span class="related-posts-title"><?php echo __( 'Related Articles', 'ahura' ); ?></span>
    <div class="row">
        <?php
        $related_onCat = get_posts( ['category__in' => wp_get_post_categories( $post->ID ), 'numberposts' => 4, 'post__not_in' => [$post->ID]] );
        $related_onTag = get_posts( ['tax_query' => [['taxonomy' => 'post_tag', 'field' => 'id', 'terms' => wp_get_post_tags( $post->ID, ['fields' => 'ids'] ) ]], 'numberposts' => 4, 'post__not_in' => [$post->ID] ] );
        if(get_theme_mod('show_relatedposts') && get_theme_mod('show_relatedposts_ontags')) {
            $related = $related_onTag;
        } else {
            $related = $related_onCat;
        }
        if ( $related ):
            foreach ( $related as $post ) {
                setup_postdata($post);
                $thumb_id = get_post_thumbnail_id();
                ?>
                <div class="col-6 col-md-3 mb-2">
                    <article class="post-item">
                        <a href="<?php the_permalink(); ?>">
                            <div class="post-cover">
                                <?php echo wp_get_attachment_image($thumb_id, 'full'); ?>
                            </div>
                            <h3 class="post-title"><?php the_title(); ?></h3>
                        </a>
                    </article>
                </div>
                <?php
            }
            wp_reset_postdata();
        else:
            ?>
            <div class="col-12">
                <?php \ahura\app\Ahura_Alert::frontNotice(__('Sorry, related posts could not be found.', 'ahura'), \ahura\app\Ahura_Alert::WARNING); ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="clear"></div>
</div>
