<?php
function ahura_comment_callback($comment, $args, $depth){
    $plus_votes = get_comment_meta(get_comment_ID(), 'comment_likes', true);
    $negative_votes = get_comment_meta(get_comment_ID(), 'comment_dislikes', true);
    ?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
    <div id="comment-<?php comment_ID() ?>" class="comment-wrap comment-body">
        <div class="img-thumbnail">
            <?php echo get_avatar($comment, 80); ?>
        </div>
        <div class="comment-block">
            <?php if ($comment->comment_approved == '0') : ?>
                <em class="approved-comment"><?php esc_html_e('Your comment is awaiting moderation.','ahura') ?></em>
            <?php endif; ?>
            <div class="comment-by">
                <strong><?php echo get_comment_author() ?></strong>
                <div class="reply-link">
                    <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                </div>
            </div>
            <div class="comment-text"><?php comment_text() ?></div>
            <div class="comment-vote comment-actions">
                <a href="#" rel="nofollow noopener" class="plus-vote" data-id="<?php comment_ID() ?>" data-action="like">
                    <i class="fas fa-angle-up"></i>
                    <span class="count"><?php echo !empty($plus_votes) ? $plus_votes : '0' ?></span>
                </a>
                <a href="#" rel="nofollow noopener" class="negative-vote" data-id="<?php comment_ID() ?>" data-action="dislike">
                    <i class="fas fa-angle-down"></i>
                    <span class="count"><?php echo !empty($negative_votes) ? $negative_votes : '0' ?></span>
                </a>
            </div>
            <span class="comment-date"><?php printf(esc_html__('%1$s at %2$s' , 'ahura'), get_comment_date(),  get_comment_time()) ?></span>
        </div>
    </div>
</li>
<?php } ?>

<div class="ah-post-comments-template ah-comments-template-2">
    <?php if (\ahura\app\mw_options::get_mod_move_post_comment_form_to_before_list()): ?>
        <?php comment_form(); ?>
    <?php endif; ?>
    <?php if ( have_comments() ) : ?>
        <h3 class="comments-box-title">
            <?php printf( _nx( 'One Comment', '%1$s Comments', get_comments_number(), 'comments title', 'ahura' ), number_format_i18n( get_comments_number() ) ); ?>
        </h3>
        <div class="comment-list">
            <?php
            wp_list_comments('avatar_size=80&callback=ahura_comment_callback');
            ?>
        </div>
        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
            <nav id="comment-nav-below" class="navigation" role="navigation">
                <div class="nav-previous"><?php previous_comments_link( __( '&larr; Previous Comments', 'ahura' ) ); ?></div>
                <div class="nav-next"><?php next_comments_link( __( 'New Comments &rarr;', 'ahura' ) ); ?></div>
            </nav>
        <?php endif; ?>
    <?php endif; ?>

    <?php if (!\ahura\app\mw_options::get_mod_move_post_comment_form_to_before_list()): ?>
        <?php comment_form(); ?>
    <?php endif; ?>

    <?php if ( ! comments_open() ) :?>
        <div class="no-comments"><?php echo __( 'Comments closed.', 'ahura' ); ?></div>
    <?php endif; ?>
</div>