const handleTestimonialCarousel13Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: 1,
            navigation: {
                nextEl: `.testimonial-carousel-13-${params.widgetID} .tc-swiper-button-next`,
                prevEl: `.testimonial-carousel-13-${params.widgetID} .tc-swiper-button-prev`,
            }
        };

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            }
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let tc_swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/testimonial_carousel13.default', function($scope, $) {
        let wrap = $scope.find('.testimonial-carousel-13'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleTestimonialCarousel13Element(sliderData);
    });
});