const handleProductPackageElement = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: params.mobilePerView,
            spaceBetween: 10,
            breakpoints: {
                640: {
                    slidesPerView: params.mobilePerView,
                },
                768: {
                    slidesPerView: params.tabletPerView,
                },
                1024: {
                    slidesPerView: params.desktopPerView,
                },
            },
        };

        if(params.autoPlay){
            options.autoplay = {
                delay: 5000,
                disableOnInteraction: false,
            };
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_product_package.default', function($scope, $) {
        let wrap = $scope.find('.ah-product-package-element'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleProductPackageElement(sliderData);
    });
});

jQuery(document).ready(function ($){
    let toggleProductPackageLoader = function (wrap){
        let loader =  wrap.find('.is-element-loader');

        if(loader.hasClass('is-doing')){
            loader.removeClass('is-doing');
            loader.fadeOut();
        } else {
            loader.addClass('is-doing');
            loader.fadeIn();
        }
    }

    $(document).on('click', '.ah-product-package-element .buy-package', function (e){
        e.preventDefault();
        let btn = $(this),
            wrap = btn.closest('.ah-product-package-element'),
            ids = btn.data('ids');

        $.ajax({
            url: product_package_data.ajax_url,
            data: {
                action: 'ahura_product_package_multiple_element',
                ids: ids
            },
            type: 'POST',
            dataType: 'json',
            beforeSend: function (){
                toggleProductPackageLoader(wrap);
            },
            success: function (res){
                ahuraShowFixedMessage(res.data.msg, (res.success ? 'success' : 'error'));

                if(res.success && res.data.redirect){
                    ahuraAutoRedirect(res.data.redirect)
                } else {
                    toggleProductPackageLoader(wrap);
                }
            },
            error: function (e){
                toggleProductPackageLoader(wrap);
            }
        })
    });

    $(document).on('click', '.ah-product-package-element .buy-product', function (e){
        e.preventDefault();
        let btn = $(this),
            wrap = btn.closest('.ah-product-package-element'),
            id = btn.data('id');

        $.ajax({
            url: product_package_data.ajax_url,
            data: {
                action: 'ahura_product_package_single_element',
                id: id
            },
            type: 'POST',
            dataType: 'json',
            beforeSend: function (){
                toggleProductPackageLoader(wrap);
            },
            success: function (res){
                ahuraShowFixedMessage(res.data.msg, (res.success ? 'success' : 'error'));

                if(res.success && res.data.redirect){
                    ahuraAutoRedirect(res.data.redirect)
                } else {
                    toggleProductPackageLoader(wrap);
                }
            },
            error: function (e){
                toggleProductPackageLoader(wrap);
            }
        })
    })
});