jQuery(document).ready(function ($) {
    var body = $('body');

    body.on('click', '.post-tab2 .pt-item-btn', function (e) {
        e.preventDefault();
        let btn = $(this),
            gridWrap = $(`.post-tab2-wrap-${btn.data('wid')}`),
            tabContentWrap = $(btn.data('tab')),
            tabItems = gridWrap.find('.pt-tab2-items ul'),
            tabs = gridWrap.find('.pt-tab2-content-wrap'),
            tabContent = tabContentWrap.find('.pt-tab2-content'), appended, color;

        if (btn.parent().hasClass('active')) {
            return false;
        }

        if (tabContent.find('.post-item2').length > 0 || tabContent.find('.mw_element_error').length > 0) {
            tabItems.find('.active').removeClass('active');
            btn.parent().addClass('active');
            tabs.removeClass('active').hide();
            tabContentWrap.addClass('active').show();
        } else {
            $.ajax({
                url: ahura_data.ajax_url,
                data: {
                    action: 'ahura_post_tab2_ajax',
                    settings: btn.data('settings')
                },
                type: 'POST',
                dataType: 'html',
                success: function (res) {
                    tabContent.html(res);
                    tabItems.find('.active').removeClass('active');
                    btn.parent().addClass('active');
                    tabs.removeClass('active').hide();
                    tabContentWrap.addClass('active').show();
                },
                error: function () {
                    console.error('posts not found!');
                }
            });
        }
    });
});