const handlePostCarousel11Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: params.mobilePerView,
            spaceBetween: 20,
            breakpoints: {
                640: {
                    slidesPerView: params.mobilePerView,
                    spaceBetween: 10,
                },
                768: {
                    slidesPerView: params.tabletPerView,
                    spaceBetween: 20,
                },
                1024: {
                    slidesPerView: params.slidesPerView,
                    spaceBetween: 20,
                },
            },
        };

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: true,
            };
        }

        if(params.pagination){
            options.pagination = {
                el: '.swiper-pagination',
                type: 'progressbar',
            };
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let img_swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/post_carousel11.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel11'),
            slider = wrap.find('.posts-carousel'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handlePostCarousel11Element(sliderData);
    });
});