const handleItemsCarousel3Element = function (params) {
    let autoplayOn = true;

    let options = {
        loop: true,
        breakpoints: {
            640: {
                slidesPerView: 1,
                spaceBetween: 10,
            },
            768: {
                slidesPerView: 1,
                spaceBetween: 15,
            },
            1024: {
                slidesPerView: 1,
                spaceBetween: 20,
            },
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
            bulletClass: 'swiper-pagination-bullet',
            bulletActiveClass: 'swiper-pagination-bullet-active',
            renderBullet: function (index, className) {
                return '<span class="' + className + '"><span class="progress-fill"></span></span>';
            }
        },
        autoplay: autoplayOn ? {
            delay: params.playDelay,
            disableOnInteraction: false,
        } : false,
        observer: params.observer || false,
        observeParents: params.observeParents || false,
        on: {
            init: function () {
                setTimeout(function () {
                    startProgressBar(this);
                }.bind(this), 10);
            },
            slideChangeTransitionEnd: function () {
                if (autoplayOn) {
                    startProgressBar(this);
                }
            },
            slideChangeTransitionStart: function () {
                resetProgressBar(this);
            }
        }
    };

    let swiper = new Swiper(params.container, options);

    let playPauseButton = jQuery(params.container).find('.play-button');
    if (playPauseButton.length) {
        playPauseButton.on('click', function () {
            if (autoplayOn) {
                swiper.autoplay.stop();
                playPauseButton.html('<i class="fa fa-play" aria-hidden="true"></i>');
                autoplayOn = false;
                haltProgressBar(swiper);
            } else {
                swiper.autoplay.start();
                playPauseButton.html('<i class="fa fa-pause" aria-hidden="true"></i>');
                autoplayOn = true;
                startProgressBar(swiper);
            }
        });
    }
};

function startProgressBar(swiper) {
    let activeBullet = jQuery(swiper.el).find('.swiper-pagination-bullet-active .progress-fill');
    if (activeBullet.length) {
        activeBullet.css({
            transition: 'width ' + swiper.params.autoplay.delay + 'ms linear',
            width: '100%'
        });
    }
}

function resetProgressBar(swiper) {
    let progressFills = jQuery(swiper.el).find('.progress-fill');
    progressFills.css({
        transition: 'none',
        width: '0'
    });
}

function haltProgressBar(swiper) {
    let activeBullet = jQuery(swiper.el).find('.swiper-pagination-bullet-active .progress-fill');
    if (activeBullet.length) {
        const currentWidth = activeBullet.css('width');
        activeBullet.css({
            transition: 'none',
            width: currentWidth
        });
    }
}

jQuery(window).on('elementor/frontend/init', function () {
    elementorFrontend.hooks.addAction('frontend/element_ready/ahura_items_carousel3.default', function ($scope, $) {
        let wrap = $scope.find('.items-carousel3'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleItemsCarousel3Element(sliderData);
    });
});