jQuery(document).ready(function($){
    const hideStudioLoader = function (){
        $('.studio-loader').fadeOut(300);
    }

    const showStudioLoader = function (){
        $('.studio-loader').fadeIn(300);
    }

    const saveDemosData = function (params = {}){
        let data = {
            action: 'ahura_save_demos_data',
            nonce: ahura_data.nonce
        };

        if(params.hasOwnProperty('data') && params.data){
            $.each(params.data, function (k, v){
                data[k] = v;
            });
        }

        $.ajax({
            url: ahura_data.au,
            data: data,
            type: 'POST',
            dataType: 'json',
            beforeSend: function (){
                if(params.hasOwnProperty('beforeSend')){
                    params.beforeSend();
                }
            },
            complete: function (result){
                if(params.hasOwnProperty('complete')){
                    params.complete();
                }
            }
        });
    }

    const renderDemoCategories = function (){
        $.ajax({
            url: ahura_data.au,
            data: {
                action: 'ahura_load_demo_categories',
                nonce: ahura_data.nonce
            },
            type: 'POST',
            complete: function (result){
                $('.filter-tabs-list').html(result.responseText);
            }
        });
    }

    const renderDemoItems = function (){
        $.ajax({
            url: ahura_data.au,
            data: {
                action: 'ahura_load_demo_items',
                nonce: ahura_data.nonce
            },
            type: 'POST',
            complete: function (result){
                let list = result.responseText;
                if(list && list !== 0){
                    $('.items-list').html(list)
                    hideStudioLoader();
                }
            }
        });
    }

    if($(document).find('.ahura-filter-tab-items').length){
        saveDemosData({
            data: {
                resave: true
            },
            complete: function (){
                renderDemoCategories();
                renderDemoItems();
            }
        });
    }

    $(document).on('click', '.ah-reload-list', function(e){
        e.preventDefault();
        saveDemosData({
            data: {
                resave: true
            },
            beforeSend: function (){
                showStudioLoader();
            },
            complete: function (){
                renderDemoCategories();
                renderDemoItems();
            }
        });
    });

    $(document).on('click', '.ahura-filter-tabs .filter-tabs-list a', function(e){
        e.preventDefault();
        let btn = $(this),
            tabs = btn.parent().parent(),
            activeTabs = tabs.children('.active'),
            filterValue = btn.attr('data-filter'),
            targets = $(filterValue);
  
        activeTabs.removeClass('active');
        btn.parent().addClass('active');

        if (targets.length){
            $('.filter-item').fadeOut();
            targets.fadeIn();
        } else {
            $('.filter-item').fadeIn();
        }
    });

    let all_items = $('.ahura-studio-filter-tab-items .filter-item'),
        item, demo_url, demo_cover, demo_loader, load_demo;

    if(all_items.length){
        setTimeout(function(){
            $.each(all_items, function(i, el){
                setTimeout(function(){ 
                    item = $(el);
                    demo_cover = item.find('.filter-item-cover');
                    demo_url = demo_cover.data('demo-preview-url');
                    demo_loader = demo_cover.find('.filter-item-cover-loading');
                    if(demo_url.length){
                        demo_cover.append(
                            $('<img/>', {'src': demo_url, 'width': '100%'}).hide()
                        );
						demo_cover.find('img').fadeIn();
                        demo_loader.hide();
                    }
                }, i * 100);
            });
        }, 2000);
    }

    $(document).on('click', '.show-demo-options', function(e){
        e.preventDefault();
        let btn = $(this),
            options = btn.parent().parent().find('.filter-item-options');
        if(options.length){
            options.toggleClass('show-options');
        }
    });

    $(document).on('click', '.aside-btn', function(e){
        e.preventDefault();
        let btn = $(this),
            tabs = $('.ahura-filter-tabs');

        btn.toggleClass('toggled');
        tabs.slideToggle();
    });
});

function ahura_is_json(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}

function ahura_timeout_message(title, type = 'success', time = 3000){
    Swal.fire({
        position: 'center-center',
        icon: type,
        title: title,
        showConfirmButton: false,
        timer: 3000
    })
}