<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class templates_tab extends \ahura\app\elementor\Elementor_Widget_Base {
    /**
     * templates_tab constructor.
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('templates_tab_js', mw_assets::get_js('elementor.templates_tab'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('templates_tab_css', mw_assets::get_css('elementor.templates_tab'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('templates_tab_js')];
    }

    public function get_name() {
        return 'templates_tab';
    }

    public function get_title() {
        return __('Templates Tab', 'ahura');
    }

    public function get_icon() {
        return 'eicon-accordion';
    }

    public function get_categories() {
        return ['ahuraelements'];
    }

    function get_keywords()
    {
        return ['ahura', 'templates tab', 'accordion', esc_html__('ahura' , 'ahura'), esc_html__('Templates tab' , 'ahura')];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ahura'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'tab_style',
			[
				'label' => esc_html__( 'Style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => esc_html__( 'Style 1', 'ahura' ),
					'style2' => esc_html__( 'Style 2', 'ahura' ),
				],
			]
		);

        $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Resume', 'ahura' ),
			]
		);

        $this->add_control(
			'subtitle',
			[
				'label' => esc_html__( 'Subitle', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'All over my details find here..', 'ahura' ),
			]
		);

        $this->add_control(
            'important_note',
            [
                'type' => Controls_Manager::RAW_HTML,
                'raw' => esc_html__('You can create templates from elementor saved templates or ahura builder page.', 'ahura'),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
            ]
        );

        $repeater =  new \Elementor\Repeater();

        $repeater->add_control(
            'item_title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $temps_cls = new \ahura\app\elementor\Ahura_Elementor_Builder();
        $temps = $temps_cls->getTemplates(['section_builder', 'elementor_library']);
        
        $options = [];

        if($temps){
            foreach($temps as $temp){
                $options[$temp->ID] = $temp->post_title;
            }
        }

        $repeater->add_control(
            'item_template',
            [
                'label' => esc_html__('Template', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => $options,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{item_title}}}',
            ]
        );

        $this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Tab icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'condition' => [
					'tab_style' => 'style1',
				]
			]
		);

        $this->add_control(
			'active_icon',
			[
				'label' => esc_html__( 'Tab active icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'condition' => [
					'tab_style' => 'style1',
				]
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'general_section',
            [
                'label' => __('General', 'ahura'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'widget_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 540,
				],
				'selectors' => [
					'{{WRAPPER}} .templates-tab-container' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'sidebar_section',
            [
                'label' => __('Sidebar', 'ahura'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'sidebar_general_options',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'tab_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 800,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 200,
				],
				'selectors' => [
					'{{WRAPPER}} .is-style2 .tab-title' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => ['tab_style' => 'style2']
			]
		);

        $this->add_responsive_control(
			'sidebar_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 25,
				],
				'selectors' => [
					'{{WRAPPER}} .sidebar' => 'width: {{SIZE}}%;',
				],
				'condition' => ['tab_style' => 'style1']
			]
		);

        $this->add_control(
			'sidebar_background',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
				'selectors' => [
					'{{WRAPPER}} .sidebar' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'sidebar_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .sidebar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'sidebar_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .sidebar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'sidebar_title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'sidebar_title_typography',
				'selector' => '{{WRAPPER}} h2',
			]
		);

        $this->add_control(
			'sidebar_title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h2' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'sidebar_title_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'sidebar_subtitle_options',
			[
				'label' => esc_html__( 'Subtitle', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'sidebar_subtitle_typography',
				'selector' => '{{WRAPPER}} h3',
			]
		);

        $this->add_responsive_control(
			'sidebar_subtitle_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'sidebar_subtitle_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h3' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'sidebar_items_options',
			[
				'label' => esc_html__( 'Items', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'item_typography',
				'selector' => '{{WRAPPER}} .sidebar .tab-title',
			]
		);

        $this->add_control(
			'sidebar_item_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sidebar .tab-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'sidebar_item_background',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
				'selectors' => [
					'{{WRAPPER}} .sidebar .tab-title' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'sidebar_item_active_color',
			[
				'label' => esc_html__( 'Active color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
				'selectors' => [
					'{{WRAPPER}} .sidebar .tab-title.active' => 'color: {{VALUE}}',
					'{{WRAPPER}} .sidebar .tab-title:hover' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'sidebar_item_active_background',
			[
				'label' => esc_html__( 'Active background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#080808',
				'selectors' => [
					'{{WRAPPER}} .sidebar .tab-title.active' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .sidebar .tab-title:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'sidebar_item_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .sidebar .tab-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'sidebar_item_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
                'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 5,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .sidebar .tab-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'sidebar_item_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
                'default' => [
					'top' => 8,
					'right' => 8,
					'bottom' => 8,
					'left' => 8,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .sidebar .tab-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'sidebar_item_border',
				'selector' => '{{WRAPPER}} .is-style2 .tab-title',
				'condition' => ['tab_style' => 'style2']
			]
		);

        $this->add_responsive_control(
			'icon_width',
			[
				'label' => esc_html__( 'Icon width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 25,
				],
				'selectors' => [
					'{{WRAPPER}} .templates-tab-container .icon-container svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style_section',
            [
                'label' => __('Content', 'ahura'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'content_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 75,
				],
				'selectors' => [
					'{{WRAPPER}} .content' => 'width: {{SIZE}}%;',
				],
				'condition' => ['tab_style' => 'style1']
			]
		);

        $this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $items = $settings['items'];
        $builder = new \ahura\app\elementor\Ahura_Elementor_Builder();
		$tab_style = isset($settings['tab_style']) ? $settings['tab_style'] : 'style1';
		$is_style1 = isset($settings['tab_style']) && $settings['tab_style'] === 'style1';
        ?>

        <?php if($items): ?>
        <div class="d-flex templates-tab-container templates-tab-<?php echo $wid; ?> is-<?php echo $tab_style; ?>" data-widget-id="<?php echo $wid; ?>">
            <div class="sidebar">
                <?php if(!empty($settings['title']) && !empty($settings['subtitle'])): ?>
                    <div class="details">
                        <?php if(!empty($settings['title'])): ?>
                            <h2><?php echo $settings['title']; ?></h2>
                        <?php endif; ?>
                        <?php if(!empty($settings['subtitle'])): ?>
                            <h3><?php echo $settings['subtitle']; ?></h3>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <?php foreach ($items as $index => $item) { ?>
                    <div class="<?php echo $is_style1 ? 'd-flex justify-content-between align-items-center' : ''; ?> tab-title<?php echo $index === 0 ? ' active' : ''; ?>" data-tab="<?php echo $index; ?>">
                        <span><?php echo $item['item_title']; ?></span>
						<?php if($is_style1): ?>
							<div class="justify-content-center align-items-center icon-container">
								<?php if(!empty($settings['icon']['value'])): ?>
									<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
								<?php else: ?>
									<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none"><path d="M28.3333 28.3334L11.6666 11.6667" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M28.3333 11.6667H11.6666V28.3334" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>
								<?php endif; ?>
							</div>
							<div class="justify-content-center align-items-center icon-container active-icon">
								<?php if(!empty($settings['active_icon']['value'])): ?>
									<?php \Elementor\Icons_Manager::render_icon( $settings['active_icon'], [ 'aria-hidden' => 'true' ] ); ?>
								<?php else: ?>
									<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none"><path d="M28.3333 28.3334L11.6666 11.6667" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M28.3333 11.6667H11.6666V28.3334" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>
								<?php endif; ?>
							</div>
						<?php endif; ?>
                    </div>
                <?php } ?>
            </div>
            <div class="content">
                <?php foreach ($items as $index => $item) { ?>
                    <?php if(is_admin() && $index <= 0): ?>
                        <div class="d-flex justify-content-center align-items-start alert-tab">
							<?php if(empty($item['item_template'])): ?>
								<?php
								\ahura\app\Ahura_Alert::frontNotice(__('Please select a template on Elementor edit panel for this section.', 'ahura'), \ahura\app\Ahura_Alert::INFO);
								?>
							<?php else: ?>
								<?php
								\ahura\app\Ahura_Alert::frontNotice(__('To see the result, open the preview page in a new tab.', 'ahura'), \ahura\app\Ahura_Alert::INFO);
								?>
							<?php endif; ?>
                        </div>
                    <?php elseif(!is_admin()): ?>
                        <div class="tab-content" data-tab="<?php echo $index; ?>">
							<?php if(empty($item['item_template'])): ?>
								<?php
								\ahura\app\Ahura_Alert::frontNotice(__('Please select a template on Elementor edit panel for this section.', 'ahura'), \ahura\app\Ahura_Alert::INFO);
								?>
							<?php else: ?>
								<?php $builder->setContentID($item['item_template'])->build(true); ?>
							<?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php } ?>
            </div>
        </div>
        <?php else: ?>
            <?php
                \ahura\app\Ahura_Alert::frontNotice(__('You can create templates from elementor saved templates or ahura builder page.', 'ahura'), \ahura\app\Ahura_Alert::ERROR);
            ?>
        <?php endif; ?>
        <?php
    }
}
?>
