<?php
namespace ahura\inc\widgets;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\traits\WoocommerceMethods;
use ahura\app\woocommerce;
use Elementor\Controls_Manager;

use ahura\app\mw_assets;

class shop_carousel9 extends \ahura\app\elementor\Elementor_Widget_Base {
    use WoocommerceMethods;

    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_owlcarousel_assets();
        mw_assets::register_script('shop_carousel9_js', mw_assets::get_js('elementor.shop_carousel9'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('shop_carousel9_css', mw_assets::get_css('elementor.shop_carousel9'));
        if(!is_rtl()){
            $this->register_elementor_style('shop_carousel9_ltr_css', mw_assets::get_css('elementor.ltr.shop_carousel9_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('shop_carousel9_js')];
    }

    public function get_name() {
        return 'shop_carousel9';
    }

    public function get_title() {
        return __( 'Products Carousel 9', 'ahura' );
    }

    public function get_icon() {
        return 'eicon-slides';
    }

    public function get_categories() {
        return ['ahuraelements','ahura_woocommerce'];
    }

    function get_keywords()
    {
		return ['ahura', 'shop', 'product', 'products carousel', 'shop carousel 9', esc_html__( 'ahura' , 'ahura'), esc_html__( 'Products' , 'ahura'), esc_html__( 'Shop Carousel 9' , 'ahura')];
    }

    protected function register_controls() {
        if(!woocommerce::is_active()) {
            return false;
        }

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $options = [];

        $products = $this->get_products_array();

        if($products){
            foreach($products as $product) {
                $options[$product['ID']] = $product['post_title'];
            }
        }

        $default = ($options) ? key($options) : 0;

        $repeater->add_control(
            'pid',
            [
                'label' => esc_html__('Product', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => $options,
                'default' => $default
            ]
        );

        $repeater->add_control(
            'use_custom_image',
            [
                'label' => esc_html__( 'Use Custom Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'ahura' ),
                'label_off' => esc_html__( 'No', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater->add_control(
            'custom_image',
            [
                'label' => esc_html__( 'Choose Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => ['use_custom_image' => 'yes']
            ]
        );

        $this->add_control(
            'products',
            [
                'label' => esc_html__('Products', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['pid' => $default],
                ],
                'title_field' => '{{{pid}}}',
                'condition' => [
                    'only_discounted_products!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'only_discounted_products',
            [
                'label' => esc_html__('Only Discounted Products', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'items_num',
            [
                'label' => esc_html__('Products Number', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 5,
                'min' => 1,
                'condition' => [
                    'only_discounted_products' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'settings_section',
            [
                'label' => __( 'Settings', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'autoplay_delay',
            [
                'label' => esc_html__( 'Autoplay delay', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 10000,
                'step' => 1,
                'default' => 4500,
                'condition' => ['autoplay' => 'yes']
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Show Pagination', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-dots' => 'display:block;'
                ]
            ]
        );

        $this->add_control(
            'slider_loop',
            [
                'label' => esc_html__('Loop', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-cover img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'item_img_styles',
            [
                'label' => esc_html__('Image', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'item_img_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'default' => [
                    'size' => 424,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-cover img' => 'height: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_responsive_control(
            'item_img_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product-cover img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 20,
                    'right' => 20,
                    'bottom' => 20,
                    'left' => 20,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'img_border',
                'selector' => '{{WRAPPER}} .product-cover img',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_title_styles',
            [
                'label' => esc_html__('Title', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $alignmentOptions = [
            'right' => [
                'title' => esc_html__( 'Right', 'ahura' ),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__( 'Center', 'ahura' ),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__( 'Left', 'ahura' ),
                'icon' => 'eicon-text-align-left',
            ],
        ];

        if(!is_rtl()) {
            $alignmentOptions = array_reverse($alignmentOptions);
        }

        $this->add_responsive_control(
			'title_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => $alignmentOptions,
				'default' => is_rtl() ? 'right' : 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .slider-item .product-title' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .product-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'ahura'),
                'name' => 'item_title_typography',
                'selector' => '{{WRAPPER}} .product-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '37',
                        ]
                    ]
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_price_styles',
            [
                'label' => esc_html__('Price', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'price_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => $alignmentOptions,
				'default' => is_rtl() ? 'right' : 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .product-price-wrap' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'item_price_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF510C',
                'selectors' => [
                    '{{WRAPPER}} .product-price-wrap' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'ahura'),
                'name' => 'item_price_typography',
                'selector' => '{{WRAPPER}} .product-price-wrap *',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '700'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '25',
                        ]
                    ],
                ]
            ]
        );

        $this->add_control(
            'divider_price',
            [
                'label' => esc_html__('Sale Price', 'ahura'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'item_price_dis_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#cbcbcb',
                'selectors' => [
                    '{{WRAPPER}} .product-price-wrap del' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'ahura'),
                'name' => 'item_price_dis_typography',
                'selector' => '{{WRAPPER}} .product-price-wrap del *',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '400'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '25',
                        ]
                    ],
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_buttons_styles',
            [
                'label' => esc_html__('Button', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $btnAlignmentOptions = [
            'start' => [
                'title' => esc_html__( is_rtl() ? 'Right' : 'Left', 'ahura' ),
                'icon' => 'eicon-text-align-' . (is_rtl() ? 'right' : 'left'),
            ],
            'center' => [
                'title' => esc_html__( 'Center', 'ahura' ),
                'icon' => 'eicon-text-align-center',
            ],
            'end' => [
                'title' => esc_html__( is_rtl() ? 'Left' : 'right', 'ahura' ),
                'icon' => 'eicon-text-align-' . (is_rtl() ? 'left' : 'right'),
            ],
        ];

        $this->add_responsive_control(
			'buttons_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => $btnAlignmentOptions,
				'default' => 'start',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .shop-carousel9-element .product-btns a' => 'justify-content: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'item_button_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .product-btns a span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'item_button_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff510c',
                'selectors' => [
                    '{{WRAPPER}} .product-btns a span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product-btns a :is(span,i)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ]
            ]
        );

        $this->add_control(
            'btn_icon_options',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'item_button_icon_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .product-btns a i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'item_button_icon_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fcb69b',
                'selectors' => [
                    '{{WRAPPER}} .product-btns a i' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_style',
            [
                'label' => esc_html__('Box', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_bg',
                'selector' => '{{WRAPPER}} .product-details-wrap',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic'
                    ],
                    'color' => [
                        'default' => '#fafafa'
                    ]
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .product-details-wrap',
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product-details-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 20,
                    'right' => 20,
                    'bottom' => 20,
                    'left' => 20,
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_paginate_style',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_pagination' => 'yes']
            ]
        );

        $this->add_control(
            'paginate_color',
            [
                'label' => esc_html__('Normal Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7e7e7e',
                'selectors' => [
                    '{{WRAPPER}} .owl-dots .owl-dot' => 'background-color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'paginate_active_color',
            [
                'label' => esc_html__('Active Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff510c',
                'selectors' => [
                    '{{WRAPPER}} .owl-dots .owl-dot.active' => 'background-color: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();
    }

    public function get_item($product_id)
    {
        $settings = $this->get_settings_for_display();
        $products = $settings['products'];

        if(!empty($products)){
            foreach ($products as $product){
                if ($product['pid'] == $product_id)
                    return $product;
            }
        }

        return false;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $has_paginate = ($settings['show_pagination'] == 'yes');

        if (\ahura\app\woocommerce::is_active()) {

            $only_discounted = ($settings['only_discounted_products'] == 'yes');

            if(isset($settings['products']) && is_array($settings['products'])){
                $ids = array_map(function($p){
                    return $p['pid'];
                }, $settings['products']);
            } else {
                $ids = [0];
            }

            $products = $settings['products'] ? $this->get_products(['post__in' => $ids]) : false;

            if($only_discounted){
                $products = $this->get_discounted_products(['per_page' => ($settings['items_num'] ? $settings['items_num'] : -1), 'post_type' => ['product', 'product_variation']]);
            }

            if (!$products->have_posts())
                return false;

            $slider_data = [
                'loop' => $settings['slider_loop'] == 'yes',
                'autoplay' => $settings['autoplay'] == 'yes',
                'autoplayTimeout' => $settings['autoplay_delay'] ?? 4500,
            ];
            ?>
            <div class="shop-carousel9-element">
                <div class="slider-wrap">
                    <div class="slider-items owl-carousel" data-slider='<?php echo json_encode($slider_data) ?>'>
                        <?php
                        while($products->have_posts()): $products->the_post();
                            global $product;
                            $item = $this->get_item($product->get_id());
                        ?>
                        <div class="slider-item">
                            <div class="product-cover">
                                <a href="<?php the_permalink() ?>">
                                    <?php
                                    if($item && $item['use_custom_image'] == 'yes'){
                                        $custom_image = $item['custom_image'];
                                        if(!empty($custom_image['id'])){
                                            echo wp_get_attachment_image($custom_image['id'], 'full');
                                        } else {
                                            echo sprintf('<img src="%s" alt="%s">', $custom_image['url'], get_the_title());
                                        }
                                    } else {
                                        $thumbnail_id = $product->get_image_id();
                                        if (empty(get_the_post_thumbnail()) && $product->is_type('variation')) {
                                            $thumbnail_id = wc_get_product($product->get_parent_id())->get_image_id();
                                        }
                                        echo wp_get_attachment_image($thumbnail_id, 'full');
                                    }
                                    ?>
                                </a>
                            </div>
                            <div class="product-details-wrap">
                                <div class="product-details w-100">
                                    <h3 class="product-title"><?php the_title() ?></h3>
                                    <div class="product-price-wrap">
                                        <?php echo woocommerce_template_single_price();	?>
                                    </div>
                                    <div class="product-colors-wrap">
                                        <?php woocommerce::render_product_colors($product, 4); ?>
                                    </div>
                                    <div class="product-btns">
                                        <a href="<?php the_permalink() ?>">
                                            <span><?php echo __('Buy Product', 'ahura') ?></span>
                                            <i class="fas fa-arrow-<?php echo is_rtl() ? 'left' : 'right' ?>"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                        endwhile;
                        wp_reset_query();
                        ?>
                    </div>
                </div>
            </div>
            <?php
        }
    }
}