<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;
use ahura\app\mw_options;
use ahura\app\Number;
use ahura\app\Post_Meta;
use Elementor\Controls_Manager;

class post_carousel extends \ahura\app\elementor\Elementor_Widget_Base {
    /**
     * post_carousel constructor.
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
		mw_assets::register_owlcarousel_assets();
        mw_assets::register_script('post_carousel_js', mw_assets::get_js('elementor.post_carousel'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('post_carousel_css', mw_assets::get_css('elementor.post_carousel'));
        if (!is_rtl()) {
            $this->register_elementor_style('post_carousel_ltr_css', mw_assets::get_css('elementor.ltr.post_carousel_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('post_carousel_js')];
    }

	public function get_name() {
		return 'postcarousel';
	}

	public function get_title() {
		return __( 'Post Carousel', 'ahura' );
	}

    public function get_icon() {
		return 'aicon-svg-post-carousel';
	}

	public function get_categories() {
		return [ 'ahuraelements', 'ahura_posts' ];
	}

	function get_keywords()
    {
        return ['ahura', 'post', 'post carousel', esc_html__('ahura', 'ahura'), esc_html__('Post Carousel', 'ahura')];
    }

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$categories = get_categories();
		$cats       = array();
		foreach ( $categories as $category ) {
			$cats[ $category->term_id ] = $category->name;
		}
		$default = key($cats);
		$this->add_control(
			'catsid',
			[
				'label'    => __( 'Categories', 'ahura' ),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'options'  => $cats,
				'label_block' => true,
				'multiple' => true,
				'default' => $default
			]
		);

		$this->add_control(
			'excerpt',
			[
				'label'   => __( 'Show Excerpt', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
                    'yes' => [
                        'title' => __( 'Yes', 'ahura' ),
                        'icon'  => 'eicon-check'
                    ],
                    'no'  => [
                        'title' => __( 'No', 'ahura' ),
                        'icon'  => 'eicon-close'
                    ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'excerpt_chars_count',
			[
				'label'   => __( 'Excerpt Characters', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 30,
				'condition' => [
					'excerpt' => 'yes'
				]
			]
		);

		$this->add_control(
			'count',
			[
				'label'      => __( 'Number of posts', 'ahura' ),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'default'    => 8
			]
		);

		$this->add_control(
			'post_order',
			[
				'label' => __('Sort', 'ahura'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'default' => 'DESC',
				'options' => [
					'ASC' => [
						'title' => __('Ascending', 'ahura'),
						'icon' => 'eicon-sort-up'
					],
					'DESC' => [
						'title' => __('Descending', 'ahura'),
						'icon' => 'eicon-sort-down'
					],
				],
				'toggle' => true
			]
		);

        $this->add_control(
            'share_buttons',
            [
                'label' => esc_html__('Share Buttons', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_item_btn',
            [
                'label' => esc_html__('Show Item Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_item_ago_time',
            [
                'label' => esc_html__('Show Post Publish Time', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

		$this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'item_cover',
                'default' => 'stthumb',
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-cover img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'box_more_options',
            [
                'label' => esc_html__( 'Box', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'show_title',
            [
                'label' => esc_html__('Show Title', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_btn',
            [
                'label' => esc_html__('Show Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        // button text
        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Button text', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __('Show all', 'ahura'),
                'default' => __('Show all', 'ahura'),
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'slider_section',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_slider_btn',
            [
                'label' => esc_html__('Show Arrows', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-nav' => 'display:block;'
                ]
            ]
        );

        $this->add_control(
            'show_slider_pagination',
            [
                'label' => esc_html__('Show Pagination', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-dots' => 'display:block;'
                ]
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides Per View', 'ahura'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'step' => 1,
                'default' => 4,
                'tablet_default' => 3,
                'mobile_default' => 1,
            ]
        );

        $this->end_controls_section();
		/**
		 * 
		 * 
		 * Styles
		 * 
		 *
		 */
        $this->start_controls_section(
            'img_styles',
            [
                'label' => __( 'Image', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_img_height',
            [
                'label' => esc_html__('Cover Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .fimage img' => 'height: {{SIZE}}{{UNIT}}',
                ]
            ]
        );

        $this->add_responsive_control(
            'cover_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .fimage img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 0,
                    'left' => 0,
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_styles',
            [
                'label' => __( 'Item', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('item_style_tabs');
        $this->start_controls_tab('item_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_background_color',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .post-c-item',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic'
                    ],
                    'color' => [
                        'default' => '#fff'
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
            'item_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .post-c-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .post-c-item',
            ]
        );

        $this->add_responsive_control(
            'item_margin',
            [
                'label' => esc_html__( 'Margin', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'allowed_dimensions' => ['top', 'bottom'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 30,
                    'left' => 0
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-c-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control('hr1', ['type' => \Elementor\Controls_Manager::DIVIDER]);

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .post-title-wrap h3' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'selector' => '{{WRAPPER}} .post-title-wrap h3',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 600
                    ],
                ]
            ]
        );

        $this->add_control(
            'item_excerpt_color',
            [
                'label' => esc_html__('Excerpt Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#556077',
                'selectors' => [
                    '{{WRAPPER}} .post-excerpt p' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_excerpt_typo',
                'selector' => '{{WRAPPER}} .post-excerpt p',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 400
                    ],
                ]
            ]
        );

        if(mw_options::is_estate_theme_mode()){
            $this->add_control(
                'estate_more_options',
                [
                    'label' => esc_html__( 'Estate Options', 'ahura' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'item_address_icon_color',
                [
                    'label' => esc_html__('Address Icon Color', 'ahura'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#2289FF',
                    'selectors' => [
                        '{{WRAPPER}} .post-metas .meta-address svg path' => 'stroke: {{VALUE}}',
                    ]
                ]
            );

            $this->add_control(
                'item_address_color',
                [
                    'label' => esc_html__('Address Color', 'ahura'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#556077',
                    'selectors' => [
                        '{{WRAPPER}} .post-metas .meta-address' => 'color: {{VALUE}}',
                    ]
                ]
            );

            $this->add_control(
                'item_features_color',
                [
                    'label' => esc_html__('Features Color', 'ahura'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#556077',
                    'selectors' => [
                        '{{WRAPPER}} .estate-icons span' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .estate-icons svg path' => 'fill: {{VALUE}}',
                    ]
                ]
            );

            $this->add_control(
                'item_price_color',
                [
                    'label' => esc_html__('Price Color', 'ahura'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#2289ff',
                    'selectors' => [
                        '{{WRAPPER}} .item-price .price-box :is(em,span)' => 'color: {{VALUE}}',
                    ]
                ]
            );

            $this->add_control(
                'item_price_label_color',
                [
                    'label' => esc_html__('Price Label Color', 'ahura'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#556077',
                    'selectors' => [
                        '{{WRAPPER}} .item-price' => 'color: {{VALUE}}',
                    ]
                ]
            );
        }

        $this->add_control(
            'item_btn_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'item_btn_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .item-btn :is(svg, path)' => 'fill: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'item_btn_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .item-btn' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_btn_border',
                'selector' => '{{WRAPPER}} .item-btn',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('item_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_background_color_hover',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .post-c-item:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border_hover',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .post-c-item:hover',
            ]
        );

        $this->add_control('hr2', ['type' => \Elementor\Controls_Manager::DIVIDER]);

        $this->add_control(
            'item_title_color_hover',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-c-item:hover .post-title-wrap h3' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'item_excerpt_color_hover',
            [
                'label' => esc_html__('Excerpt Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-c-item:hover .post-excerpt p' => 'color: {{VALUE}}',
                ]
            ]
        );

        if(mw_options::is_estate_theme_mode()){
            $this->add_control(
                'estate_more_options_hover',
                [
                    'label' => esc_html__( 'Estate Options', 'ahura' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'item_address_icon_color_hover',
                [
                    'label' => esc_html__('Address Icon Color', 'ahura'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .post-c-item:hover .post-metas .meta-address svg path' => 'stroke: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'item_address_color_hover',
                [
                    'label' => esc_html__('Address Color', 'ahura'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .post-c-item:hover .post-metas .meta-address' => 'color: {{VALUE}}',
                    ]
                ]
            );

            $this->add_control(
                'item_features_color_hover',
                [
                    'label' => esc_html__('Features Color', 'ahura'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .post-c-item:hover .estate-icons span' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .post-c-item:hover .estate-icons svg path' => 'fill: {{VALUE}}',
                    ]
                ]
            );

            $this->add_control(
                'item_price_color_hover',
                [
                    'label' => esc_html__('Price Color', 'ahura'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .post-c-item:hover .item-price .price-box :is(em,span)' => 'color: {{VALUE}}',
                    ]
                ]
            );

            $this->add_control(
                'item_price_label_color_hover',
                [
                    'label' => esc_html__('Price Label Color', 'ahura'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .post-c-item:hover .item-price' => 'color: {{VALUE}}',
                    ]
                ]
            );
        }

        $this->add_control(
            'item_btn_options_hover',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'item_btn_text_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-c-item:hover .item-btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .post-c-item:hover .item-btn :is(svg, path)' => 'fill: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'item_btn_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-c-item:hover .item-btn' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_btn_border_hover',
                'selector' => '{{WRAPPER}} .post-c-item:hover .item-btn',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

		$this->start_controls_section(
			'box_title_styles',
			[
				'label' => __( 'Box Title', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_title' => 'yes']
			]
		);

		$this->add_control(
			'widget_title_style_heading',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'title_color',
            [
                'label'   => __( 'Title Color', 'ahura' ),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#66bb6a',
                'selectors' => [
                    '{{WRAPPER}} .ah-slider-post-1 .cat-name' => 'color: {{VALUE}};',
                ],
            ]
        );

		// typography
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'label' => esc_html__('Title Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .ah-slider-post-1 .cat-name',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => 24,
                        ],
                    ],
                    'font_weight' => ['default' => 'bold'],
                ],
			]
		);

		$this->add_control(
			'title_bg_color',
			[
				'label'   => __( 'Title Background color', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ah-slider-post-1 .cat-name' => 'background-color: {{VALUE}};',
				],
			]
		);

		// border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'widget_title_border',
				'selector' => '{{WRAPPER}} .ah-slider-post-1 .cat-name',
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'label' => esc_html__('Border width', 'ahura'),
                        'default' => [
                            'unit' => 'px',
                            'top' => 0,
                            'bottom' => 0,
                            'right' => is_rtl() ? 4 : 0,
                            'left' => is_rtl() ? 0 : 4,
                        ]
                    ],
                    'color' => [
                        'label' => esc_html__('Border color', 'ahura'),
                        'default' => '#66bb6a',
                    ],
                ],
			]
		);
		
		// border-radius
		$this->add_control(
			'widget_title_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ah-slider-post-1 .cat-name' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		// padding
		$this->add_control(
			'widget_title_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ah-slider-post-1 .cat-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => 0,
                    'bottom' => 0,
                    'right' => is_rtl() ? 1 : 0,
                    'left' => is_rtl() ? 0 : 1,
                    'unit' => 'em',
                ],
			]
		);

		// margin
		$this->add_control(
			'widget_title_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ah-slider-post-1 .cat-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => 0,
                    'bottom' => 0,
                    'right' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'button_styles',
			[
				'label' => __( 'Box Button', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_btn' => 'yes'
				]
			]
		);

		// color
		$this->add_control(
			'button_text_color',
			[
				'label'   => __( 'Color', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .ah-slider-post-1 .cat-more-link' => 'color: {{VALUE}};',
				],
			]
		);

		// bg-color
		$this->add_control(
			'button_color',
			[
				'label'   => __( 'Background color', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '#66bb6a',
				'selectors' => [
					'{{WRAPPER}} .ah-slider-post-1 .cat-more-link' => 'background-color: {{VALUE}};',
				],
			]
		);
		
		// typography
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .ah-slider-post-1 .cat-more-link',
                'fields_options' => [
					'typography' => ['default' => 'yes',],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => 16,
                        ],
                    ],
                ],
			]
		);

		// border
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'selector' => '{{WRAPPER}} .ah-slider-post-1 .cat-more-link',
                'fields_options' => [
                    'width' => [
                        'label' => esc_html__('Border width', 'ahura'),
                    ],
                    'color' => [
                        'label' => esc_html__('Border color', 'ahura'),
                    ],
                ],
			]
		);
		
		// border-radius
		$this->add_control(
			'button_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .ah-slider-post-1 .cat-more-link' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		// padding
		$this->add_control(
			'button_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ah-slider-post-1 .cat-more-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => 5,
                    'bottom' => 5,
                    'right' => 15,
                    'left' => 15,
                    'unit' => 'px',
                    // 'isLinked' => false,
                ],
			]
		);

		// margin
		$this->add_control(
			'button_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ah-slider-post-1 .cat-more-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => 0,
                    'bottom' => 0,
                    'right' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
            'slider_button_style',
            [
                'label' => esc_html__('Slider button', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_slider_btn' => 'yes'
                ]
            ]
        );
        // color
        $this->add_control(
            'slider_btn_text_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .owl-nav i.fa' => 'color: {{VALUE}};'
                ],
                'default' => '#181522',
            ]
        );

        // bg color
        $this->add_control(
            'slider_btn_bg_color',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .owl-nav i.fa' => 'background-color: {{VALUE}};'
                ],
                'default' => '#ffffff',
            ]
        );

        // typography
        $this->add_responsive_control(
            'slider_btn_size',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 23,
                ],
                'selectors' => [
                    '{{WRAPPER}} .owl-nav i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // border-radius
        $this->add_control(
            'slider_next_btn_border_radius',
            [
                'label' => esc_html__( 'Next button border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .owl-nav i.fa' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 50,
                    'bottom' => 50,
                    'right' => 50,
                    'left' => 50,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_control(
            'slider_prev_btn_border_radius',
            [
                'label' => esc_html__( 'Previous button border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .owl-prev i.fa' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 50,
                    'bottom' => 50,
                    'right' => 50,
                    'left' => 50,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_paginate_style',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_slider_pagination' => 'yes']
            ]
        );

        $this->add_control(
            'paginate_color',
            [
                'label' => esc_html__('Normal Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2289FF',
                'selectors' => [
                    '{{WRAPPER}} .owl-dots .owl-dot' => 'border-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'paginate_active_color',
            [
                'label' => esc_html__('Active Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2289FF',
                'selectors' => [
                    '{{WRAPPER}} .owl-dots .owl-dot.active' => 'border-color: {{VALUE}};background-color: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();

        $this->register_additional_controls();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$chars_num = isset($settings['excerpt_chars_count']) && intval($settings['excerpt_chars_count']) ? $settings['excerpt_chars_count'] : false;
		$catidd   = $settings['catsid'];

        $slider_data =[
            'slidesPerView' => $settings['slides_per_view'] ?? 4,
            'tabletSlidesPerView' => $settings['slides_per_view_tablet'] ?? 3,
            'mobileSlidesPerView' => $settings['slides_per_view_mobile'] ?? 1,
        ];

		$default_cat_id = is_array($catidd) ? reset($catidd) : $catidd;
		$postbox5 = new \WP_Query ( array(
			'posts_per_page' => $settings['count'],
			'cat'            => $catidd,
            'order'         =>  $settings['post_order']
		) );
		if ( $postbox5->have_posts() ) : ?>
            <div class="ah-slider-post-1 postbox5 post-carousel-element">
				<?php if($settings['show_title'] === 'yes'): ?>
				<h2 class="cat-name ah-has-text">
					<?php echo get_cat_name( $default_cat_id ) ?>
				</h2>
				<?php endif; ?>
				<?php if($settings['show_btn'] === 'yes'): ?>
				<a class="cat-more-link ah-is-button" href="<?php echo get_category_link( $default_cat_id ) ?>"><?php echo $settings['button_text']; ?></a>
				<?php endif; ?>
				<div class="clear"></div>
                <div class="owl-carousel owl-post-carousel no-item-bg" data-slider='<?php echo json_encode($slider_data) ?>'>
					<?php
                    while ( $postbox5->have_posts() ) : $postbox5->the_post();
                        $address = Post_Meta::get_item_address();
                        $price = Post_Meta::get_item_price();
                        $has_elevator = Post_Meta::has_elevator();
                        $bedrooms = Post_Meta::get_bedrooms();
                        ?>
                        <div class="post-c-item ah-has-bg ah-has-border">
                            <div class="post-cover">
                                <?php if ($settings['share_buttons'] == 'yes'): ?>
                                <div class="item-icon-btns">
                                    <div class="item-icon-btn">
                                        <svg width="15" height="18" viewBox="0 0 15 18" fill="none" xmlns="http://www.w3.org/2000/svg"> <path fill-rule="evenodd" clip-rule="evenodd" d="M11.7828 0.816574C11.3697 0.816436 10.9617 0.90693 10.5875 1.08167C10.2132 1.25642 9.88186 1.51115 9.6168 1.82791C9.35173 2.14467 9.15939 2.51573 9.05336 2.91492C8.94733 3.31411 8.93018 3.7317 9.00313 4.13824L4.89447 7.01517C4.87393 7.02938 4.8542 7.04475 4.83541 7.06121C4.41858 6.73537 3.91857 6.53322 3.39241 6.47781C2.86624 6.4224 2.3351 6.51596 1.85954 6.74783C1.38398 6.9797 0.983149 7.34054 0.702753 7.7892C0.422357 8.23786 0.273682 8.75628 0.273682 9.28536C0.273682 9.81443 0.422357 10.3329 0.702753 10.7815C0.983149 11.2302 1.38398 11.591 1.85954 11.8229C2.3351 12.0547 2.86624 12.1483 3.39241 12.0929C3.91857 12.0375 4.41858 11.8353 4.83541 11.5095C4.85418 11.5263 4.8739 11.5419 4.89447 11.5564L9.00313 14.4333C8.88116 15.1133 9.01271 15.8143 9.37289 16.4038C9.73307 16.9932 10.2969 17.4302 10.9575 17.6319C11.6182 17.8336 12.3299 17.786 12.9579 17.4982C13.5859 17.2105 14.0866 16.7024 14.3652 16.0703C14.6437 15.4382 14.6809 14.7259 14.4696 14.0682C14.2583 13.4105 13.8132 12.8532 13.2185 12.5016C12.6239 12.1501 11.921 12.0288 11.2429 12.1607C10.5648 12.2925 9.95862 12.6685 9.53908 13.2172L5.64845 10.4941C5.82218 10.1275 5.91947 9.71837 5.91947 9.28579C5.91947 8.85321 5.82218 8.44321 5.64845 8.07752L9.53995 5.35347C9.83145 5.73503 10.2155 6.03594 10.6557 6.22774C11.0959 6.41953 11.5777 6.49588 12.0556 6.44955C12.5336 6.40322 12.9918 6.23576 13.387 5.96299C13.7821 5.69022 14.1012 5.32116 14.314 4.89071C14.5268 4.46027 14.6263 3.98266 14.603 3.50305C14.5798 3.02344 14.4346 2.55768 14.1812 2.14982C13.9278 1.74195 13.5746 1.40547 13.1549 1.17217C12.7352 0.938878 12.2629 0.816487 11.7828 0.816574ZM10.2627 3.63965C10.2627 3.23649 10.4228 2.84984 10.7079 2.56476C10.993 2.27969 11.3796 2.11953 11.7828 2.11953C12.1859 2.11953 12.5726 2.27969 12.8577 2.56476C13.1427 2.84984 13.3029 3.23649 13.3029 3.63965C13.3029 4.04281 13.1427 4.42945 12.8577 4.71453C12.5726 4.99961 12.1859 5.15976 11.7828 5.15976C11.3796 5.15976 10.993 4.99961 10.7079 4.71453C10.4228 4.42945 10.2627 4.04281 10.2627 3.63965ZM3.09639 7.76568C2.69323 7.76568 2.30659 7.92583 2.02151 8.21091C1.73643 8.49598 1.57628 8.88263 1.57628 9.28579C1.57628 9.68895 1.73643 10.0756 2.02151 10.3607C2.30659 10.6458 2.69323 10.8059 3.09639 10.8059C3.49955 10.8059 3.8862 10.6458 4.17128 10.3607C4.45635 10.0756 4.61651 9.68895 4.61651 9.28579C4.61651 8.88263 4.45635 8.49598 4.17128 8.21091C3.8862 7.92583 3.49955 7.76568 3.09639 7.76568ZM11.7828 13.4118C11.3796 13.4118 10.993 13.572 10.7079 13.8571C10.4228 14.1421 10.2627 14.5288 10.2627 14.9319C10.2627 15.3351 10.4228 15.7217 10.7079 16.0068C10.993 16.2919 11.3796 16.4521 11.7828 16.4521C12.1859 16.4521 12.5726 16.2919 12.8577 16.0068C13.1427 15.7217 13.3029 15.3351 13.3029 14.9319C13.3029 14.5288 13.1427 14.1421 12.8577 13.8571C12.5726 13.572 12.1859 13.4118 11.7828 13.4118Z" fill="white"/> </svg>
                                        <div class="share-icons">
										    <a target="_blank" href="https://telegram.me/share/url?url=<?php the_permalink(); ?>" rel="nofollow"><i class="fab fa-telegram"></i></a>
                                            <a target="_blank" href="whatsapp://send?text=<?php the_permalink(); ?>" rel="nofollow"><i class="fab fa-whatsapp"></i></a>
                                            <a target="_blank" href="mailto:?subject=<?php the_title() ?>&amp;body=<?php the_permalink(); ?>" rel="nofollow"><i class="fas fa-envelope"></i></a>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php if($settings['show_item_ago_time'] == 'yes'): ?>
                                    <span class="item-ago-time"><?php echo Post_Meta::get_human_time_diff() ?></span>
                                <?php endif; ?>
                                <a class="fimage" href="<?php the_permalink(); ?>"><?php the_post_thumbnail($settings['item_cover_size']); ?></a>
                            </div>
                            <div class="post-details ah-has-text">
                                <a href="<?php the_permalink(); ?>" class="post-title-wrap">
                                    <h3><?php the_title() ?></h3>
                                </a>
                                <?php if (mw_options::is_estate_theme_mode()): ?>
                                    <?php if (!empty($address)): ?>
                                    <div class="post-metas estate-metas">
                                        <div class="meta-address">
                                            <svg width="27" height="28" viewBox="0 0 27 28" fill="none" xmlns="http://www.w3.org/2000/svg"> <path fill-rule="evenodd" clip-rule="evenodd" d="M4.7323 12.2916C4.74832 7.57565 8.58438 3.76557 13.3004 3.78154C18.0164 3.79762 21.8264 7.63367 21.8105 12.3497V12.4464C21.7524 15.5119 20.0407 18.3454 17.9422 20.5599C16.7421 21.8062 15.4019 22.9095 13.9483 23.8479C13.5596 24.1841 12.9831 24.1841 12.5944 23.8479C10.4275 22.4374 8.52563 20.6567 6.97586 18.5871C5.59457 16.7824 4.81033 14.592 4.7323 12.3206V12.2916Z" stroke="#2289FF" stroke-width="2.22422" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.4" d="M13.2714 15.1927C14.7829 15.1927 16.0082 13.9675 16.0082 12.456C16.0082 10.9445 14.7829 9.71924 13.2714 9.71924C11.76 9.71924 10.5347 10.9445 10.5347 12.456C10.5347 13.9675 11.76 15.1927 13.2714 15.1927Z" stroke="#2289FF" stroke-width="2.22422" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                                            <span><?php echo wp_trim_words($address, 5, '...') ?></span>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    <?php if ($has_elevator || $bedrooms): ?>
                                    <div class="estate-metas estate-icons">
                                        <?php if ($has_elevator): ?>
                                        <div class="meta-elevator">
                                            <svg width="30" height="28" viewBox="0 0 30 28" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M10.6234 3.02613H11.1202C11.286 3.02613 11.4202 2.89183 11.4202 2.72614C11.4202 2.56044 11.286 2.42615 11.1202 2.42615H10.6234C10.4576 2.42615 10.3234 2.56044 10.3234 2.72614C10.3234 2.89183 10.4576 3.02613 10.6234 3.02613ZM12.5326 3.02613H13.0297C13.1955 3.02613 13.3297 2.89183 13.3297 2.72614C13.3297 2.56044 13.1955 2.42615 13.0297 2.42615H12.5326C12.3668 2.42615 12.2326 2.56044 12.2326 2.72614C12.2326 2.89183 12.3668 3.02613 12.5326 3.02613ZM14.4421 3.02613H14.939C15.1048 3.02613 15.239 2.89183 15.239 2.72614C15.239 2.56044 15.1048 2.42615 14.939 2.42615H14.4421C14.2763 2.42615 14.1421 2.56044 14.1421 2.72614C14.1421 2.89183 14.2763 3.02613 14.4421 3.02613ZM16.3513 3.02613H16.8482C17.014 3.02613 17.1482 2.89183 17.1482 2.72614C17.1482 2.56044 17.014 2.42615 16.8482 2.42615H16.3513C16.1855 2.42615 16.0513 2.56044 16.0513 2.72614C16.0513 2.89183 16.1855 3.02613 16.3513 3.02613ZM18.2608 3.02613H18.7577C18.9235 3.02613 19.0577 2.89183 19.0577 2.72614C19.0577 2.56044 18.9235 2.42615 18.7577 2.42615H18.2608C18.095 2.42615 17.9608 2.56044 17.9608 2.72614C17.9608 2.89183 18.095 3.02613 18.2608 3.02613ZM4.5333 14.9798H5.85311C6.32749 14.9798 6.62821 14.4671 6.39452 14.0508L5.73479 12.8832C5.49845 12.4622 4.88949 12.4594 4.65173 12.8825L3.99138 14.0514C3.88182 14.2465 3.88413 14.4784 3.99725 14.6717C4.10997 14.8647 4.31034 14.9798 4.5333 14.9798ZM5.17429 13.1775H5.17841C5.18835 13.1775 5.21178 13.1783 5.21178 13.1775L5.87123 14.3689C5.8648 14.3799 5.85745 14.3799 5.85305 14.3799H4.53325L4.51422 14.3459L5.17429 13.1775ZM5.85311 15.8559H4.53302C4.05948 15.8559 3.75752 16.3682 3.9916 16.7849L4.65133 17.9525C4.88768 18.3736 5.49664 18.3764 5.7344 17.9533L6.39475 16.7844C6.62754 16.3701 6.32856 15.8559 5.85311 15.8559ZM5.21178 17.6582C5.21178 17.6584 5.18863 17.658 5.17869 17.658C5.17604 17.658 5.17429 17.658 5.17429 17.6582L4.51484 16.4669C4.52127 16.4559 4.52862 16.4559 4.53302 16.4559H5.85311L5.87186 16.4899L5.21178 17.6582Z" fill="#556077"/> <path d="M27.7446 25.0726H27.0687V2.90067C27.0687 1.33408 25.794 0.0595703 24.2276 0.0595703H5.15356C3.58708 0.0595703 2.31245 1.33408 2.31245 2.90067V25.0727H1.63657C0.879533 25.0727 0.291016 25.6882 0.291016 26.4181C0.291016 27.1587 0.894499 27.7612 1.63657 27.7612H27.7446C28.4689 27.7612 29.0902 27.1787 29.0902 26.4181C29.0902 25.6761 28.4867 25.0726 27.7446 25.0726ZM2.91238 2.90067C2.91238 1.66496 3.91785 0.659552 5.1535 0.659552H24.2276C25.4633 0.659552 26.4687 1.66502 26.4687 2.90067V25.0727H21.907V7.71092C21.907 6.14416 20.6323 4.86965 19.0659 4.86965H10.3152C8.74848 4.86965 7.4738 6.14416 7.4738 7.71092V25.0726H2.91238V2.90067ZM8.07378 25.0726V7.71092C8.07378 6.4751 9.07925 5.46963 10.3152 5.46963H14.3906V25.0726H8.07378ZM14.9906 5.46963H19.0659C20.3016 5.46963 21.307 6.4751 21.307 7.71092V25.0726H14.9906V5.46963ZM27.7446 27.1611H1.63657C1.22555 27.1611 0.890998 26.8278 0.890998 26.4181C0.890998 26.0082 1.22126 25.6726 1.63657 25.6726H27.7446C28.1556 25.6726 28.4902 26.007 28.4902 26.4181C28.4902 26.8431 28.1413 27.1611 27.7446 27.1611Z" fill="#556077"/> </svg>
                                            <span><?php echo __('Elevator', 'ahura') ?></span>
                                        </div>
                                        <?php endif; ?>
                                        <?php if ($bedrooms): ?>
                                        <div class="meta-bedroom">
                                            <svg width="30" height="31" viewBox="0 0 30 31" fill="none" xmlns="http://www.w3.org/2000/svg"> <g clip-path="url(#clip0_0_168)"> <path d="M27.9996 13.9303V5.3854C27.9996 3.80232 26.7416 2.5144 25.1956 2.5144H4.76015C3.21389 2.5144 1.95593 3.80232 1.95593 5.3854V13.9305C1.12519 14.5084 0.578125 15.4834 0.578125 16.5869V17.157C0.578125 17.9606 1.09554 18.6425 1.80717 18.8727C1.52717 19.1762 1.35419 19.5839 1.35419 20.0329V24.7486C1.35419 25.6829 2.09802 26.443 3.01233 26.443H4.96996V26.9947C4.96996 27.5461 5.40825 27.9946 5.94668 27.9946H6.94215C7.48063 27.9946 7.91887 27.5461 7.91887 26.9947V26.443H22.0369V26.9947C22.0369 27.5461 22.4752 27.9946 23.0136 27.9946H24.0091C24.5476 27.9946 24.9858 27.5461 24.9858 26.9947V26.443H26.9431C27.8574 26.443 28.6013 25.6829 28.6013 24.7486V20.0329C28.6013 19.5839 28.4283 19.1762 28.1483 18.8727C28.8598 18.6426 29.3773 17.9606 29.3773 17.157V16.5869C29.3773 15.4833 28.8304 14.5082 27.9996 13.9303ZM2.55591 13.6038V5.3854C2.55591 4.14096 3.54466 3.12867 4.76015 3.12867H25.1956C26.4108 3.12867 27.3996 4.14096 27.3996 5.3854V13.6037C27.0716 13.4699 26.6468 13.3772 26.2424 13.3772H24.0737C24.2045 13.169 24.2825 12.9228 24.2825 12.6573V10.1866C24.2825 9.45133 23.6983 8.85326 22.9803 8.85326H17.3429C16.6248 8.85326 16.0407 9.45133 16.0407 10.1866V12.6573C16.0407 12.9228 16.1188 13.169 16.2495 13.3772H13.7065C13.8373 13.169 13.9153 12.9228 13.9153 12.6573V10.1866C13.9153 9.45133 13.3311 8.85326 12.6128 8.85326H6.97564C6.25729 8.85326 5.67312 9.45133 5.67312 10.1866V12.6573C5.67312 12.9228 5.75116 13.169 5.8819 13.3772H3.7134C3.30114 13.3772 2.87386 13.4742 2.55591 13.6038ZM17.3298 13.3772C16.9487 13.3699 16.6406 13.0505 16.6406 12.6573V10.1866C16.6406 9.7901 16.9556 9.46752 17.3428 9.46752H22.9803C23.3676 9.46752 23.6825 9.7901 23.6825 10.1866V12.6573C23.6825 13.0505 23.3744 13.3699 22.9932 13.3772H17.3298ZM6.96253 13.3772C6.58133 13.3699 6.27304 13.0505 6.27304 12.6573V10.1866C6.27304 9.7901 6.58828 9.46752 6.97558 9.46752H12.6127C13 9.46752 13.3153 9.7901 13.3153 10.1866V12.6573C13.3153 13.0505 13.0069 13.3699 12.6258 13.3772H6.96253ZM7.31889 26.9947C7.31875 27.097 7.27902 27.195 7.20839 27.2673C7.13777 27.3396 7.04202 27.3803 6.94215 27.3804H5.94668C5.8468 27.3803 5.75105 27.3396 5.68043 27.2673C5.60981 27.195 5.57007 27.097 5.56994 26.9947V26.443H7.31889V26.9947ZM24.3859 26.9947C24.3858 27.097 24.346 27.195 24.2754 27.2673C24.2048 27.3396 24.109 27.3803 24.0092 27.3804H23.0137C22.9138 27.3803 22.8181 27.3396 22.7474 27.2673C22.6768 27.195 22.6371 27.097 22.637 26.9947V26.443H24.3859V26.9947ZM28.0013 24.7486C28.0013 25.3442 27.5267 25.8287 26.9432 25.8287H3.01239C2.42879 25.8287 1.95423 25.3442 1.95423 24.7486V20.0329C1.95423 19.4485 2.41196 18.9738 2.98043 18.9561H26.9751C27.5436 18.9738 28.0013 19.4486 28.0013 20.0329V24.7486ZM28.7773 17.157C28.7773 17.8104 28.2582 18.3418 27.6201 18.3418H27.0069C26.9747 18.3406 3.26658 18.3295 2.94852 18.3418H2.3356C1.69722 18.3418 1.17811 17.8104 1.17811 17.157V16.5869C1.17811 15.1401 2.33933 13.9914 3.7134 13.9914C17.8782 13.9936 24.28 13.9914 26.2423 13.9914C27.6093 13.9914 28.7773 15.1331 28.7773 16.5869V17.157Z" fill="#556077"/> <path d="M7.07393 20.4839H5.32029C4.77599 20.4839 4.33301 20.9374 4.33301 21.4948V23.2866C4.33301 23.846 4.77599 24.301 5.32029 24.301H7.07393C7.61823 24.301 8.06121 23.846 8.06121 23.2866V21.4948C8.06121 20.9374 7.61828 20.4839 7.07393 20.4839ZM7.46123 23.2867C7.46123 23.5072 7.28751 23.6868 7.07393 23.6868H5.32029C5.1067 23.6868 4.93299 23.5072 4.93299 23.2867V21.4949C4.93299 21.2762 5.1067 21.0982 5.32029 21.0982H7.07393C7.28751 21.0982 7.46123 21.2762 7.46123 21.4949V23.2867ZM12.9276 20.4839H11.1742C10.6296 20.4839 10.1867 20.9374 10.1867 21.4948V23.2866C10.1867 23.846 10.6297 24.301 11.1742 24.301H12.9276C13.4722 24.301 13.9152 23.846 13.9152 23.2866V21.4948C13.9152 20.9374 13.4722 20.4839 12.9276 20.4839ZM13.3152 23.2867C13.3152 23.5072 13.1415 23.6868 12.9276 23.6868H11.1742C10.9604 23.6868 10.7867 23.5072 10.7867 23.2867V21.4949C10.7868 21.3897 10.8277 21.2888 10.9003 21.2145C10.973 21.1401 11.0715 21.0983 11.1742 21.0982H12.9276C13.1415 21.0982 13.3152 21.2762 13.3152 21.4949V23.2867ZM18.7815 20.4839H17.0279C16.4836 20.4839 16.0406 20.9374 16.0406 21.4948V23.2866C16.0406 23.846 16.4836 24.301 17.0279 24.301H18.7815C19.3258 24.301 19.7688 23.846 19.7688 23.2866V21.4948C19.7688 20.9374 19.3258 20.4839 18.7815 20.4839ZM19.1688 23.2867C19.1688 23.5072 18.9951 23.6868 18.7815 23.6868H17.0278C16.8143 23.6868 16.6405 23.5072 16.6405 23.2867V21.4949C16.6405 21.2762 16.8143 21.0982 17.0278 21.0982H18.7815C18.9951 21.0982 19.1688 21.2762 19.1688 21.4949V23.2867ZM24.6352 20.4839H22.8818C22.3372 20.4839 21.8942 20.9374 21.8942 21.4948V23.2866C21.8942 23.846 22.3372 24.301 22.8818 24.301H24.6352C25.1798 24.301 25.6227 23.846 25.6227 23.2866V21.4948C25.6227 20.9374 25.1798 20.4839 24.6352 20.4839ZM25.0227 23.2867C25.0227 23.5072 24.849 23.6868 24.6352 23.6868H22.8818C22.6679 23.6868 22.4942 23.5072 22.4942 23.2867V21.4949C22.4943 21.3897 22.5352 21.2888 22.6079 21.2145C22.6805 21.1401 22.7791 21.0983 22.8818 21.0982H24.6352C24.849 21.0982 25.0227 21.2762 25.0227 21.4949V23.2867Z" fill="#556077"/> </g> <defs> <clipPath id="clip0_0_168"> <rect width="28.9148" height="29.6032" fill="white" transform="translate(0.520264 0.452881)"/> </clipPath> </defs> </svg>
                                            <span><?php echo sprintf(__('%d Bedroom', 'ahura'), $bedrooms) ?></span>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php if ($settings['excerpt'] == 'yes' && has_excerpt()) : ?>
                                    <div class="post-excerpt">
                                        <?php
                                        if($chars_num){
                                            echo '<p>' . wp_trim_words(get_the_excerpt(), $chars_num, '...') . '</p>';
                                        } else {
                                            the_excerpt();
                                        }
                                        ?>
                                    </div>
                                <?php endif; ?>
                                <?php if (mw_options::is_estate_theme_mode() && !empty($price)): ?>
                                <div class="item-price estate-price">
                                    <div><?php _e('Price', 'ahura') ?></div>
                                    <div class="price-box"><span><?php echo number_format($price) ?></span><em><?php echo mw_options::get_theme_currency_unit() ?></em></div>
                                </div>
                                <?php endif; ?>
                            </div>
                            <?php if ($settings['show_item_btn'] == 'yes'): ?>
                            <div class="item-buttons">
                                <a href="<?php the_permalink() ?>" class="item-btn">
                                    <i class="fas fa-arrow-<?php echo is_rtl() ? 'left' : 'right' ?>"></i>
                                </a>
                            </div>
                            <?php endif; ?>
                        </div>
					<?php endwhile; ?>
				</div>
			    <?php wp_reset_postdata(); ?>
            </div>
			<?php endif; ?>
            <div class="clear"></div>
		<?php
	}
}
