<?php
// Block direct access to the main plugin file.
defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class Ahura_Popup_Search2 extends \ahura\app\elementor\Elementor_Widget_Base
{
    function __construct($data=[], $args=null)
    {
        parent::__construct($data, $args);
        $this->register_elementor_script('popup_search2_js', mw_assets::get_js('elementor.popup_search2'));
        wp_localize_script($this->get_asset_handle_name('popup_search2_js'), 'search_data', ['au' => admin_url('admin-ajax.php')]);
    }

    public function __register_assets()
    {
        $this->register_elementor_style('popup_search2_css', mw_assets::get_css('elementor.popup_search2'));
    }

    function get_script_depends()
    {
        return [$this->get_asset_handle_name('popup_search2_js')];
    }

    public function get_name()
    {
        return 'popup_search2';
    }

    public function get_title()
    {
        return esc_html__('Popup Search 2', 'ahura');
    }

    public function get_icon()
    {
        return 'eicon-site-search';
    }

    public function get_categories()
    {
        return ['ahuraheader'];
    }

    public function get_keywords()
    {
        return ['ahura', 'search', esc_html__('ahura', 'ahura'), esc_html__('search', 'ahura'), esc_html__('Popup search 2', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'post_type',
            [
                'label' => esc_html__( 'Post Type', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'default',
                'options' => array_merge(['default' => __('Default', 'ahura')], get_post_types(['public' => true])),
            ]
        );

        $this->add_control(
            'show_category',
            [
                'label'   => esc_html__( 'Show Category', 'ahura' ),
                'type'    => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['post_type' => 'product']
            ]
        );

        $this->add_control(
            'placeholder',
            [
                'label' => esc_html__('Placeholder', 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Search...', 'ahura')
            ]
        );

        $this->add_control(
            'hide_in_scroll',
            [
                'label' => esc_html__('Hide in scroll', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'ahura' ),
                'label_off' => esc_html__( 'No', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control('hr1', ['type' => \Elementor\Controls_Manager::DIVIDER]);

        $this->add_control(
            'show_icon',
            [
                'label' => esc_html__('Show Icon', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );

        $this->add_control(
            'show_text',
            [
                'label' => esc_html__('Show Text', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__('Button Text', 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Search', 'ahura'),
                'condition' => ['show_text' => 'yes']
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         *
         * Styles
         *
         *
         */
		 $this->start_controls_section(
            'field_style_section',
            [
                'label' => __( 'Field', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
		
		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Text Typography', 'ahura'),
                'name' => 'field_text_typo',
                'selector' => '{{WRAPPER}} .is-search-input',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '19',
                        ]
                    ]
                ],
            ]
        );
		
		$this->end_controls_section();
        
        $this->start_controls_section(
            'btn_style_section',
            [
                'label' => __( 'Button', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('style_tabs');

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'ahura' ),
            ]
        );

        $alignment = array(
            'start' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'end' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_control(
            'btn_text_align',
            [
                'label' => esc_html__('Text Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .toggle-search-btn' => 'justify-content: {{VALUE}}',
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 45
                ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-search-btn' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_icon_size',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 24
                ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-search-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .toggle-search-btn svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['show_icon' => 'yes']
            ]
        );

        $this->add_control(
            'btn_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .toggle-search-btn i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .toggle-search-btn svg path' => 'fill: {{VALUE}}',
                ],
                'condition' => ['show_icon' => 'yes']
            ]
        );

        $this->add_control(
            'btn_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .toggle-search-btn span' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_text' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Text Typography', 'ahura'),
                'name' => 'btn_text_typo',
                'selector' => '{{WRAPPER}} .toggle-search-btn span',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
                'condition' => [
                    'show_text' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .toggle-search-btn',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .toggle-search-btn',
            ]
        );

        $this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-search-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .toggle-search-btn',
            ]
        );

        $this->add_control(
            'btn_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-search-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'ahura' ),
            ]
        );

        $this->add_control(
            'btn_icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .toggle-search-btn:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .toggle-search-btn:hover svg path' => 'fill: {{VALUE}}',
                ],
                'condition' => ['show_icon' => 'yes']
            ]
        );

        $this->add_control(
            'btn_text_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .toggle-search-btn:hover span' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_text' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_hover',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .toggle-search-btn:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_hover',
                'selector' => '{{WRAPPER}} .toggle-search-btn:hover',
            ]
        );

        $this->add_control(
            'btn_border_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-search-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_shadow_hover',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .toggle-search-btn:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->register_additional_controls();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $hide_in_scroll = $settings['hide_in_scroll'] == 'yes';
        $placeholder = $settings['placeholder'];
        $post_type = $settings['post_type'];
        $has_category = $post_type == 'product' && $settings['show_category'] == 'yes';
        $product_categories = get_terms( [ 'taxonomy' => 'product_cat', 'hide_empty' => true ] );
        ?>
        <div class="popup-search2-element is-element-<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
            <div class="toggle-search-btn ah-is-button ah-has-text ah-has-icon <?php echo $hide_in_scroll ? 'hide_in_scroll' : '' ?>">
                <?php if ($settings['show_icon'] == 'yes'): ?>
                    <?php if (!empty($settings['btn_icon']['value'])): ?>
                        <?php \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php else: ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"> <path d="M11.5 21C16.7467 21 21 16.7467 21 11.5C21 6.25329 16.7467 2 11.5 2C6.25329 2 2 6.25329 2 11.5C2 16.7467 6.25329 21 11.5 21Z" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.4" d="M22 22L20 20" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if ($settings['show_text'] == 'yes'): ?>
                    <span><?php echo $settings['btn_text'] ?></span>
                <?php endif; ?>
            </div>
            <div class="popup-search-container">
                <div class="popup-search-wrap <?php echo $has_category ? 'search-with-cat' : '' ?>">
                    <div class="popup-search-overlay"></div>
                    <div class="popup-search-content">
                        <div class="search-field-wrap">
                            <div class="is-search-field <?php echo $has_category ? 'with-cat' : '' ?>">
                                <form action="<?php echo home_url() ?>" method="get">
                                    <?php if ($has_category): ?>
                                        <div class="categories-selector">
                                            <div class="ahura-select-field">
                                                <div class="ah-selected-item-wrap">
                                                    <div class="ah-selected-item">
                                                        <i class="fas fa-bars"></i>
                                                        <span class="ah-selected-text"><?php echo __('All Products', 'ahura'); ?></span>
                                                    </div>
                                                    <i class="fas fa-angle-down"></i>
                                                </div>
                                                <div class="ah-select-options">
                                                    <div class="select-option selected" data-value=""><?php echo __('All Products', 'ahura'); ?></div>
                                                    <?php if(\ahura\app\woocommerce::is_active() && $product_categories): ?>
                                                        <?php
                                                        foreach ($product_categories as $category) {
                                                            echo '<div class="select-option" data-value="' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</div>';
                                                        }
                                                        ?>
                                                    <?php endif; ?>
                                                </div>
                                                <select name="product_cat" class="cat-select cat-select-input" style="display:none">
                                                    <option value=""><?php echo __('All Products', 'ahura'); ?></option>
                                                    <?php if(\ahura\app\woocommerce::is_active() && $product_categories): ?>
                                                        <?php
                                                        foreach ($product_categories as $category) {
                                                            echo '<option value="' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</option>';
                                                        }
                                                        ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <input type="text" name="s" placeholder="<?php echo $placeholder ?>" autocomplete="off" class="is-search-input">
                                    <?php if($post_type != 'default'): ?>
                                        <input type="hidden" name="post_type" value="<?php echo $post_type ?>">
                                    <?php endif; ?>
                                </form>
                            </div>
                            <div class="is-close-btn">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"> <path d="M12 22C17.5 22 22 17.5 22 12C22 6.5 17.5 2 12 2C6.5 2 2 6.5 2 12C2 17.5 6.5 22 12 22Z" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <g opacity="0.4"> <path d="M9.16992 14.8299L14.8299 9.16992" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path d="M14.8299 14.8299L9.16992 9.16992" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </g> </svg>
                            </div>
                        </div>
                        <div class="popup-search-result-wrap">
                            <div class="popup-search-result"></div>
                            <div class="is-search-loader" style="display:none;">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 200"><radialGradient id="a7" cx=".66" fx=".66" cy=".3125" fy=".3125" gradientTransform="scale(1.5)"><stop offset="0" stop-color="#FFFFFF"></stop><stop offset=".3" stop-color="#FFFFFF" stop-opacity=".9"></stop><stop offset=".6" stop-color="#FFFFFF" stop-opacity=".6"></stop><stop offset=".8" stop-color="#FFFFFF" stop-opacity=".3"></stop><stop offset="1" stop-color="#FFFFFF" stop-opacity="0"></stop></radialGradient><circle transform-origin="center" fill="none" stroke="url(#a7)" stroke-width="15" stroke-linecap="round" stroke-dasharray="200 1000" stroke-dashoffset="0" cx="100" cy="100" r="70"><animateTransform type="rotate" attributeName="transform" calcMode="spline" dur="0.4" values="360;0" keyTimes="0;1" keySplines="0 0 1 1" repeatCount="indefinite"></animateTransform></circle><circle transform-origin="center" fill="none" opacity=".2" stroke="#FFFFFF" stroke-width="15" stroke-linecap="round" cx="100" cy="100" r="70"></circle></svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    }
}
