<?php
namespace ahura\inc\widgets;

defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class brands2 extends \ahura\app\elementor\Elementor_Widget_Base {
    public function __construct($data = [], $args = [])
    {
        parent::__construct($data, $args);
        mw_assets::register_splide_assets(true);
        mw_assets::register_script('brands2_js', mw_assets::get_js('elementor.brands2'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('brands2_css', mw_assets::get_css('elementor.brands2'));
    }

    public function get_script_depends() {
        return [mw_assets::get_handle_name('brands2_js')];
    }

    public function get_name() {
        return 'ahura_brands2';
    }

    public function get_title() {
        return __('Brands 2', 'ahura');
    }

    public function get_icon() {
        return 'eicon-carousel';
    }

    public function get_categories() {
        return ['ahuraelements'];
    }

    public function get_keywords() {
        return ['ahura', 'brands', 'brands2', $this->get_title()];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'ahura' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 30,
                'step' => 1,
                'default' => 7,
            ]
        );

        $this->add_control(
            'slides_speed',
            [
                'label' => esc_html__('Slides Speed', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'ahura'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'ahura'),
                'type' => Controls_Manager::URL,
                'dynamic' => ['active' => true],
                'placeholder' => esc_html__('https://example.com', 'ahura'),
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'slides',
            [
                'label' => esc_html__('Slides', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                        ['image' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                        ['image' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                        ['image' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                        ['image' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                        ['image' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                        ['image' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                        ['image' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'images_style',
            [
                'label' => esc_html__('Image', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_image_width',
            [
                'label' => esc_html__('Image Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => ['unit' => 'px', 'size' => 123],
                'selectors' => [
                    '{{WRAPPER}} .slide-item img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_image_height',
            [
                'label' => esc_html__('Image Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => ['unit' => 'px', 'size' => 123],
                'selectors' => [
                    '{{WRAPPER}} .slide-item img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_img_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .slide-item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'items_style',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_bg',
                'selector' => '{{WRAPPER}} .slide-item',
            ]
        );

        $this->add_responsive_control(
            'item_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .slide-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .slide-item',
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .slide-item' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $slides = $settings['slides'];

        if (empty($slides))
            return false;

        $sliderData = [
            'perView' => $settings['slides_per_view'],
            'slidesSpeed' => $settings['slides_speed']
        ];
        ?>
        <div class="ahura-brands2-element">
            <section class="brands2-carousel-slider splide" data-slider='<?php echo wp_json_encode($sliderData) ?>'>
                <div class="splide__track">
                    <ul class="splide__list">
                        <?php
                        foreach ($slides as $slide):
                            $id = $slide['_id'];
                            $hasLink = !empty($slide['link']['url']);
                            if ($hasLink) {
                                $this->add_link_attributes("item_link_{$id}", $slide['link']);
                            }
                            ?>
                            <li class="splide__slide">
                                <div class="slide-item">
                                    <?php if ($hasLink) : ?>
                                    <a <?php $this->print_render_attribute_string("item_link_{$id}"); ?>>
                                        <?php endif; ?>

                                        <img src="<?php echo esc_url($slide['image']['url']); ?>" alt="Brand (<?php echo esc_attr($id) ?>)" />

                                        <?php if ($hasLink) : ?>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </section>
        </div>
        <?php
    }
}