<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class ahura_archive_description extends \ahura\app\elementor\Elementor_Widget_Base {
    private $query;

    public function __register_assets()
    {
        $this->register_elementor_style('archive_posts_description_css', mw_assets::get_css('elementor.archive_posts_description'));
    }

    public function get_name()
    {
        return 'ahura_archive_posts_description';
    }

    public function get_title()
    {
        return esc_html__('Archive description', 'ahura');
    }

    public function get_icon() {
        return 'eicon-text';
    }

    public function get_categories()
    {
        return ['ahura_archive'];
    }

    public function get_keywords()
    {
        return ['ahura', 'archive', 'description', 'archive', esc_html__('ahura', 'ahura'), esc_html__('archive', 'ahura'), esc_html__('posts acrhive', 'ahura'), esc_html__('description', 'ahura'), esc_html__('Archive description', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'display_settings',
            [
                'label' => esc_html__('Layout', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
			'not_found_text',
			[
				'label' => esc_html__( 'Not found text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Not found any description...', 'ahura' ),
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'item_post_styles',
            [
                'label' => esc_html__('Box', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .archive-description' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .archive-description',
			]
		);

        $this->add_control(
			'margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .archive-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->register_additional_controls();
    }

    /**
     *
     * Render content for display
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $not_found_text = isset($settings['not_found_text']) ? $settings['not_found_text'] : null; 
        if(!is_admin() && empty($not_found_text) && empty(get_the_archive_description())) return; ?>

        <div class="ah-archive-posts-description ah-archive-posts-element-wrap">
            <div class="archive-description">
                <?php if(is_admin()) {
                    echo ahura_get_lorem_ipsum();
                    return;
                }
                if (is_archive()) :
                    if(!empty(get_the_archive_description())) {
                        echo get_the_archive_description();
                    } elseif(empty(get_the_archive_description()) && !empty($not_found_text)) {
                        echo $not_found_text;
                    } ?>
                <?php endif; ?>
            </div>
        </div>
    <?php
    }
} 