<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\customization\ios_checkbox;
use ahura\app\customization\simple_select_box;
use ahura\app\customization\simple_text;
use ahura\app\customization\simple_range;
use ahura\app\customization\heading_box;
use ahura\app\mw_options;

$this->customizer->add_setting('ah_woo_login_my_account_controls');
$this->customizer->add_control(new heading_box($this->customizer, 'ah_woo_login_my_account_controls', [
    'label' => __('Login page', 'ahura'),
    'section' => $this->current_section,
]));

$this->customizer->add_setting('ahura_woo_login_my_account_style', ['default' => 2]);
$this->customizer->add_control(new simple_select_box($this->customizer, 'ahura_woo_login_my_account_style', [
    'section' => $this->current_section,
    'label' => __('Account Login Style', 'ahura'),
    'choices' => [
        1 => __('Default', 'ahura'),
        2 => __('Style 2', 'ahura'),
        3 => __('Style 3', 'ahura'),
    ],
]));

$this->customizer->add_setting('ahura_login_my_account_padding', ['default' => 100]);
$this->customizer->add_control(new simple_range( $this->customizer, 'ahura_login_my_account_padding',array(
    'label' => __('Padding','ahura'),
    'section' => $this->current_section,
    'input_attrs' => array(
        'min' => 0,
        'max' => 200,
    ),
    'active_callback' => function(){
        return mw_options::get_login_my_account_mode() == 3;
    },
) ) );

$this->customizer->add_setting('ahura_login_my_account_logo', false);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_login_my_account_logo', [
    'label' => __('Use logo', 'ahura'),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_login_my_account_mode() != 1;
    },
]));

$this->customizer->add_setting( 'ahura_login_my_account_custom_logo_url', [ 'default' => '' ] );
$this->customizer->add_control( new WP_Customize_Image_Control( $this->customizer, 'ahura_login_my_account_custom_logo_url', array(
    'label' => __( 'Logo', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_login_my_account_mode() != 1 && mw_options::get_login_my_account_logo_state();
    }
) ));

$this->customizer->add_setting('ahura_login_my_account_custom_logo_direction', ['default' => 'center']);
$this->customizer->add_control('ahura_login_my_account_custom_logo_direction', [
    'label' => __("Logo direction", 'ahura'),
    'section' => $this->current_section,
    'type' => 'select',
    'choices' => [
        'start' => 'Start',
        'center' => 'Center',
        'end' => 'End',
    ],
    'active_callback' => function(){
        return mw_options::get_login_my_account_mode() == 3 && mw_options::get_login_my_account_logo_state();
    }
]);

$this->customizer->add_setting('ahura_login_my_account_logo_width', ['default' => 150]);
$this->customizer->add_control(new simple_range( $this->customizer, 'ahura_login_my_account_logo_width',array(
    'label' => __('Logo width','ahura'),
    'section' => $this->current_section,
    'input_attrs' => array(
        'min' => 100,
        'max' => 1000,
    ),
    'active_callback' => function(){
        return mw_options::get_login_my_account_mode() == 3 && mw_options::get_login_my_account_logo_state();
    },
) ) );

$this->customizer->add_setting('ahura_login_my_account_color', array('default' => '#099aa7'));
$this->customizer->add_control( new WP_Customize_Color_Control( $this->customizer, 'ahura_login_my_account_color',array(
        'label' => __('Main color','ahura'),
        'section' => $this->current_section,
        'active_callback' => function(){
            return mw_options::get_login_my_account_mode() == 3;
        },
    ) )
);

$this->customizer->add_setting('ahura_login_my_account_background_color', array('default' => ''));
$this->customizer->add_control( new WP_Customize_Color_Control( $this->customizer, 'ahura_login_my_account_background_color',array(
        'label' => __('Background color','ahura'),
        'section' => $this->current_section,
        'active_callback' => function(){
            return mw_options::get_login_my_account_mode() == 3;
        },
    ) )
);

$this->customizer->add_setting( 'ahura_login_my_account_custom_img', [ 'default' => '' ] );
$this->customizer->add_control( new WP_Customize_Image_Control( $this->customizer, 'ahura_login_my_account_custom_img', array(
    'label' => __( 'Image', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_login_my_account_mode() == 3;
    }
) ));

$this->customizer->add_setting('ah_woo_my_account_controls');
$this->customizer->add_control(new heading_box($this->customizer, 'ah_woo_my_account_controls', [
    'label' => __('My account page', 'ahura'),
    'section' => $this->current_section,
]));

$this->customizer->add_setting('ahura_woo_my_account_style', ['default' => 2]);
$this->customizer->add_control(new simple_select_box($this->customizer, 'ahura_woo_my_account_style', [
    'section' => $this->current_section,
    'label' => __('My Account Style', 'ahura'),
    'choices' => [
        1 => __('Default', 'ahura'),
        2 => __('Style 2', 'ahura'),
    ],
]));

$this->customizer->add_setting( 'ahura_myaccount_dashboard_extra_text' );
$this->customizer->add_control( new simple_text($this->customizer, 'ahura_myaccount_dashboard_extra_text', [
    'label' => __( 'Dashboard extra text', 'ahura' ),
    'section' => $this->current_section,
    'type'    => 'text',
] ) );

$this->customizer->add_setting( 'ahura_myaccount_remove_orders_tab', [ 'default' => false ] );
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_myaccount_remove_orders_tab', [
    'label' => __( 'Remove orders tab', 'ahura' ),
    'section' => $this->current_section
] ) );

$this->customizer->add_setting( 'ahura_myaccount_remove_download_tab', [ 'default' => false ] );
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_myaccount_remove_download_tab', [
    'label' => __( 'Remove download tab', 'ahura' ),
    'section' => $this->current_section
] ) );

$this->customizer->add_setting( 'ahura_myaccount_remove_address_tab', [ 'default' => false ] );
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_myaccount_remove_address_tab', [
    'label' => __( 'Remove edit address tab', 'ahura' ),
    'section' => $this->current_section
] ) );

$this->customizer->add_setting( 'ahura_myaccount_remove_account_tab', [ 'default' => false ] );
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_myaccount_remove_account_tab', [
    'label' => __( 'Remove edit account tab', 'ahura' ),
    'section' => $this->current_section
] ) );

$this->customizer->add_setting( 'ahura_myaccount_remove_logout_tab', [ 'default' => false ] );
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_myaccount_remove_logout_tab', [
    'label' => __( 'Remove logout tab', 'ahura' ),
    'section' => $this->current_section
] ) );