<?php
namespace ahura\app\elementor;

use ahura\app\mw_options;
use Elementor\Plugin;

class Elementor_Assets
{
    /**
     *
     * Get the id of the pages used in the current state
     *
     * @return array|null
     */
    public static function get_page_ids()
    {
        global $wp_styles;
        $ids = [];

        if(!empty($wp_styles)){
            foreach ($wp_styles->queue as $style){
                preg_match_all('!\d+!', $style, $matches);
                $id = implode('', $matches[0] ?? []);
                if (empty($id) || get_post_status($id) != 'publish')
                    continue;
                $ids[] = implode('', $matches[0]);
            }
        }

        return is_array($ids) && !empty($ids) ? array_unique($ids) : [];
    }

    /**
     *
     * Extract element types (name) from current page elements
     *
     * @param $elements
     * @return array
     */
    public static function extract_element_types($elements)
    {
        $types = [];

        array_walk_recursive($elements, function($value, $key) use (&$types) {
            if ($key === 'widgetType') {
                $types[] = $value;
            }
        });

        return $types;
    }

    /**
     *
     * Load current page assets
     *
     * @return false|void
     */
    public static function load_page_elements_asset()
    {
        $pages_id = self::get_page_ids();

        if (empty($pages_id) || !is_array($pages_id))
            return false;

        $widgets = Plugin::instance()->widgets_manager->get_widget_types();

        foreach ($pages_id as $id){
            $document = \Elementor\Plugin::$instance->documents->get($id);

            if (empty($document) || !method_exists($document, 'get_elements_data'))
                continue;

            $page_elements = $document->get_elements_data();

            if(!empty($page_elements) && is_array($page_elements)){
                $types = self::extract_element_types($page_elements);

                if (!empty($types)){
                    foreach ($types as $type){
                        $class = $widgets[$type] ?? null;
                        if (is_object($class) && method_exists($class, '__register_assets')){
                            $class->__register_assets();
                        }
                    }
                }
            }
        }

        global $wp_styles;

        if (!empty($wp_styles)){
            foreach ($wp_styles->registered as $style){
                $handle = $style->handle;
                if (!ahura_str_contains($handle, 'ah_elementor'))
                    continue;

                wp_enqueue_style($handle, $style->src, $style->deps, $style->ver);
            }
        }
    }

    public static function enqueue_elementor_post_scripts(){
        if ( class_exists( '\Elementor\Plugin' ) ) {
            $elementor = \Elementor\Plugin::instance();
            $elementor->frontend->enqueue_styles();
        }

        if ( class_exists( '\ElementorPro\Plugin' ) ) {
            $elementor_pro = \ElementorPro\Plugin::instance();
            if ( method_exists( $elementor_pro, 'enqueue_styles' ) ) {
                $elementor_pro->enqueue_styles();
            }
        }

        if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
            $css_file = new \Elementor\Core\Files\CSS\Post(mw_options::get_custom_header_id());
        } elseif ( class_exists( '\Elementor\Post_CSS_File' ) ) {
            $css_file = new \Elementor\Post_CSS_File(mw_options::get_custom_header_id());
        }

        if (isset($css_file))
            $css_file->enqueue();

        if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
            $css_file = new \Elementor\Core\Files\CSS\Post(mw_options::get_custom_footer_id());
        } elseif ( class_exists( '\Elementor\Post_CSS_File' ) ) {
            $css_file = new \Elementor\Post_CSS_File(mw_options::get_custom_footer_id());
        }

        if (isset($css_file))
            $css_file->enqueue();

        self::load_page_elements_asset();
    }

    public static function enqueue_elementor_post_scripts_on_footer(){
        self::load_page_elements_asset();
    }
}