<?php
namespace ahura\app;

use ahura\app\Logger;

class Demo_Manager {
    private static $endpoint = 'demo/ahura/wp-json/demo_manager/';
    private static $usages_endpoint = 'demo/ahura/wp-json/demo_manager/usages/increase/';

    public static function getApiUrl()
    {
        $license = license::get_license_key();
        return strpos($license, 'ertano_') === 0 ? 'https://ertano.com/' . self::$endpoint : 'https://mihanwp.com/' . self::$endpoint;
    }

    public static function getUsagesApiUrl($demo_real_id)
    {
        $license = license::get_license_key();
        return strpos($license, 'ertano_') === 0 ? 'https://ertano.com/' . self::$usages_endpoint . $demo_real_id : 'https://mihanwp.com/' . self::$usages_endpoint . $demo_real_id;
    }

    public static function getList()
    {
        $lang_param = "?lang=" . get_locale();
        $api_url = self::getApiUrl() . 'list' . $lang_param;
        return self::client([
            'url' => $api_url,
            'license' => license::get_license_key()
        ]);
    }

    public static function getCategories()
    {
        $api_url = self::getApiUrl() . 'categories';
        return self::client([
            'url' => $api_url,
            'license' => license::get_license_key()
        ]);
    }

    public static function updateDemoUsages($demo_real_id)
    {
        return self::client(['url' => self::getUsagesApiUrl($demo_real_id)]);
    }

    public static function client($params)
    {
        if (!isset($params['license'])){
            $params['license'] = license::get_license_key();
        }

        $args = [
            'timeout' => 350,
            'sslverify' => true,
            'headers' => array(
                'API-KEY' => $params['license'],
            ),
        ];

        $remote = wp_remote_get($params['url'], $args);
        $response = wp_remote_retrieve_body($remote);
        return !is_wp_error($remote) && wp_remote_retrieve_response_code($remote) === 200 && ahura_is_json($response) ? json_decode($response, 1) : false;
    }
}