<?php
/* template name: Project */
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
?>

<div class="page-wrap archive-project">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-10 mx-auto page-head">
                <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                    <?php echo get_the_title(); ?>
                </h1>
            </div>
            <div class="col-12 filters">
                <div class="row justify-content-center mb-2 filterGroup" data-filter-group="st">
                    <button class="col-auto button" data-filter=".process">در حال اجرا</button>
                    <button class="col-auto button" data-filter=".completed">اتمام شده</button>
                    <button class="col-auto button" data-filter=".external">بین الملل</button>
                    <button class="col-auto button" data-filter=".internal">داخلی</button>
                </div>
                <?php
                $terms = get_terms(array(
                    'taxonomy' => 'project-category',
                    'hide_empty' => false,
                ));
                if (!$terms) {
                    return;
                } ?>
                <div class="row justify-content-center mb-5 filterGroup" data-filter-group="cs">
                    <?php foreach ($terms as $term) { ?>
                        <button class="col-auto button"
                                data-filter=".<?php echo $term->term_id; ?>"><?php echo $term->name; ?></button>
                    <?php } ?>
                </div>
                <div class="grid">
                    <?php
                    $args = array(
                        'post_type' => 'project',
                        'paged' => $paged,
                        'post_status ' => 'publish',
                        'posts_per_page' => 15
                    );
                    $posts = new WP_Query($args);
                    if ($posts->have_posts()):
                        $i = 0.25;
                        while ($posts->have_posts()) : $posts->the_post();
                            $status = get_field('project_status');
                            $location = get_field('location');
                            $taxonomy = 'project-category';
                            $pr_terms = get_the_terms(get_the_ID(), $taxonomy);
                            if ($pr_terms && !is_wp_error($pr_terms)) {
                                $pterm = $pr_terms[0];
                                $cl = $pterm->term_id;
                            }

                            ?>
                    <div class="col-12 col-sm-6 col-lg-3 project-ca <?php echo $status['value']; ?> <?php echo $location['value']; ?> <?php echo $pr_terms && !is_wp_error($pr_terms) ? $cl : ''; ?>">

                        <div class="project-card">
                                <div class="entry-media position-relative">
                                    <a href="<?php echo get_the_permalink(); ?>">
                                        <figure>
                                            <?php the_post_thumbnail('project-img'); ?>
                                        </figure>
                                    </a>
                                    <div class="project-category">
                                        <?php
                                        if ($pr_terms && !is_wp_error($pr_terms)) {
                                            $pterm = $pr_terms[0];
                                            echo '<a href="' . get_term_link($pterm->term_id) . '">' . $pterm->name . '</a>';
                                        }
                                        ?>
                                    </div>
                                </div>

                                <div class="entry-content">
                                    <h3 class="entry-title"><a
                                                href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                    </h3>
                                    <div class="entry-meta d-flex flex-column">
                                        <?php if ($status != '') {
                                            echo '<span><i class="icon-status"></i>' . $status['label'] . '</span>';
                                        } ?>
                                        <?php if ($location != '') {
                                            echo '<span><i class="icon-map"></i>' . $location['label'] . '</span>';
                                        } ?>
                                    </div>
                                </div>
                            </div>
                            <?php echo '</div>';
                            $i += 0.25; endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
                <!-- Pagination -->
                <div class="pagination">
                    <?php pagination_bar($posts); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>
