<?php

ob_start();
function socialshares () {
	$title= urlencode(get_the_title());
	$url= urlencode(get_permalink());
	$homeurl= urlencode(get_bloginfo('url'));
	$desc = urlencode(get_the_excerpt());
	$share = '<ul class="share-social">';
	$share .= '<li><span><i class="icon-share"></i></span></li>';
	$share .= '<li class="facebook"><a href="https://www.facebook.com/sharer/sharer.php?u='.$url.'&amp;t='.$title.'" title="Share on Facebook" target="_blank" rel=" nofollow noopener"><i class="icon-facebook"></i></a></li>';
    $share .= '<li class="twitter"><a href="https://twitter.com/intent/tweet?source='.$url.'&amp;text='.$title.':'.$homeurl.'" target="_blank" title="Tweet" rel="nofollow noopener" class=""><i class="icon-twitter"></i></a></li>';
	$share .= '<li class="telegram"><a href="https://telegram.me/share/url?url='.$url.'&amp;text='.$title.':'.$homeurl.'" title="telegram" rel="nofollow noopener" target="_blank"><i class="icon-telegram"></i></a></li>';
	$share .= '<li class="linkedin"><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url='.$url.'&amp;title='.$title.'&amp;summary='.$desc.'&amp;source='.$homeurl.'" target="_blank" title="Share on LinkedIn" class="" rel="nofollow noopener" ><i class="icon-linkedin"></i></a></li>';
	$share .= '</ul>';
	return $share;
}

//Show Social Links
function sociallinks()
{
    if (have_rows('add_social', 'option')):
        $share = '<ul class="social-list d-flex align-items-center">';
        while (have_rows('add_social', 'option')) : the_row();
            $social_name = get_sub_field('social_icon', 'option');
            $social_url = get_sub_field('social_link', 'option');
            if ($social_url != '') {
                $share .= '<li>';
                $share .= '<a href = "' . $social_url . '" target = "_blank" class="' . $social_name . '" >';
                $share .= '<i class="icon-' . $social_name . '" ></i >';
                $share .= '</a >';
                $share .= '</li>';
            }
        endwhile;
        $share .= '</ul>';
        return $share;
    endif;
}

//lightgallery
add_filter('post_gallery', 'ct_post_gallery', 10, 2);
function ct_post_gallery($output, $attr) {
    global $post;

    if (isset($attr['orderby'])) {
        $attr['orderby'] = sanitize_sql_orderby($attr['orderby']);
        if (!$attr['orderby'])
            unset($attr['orderby']);
    }

    extract(shortcode_atts(array(
        'order' => 'ASC',
        'orderby' => 'menu_order ID',
        'id' => $post->ID,
        'itemtag' => 'dl',
        'icontag' => 'dt',
        'captiontag' => 'dd',
        'columns' => 3,
        'size' => 'medium',
        'include' => '',
        'exclude' => ''
    ), $attr));

    $id = intval($id);
    if ('RAND' == $order) $orderby = 'none';

    if (!empty($include)) {
        $include = preg_replace('/[^0-9,]+/', '', $include);
        $_attachments = get_posts(array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby));

        $attachments = array();
        foreach ($_attachments as $key => $val) {
            $attachments[$val->ID] = $_attachments[$key];
        }
    }

    if (empty($attachments)) return '';

    // Here's your actual output, you may customize it to your need
    $output .= "<div class=\"position-relative\"><div class=\"swiper swiper-gallery\"><div class=\"swiper-wrapper page_lightgallery\" id=\"page_lightgallery\">\n";

    // Now you loop through each attachment
    foreach ($attachments as $id => $attachment) {
        // Fetch the thumbnail (or full image, it's up to you)
        $full = wp_get_attachment_image_src($id, 'full');
        // $img = wp_get_attachment_image_src($id, 'my-custom-image-size');
        $size = 'medium';
        $img = wp_get_attachment_image_src($id, $size);
        $image_alt = get_post_meta( $id , '_wp_attachment_image_alt', true);
        $output .= "<div class=\"swiper-slide gallery_item\" data-src=\"{$full[0]}\" data-thumb=\"{$full[0]}\">\n";
        $output .= "<a href=\"{$full[0]}\" ><i class='icon-plus'></i><img src=\"{$img[0]}\" width=\"{$img[1]}\" height=\"{$img[2]}\" alt=\"{$image_alt}\" /></a>\n";
        $output .= "</div>\n";
    }

    $output .= "</div></div><div class=\"swiper-button-prev\"></div><div class=\"swiper-button-next\"></div></div>\n";

    return $output;
}

// Pagination
function pagination_bar( $custom_query ) {
	$total_pages = $custom_query->max_num_pages;
	//echo $total_pages;
	$big = 999999999; // need an unlikely integer
	if ($total_pages > 1){
		$current_page = max(1, get_query_var('paged'));
		echo paginate_links(array(
			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format' => '?paged=%#%',
			'prev_text' => __('<i class="icon-chevron-left"></i>'),
			'next_text' => __('<i class="icon-chevron-left"></i>'),
			'before_page_number' => '',
			'current' => $current_page,
			'total' => $total_pages,
		));
	}
}

add_action('acf/init', 'my_acf_op_init');
function my_acf_op_init() {

    // Check function exists.
    if( function_exists('acf_add_options_page') ) {

        // Register options page.
        $option_page = acf_add_options_page(array(
            'page_title'    => __('خدمات تخصصی'),
            'menu_title'    => __('خدمات تخصصی'),
            'menu_slug'     => 'theme-general-settings',
            'capability'    => 'edit_posts',
            'redirect'      => false
        ));
    }
}

// Request
add_filter('acf/validate_value/name=request_number', 'my_acf_validate_value', 10, 4);
function my_acf_validate_value( $valid, $value, $field, $input ){
    if( preg_match('/^[0-9]{11}$/D', $value ) ) {
        return $valid;
    } else {
        if( !$value ) {
            return 'لطفا شماره موبایل خود را  وارد نمایید';
        } else {
            return 'ورود حروف غیرمجاز است، لطفا عدد صحیح وارد نمایید.';

        }
    }
}



//function acf_review_before_save_post($post_id) {
//    $_POST['acf']['_post_title'] = $_POST['acf']['name_pro'];
//    return $post_id;
//}
//add_action('acf/pre_save_post', 'acf_review_before_save_post', -1);



add_action( 'admin_menu', 'pending_posts_bubble_wpse_89028', 999 );
function pending_posts_bubble_wpse_89028() {
    global $menu; $args = array( 'public' => true , 'name' => 'requests' );
    $post_types = get_post_types( $args ); $post_types = get_post_types( $args );
    $args = array(
        'post_type' => array('requests') ,
        'post_status' => 'draft',
    );
    foreach( $post_types as $pt ){
        // Count posts
        $cpt_count = wp_count_posts( $pt );
        if ( $cpt_count->draft ) {
            // Menu link suffix, Post is different from the rest
            $suffix = ( 'post' == $pt ) ? '' : "?post_type=$pt";
            // Locate the key of
            $key = recursive_array_search_php_91365( "edit.php$suffix", $menu );
            // Not found, just in case
            if( !$key )
                return;
            // Modify menu item
            $menu[$key][0] .= sprintf( '<span class="update-plugins count-%1$s" style="background- color:white;color:black"><span class="plugin-count">%1$s</span></span>', $cpt_count->draft );
        }
    }
}


function recursive_array_search_php_91365( $needle, $haystack ) {
    foreach( $haystack as $key => $value ) {
        $current_key = $key;
        if($needle === $value OR ( is_array( $value ) && recursive_array_search_php_91365( $needle, $value ) !== false ) ) { return $current_key;}
    }
    return false;
}

?>

