<?php
/* Template Name: Contact */
get_header();
$map_code = get_field('map_code');
?>

<div class="page-wrap contact_page">
    <div class="container">
        <div class="row mb-5">
            <div class="col-12 col-lg-9 mx-auto">
                <div class="row align-items-center">
                    <div class="col-12 page-head">
                        <h1 class="page-title wow fadeInUp" data-wow-delay="0.25s">
                            <?php echo get_the_title(); ?>
                        </h1>
                    </div>
                    <?php
                    if (have_rows('add_contact')):

                        while (have_rows('add_contact')) : the_row();
                            $contact_name = get_sub_field('contact_name');
                            $address = get_sub_field('address');
                            $email = get_sub_field('email');
                            $phone = get_sub_field('phone');

                            ?>
                            <div class="col-12 col-lg-6 contact-info-wrap">
                                <div class="contact-info-box  wow fadeInUp" data-wow-delay="0.5s">
                                   <?php if ($contact_name != '') { echo '<h3>'.$contact_name.'</h3>'; }
                                    if ($address != '') {
                                        echo '<div class="contact-item">
                                            <span class="icon-wrapper"><i class="icon-location"></i></span>
                                                <span>' . $address . '</span>
                                        </div>';
                                    }
                                    if ($phone != '') {
                                        echo '<div class="contact-item" >
                                            <span class="icon-wrapper"><i class="icon-phone"></i></span>
                                                <a class="ltr" href="tel:' . $phone . '">' . $phone . '</a>
                                        </div>';
                                    }
                                    if ($email != '') {
                                        echo '<div class="contact-item">
                                             <span class="icon-wrapper"><i class="icon-email"></i></span>
                                                <a href="mailto:' . $email . '">' . $email . '</a>
                                        </div>';
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php
                        endwhile;
                        endif; ?>
                </div>
            </div>
        </div>
    </div>

    <section class="contact-form-sec">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-6 order-last order-lg-first">
                    <?php
                    echo '<div class="contact-form-wrap">';
                    echo '<h4 class="section-title  wow fadeInUp" data-wow-delay="0.5s">با ما در ارتباط باشید</h4>';
                    echo '<div class="position-relative contact-form">';
                    echo do_shortcode('[contact-form-7 id="fcfc072" title="فرم تماس"]');
                    echo '</div></div>';
                    ?>
                </div>
                <div class="col-12 col-lg-6">
                    <?php if ($map_code != '') { ?>
                        <div class="contact-map wow fadeInUp" data-wow-delay="0.5s">
                            <?php echo $map_code; ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
</div>
<?php get_footer(); ?>

