<?php

/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version 4.4.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
global $post;
do_action('woocommerce_account_dashboard');
do_action('woocommerce_before_my_account');
?>
<style>
	.footer-checkout {
		display: none;
	}
</style>
<div class="wo-profile-content">
	<div class="box__dashboard row">
		<div class="col-12 col-md-6 col-lg-3">
			<div class="dash_card blue">
				<title><?php esc_html_e('Cart', 'denver'); ?></title>
				<i class="fal fa-shopping-basket"></i>
				<div class="value">
					<div class="header-cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></div>
				</div>
				<div class="stat">
					<a href="<?php echo wc_get_cart_url(); ?>" title="<?php _e('View your shopping cart', 'denver'); ?>" target="block"><?php _e('See more', 'denver'); ?></a>
				</div>
			</div>
		</div>
		<div class="col-12 col-md-6 col-lg-3">
			<div class="dash_card green">
				<title><?php esc_html_e('Wishlist', 'denver'); ?></title>
				<i class="fal fa-heart"></i>
				<?php if (class_exists('YITH_WCWL_Privacy')) {
					$wishlist_count = YITH_WCWL()->count_products(); ?>
					<div class="value"><?php echo $wishlist_count; ?></div>
					<div class="stat">
						<a href="<?php echo esc_url(home_url('/wishlist')); ?>" target="block"><?php _e('See more', 'denver'); ?></a>
					</div>
				<?php
				} else {
					echo '<div class="stat">';
					echo 'سیستم علاقه مندی ها فعال نیست !';
					echo '</div>';
				} ?>
			</div>
		</div>
		<div class="col-12 col-md-6 col-lg-3">
			<div class="dash_card orange">
				<title><?php esc_html_e('orders', 'denver'); ?></title>
				<i class="fal fa-box-check"></i>
				<div class="value"><?php echo wc_product_sold_count(); ?></div>
				<div class="stat">
					<a href="<?php echo wc_get_account_endpoint_url('orders'); ?>"><?php _e('See more', 'denver'); ?></a>
				</div>
			</div>
		</div>
		<div class="col-12 col-md-6 col-lg-3">
			<div class="dash_card red">
				<title><?php esc_html_e('Total amount purchased', 'denver'); ?></title>
				<i class="fal fa-sack-dollar"></i>
				<div class="value">
					<?php
					echo get_customer_total_order();
					echo '<span style="font-size: 14px;margin-right: 10px;">' . get_woocommerce_currency_symbol() . '</span>';
					?>
				</div>
				<div class="stat">
					<a href="#"><?php esc_html_e('See more', 'denver'); ?></a>
				</div>
			</div>
		</div>
	</div>
	<?php
	if (do_shortcode('[my_purchased_products]')) { ?>
		<header>
			<span class="title_single" style="display: block;"><?php esc_html_e('Products purchased', 'denver'); ?></span>
		</header>
	<?php
		echo do_shortcode('[my_purchased_products]');
	} else { ?>
		<header>
			<span class="title_single" style="display: block;"><?php esc_html_e('You have purchased a product !', 'denver'); ?></span>
		</header>
	<?php } ?>
	<section class="woo-list-slider-owl woo_upsells">
		<header>
			<span><?php esc_html_e('The latest blog content', 'denver'); ?></span>
		</header>
		<div class="wo-box">
			<div class="swiper-container">
				<div class="swiper-wrapper" style="height: 325px;">
					<div class="owl-posts owl-carousel owl-theme sec-promotions" style=" width: 100%;">
						<?php
						$args = array(
							'post_type' => 'post',
							'posts_per_page' => '20',
						);

						$post_query = new WP_Query($args);

						if ($post_query->have_posts()) {
							while ($post_query->have_posts()) {
								$post_query->the_post();
						?>
								<div class="posts_my_account">

									<div class="new_posts_my_account">
										<a href="<?php the_permalink(); ?>">
											<figure class="">
												<?php
												if (has_post_thumbnail()) {
													the_post_thumbnail(array(300, 300), array('alt' => '' . get_the_title(), 'title' => '' . get_the_title() . ''));
												} else { ?>
													<img src="<?php print(get_template_directory_uri()); ?>/assets/images/thumb.gif" width="60" height="60" alt="تصویر پیدا نشد" title="تصویر پیدا نشد">
												<?php } ?>
											</figure>
											<figcaption>
												<?php the_title() ?>
												<span class="post-time" style="bottom:0px">
													<?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?>
												</span>
											</figcaption>
										</a>
									</div>
								</div>
						<?php
							}
						}
						?>

					</div>
				</div>
			</div>
		</div>
	</section>
</div>
<?php
/**
 * My Account dashboard.
 *
 * @since 2.6.0
 */

/**
 * Deprecated woocommerce_before_my_account action.
 *
 * @deprecated 2.6.0
 */

/**
 * Deprecated woocommerce_after_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action('woocommerce_after_my_account');

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
