<?php


require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';


class CLOUD_SERVER_ADMIN
{

    public static function  GetList($token, $idc)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT " . $GLOBALS['csid'] . " as ServerID," . $GLOBALS['csname'] . " as ServerName,
        " . $GLOBALS['cs_ip'] . " as ServerIP, IF(" . $GLOBALS['cs_additionalip'] . " =0, 'NoAdditionalIP', 'AdditionalIP') as AdditionalIP ,
                    CASE
                    WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
                    WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
                    WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
                    WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
                    WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
                    WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
                    WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
                    WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
                        
            END as server_Status ," .
            $GLOBALS['cs_startdate'] . " as ServerStartDate," . $GLOBALS['cs_lastupdate'] . " as ServerLastUpdate,
        " . $GLOBALS['cs_ram'] . " as ServerRam," . $GLOBALS['cs_vcpu'] . " as ServerVCPU," . $GLOBALS['cs_hard'] . " as ServerHard 
        from " . $GLOBALS["cloud_server_tablename"] . " 
        
        where " . $GLOBALS['cs_uid_fk'] . "=" . $uid . " and " . $GLOBALS['cs_idcid_fk'] . "=" . $idc;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        for ($i = 0; $i < count($listOfRecordType); $i++) {
            if ($listOfRecordType[$i]["AdditionalIP"] == "AdditionalIP") {
                $listOfRecordType[$i]["AdditionalIP"] = CLOUD_ADDITIONALIP_ADMIN::GetList($listOfRecordType[$i]["ServerID"]);
            }
        }
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد ", "data" => $listOfRecordType];
    }
    public static  function UserCanAccessToServer($uid, $sid)
    {

        $sql = "SELECT * from " . $GLOBALS["cloud_server_tablename"] . " 
          where " . $GLOBALS['cs_uid_fk'] . "=" . $uid . " and " . $GLOBALS['csid'] . "=" . $sid;


        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است",];
            return $result;
        } else {
            $listOfRecordType = [
                "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)
            ];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function HardReboot($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        API_CLOUD_SERVER_ADMIN::RunHardReboot($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
        self::SetLastUpdateServer($id);
        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد "];
    }
    public static function SoftReboot($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        API_CLOUD_SERVER_ADMIN::RunSoftReboot($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
        self::SetLastUpdateServer($id);
        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد "];
    }
    public static function ChangePassword($token, $id, $password)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }

        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
  
        $r=TOOLS_ADMIN::checkPassword($password);
        if($r!="success"){
            return ["status"=>"error","message"=>$r];
        };
        API_CLOUD_SERVER_ADMIN::RunChangePassword($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"], $password);
        self::SetLastUpdateServer($id);
        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد "];
    }
    public static function RebuildServer($token,$serverid,$os){
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $serverid);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        if($u["data"][0]["cs_status"]!="1"){
            return ["status"=>"error","message"=>"سرور شما در وضعیت فعال نیست و وامکان تغییر ندارد"];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $osimage = CLOUD_FLAVOR_ADMIN::ReturnOSID($os);
        if ($osimage["status"] == "error") {
            return ["status" => "error", "message" => "سیستم عامل درخواستی شما اشتباه است "];
        }
        
         API_CLOUD_SERVER_ADMIN::RunRebuildOS($m,$u["data"][0]["cs_serverid"],$osimage["os"],
        $u["data"][0]["cs_idcid_fk"]);
        self::ChangeServerStatus($serverid, 6);
        self::UpdateServerDetailsFromAPI("cs_osid",$osimage["os"] , $serverid);
        self::UpdateServerDetailsFromAPI("cs_osname",$osimage["os"] , $serverid);
        return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد "]; 
    }
    public static function RestoreSnapShot($token,$serverid,$snapshotid){
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $serverid);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        if($u["data"][0]["cs_status"]!="1"){
            return ["status"=>"error","message"=>"سرور شما در وضعیت فعال نیست و وامکان تغییر ندارد"];
        }
        $n=CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid,$snapshotid);
        
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        
         API_CLOUD_SERVER_ADMIN::RunRestoreSnapshot($m,$u["data"][0]["cs_serverid"],$n["data"][0]["cv_serverid"],
        $u["data"][0]["cs_idcid_fk"]);
        self::ChangeServerStatus($serverid, 6);
        self::UpdateServerDetailsFromAPI("cs_osid",$n["data"][0]["cv_osid"], $serverid);
        self::UpdateServerDetailsFromAPI("cs_osname",$n["data"][0]["cv_osname"] , $serverid);
        return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد "]; 
    }
    public static function GetVNC($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        $i = API_CLOUD_SERVER_ADMIN::RunGetVNCConsole($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد ", "console" => $i];
    }
    public static function ChangeServerStatus($id, $status)
    {
        $sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] . " SET  " . $GLOBALS['cs_status']
            . "='" . $status . "' where " . $GLOBALS['csid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        self::SetLastUpdateServer($id);
    }
    public static function PauseServer($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        if ($u["data"][0]["cs_status"] != "1") {
            return ["status" => "error", "message" => "سرور شما در حالت فعال نیست"];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        API_CLOUD_SERVER_ADMIN::RunPauseServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
        self::ChangeServerStatus($id, 4);
        self::SetLastUpdateServer($id);
        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد ",];
    }
    public static function UnPauseServer($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        if ($u["data"][0]["cs_status"] != "4") {
            return ["status" => "error", "message" => "سرور شما در حالت توقف نیست  "];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        API_CLOUD_SERVER_ADMIN::RunUnPauseServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
        self::ChangeServerStatus($id, 1);
        self::SetLastUpdateServer($id);
        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد ",];
    }
    public static function ChangeServerHostname($token, $id, $hostname)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);

        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        if ($u["data"][0]["cs_status"] != "1") {
            return ["status" => "error", "message" => "وضعیت سرور شما  در حالت فعال نیست و شما امکان تغییر هاست نیم را ندارید "];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        if (!preg_match("/^[a-zA-z0-9.]*$/", $hostname)) {
            return ["status" => "error", "message" => "هاست نیم ارسالی شما نامعتبر است "];
        }

        $sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] . " SET  " . $GLOBALS['csname']
            . "='" . $hostname . "' where " . $GLOBALS['csid'] . "=" . $id;

        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        API_CLOUD_SERVER_ADMIN::RunChangeHostname($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"], $hostname);
        self::SetLastUpdateServer($id);
        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد ",];
    }
    public static function  SetLastUpdateServer($id)
    {

        $now =   date("Y/m/d H:i:s");

        $sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] . " SET  " . $GLOBALS['cs_lastupdate']
            . "='" . $now . "' where " . $GLOBALS['csid'] . "=" . $id;

        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function DeleteServer($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);

        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        if ($u["data"][0]["cs_status"] != "1") {
            return ["status" => "error", "message" => "وضعیت سرور شما  در حالت فعال نیست و شما امکان تغییر هاست نیم را ندارید "];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);


        self::ChangeServerStatus($id, "5");
        self::SetLastUpdateServer($id);
        API_CLOUD_SERVER_ADMIN::RunDeleteServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);

        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد ",];
    }
    public static function GetOneByID($token, $vid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT " . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cv_name'] . " as VolumeName,
        " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
            $GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate,
        csname as ServerHostName from " . $GLOBALS["cloud_volume_tablename"] . " 
        LEFT JOIN tbl_cloud_server ON cv_csid_fk=csid 
        where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " and " . $GLOBALS['cvid'] . "=" . $vid;


        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است",];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function RemoveKey($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $sshkeys = self::GetOneByID($token, $id);
        if ($sshkeys["status"] != "success") {
            return ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);


        //$sql = "DELETE FROM " . $GLOBALS["cloud_sshkey_tablename"] . " WHERE sk_serverid='" . $sshkeys["data"][0]["hashkey"]."'";
        // $conn = GetConnection();
        // $conn->query($sql);
        $id = API_CLOUD_SSHKEY_ADMIN::RunRemoveSSHKEY($sshkeys["data"][0]["hashkey"], $m, $sshkeys["data"][0]["idc"]);
        //  $conn->close();

        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد", $id];
    }
    public static function ShutDownServer($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        if ($u["data"][0]["cs_status"] != "1") {
            return ["status" => "error", "message" => "سرور شما در روشن نیست  "];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        API_CLOUD_SERVER_ADMIN::RunShutDownServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
        self::ChangeServerStatus($id, 7);
        self::SetLastUpdateServer($id);
        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد ",];
    }
    public static function StartServer($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        if ($u["data"][0]["cs_status"] != "7") {
            return ["status" => "error", "message" => "سرور شما در خاموش نیست  "];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        API_CLOUD_SERVER_ADMIN::RunStartServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
        self::ChangeServerStatus($id, 1);
        self::SetLastUpdateServer($id);
        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد ",];
    }
    public static function ResizeServer($token, $id, $cpu, $ram)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }
        if ($u["data"][0]["cs_status"] != "1") {
            return ["status" => "error", "message" => "سرور شما در حالت روشن نیست  "];
        }
        if (filter_var($ram, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "میزان رم ارسالی نامعتبر است "];
        }
        if (filter_var($cpu, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "میزان CPU ارسالی نامعتبر است "];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] . " SET  " . $GLOBALS['cs_ram']
            . "='" . $ram . "'," . $GLOBALS['cs_vcpu'] . "='" . $cpu . "' where " . $GLOBALS['csid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        self::SetLastUpdateServer($id);
        $flavordid = CLOUD_FLAVOR_ADMIN::ReturnFLAVORID($ram, $cpu);
        API_CLOUD_SERVER_ADMIN::RunResizeServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"], $flavordid["package"]);
        self::ChangeServerStatus($id, 1);
        self::SetLastUpdateServer($id);
        return ["status" => "success", "message" => "درخواست شما با موفقیت  انجام شد ",];
    }
    public static function AttachInternalInterface($token, $serverid, $privatenetworkid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $serverid);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
        }

        $n = CLOUD_PRIVATENETWORKS_ADMIN::UserCanAccessToPrivateNetwork($uid, $privatenetworkid);
        if ($n["status"] == "error") {
            return ["status" => "error", "message" => " شما اجازه دسترسی به این شبکه را ندارید "];
        }
        $ip = API_CLOUD_SERVER_ADMIN::RunAttachInternalNetwork(
            $m,
            $u["data"][0]["cs_idcid_fk"],
            $u["data"][0]["cs_serverid"],
            $n["data"][0]["cv_serverid"]
        );
        $rip = json_decode($ip)[0]->ip_address;
        $returnedid = CLOUD_ADDITIONALIP_ADMIN::AddIP($serverid, json_decode($ip)[0]->ip_address, 0)["id"];
        $a = API_CLOUD_SERVER_ADMIN::GetInterfaceList(
            $m,
            $u["data"][0]["cs_idcid_fk"],
            $u["data"][0]["cs_serverid"]
        );
        $x = json_decode($a, true);
        $list = $x["interfaces"];
        $r = CLOUD_ADDITIONALIP_ADMIN::UpdateFromAPI($returnedid, $rip, $list);
        self::UpdateServerDetailsFromAPI("cs_additionalip", 1, $serverid);
        self::SetLastUpdateServer($serverid);
        CLOUD_NETWORKSERVER_ADMIN::AddNetWorkToServer( $serverid,0,$privatenetworkid);
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد "];
    }
    public static function DetachInternalInterface($token, $ipid, $serverid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $c = self::UserCanAccessToServer($uid, $serverid);

        if ($c["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید "];
        }
        $b = CLOUD_ADDITIONALIP_ADMIN::DeleteAdditionalIP($ipid, $serverid);
        if ($b["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این IP را ندارید "];
        }
        API_CLOUD_SERVER_ADMIN::RunDetachInternalNetwork(
            $m,
            $c["data"][0]["cs_idcid_fk"],
            $c["data"][0]["cs_serverid"],
            $b["data"]["data"][0]["ca_serverid"]
        );

        if (CLOUD_ADDITIONALIP_ADMIN::ReturnCountOfAdditionalIps($serverid) == "0") {
            self::UpdateServerDetailsFromAPI("cs_additionalip", 0,  $serverid);
        }
        self::SetLastUpdateServer($serverid);
        
        CLOUD_NETWORKSERVER_ADMIN::DeleteNetWorkFromServer($serverid,0,$ipid);
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد "];
    }
    public static function UpdateServerDetailsFromAPI($field, $value, $id)
    {
        $sql = "UPDATE  " . $GLOBALS["cloud_server_tablename"] . " SET " . $GLOBALS[$field] . "='" . $value . "'
                where " . $GLOBALS['csid'] . "=" . $id;
        $conn = GetConnection();
        mysqli_query($conn, $sql);
        $conn->close();
    }
    public static function GetServerDetail($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        $sql = "SELECT " . $GLOBALS['csid'] . " as ServerID," . $GLOBALS['csname'] . " as ServerName,
        " . $GLOBALS['cs_ip'] . " as ServerIP, IF(" . $GLOBALS['cs_additionalip'] . " =0, 'NoAdditionalIP', 'AdditionalIP') as AdditionalIP ,cs_firewall as Firewall,
                    CASE
                WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
                WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
                WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
                WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
                WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
                WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
                WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
                WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
                	
            END as server_Status ," .
            $GLOBALS['cs_startdate'] . " as ServerStartDate," . $GLOBALS["cs_idcid_fk"] . " as IDCID," . $GLOBALS["cs_serverid"] . " as BackID," . $GLOBALS['cs_lastupdate'] . " as ServerLastUpdate,
        " . $GLOBALS['cs_ram'] . " as ServerRam," . $GLOBALS['cs_vcpu'] . " as ServerVCPU," . $GLOBALS['cs_hard'] . " as ServerHard 
        from " . $GLOBALS["cloud_server_tablename"] . " 
        
        where " . $GLOBALS['cs_uid_fk'] . "=" . $uid . " and " . $GLOBALS['csid']  . "=" . $id;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);


        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است",];
            return $result;
        } else {
            if($listOfRecordType[0]["BackID"]==""){
                return ["status"=>"error","message"=>"خطا در ایجاد سرور "];
            }
            if ($listOfRecordType[0]["server_Status"] == "build") {

                $n =   API_CLOUD_SERVER_ADMIN::GetServerDetailFromAPI(
                    $m,
                    $listOfRecordType[0]["IDCID"],
                    $listOfRecordType[0]["BackID"]
                );

                $i = str_replace("'", '"', $n->addresses);
                $ip = json_decode($i, true);
            
               if(array_key_exists("public-1",$ip)){
                      $ip = $ip["public-1"][0]["addr"];
                self::UpdateServerDetailsFromAPI("cs_ip", $ip, $id);
               }
             
                $status = $n->status;
                if ($status == "ACTIVE") {
                    self::UpdateServerDetailsFromAPI("cs_status", 1, $id);
                }
            }
            $f=explode(",",$listOfRecordType[0]["Firewall"]);
            $fs=[];
            foreach($f as $s){
                    array_push($fs,CLOUD_FIREWALL_ADMIN::GetOneByID($s));
            }
            unset($listOfRecordType[0]["Firewall"]);
            $afw=CLOUD_SECURITYGROUPSTOSERVER_ADMIN::GetList($id);
            $listOfRecordType[0]["Firewall"]= $fs;
            $listOfRecordType[0]["AdditionalFirewall"]=$afw;
            $vl=CLOUD_VOLUME_ADMIN::GetOneByServerID($id,0);
            $sn=CLOUD_VOLUME_ADMIN::GetOneByServerID($id,1);
            $pv=CLOUD_NETWORKSERVER_ADMIN::GetlistByServerID($id, 0);
            $listOfRecordType[0]["volume"]= $vl;
            $listOfRecordType[0]["snapshot"]= $sn;
            $listOfRecordType[0]["privatenetwork"]= $pv;
            if ($listOfRecordType[0]["AdditionalIP"] == "AdditionalIP") {
                $listOfRecordType[0]["AdditionalIP"] = CLOUD_ADDITIONALIP_ADMIN::GetList($listOfRecordType[0]["ServerID"]);
            }
            $ls = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
        }


        $conn->close();
        return $ls;
    }
    public static function AttachFirewallToServer($token, $serverid,$fwid){
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $fw= CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $fwid);
        if($fw["status"]=="error"){
            return ["status"=>"error","message"=>"شما اجازه دسترسی به این فایروال را ندارید"];
        }
        $sd=self::UserCanAccessToServer($uid, $serverid);
        if($sd["status"]=="error"){
            return ["status"=>"error","message"=>"شما اجازه دسترسی به این سرور را ندارید"];
        }
        $fwsd=CLOUD_SECURITYGROUPSTOSERVER_ADMIN::CheckFirewallIsUsable($fwid,$serverid);
        if($fwsd=="1"){
            return ["status"=>"error","message"=>" شما قبلا این فایروال را در سرور اضافه نموده اید"];
        }
         
        $sfwid= $fw["data"][0]["cf_serverid"];
        $ssid=$sd["data"][0]["cs_serverid"] ;
        CLOUD_SECURITYGROUPSTOSERVER_ADMIN::AddFireWallToServer($serverid,$fwid);
        API_CLOUD_SERVER_ADMIN::RunAttachFirewallToServer($m,$ssid,$sfwid,$sd["data"][0]["cs_idcid_fk"]);
        return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد "];
    }
    public static function DetachFirewallToServer($token, $serverid,$fwid){
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $fw= CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $fwid);
        if($fw["status"]=="error"){
            return ["status"=>"error","message"=>"شما اجازه دسترسی به این فایروال را ندارید"];
        }
        $sd=self::UserCanAccessToServer($uid, $serverid);
        if($sd["status"]=="error"){
            return ["status"=>"error","message"=>"شما اجازه دسترسی به این سرور را ندارید"];
        }
        $fwsd=CLOUD_SECURITYGROUPSTOSERVER_ADMIN::CheckFirewallIsUsable($fwid,$serverid);
        if($fwsd=="0"){
            return ["status"=>"error","message"=>"شما هنوز این فایروال را به سرور اضافه نکرده اید"];
        }
      
        $sfwid= $fw["data"][0]["cf_serverid"];
        $ssid=$sd["data"][0]["cs_serverid"] ;
        CLOUD_SECURITYGROUPSTOSERVER_ADMIN::DeleteFirewallFromServer($serverid,$fwid);
        API_CLOUD_SERVER_ADMIN::RunDetachFirewallToServer($m,$ssid,$sfwid,$sd["data"][0]["cs_idcid_fk"]);
        return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد "];
    }
    public static function AttachVolumeToServer($token, $serverid,$vlid){
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $fw= CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid, $vlid);
        if($fw["status"]=="error"){
            return ["status"=>"error","message"=>"شما اجازه دسترسی به این Volume را ندارید"];
        }
        $sd=self::UserCanAccessToServer($uid, $serverid);
        if($sd["status"]=="error"){
            return ["status"=>"error","message"=>"شما اجازه دسترسی به این سرور را ندارید"];
        }
        $fwsd=CLOUD_VOLUME_ADMIN::CheckVolumeIsUsable($vlid);
    
        if($fwsd["data"][0]["VolumeID"]!="0"){
            return ["status"=>"error","message"=>"شما قبلا این هارد را به صرور دیگری ا ضافه نموده اید "];
        }
      
        $sfwid= $fw["data"][0]["cv_serverid"];
        $ssid=$sd["data"][0]["cs_serverid"] ;
        CLOUD_VOLUME_ADMIN::UpdateVPSID($vlid,$serverid);
        API_CLOUD_SERVER_ADMIN::RunAttachVolumeToServer($m,$ssid,$sfwid,$sd["data"][0]["cs_idcid_fk"]);
        return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد "];
    }
    public static function DetachVolumeToServer($token, $serverid,$vlid){
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $fw= CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid, $vlid);
        if($fw["status"]=="error"){
            return ["status"=>"error","message"=>"شما اجازه دسترسی به این Volume را ندارید"];
        }
        $sd=self::UserCanAccessToServer($uid, $serverid);
        if($sd["status"]=="error"){
            return ["status"=>"error","message"=>"شما اجازه دسترسی به این سرور را ندارید"];
        }
        $fwsd=CLOUD_VOLUME_ADMIN::CheckVolumeIsUsable($vlid);
    
        if($fwsd["data"][0]["VolumeID"]!=$serverid){
            return ["status"=>"error","message"=>"شما امکان دسترسی به این هارد را ندارید"];
        }
      
        $sfwid= $fw["data"][0]["cv_serverid"];
        $ssid=$sd["data"][0]["cs_serverid"] ;
        CLOUD_VOLUME_ADMIN::UpdateVPSIDNull($vlid,);
        API_CLOUD_SERVER_ADMIN::RunDetachVolumeToServer($m,$ssid,$sfwid,$sd["data"][0]["cs_idcid_fk"]);
        return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد "];
    }
    public static function CreateServer($token, $idc, $osname, $name, $ram, $cpu, $hard, $sshkey, $network, $firewall)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        if (!preg_match("/^[a-zA-z0-9.]*$/", $name)) {
            return ["status" => "error", "message" => "هاست نیم ارسالی شما نامعتبر است "];
        }
        $osimage = CLOUD_FLAVOR_ADMIN::ReturnOSID($osname);
        if ($osimage["status"] == "error") {
            return ["status" => "error", "message" => "سیستم عامل درخواستی شما اشتباه است "];
        }
        if (filter_var($ram, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "میزان رم ارسالی نامعتبر است "];
        }
        if (filter_var($cpu, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "میزان CPU ارسالی نامعتبر است "];
        }
        if (filter_var($hard, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "میزان هارد ارسالی نامعتبر است "];
        }
        if (filter_var($sshkey, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "SSH KEY ارسالی نامعتبر است "];
        }
        if ($network != "public") {
            $n = explode(",", $network);
            if ($n[0] != "private") {
                return ["status" => "error", "message" => "شبکه درخواستی شما نامعتبر است"];
            }
            if (!array_key_exists(1, $n)) {
                return ["status" => "error", "message" => "شناسه شبکه خصوصی ارسالی نامعتبر است "];
            }
            $c = CLOUD_PRIVATENETWORKS_ADMIN::GetOneByID($token, $n[1]);

            if ($c["status"] == "error") {
                return ["status" => "error", "message" => "شما اجازه دسترسی به این شبکه را ندارید "];
            }
        }
        $f = explode(",", $firewall);

        $defaultsecuritygroup=[];
        foreach ($f as $a) {
            if ($a != "default") {
                $b = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $a);

                if ($b["status"] == "error") {
                    return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
                }
                array_push($defaultsecuritygroup , $b["data"][0]["cf_serverid"]);
            } else {
                $projectinfo = CLOUD_PROJECT_ADMIN::GetDefaultSecurityGroup($uid, $idc);
                if ($projectinfo["data"][0]["cp_default_Security_group"] == null) {

                    $projectinfo = CLOUD_PROJECT_ADMIN::GetDataFromAPI($uid, $idc);
                }
                $defaultsecuritygroup = $projectinfo["data"][0]["cp_default_Security_group"];
            }
        }

        if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }

        $volumeinfo = CLOUD_VOLUME_ADMIN::AddVolumeAndAttachToServer($token, $name, $hard, $idc, $osname, $osimage["os"]);
        $vid = $volumeinfo["vid"];
        $lastVolumeID = $volumeinfo["id"];


        $publicNetwork = CLOUD_IDC_ADMIN::GetOneByID($idc)["data"][0]["ci_public_network"];
        $now = date("Y/m/d H:i:s");
        $image_id = "";
        if ($sshkey == 0) {
            $sshkey = "";
        }

        $flavor_id = CLOUD_FLAVOR_ADMIN::ReturnFLAVORID($ram, $cpu)["package"];

        $outapi =  API_CLOUD_SERVER_ADMIN::RunCreateServer(
            $name,
            $image_id,
            $m,
            $idc,
            $flavor_id,
            $sshkey,
            [$publicNetwork],
            $defaultsecuritygroup,
            $vid
        );
        if ($sshkey == 0) {
            $sshkey = "0";
        }

        $GLOBALS['cs_networkid']="cs_networkid";
        $GLOBALS['cs_sshkey']="cs_sshkey";
        $GLOBALS['cs_firewall']="cs_firewall";
        $GLOBALS['cs_osid']="cs_osid";
        $GLOBALS['cs_osname']="cs_osname";
        
        $sql = "INSERT INTO " . $GLOBALS["cloud_server_tablename"] . " VALUES (0,'" . $name
            . "','" . $uid . "','" . $outapi->id . "','" . $idc . "','6','0','" . $ram . "','" . $cpu . "','" . $hard . "','0','"
            . $now . "','" . $now . "','" . $publicNetwork . "','" . $sshkey . "','" . $firewall . "','".$osname."','". $osimage["os"]."')";

        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        // $id = API_CLOUD_SSHKEY_ADMIN::RunCreateAPISSHKEY( $sid,$pubkey,$m,$idc);
        $conn->close();
        CLOUD_VOLUME_ADMIN::UpdateServerID($lastVolumeID, $outapi->id);
        return [  $outapi ,"status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
    }
    public static function  GetSnapShot($token,$serverid,$sname){
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $c = self::UserCanAccessToServer($uid, $serverid);

        if ($c["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید "];
        }
        $ssid=$c["data"][0]["cs_serverid"] ;
        API_CLOUD_SNAPSHOT_ADMIN::RunCreateAPISNAPSHOT($ssid,$sname,$m,$c["data"][0]["cs_idcid_fk"]);
       $r= API_CLOUD_SNAPSHOT_ADMIN::RunGetSnapShotList($m,$c["data"][0]["cs_idcid_fk"]);
       $m=json_decode($r,true);
       array_multisort( array_column($m, "created_at"), SORT_DESC, $m );
       $id=$m[0]["id"];
       $name=$m[0]["name"];
       $space=$m[0]["size"]; 
       $r=CLOUD_VOLUME_ADMIN::AddSnapShotVolume($uid, $name, $space, $c["data"][0]["cs_idcid_fk"]
       , $id,  $c["data"][0]["cs_osname"],  $c["data"][0]["cs_osid"],$serverid);
       return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد " ];
    }
    public static function  GetListOfSnapShots($token,$serverid){
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $c = self::UserCanAccessToServer($uid, $serverid);

        if ($c["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید "];
        }
        $ssid=$c["data"][0]["cs_serverid"] ;
         return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد ","data"=>CLOUD_VOLUME_ADMIN::GetOneByServerID($serverid,1)];
    }
    
}
