from django.urls import path
from . import views

urlpatterns = [
    path('login/', views.LoginView.as_view()),
    path('logout/', views.LogoutView.as_view()),
    path('register/', views.GuestRegisterView.as_view()),
    path('get-users/', views.GetUsersView.as_view()),
    path('roles-users/<str:role>/', views.GetRoleUsersView.as_view()),
    path('roles-permissions/<str:role>/', views.GetRolePermissionsView.as_view()),
    
    # Roles
    path('roles/get/', views.GetRolesView.as_view()),
    path('roles/add/', views.AddRolesView.as_view()),
    path('roles/update/<int:pk>/', views.UpdateRoleView.as_view()),
    path('roles/delete/<int:pk>/', views.DeleteRoleView.as_view()),
    path('roles/assign/', views.RoleAssignmentView.as_view()),
    
    # Permissions
    path('permissions/get/', views.GetPermissionsView.as_view()),
    path('permissions/add/', views.AddPermissionsView.as_view()),
    path('permissions/update/<int:pk>/', views.UpdatePermissionView.as_view()),
    path('permissions/delete/<int:pk>/', views.DeletePermissionView.as_view()),
    path('permissions/assign-user/', views.PermissionAssignUserView.as_view()),
    path('permissions/assign-role/', views.PermissionAssignRoleView.as_view()),
    path('permissions/get-user-accesslevel/<str:uid>', views.GetUsersAccesslevel.as_view()),
    
    # Get Permissions from ClientSide
    path('get-sidebar-items/', views.GetSidebarItemsView.as_view()),
    path('get-inner-pages/<str:pagename>/', views.GetInnerPagesView.as_view()),
    path('get-badge-items/', views.GetSidebarBadgeView.as_view()),
    
    # User Notes
    path('get-note/<str:start_date>/<str:end_date>/', views.GetNoteView.as_view()),
    path('add-note/', views.AddNoteView.as_view()),
    path('edit-note/<int:id>/', views.UpdateNoteView.as_view()),
    path('delete-note/<int:id>/', views.DeleteNoteView.as_view()),
    
    # Phone Number
    path('list-phone/', views.ListPhoneView.as_view()),
    path('add-phone/', views.AddPhoneView.as_view()),
    path('edit-phone/<int:id>/', views.EditPhoneView.as_view()),
    path('delete-phone/<int:id>/', views.DeletePhoneView.as_view()),
    
    
    path('authorization-checker/', views.AuthorizationCheckerView.as_view()),
]
