from django.urls import path
from . import views


urlpatterns = [
    path('members/get/', views.MembersGetView.as_view()),
    path('members/add/', views.MembersAddView.as_view()),
    path('members/update/<int:pk>/', views.MembersUpdateView.as_view()),
    path('members/delete/<int:pk>/', views.MembersDeleteView.as_view()),
    
    path('contracts/get-list/', views.ContractsListView.as_view()),
    path('contracts/get/<int:cid>/', views.ContractsGetView.as_view()),
    path('contracts/add/', views.ContractsAddView.as_view()),
    path('contracts/update/<int:pk>/', views.ContractsUpdateView.as_view()),
    path('contracts/delete/<int:pk>/', views.ContractsDeleteView.as_view()),
    
    path('contract-member/get/<int:cid>/', views.ContractMemberGetView.as_view()),
    path('contract-member/add/<int:cid>/', views.ContractMemberAddView.as_view()),
    path('contract-member/update/<int:cid>/<int:mid>/', views.ContractMemberUpdateView.as_view()),
    path('contract-member/delete/<int:cid>/<int:mid>/', views.ContractMemberDeleteView.as_view()),
    path('contract-member/get-parent/<int:cid>/', views.ContractParentMemberView.as_view()),
    
    path('contract-services/get/<int:cid>/', views.GetContractServicesView.as_view()),
    path('contract-services/add/<int:cid>/', views.AddContractServicesView.as_view()),
    path('contract-services/update/<int:csid>/', views.UpdateContractServicesView.as_view()),
    path('contract-services/delete/<int:csid>/', views.DeleteContractServicesView.as_view()),
    
    path('contract-periods/get/', views.GetContractPeriodsView.as_view()),
    path('contract-periods/get/<int:cid>/', views.GetOneContractPeriodsView.as_view()),
    path('contract-periods/get-requests/<int:cid>/<int:pid>/', views.GetRequestsContractPeriodsView.as_view()),
    path('contract-periods/add/<int:cid>/', views.AddContractPeriodsView.as_view()),
    path('contract-periods/delete/<int:pid>/', views.DeleteContractPeriodsView.as_view()),
    path('contract-periods/update/<int:cid>/<int:pid>/', views.UpdateContractPeriodsView.as_view()),
    path('contract-periods/delete-requests-period/<int:pid>/', views.DeleteRequestsPeriodView.as_view()),
    
    path('documents/get/', views.DocumentsGetView.as_view()),
    path('documents/get-document/<int:cid>/', views.DocumentsGetContractView.as_view()),
    path('documents/add/', views.DocumentsAddView.as_view()),
    path('documents/get-document-requests/<int:mid>/<int:did>/', views.GetDocumentRequestsView.as_view()),
    path('documents/update/<int:mid>/<int:did>/', views.DocumentsUpdateView.as_view()),
    path('documents/delete/<int:mid>/<int:did>/', views.DocumentsDeleteView.as_view()),
    path('documents/export-file/', views.ExportDocumentView.as_view()),
    path('documents/get-members/<int:cid>/', views.DocumentGetMembersView.as_view()),
    path('documents/get-services/<int:cid>/', views.DocumentGetServicesView.as_view()),
    path('documents/filter-api/', views.DocumentsFilterView.as_view()),
    
    path('relationship/get/', views.RelationshipGetView.as_view()),
    path('relationship/add/', views.RelationshipAddView.as_view()),
    path('relationship/update/<int:pk>/', views.RelationshipUpdateView.as_view()),
    path('relationship/delete/<int:pk>/', views.RelationshipDeleteView.as_view()),
    
    path('flags/get/', views.FlagsGetView.as_view()),
    path('flags/add/', views.FlagsAddView.as_view()),
    path('flags/update/<int:pk>/', views.FlagsUpdateView.as_view()),
    path('flags/delete/<int:pk>/', views.FlagsDeleteView.as_view()),
    
    path('requests/get/<int:rid>/<int:mid>/', views.RequestsGetView.as_view()),
    path('requests/add/', views.RequestsAddView.as_view()),
    path('requests/update/<int:rid>/<int:mid>/', views.RequestsUpdateView.as_view()),
    path('requests/delete/<int:rid>/<int:mid>/', views.RequestsDeleteView.as_view()),
    
    path('requests-periods/update/', views.RequestsPeriodsUpdateView.as_view()),
    
    path('periods/get/<int:cid>/<int:pid>/', views.GetPeriodsView.as_view()),
    
    path('contract-periods/get-excel-requests/<int:cid>/<int:pid>/', views.GetExcelRequestsPeriodsView.as_view()),
    path('export-insurance-members/<int:cid>/', views.ExportInsuranceMembersView.as_view()),
    path('export-excel-insurance/', views.ExportExcelView.as_view()),
    path('import-excel-insurance/', views.ImportExcelView.as_view()),
    path('generate-pdf/<int:did>/', views.GeneratePDFForDocumentView.as_view()),
    path('get-excel-sample-file/', views.GetSampleExcelView.as_view()),
    
    path('generate-excel/', views.GenerateExcelRequestsView.as_view()),
    path('pdf-maker/', views.GeneratePDFRequestsView.as_view()),
    path('all_services/', views.GetAllServicesView.as_view()),
    path('all_users/', views.GetAllUsersView.as_view()),
]
