/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.15-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: panelkeloncloud_maindb
-- ------------------------------------------------------
-- Server version	10.11.15-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `panelkeloncloud_maindb`
--


--
-- Table structure for table `captcha_manager`
--

DROP TABLE IF EXISTS `captcha_manager`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `captcha_manager` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(255) NOT NULL,
  `ask` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `captcha_manager_ip_unique` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `captcha_manager`
--

LOCK TABLES `captcha_manager` WRITE;
/*!40000 ALTER TABLE `captcha_manager` DISABLE KEYS */;
/*!40000 ALTER TABLE `captcha_manager` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `captchas`
--

DROP TABLE IF EXISTS `captchas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `captchas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(100) NOT NULL,
  `security` varchar(250) NOT NULL,
  `validated` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `captchas`
--

LOCK TABLES `captchas` WRITE;
/*!40000 ALTER TABLE `captchas` DISABLE KEYS */;
/*!40000 ALTER TABLE `captchas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_datacenter`
--

DROP TABLE IF EXISTS `cloud_datacenter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_datacenter` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` bigint(20) unsigned NOT NULL,
  `primary_middleware` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `country` varchar(255) NOT NULL,
  `origin` varchar(255) NOT NULL,
  `network_serial` varchar(255) NOT NULL,
  `api_key` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `has_sas` tinyint(1) NOT NULL DEFAULT 0,
  `has_ssd` tinyint(1) NOT NULL DEFAULT 0,
  `has_nvme` tinyint(1) NOT NULL DEFAULT 0,
  `ip_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_datacenter_code_index` (`code`),
  KEY `cloud_datacenter_primary_middleware_foreign` (`primary_middleware`),
  CONSTRAINT `cloud_datacenter_primary_middleware_foreign` FOREIGN KEY (`primary_middleware`) REFERENCES `cloud_datacenter` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_datacenter`
--

LOCK TABLES `cloud_datacenter` WRITE;
/*!40000 ALTER TABLE `cloud_datacenter` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_datacenter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_firewall`
--

DROP TABLE IF EXISTS `cloud_firewall`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_firewall` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `datacenter_id` bigint(20) unsigned DEFAULT NULL,
  `project_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `serial` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_firewall_user_id_foreign` (`user_id`),
  KEY `cloud_firewall_project_id_foreign` (`project_id`),
  CONSTRAINT `cloud_firewall_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `cloud_project` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cloud_firewall_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`uid`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_firewall`
--

LOCK TABLES `cloud_firewall` WRITE;
/*!40000 ALTER TABLE `cloud_firewall` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_firewall` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_firewall_rules`
--

DROP TABLE IF EXISTS `cloud_firewall_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_firewall_rules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `firewall_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `serial` varchar(255) NOT NULL,
  `direction` enum('inbound','outbound') NOT NULL,
  `protocol` varchar(255) NOT NULL DEFAULT 'any',
  `port` varchar(255) NOT NULL DEFAULT 'any',
  `ip` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_firewall_rules_firewall_id_foreign` (`firewall_id`),
  CONSTRAINT `cloud_firewall_rules_firewall_id_foreign` FOREIGN KEY (`firewall_id`) REFERENCES `cloud_firewall` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_firewall_rules`
--

LOCK TABLES `cloud_firewall_rules` WRITE;
/*!40000 ALTER TABLE `cloud_firewall_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_firewall_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_firewall_server`
--

DROP TABLE IF EXISTS `cloud_firewall_server`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_firewall_server` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `firewall_id` bigint(20) unsigned NOT NULL,
  `server_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_firewall_server_firewall_id_foreign` (`firewall_id`),
  KEY `cloud_firewall_server_server_id_foreign` (`server_id`),
  CONSTRAINT `cloud_firewall_server_firewall_id_foreign` FOREIGN KEY (`firewall_id`) REFERENCES `cloud_firewall` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cloud_firewall_server_server_id_foreign` FOREIGN KEY (`server_id`) REFERENCES `cloud_server` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_firewall_server`
--

LOCK TABLES `cloud_firewall_server` WRITE;
/*!40000 ALTER TABLE `cloud_firewall_server` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_firewall_server` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_flavor`
--

DROP TABLE IF EXISTS `cloud_flavor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_flavor` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `flavor` varchar(255) NOT NULL,
  `serial` varchar(255) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_flavor`
--

LOCK TABLES `cloud_flavor` WRITE;
/*!40000 ALTER TABLE `cloud_flavor` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_flavor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_manual_tasks`
--

DROP TABLE IF EXISTS `cloud_manual_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_manual_tasks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `project_id` bigint(20) unsigned DEFAULT NULL,
  `server_id` bigint(20) unsigned DEFAULT NULL,
  `volume_id` bigint(20) unsigned DEFAULT NULL,
  `done_by_admin_id` bigint(20) unsigned DEFAULT NULL,
  `task_status` enum('PENDING','DONE','REMOVED') NOT NULL DEFAULT 'PENDING',
  `task_subject` text NOT NULL,
  `description` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_manual_tasks_project_id_foreign` (`project_id`),
  KEY `cloud_manual_tasks_server_id_foreign` (`server_id`),
  KEY `cloud_manual_tasks_volume_id_foreign` (`volume_id`),
  KEY `cloud_manual_tasks_user_id_foreign` (`user_id`),
  CONSTRAINT `cloud_manual_tasks_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `cloud_project` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cloud_manual_tasks_server_id_foreign` FOREIGN KEY (`server_id`) REFERENCES `cloud_server` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cloud_manual_tasks_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`uid`) ON DELETE SET NULL,
  CONSTRAINT `cloud_manual_tasks_volume_id_foreign` FOREIGN KEY (`volume_id`) REFERENCES `cloud_volume` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_manual_tasks`
--

LOCK TABLES `cloud_manual_tasks` WRITE;
/*!40000 ALTER TABLE `cloud_manual_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_manual_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_middleware`
--

DROP TABLE IF EXISTS `cloud_middleware`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_middleware` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `protocol` varchar(255) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `port` varchar(255) NOT NULL,
  `api_key` varchar(255) NOT NULL,
  `tag` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 0,
  `datacenter_id` bigint(20) unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_middleware_datacenter_id_foreign` (`datacenter_id`),
  CONSTRAINT `cloud_middleware_datacenter_id_foreign` FOREIGN KEY (`datacenter_id`) REFERENCES `cloud_datacenter` (`code`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_middleware`
--

LOCK TABLES `cloud_middleware` WRITE;
/*!40000 ALTER TABLE `cloud_middleware` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_middleware` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_operating_system`
--

DROP TABLE IF EXISTS `cloud_operating_system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_operating_system` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `serial` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `distro` varchar(255) NOT NULL,
  `version` varchar(255) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cloud_operating_system_serial_unique` (`serial`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_operating_system`
--

LOCK TABLES `cloud_operating_system` WRITE;
/*!40000 ALTER TABLE `cloud_operating_system` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_operating_system` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_project`
--

DROP TABLE IF EXISTS `cloud_project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_project` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `datacenter_id` bigint(20) unsigned DEFAULT NULL,
  `firewall_id` bigint(20) unsigned DEFAULT NULL,
  `serial` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '__default__',
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_project_user_id_foreign` (`user_id`),
  CONSTRAINT `cloud_project_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`uid`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_project`
--

LOCK TABLES `cloud_project` WRITE;
/*!40000 ALTER TABLE `cloud_project` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_server`
--

DROP TABLE IF EXISTS `cloud_server`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_server` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `status` enum('ON','OFF','RESTARTING','RELOAD','RESCUED','RESCUING','SUSPENDED','BUILD','REBUILD') NOT NULL DEFAULT 'BUILD',
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `datacenter_id` bigint(20) unsigned DEFAULT NULL,
  `volume_id` bigint(20) unsigned DEFAULT NULL,
  `rescue_volume` bigint(20) unsigned DEFAULT NULL,
  `ssh_id` bigint(20) unsigned DEFAULT NULL,
  `default_password` varchar(255) DEFAULT NULL,
  `serial` varchar(255) DEFAULT NULL,
  `is_test` tinyint(1) NOT NULL DEFAULT 0,
  `is_paused` tinyint(1) NOT NULL DEFAULT 0,
  `ha_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `cpu` smallint(5) unsigned NOT NULL,
  `ram` smallint(5) unsigned NOT NULL,
  `reload_count` int(11) NOT NULL DEFAULT 0,
  `rescue_count` int(11) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `host_id` text DEFAULT NULL,
  `human_id` text DEFAULT NULL,
  `metadata` text DEFAULT NULL,
  `old_serial` varchar(255) DEFAULT NULL,
  `old_volume_id` bigint(20) unsigned DEFAULT NULL,
  `remote_request_id` varchar(255) DEFAULT NULL,
  `remote_request_data` longtext DEFAULT NULL,
  `is_rescued` tinyint(1) NOT NULL DEFAULT 0,
  `admin_suspend` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `cloud_server_user_id_foreign` (`user_id`),
  KEY `cloud_server_datacenter_id_foreign` (`datacenter_id`),
  KEY `cloud_server_volume_id_foreign` (`volume_id`),
  KEY `cloud_server_rescue_volume_foreign` (`rescue_volume`),
  KEY `cloud_server_ssh_id_foreign` (`ssh_id`),
  KEY `cloud_server_old_volume_id_foreign` (`old_volume_id`),
  CONSTRAINT `cloud_server_datacenter_id_foreign` FOREIGN KEY (`datacenter_id`) REFERENCES `cloud_datacenter` (`code`) ON DELETE SET NULL,
  CONSTRAINT `cloud_server_old_volume_id_foreign` FOREIGN KEY (`old_volume_id`) REFERENCES `cloud_volume` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cloud_server_rescue_volume_foreign` FOREIGN KEY (`rescue_volume`) REFERENCES `cloud_volume` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cloud_server_ssh_id_foreign` FOREIGN KEY (`ssh_id`) REFERENCES `cloud_ssh` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cloud_server_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`uid`) ON DELETE SET NULL,
  CONSTRAINT `cloud_server_volume_id_foreign` FOREIGN KEY (`volume_id`) REFERENCES `cloud_volume` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_server`
--

LOCK TABLES `cloud_server` WRITE;
/*!40000 ALTER TABLE `cloud_server` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_server` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_server_interface`
--

DROP TABLE IF EXISTS `cloud_server_interface`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_server_interface` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `server_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `mac_type` enum('fixed','dynamic') NOT NULL DEFAULT 'fixed',
  `mac_address` varchar(255) NOT NULL,
  `ip_type` enum('IPv4','IPv6') NOT NULL DEFAULT 'IPv4',
  `ip_address` varchar(255) NOT NULL,
  `serial` varchar(255) DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_server_interface_server_id_foreign` (`server_id`),
  CONSTRAINT `cloud_server_interface_server_id_foreign` FOREIGN KEY (`server_id`) REFERENCES `cloud_server` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_server_interface`
--

LOCK TABLES `cloud_server_interface` WRITE;
/*!40000 ALTER TABLE `cloud_server_interface` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_server_interface` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_server_logs`
--

DROP TABLE IF EXISTS `cloud_server_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_server_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `server_id` bigint(20) unsigned DEFAULT NULL,
  `action` varchar(255) NOT NULL,
  `importance` enum('LOW','MEDIUM','HIGH') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_server_logs_server_id_foreign` (`server_id`),
  CONSTRAINT `cloud_server_logs_server_id_foreign` FOREIGN KEY (`server_id`) REFERENCES `cloud_server` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_server_logs`
--

LOCK TABLES `cloud_server_logs` WRITE;
/*!40000 ALTER TABLE `cloud_server_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_server_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_server_network_usage`
--

DROP TABLE IF EXISTS `cloud_server_network_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_server_network_usage` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `server_id` bigint(20) unsigned DEFAULT NULL,
  `incoming` bigint(20) unsigned DEFAULT NULL,
  `outgoing` bigint(20) unsigned DEFAULT NULL,
  `last_invoice` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `base_incoming` bigint(20) unsigned NOT NULL DEFAULT 0,
  `base_outgoing` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `cloud_server_network_usage_server_id_foreign` (`server_id`),
  KEY `cloud_server_network_usage_user_id_foreign` (`user_id`),
  CONSTRAINT `cloud_server_network_usage_server_id_foreign` FOREIGN KEY (`server_id`) REFERENCES `cloud_server` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cloud_server_network_usage_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`uid`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_server_network_usage`
--

LOCK TABLES `cloud_server_network_usage` WRITE;
/*!40000 ALTER TABLE `cloud_server_network_usage` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_server_network_usage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_ssh`
--

DROP TABLE IF EXISTS `cloud_ssh`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_ssh` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `datacenter_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `key` text NOT NULL,
  `serial` text NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_ssh_user_id_foreign` (`user_id`),
  KEY `cloud_ssh_datacenter_id_foreign` (`datacenter_id`),
  CONSTRAINT `cloud_ssh_datacenter_id_foreign` FOREIGN KEY (`datacenter_id`) REFERENCES `cloud_datacenter` (`code`) ON DELETE SET NULL,
  CONSTRAINT `cloud_ssh_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`uid`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_ssh`
--

LOCK TABLES `cloud_ssh` WRITE;
/*!40000 ALTER TABLE `cloud_ssh` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_ssh` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloud_volume`
--

DROP TABLE IF EXISTS `cloud_volume`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloud_volume` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `datacenter_id` bigint(20) unsigned DEFAULT NULL,
  `serial` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `type` enum('SAS','SSD','NVME') NOT NULL,
  `space` int(10) unsigned NOT NULL,
  `status` enum('AVAILABLE','INUSE','PENDING','ALOCATING','DELETED') NOT NULL,
  `is_bootable` tinyint(1) NOT NULL,
  `is_snapshot` tinyint(1) NOT NULL,
  `operating_system` bigint(20) unsigned DEFAULT NULL,
  `mount_point` varchar(255) DEFAULT NULL,
  `attached_to` bigint(20) unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cloud_volume_user_id_foreign` (`user_id`),
  KEY `cloud_volume_datacenter_id_foreign` (`datacenter_id`),
  KEY `cloud_volume_attached_to_foreign` (`attached_to`),
  KEY `cloud_volume_operating_system_foreign` (`operating_system`),
  CONSTRAINT `cloud_volume_attached_to_foreign` FOREIGN KEY (`attached_to`) REFERENCES `cloud_server` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cloud_volume_datacenter_id_foreign` FOREIGN KEY (`datacenter_id`) REFERENCES `cloud_datacenter` (`code`) ON DELETE SET NULL,
  CONSTRAINT `cloud_volume_operating_system_foreign` FOREIGN KEY (`operating_system`) REFERENCES `cloud_operating_system` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cloud_volume_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`uid`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloud_volume`
--

LOCK TABLES `cloud_volume` WRITE;
/*!40000 ALTER TABLE `cloud_volume` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloud_volume` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `domains`
--

DROP TABLE IF EXISTS `domains`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `domains` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `status` enum('pending','active','delete','suspend','admin-suspend') NOT NULL,
  `plan` varchar(255) NOT NULL,
  `note` varchar(255) NOT NULL,
  `orderid` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domains_user_id_foreign` (`user_id`),
  KEY `domains_orderid_foreign` (`orderid`),
  CONSTRAINT `domains_orderid_foreign` FOREIGN KEY (`orderid`) REFERENCES `tbl_orders` (`oid`) ON DELETE SET NULL,
  CONSTRAINT `domains_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`uid`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `domains`
--

LOCK TABLES `domains` WRITE;
/*!40000 ALTER TABLE `domains` DISABLE KEYS */;
/*!40000 ALTER TABLE `domains` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `edges_logs`
--

DROP TABLE IF EXISTS `edges_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `edges_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task` varchar(255) NOT NULL DEFAULT 'CDN Task',
  `type` varchar(255) NOT NULL,
  `target` varchar(255) NOT NULL,
  `request` longtext NOT NULL,
  `request_time` varchar(255) NOT NULL,
  `response` longtext DEFAULT NULL,
  `response_time` varchar(255) DEFAULT NULL,
  `response_status` tinyint(1) NOT NULL DEFAULT 0,
  `retry` varchar(255) NOT NULL DEFAULT 'no',
  `log_date` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `edges_logs`
--

LOCK TABLES `edges_logs` WRITE;
/*!40000 ALTER TABLE `edges_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `edges_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exceptions`
--

DROP TABLE IF EXISTS `exceptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `exceptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `message` varchar(255) NOT NULL,
  `details` longtext DEFAULT NULL,
  `file` varchar(255) NOT NULL,
  `line` int(10) unsigned NOT NULL,
  `stack_trace` longtext NOT NULL,
  `debug` tinyint(1) DEFAULT NULL,
  `user` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(255) NOT NULL,
  `hostname` varchar(255) DEFAULT NULL,
  `method` varchar(255) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `attachments` blob DEFAULT NULL,
  `headers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `project` varchar(255) DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'Exception',
  `level` enum('critical','fault','warning','info','debug') NOT NULL DEFAULT 'debug',
  `date_insert` datetime NOT NULL DEFAULT current_timestamp(),
  `date_reported` datetime DEFAULT NULL,
  `version` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exceptions`
--

LOCK TABLES `exceptions` WRITE;
/*!40000 ALTER TABLE `exceptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `exceptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `freessl`
--

DROP TABLE IF EXISTS `freessl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `freessl` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sslpools_id` bigint(20) unsigned DEFAULT NULL,
  `certificate` varchar(255) NOT NULL,
  `cabundle` varchar(255) DEFAULT NULL,
  `privatekey` varchar(255) NOT NULL,
  `status` enum('pending','issued') NOT NULL,
  `expiredate` datetime NOT NULL,
  `websites_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `freessl_sslpools_id_foreign` (`sslpools_id`),
  KEY `freessl_websites_id_foreign` (`websites_id`),
  CONSTRAINT `freessl_sslpools_id_foreign` FOREIGN KEY (`sslpools_id`) REFERENCES `sslpools` (`id`) ON DELETE SET NULL,
  CONSTRAINT `freessl_websites_id_foreign` FOREIGN KEY (`websites_id`) REFERENCES `websites` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `freessl`
--

LOCK TABLES `freessl` WRITE;
/*!40000 ALTER TABLE `freessl` DISABLE KEYS */;
/*!40000 ALTER TABLE `freessl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `freesslrequets`
--

DROP TABLE IF EXISTS `freesslrequets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `freesslrequets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `websites_id` bigint(20) unsigned DEFAULT NULL,
  `status` enum('pending','ended') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `freesslrequets_websites_id_foreign` (`websites_id`),
  CONSTRAINT `freesslrequets_websites_id_foreign` FOREIGN KEY (`websites_id`) REFERENCES `websites` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `freesslrequets`
--

LOCK TABLES `freesslrequets` WRITE;
/*!40000 ALTER TABLE `freesslrequets` DISABLE KEYS */;
/*!40000 ALTER TABLE `freesslrequets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gateway`
--

DROP TABLE IF EXISTS `gateway`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gateway` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(255) NOT NULL DEFAULT 'sending',
  `type` enum('CDN','CLOUD','NORMAL') NOT NULL,
  `user_ip` varchar(255) DEFAULT NULL,
  `target` varchar(255) NOT NULL,
  `request_method` enum('GET','POST','PUT','DELETE','PATCH','HEAD','OPTIONS','COPY','LINK','UNLINK','LOCK','UNLOCK','PROPFIND','VIEW') NOT NULL,
  `request` longtext NOT NULL,
  `response` longtext DEFAULT NULL,
  `exceptions` longtext DEFAULT NULL,
  `start` varchar(255) NOT NULL,
  `finish` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_request` longtext DEFAULT NULL,
  `user_called_path` varchar(255) DEFAULT NULL,
  `launcher` enum('API','SUPERVISOR') NOT NULL DEFAULT 'API',
  `is_parsable` tinyint(1) DEFAULT NULL,
  `is_success` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gateway_user_id_foreign` (`user_id`),
  CONSTRAINT `gateway_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`uid`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gateway`
--

LOCK TABLES `gateway` WRITE;
/*!40000 ALTER TABLE `gateway` DISABLE KEYS */;
/*!40000 ALTER TABLE `gateway` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `logs`
--

DROP TABLE IF EXISTS `logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task` varchar(255) NOT NULL DEFAULT 'cdn_task',
  `type` varchar(255) NOT NULL,
  `protocol` varchar(255) NOT NULL DEFAULT 'local',
  `request` text NOT NULL,
  `request_time` varchar(255) NOT NULL,
  `response` longtext DEFAULT NULL,
  `response_time` varchar(255) DEFAULT NULL,
  `response_status` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `log_date` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `logs`
--

LOCK TABLES `logs` WRITE;
/*!40000 ALTER TABLE `logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `queue_logs`
--

DROP TABLE IF EXISTS `queue_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `Successful` tinyint(1) DEFAULT NULL,
  `Task` varchar(255) DEFAULT NULL,
  `Trace` text DEFAULT NULL,
  `Description` text DEFAULT NULL,
  `Headers` varchar(255) DEFAULT NULL,
  `Params` longtext DEFAULT NULL,
  `Response` longtext DEFAULT NULL,
  `Considerations` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `queue_logs`
--

LOCK TABLES `queue_logs` WRITE;
/*!40000 ALTER TABLE `queue_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `queue_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(255) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sslpools`
--

DROP TABLE IF EXISTS `sslpools`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sslpools` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `domain_id` bigint(20) unsigned DEFAULT NULL,
  `domains` varchar(255) NOT NULL,
  `altdomains` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `issuername` varchar(255) NOT NULL,
  `certificate` varchar(255) NOT NULL,
  `cabundle` varchar(255) DEFAULT NULL,
  `privatekey` varchar(255) NOT NULL,
  `expiredate` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sslpools_domain_id_foreign` (`domain_id`),
  CONSTRAINT `sslpools_domain_id_foreign` FOREIGN KEY (`domain_id`) REFERENCES `domains` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sslpools`
--

LOCK TABLES `sslpools` WRITE;
/*!40000 ALTER TABLE `sslpools` DISABLE KEYS */;
/*!40000 ALTER TABLE `sslpools` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sslwebsites`
--

DROP TABLE IF EXISTS `sslwebsites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sslwebsites` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `https_status` enum('both','https','http') NOT NULL,
  `ssl_status` enum('none','userssl','freessl') NOT NULL,
  `websites_id` bigint(20) unsigned DEFAULT NULL,
  `sslpools_id` bigint(20) unsigned DEFAULT NULL,
  `hsts_status` enum('off','on') NOT NULL,
  `hsts_tim` bigint(20) unsigned DEFAULT NULL,
  `tlsversion` varchar(255) NOT NULL DEFAULT 'default',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sslwebsites_websites_id_foreign` (`websites_id`),
  KEY `sslwebsites_sslpools_id_foreign` (`sslpools_id`),
  CONSTRAINT `sslwebsites_sslpools_id_foreign` FOREIGN KEY (`sslpools_id`) REFERENCES `sslpools` (`id`) ON DELETE SET NULL,
  CONSTRAINT `sslwebsites_websites_id_foreign` FOREIGN KEY (`websites_id`) REFERENCES `websites` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sslwebsites`
--

LOCK TABLES `sslwebsites` WRITE;
/*!40000 ALTER TABLE `sslwebsites` DISABLE KEYS */;
/*!40000 ALTER TABLE `sslwebsites` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_2fa_login`
--

DROP TABLE IF EXISTS `tbl_2fa_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_2fa_login` (
  `2fa_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `2fa_uid_fk` bigint(20) NOT NULL,
  `2fa_code` varchar(6) NOT NULL,
  `2fa_expiretime` varchar(30) NOT NULL,
  PRIMARY KEY (`2fa_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_2fa_login`
--

LOCK TABLES `tbl_2fa_login` WRITE;
/*!40000 ALTER TABLE `tbl_2fa_login` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_2fa_login` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_action_queue`
--

DROP TABLE IF EXISTS `tbl_action_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_action_queue` (
  `aqid` varchar(50) NOT NULL,
  `atask` varchar(200) NOT NULL,
  `atype` varchar(200) NOT NULL,
  `aparamter` varchar(30000) NOT NULL,
  `atime` datetime NOT NULL,
  `aretrytime` int(11) NOT NULL,
  `aresponsetime` datetime NOT NULL DEFAULT current_timestamp(),
  `aresponsestatus` varchar(25000) NOT NULL,
  `astatus` int(11) NOT NULL DEFAULT 0 COMMENT '0-prnding \\n 1-inprogress \\n 2-failed \\n 3-success',
  `a_actiontype` varchar(50) NOT NULL DEFAULT 'SendCDNAPI',
  PRIMARY KEY (`aqid`),
  UNIQUE KEY `aqid` (`aqid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_action_queue`
--

LOCK TABLES `tbl_action_queue` WRITE;
/*!40000 ALTER TABLE `tbl_action_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_action_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_admin`
--

DROP TABLE IF EXISTS `tbl_admin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_admin` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `a_name` varchar(500) NOT NULL,
  `a_family` varchar(500) NOT NULL,
  `a_uname` varchar(200) NOT NULL,
  `a_signup_date` varchar(30) NOT NULL,
  `a_lastlogin` varchar(30) NOT NULL,
  `a_sessionkey` varchar(5000) NOT NULL,
  `a_exp_token` varchar(30) DEFAULT NULL,
  `a_status` int(11) NOT NULL,
  `amobile` varchar(12) NOT NULL,
  `amail` varchar(500) NOT NULL,
  `apassword` varchar(500) NOT NULL,
  `a_additional` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`aid`),
  UNIQUE KEY `a_uname` (`a_uname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_admin`
--

LOCK TABLES `tbl_admin` WRITE;
/*!40000 ALTER TABLE `tbl_admin` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_admin` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_admin_rolename`
--

DROP TABLE IF EXISTS `tbl_admin_rolename`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_admin_rolename` (
  `arnid` int(11) NOT NULL AUTO_INCREMENT,
  `arn_name` varchar(200) NOT NULL,
  `arn_acess` varchar(5000) NOT NULL,
  PRIMARY KEY (`arnid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_admin_rolename`
--

LOCK TABLES `tbl_admin_rolename` WRITE;
/*!40000 ALTER TABLE `tbl_admin_rolename` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_admin_rolename` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_admin_roles`
--

DROP TABLE IF EXISTS `tbl_admin_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_admin_roles` (
  `arid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ar_aid_dk` bigint(20) NOT NULL,
  `ar_access` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `ar_arnid_fk` int(11) DEFAULT NULL,
  PRIMARY KEY (`arid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_admin_roles`
--

LOCK TABLES `tbl_admin_roles` WRITE;
/*!40000 ALTER TABLE `tbl_admin_roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_admin_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_adminlog`
--

DROP TABLE IF EXISTS `tbl_adminlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_adminlog` (
  `alid` varchar(50) NOT NULL,
  `al_aid_fk` int(11) NOT NULL,
  `al_description` varchar(20000) NOT NULL,
  `al_uid_fk` bigint(20) NOT NULL,
  `al_action` varchar(50) NOT NULL,
  `al_date` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`alid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_adminlog`
--

LOCK TABLES `tbl_adminlog` WRITE;
/*!40000 ALTER TABLE `tbl_adminlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_adminlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_asessions`
--

DROP TABLE IF EXISTS `tbl_asessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_asessions` (
  `assid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ass_token` varchar(128) NOT NULL,
  `ass_uid_fk` bigint(20) NOT NULL,
  `ass_expiredate` varchar(50) NOT NULL,
  PRIMARY KEY (`assid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_asessions`
--

LOCK TABLES `tbl_asessions` WRITE;
/*!40000 ALTER TABLE `tbl_asessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_asessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_attachments`
--

DROP TABLE IF EXISTS `tbl_attachments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_attachments` (
  `at_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `at_name` varchar(5000) NOT NULL,
  `at_date` varchar(30) NOT NULL,
  `at_type` varchar(500) NOT NULL,
  PRIMARY KEY (`at_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_attachments`
--

LOCK TABLES `tbl_attachments` WRITE;
/*!40000 ALTER TABLE `tbl_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_attachments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_backendprotocol`
--

DROP TABLE IF EXISTS `tbl_backendprotocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_backendprotocol` (
  `bpid` bigint(20) NOT NULL AUTO_INCREMENT,
  `bpstatus` varchar(20) NOT NULL,
  `bpwid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`bpid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_backendprotocol`
--

LOCK TABLES `tbl_backendprotocol` WRITE;
/*!40000 ALTER TABLE `tbl_backendprotocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_backendprotocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_bank_gateway`
--

DROP TABLE IF EXISTS `tbl_bank_gateway`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_bank_gateway` (
  `bgw_id` int(11) NOT NULL AUTO_INCREMENT,
  `bgw_logo` varchar(5000) NOT NULL,
  `bgw_name` varchar(5000) NOT NULL,
  `bgw_status` int(11) NOT NULL,
  `bgw_path` text NOT NULL,
  PRIMARY KEY (`bgw_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_bank_gateway`
--

LOCK TABLES `tbl_bank_gateway` WRITE;
/*!40000 ALTER TABLE `tbl_bank_gateway` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_bank_gateway` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_blockip_website`
--

DROP TABLE IF EXISTS `tbl_blockip_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_blockip_website` (
  `biw_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `biw_wid_fk` bigint(20) NOT NULL,
  `biw_ip` varchar(100) NOT NULL,
  PRIMARY KEY (`biw_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_blockip_website`
--

LOCK TABLES `tbl_blockip_website` WRITE;
/*!40000 ALTER TABLE `tbl_blockip_website` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_blockip_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cdn_log_websitebandwidth`
--

DROP TABLE IF EXISTS `tbl_cdn_log_websitebandwidth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cdn_log_websitebandwidth` (
  `clwbid` bigint(20) NOT NULL AUTO_INCREMENT,
  `clwb_did_fk` bigint(20) NOT NULL,
  `clwb_bwusage` bigint(20) NOT NULL,
  `clwb_bwusage_percent` int(11) NOT NULL,
  `clwb_rqusage` bigint(20) NOT NULL,
  `clwb_rqusage_percent` int(11) NOT NULL,
  `clwb_startdate` varchar(30) NOT NULL,
  `clwb_enddate` varchar(30) NOT NULL,
  `clwb_announce` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`clwbid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cdn_log_websitebandwidth`
--

LOCK TABLES `tbl_cdn_log_websitebandwidth` WRITE;
/*!40000 ALTER TABLE `tbl_cdn_log_websitebandwidth` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cdn_log_websitebandwidth` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cdn_range_ip`
--

DROP TABLE IF EXISTS `tbl_cdn_range_ip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cdn_range_ip` (
  `crid` int(11) NOT NULL AUTO_INCREMENT,
  `crip` varchar(5000) NOT NULL,
  `crstatus` int(11) NOT NULL,
  `crv` int(11) NOT NULL COMMENT 'v4\r\nv6',
  `crtype` int(11) NOT NULL COMMENT '0-public\r\n1-organize',
  PRIMARY KEY (`crid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cdn_range_ip`
--

LOCK TABLES `tbl_cdn_range_ip` WRITE;
/*!40000 ALTER TABLE `tbl_cdn_range_ip` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cdn_range_ip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cdn_suspend_temp`
--

DROP TABLE IF EXISTS `tbl_cdn_suspend_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cdn_suspend_temp` (
  `cst_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cst_domainname` varchar(5000) NOT NULL,
  `cst_domain_id` bigint(20) NOT NULL,
  `cst_uid` bigint(20) NOT NULL,
  `cst_user_mobile` varchar(20) NOT NULL,
  `cst_user_email` varchar(100) NOT NULL,
  `cst_date` datetime NOT NULL,
  `cst_cat` varchar(50) NOT NULL DEFAULT 'cdn',
  PRIMARY KEY (`cst_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cdn_suspend_temp`
--

LOCK TABLES `tbl_cdn_suspend_temp` WRITE;
/*!40000 ALTER TABLE `tbl_cdn_suspend_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cdn_suspend_temp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cdn_website`
--

DROP TABLE IF EXISTS `tbl_cdn_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cdn_website` (
  `cdn_website_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cdnw_wid_fk` bigint(20) NOT NULL,
  `cdnw_cache_level` int(11) NOT NULL,
  `cdnw_always_online` int(11) NOT NULL,
  `cdnw_css_minify` int(11) NOT NULL,
  `cdnw_js_minify` int(11) NOT NULL,
  `cdnw_html_minify` int(11) NOT NULL,
  `cdnw_cache_ttl` bigint(20) NOT NULL,
  `cdnw_developermode` int(11) NOT NULL,
  `cdnw_hotlink_protection` int(11) NOT NULL,
  `cdnw_server_cache_ttl` int(11) NOT NULL,
  `cdnw_sslstatus` int(11) NOT NULL COMMENT '1- unknown\r\n2-Force to https\r\n3-Force to HTTP\r\n',
  PRIMARY KEY (`cdn_website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cdn_website`
--

LOCK TABLES `tbl_cdn_website` WRITE;
/*!40000 ALTER TABLE `tbl_cdn_website` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cdn_website` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_change_resource_to_https`
--

DROP TABLE IF EXISTS `tbl_change_resource_to_https`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_change_resource_to_https` (
  `crthid` bigint(20) NOT NULL AUTO_INCREMENT,
  `crth_wid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`crthid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_change_resource_to_https`
--

LOCK TABLES `tbl_change_resource_to_https` WRITE;
/*!40000 ALTER TABLE `tbl_change_resource_to_https` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_change_resource_to_https` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_changetemp`
--

DROP TABLE IF EXISTS `tbl_changetemp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_changetemp` (
  `ctid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ctuid_fk` bigint(20) NOT NULL,
  `ctcode` int(11) NOT NULL,
  `ct_new_field` varchar(500) NOT NULL,
  `ct_field` int(11) NOT NULL COMMENT '1- email\r\n2-mobile\r\n',
  `ct_datetime` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`ctid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_changetemp`
--

LOCK TABLES `tbl_changetemp` WRITE;
/*!40000 ALTER TABLE `tbl_changetemp` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_changetemp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_action_queue`
--

DROP TABLE IF EXISTS `tbl_cloud_action_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_action_queue` (
  `caqid` varchar(50) NOT NULL,
  `catask` varchar(200) NOT NULL,
  `catype` varchar(200) NOT NULL,
  `caparamter` varchar(30000) NOT NULL,
  `catime` datetime NOT NULL,
  `caretrytime` int(11) NOT NULL,
  `caresponsetime` datetime NOT NULL DEFAULT current_timestamp(),
  `caresponsestatus` varchar(25000) NOT NULL,
  `castatus` int(11) NOT NULL DEFAULT 0 COMMENT '0-prnding \\n 1-inprogress \\n 2-failed \\n 3-success',
  `ca_actiontype` varchar(50) NOT NULL DEFAULT 'SendToCloudAPI',
  PRIMARY KEY (`caqid`),
  UNIQUE KEY `caqid` (`caqid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_action_queue`
--

LOCK TABLES `tbl_cloud_action_queue` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_action_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_action_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_additionalip`
--

DROP TABLE IF EXISTS `tbl_cloud_additionalip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_additionalip` (
  `caid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ca_ip` varchar(5000) NOT NULL,
  `ca_csid_fk` bigint(20) NOT NULL,
  `ca_ispublic` int(11) DEFAULT NULL,
  `ca_serverid` varchar(5000) DEFAULT NULL,
  PRIMARY KEY (`caid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_additionalip`
--

LOCK TABLES `tbl_cloud_additionalip` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_additionalip` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_additionalip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_backup`
--

DROP TABLE IF EXISTS `tbl_cloud_backup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_backup` (
  `cbid` bigint(20) NOT NULL AUTO_INCREMENT,
  `cb_name` varchar(5000) NOT NULL,
  `cb_date` varchar(30) NOT NULL,
  `cb_serverid` varchar(5000) DEFAULT NULL,
  `cb_uid_fk` bigint(20) NOT NULL,
  `cb_idcid_fk` bigint(20) NOT NULL,
  `cb_size` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`cbid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_backup`
--

LOCK TABLES `tbl_cloud_backup` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_backup` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_backup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_firewall_rules`
--

DROP TABLE IF EXISTS `tbl_cloud_firewall_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_firewall_rules` (
  `cfrid` bigint(20) NOT NULL AUTO_INCREMENT,
  `cfr_traffic_type` varchar(50) NOT NULL,
  `cfr_protocol` varchar(500) NOT NULL,
  `cfr_port` varchar(500) NOT NULL,
  `cfr_ip` varchar(500) NOT NULL,
  `cfr_cfid_fk` bigint(20) NOT NULL,
  `cfr_server_id` varchar(5000) DEFAULT NULL,
  `cfr_ipversion` int(11) NOT NULL DEFAULT 4,
  `cfr_description` varchar(500) NOT NULL,
  PRIMARY KEY (`cfrid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_firewall_rules`
--

LOCK TABLES `tbl_cloud_firewall_rules` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_firewall_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_firewall_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_firewalll`
--

DROP TABLE IF EXISTS `tbl_cloud_firewalll`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_firewalll` (
  `cfid` bigint(20) NOT NULL AUTO_INCREMENT,
  `cf_name` varchar(5000) NOT NULL,
  `cf_description` text NOT NULL,
  `cf_uid_fk` bigint(20) NOT NULL,
  `cf_serverid` varchar(5000) DEFAULT NULL,
  `cf_idcid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`cfid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_firewalll`
--

LOCK TABLES `tbl_cloud_firewalll` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_firewalll` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_firewalll` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_idc`
--

DROP TABLE IF EXISTS `tbl_cloud_idc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_idc` (
  `ciid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ci_name` text NOT NULL,
  `ci_location` text NOT NULL,
  `ci_country` text NOT NULL,
  `ci_status` int(11) NOT NULL COMMENT '1- active\r\n2- disable\r\n3- under construction\r\n4- storage full\r\n5- process full',
  `ci_apikey` text NOT NULL,
  `ci_storagetype` int(11) NOT NULL COMMENT '1- network storage\r\n2- local storage',
  `ci_about` text NOT NULL,
  `ci_url` varchar(5000) NOT NULL,
  `ci_public_network` varchar(500) NOT NULL,
  `ci_faname` varchar(500) NOT NULL,
  `ci_countofips` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ciid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_idc`
--

LOCK TABLES `tbl_cloud_idc` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_idc` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_idc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_inuseip`
--

DROP TABLE IF EXISTS `tbl_cloud_inuseip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_inuseip` (
  `ciuid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ciu_cpid_fk` bigint(20) NOT NULL,
  `ciu_sid_fk` bigint(20) NOT NULL,
  `ciu_ip` varchar(50) NOT NULL,
  PRIMARY KEY (`ciuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_inuseip`
--

LOCK TABLES `tbl_cloud_inuseip` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_inuseip` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_inuseip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_ippool`
--

DROP TABLE IF EXISTS `tbl_cloud_ippool`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_ippool` (
  `cpid` bigint(20) NOT NULL AUTO_INCREMENT,
  `cp_idcid_fk` varchar(5000) NOT NULL,
  `cp_startip` varchar(500) NOT NULL,
  `cp_endip` varchar(500) NOT NULL,
  `cp_istartip` bigint(20) NOT NULL,
  `cp_iendip` bigint(20) NOT NULL,
  `cp_exclude` varchar(5000) NOT NULL,
  `cp_usedip` varchar(11) NOT NULL DEFAULT '0-0',
  PRIMARY KEY (`cpid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_ippool`
--

LOCK TABLES `tbl_cloud_ippool` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_ippool` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_ippool` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_log`
--

DROP TABLE IF EXISTS `tbl_cloud_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_log` (
  `cldate` varchar(50) NOT NULL,
  `cl_sid_fk` bigint(20) NOT NULL,
  `cldesc` varchar(5000) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_log`
--

LOCK TABLES `tbl_cloud_log` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_logs`
--

DROP TABLE IF EXISTS `tbl_cloud_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_logs` (
  `clid` bigint(20) NOT NULL AUTO_INCREMENT,
  `cl_uid_fk` bigint(20) NOT NULL,
  `cldetails` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `cl_startdate` datetime NOT NULL,
  `cl_enddate` datetime NOT NULL,
  `cl_comment` varchar(5000) NOT NULL,
  PRIMARY KEY (`clid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_logs`
--

LOCK TABLES `tbl_cloud_logs` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_networks`
--

DROP TABLE IF EXISTS `tbl_cloud_networks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_networks` (
  `cnid` bigint(20) NOT NULL AUTO_INCREMENT,
  `cn_name` varchar(5000) NOT NULL,
  `cn_idcid_fk` bigint(20) NOT NULL,
  `cn_uid_fk` bigint(20) NOT NULL,
  `cn_serverid` varchar(5000) NOT NULL,
  PRIMARY KEY (`cnid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_networks`
--

LOCK TABLES `tbl_cloud_networks` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_networks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_networks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_project`
--

DROP TABLE IF EXISTS `tbl_cloud_project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_project` (
  `cpid` bigint(20) NOT NULL AUTO_INCREMENT,
  `cp_name` varchar(5000) NOT NULL,
  `cp_uid_fk` bigint(20) NOT NULL,
  `cp_idcid_fk` bigint(20) NOT NULL,
  `cp_default_Security_group` varchar(5000) DEFAULT NULL,
  `cp_project_id` varchar(5000) DEFAULT NULL,
  PRIMARY KEY (`cpid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_project`
--

LOCK TABLES `tbl_cloud_project` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_project` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_request`
--

DROP TABLE IF EXISTS `tbl_cloud_request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_request` (
  `crid` int(11) NOT NULL AUTO_INCREMENT,
  `cr_sid_fk` bigint(20) NOT NULL,
  `cr_request_type` varchar(400) NOT NULL,
  `cr_response` varchar(6000) NOT NULL,
  `cr_request_id` varchar(200) NOT NULL,
  `cr_request_date` datetime NOT NULL DEFAULT current_timestamp(),
  `cr_status` int(11) NOT NULL,
  `cr_tempid` varchar(500) NOT NULL,
  `cr_request` varchar(500) NOT NULL,
  PRIMARY KEY (`crid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_request`
--

LOCK TABLES `tbl_cloud_request` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_request` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_securitygroups_attachedtoserver`
--

DROP TABLE IF EXISTS `tbl_cloud_securitygroups_attachedtoserver`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_securitygroups_attachedtoserver` (
  `csa_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `csa_serverid_fk` bigint(20) NOT NULL,
  `csa_securiygroupid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`csa_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_securitygroups_attachedtoserver`
--

LOCK TABLES `tbl_cloud_securitygroups_attachedtoserver` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_securitygroups_attachedtoserver` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_securitygroups_attachedtoserver` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_server`
--

DROP TABLE IF EXISTS `tbl_cloud_server`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_server` (
  `csid` int(11) NOT NULL AUTO_INCREMENT,
  `csname` varchar(5000) NOT NULL,
  `cs_uid_fk` bigint(20) NOT NULL,
  `cs_serverid` varchar(500) DEFAULT NULL,
  `cs_idcid_fk` bigint(20) NOT NULL,
  `cs_status` int(11) NOT NULL DEFAULT 0 COMMENT '0- pending\r\n1- active\r\n2- off\r\n3- suspend\r\n4- pause\r\n5- deleted\r\n6- build\r\n7- shutdown\r\n',
  `cs_ip` varchar(500) DEFAULT NULL,
  `cs_ram` int(11) NOT NULL,
  `cs_vcpu` int(11) NOT NULL,
  `cs_hard` int(11) NOT NULL,
  `cs_additionalip` int(11) NOT NULL DEFAULT 0,
  `cs_startdate` varchar(30) DEFAULT NULL,
  `cs_lastupdate` varchar(30) DEFAULT NULL,
  `cs_networkid` varchar(500) DEFAULT NULL,
  `cs_sshkey` int(11) DEFAULT NULL,
  `cs_firewall` varchar(5000) NOT NULL DEFAULT 'default',
  `cs_osid` varchar(500) NOT NULL,
  `cs_osname` varchar(500) NOT NULL,
  `cs_test` int(1) NOT NULL DEFAULT 0,
  `cs_additional` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `cs_orderid` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`csid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_server`
--

LOCK TABLES `tbl_cloud_server` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_server` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_server` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_servernetwork`
--

DROP TABLE IF EXISTS `tbl_cloud_servernetwork`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_servernetwork` (
  `csnid` bigint(20) NOT NULL AUTO_INCREMENT,
  `csn_sid_fk` bigint(20) NOT NULL,
  `csn_nid_fk` bigint(20) NOT NULL,
  `csn_ispublic` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`csnid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_servernetwork`
--

LOCK TABLES `tbl_cloud_servernetwork` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_servernetwork` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_servernetwork` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_sshkey`
--

DROP TABLE IF EXISTS `tbl_cloud_sshkey`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_sshkey` (
  `skid` bigint(20) NOT NULL AUTO_INCREMENT,
  `sk_prvkey` text NOT NULL,
  `sk_pubkey` text NOT NULL,
  `sk_uid_fk` bigint(20) NOT NULL,
  `sk_name` varchar(5000) NOT NULL,
  `sk_serverid` varchar(5000) DEFAULT NULL,
  `sk_idcid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`skid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_sshkey`
--

LOCK TABLES `tbl_cloud_sshkey` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_sshkey` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_sshkey` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_volume`
--

DROP TABLE IF EXISTS `tbl_cloud_volume`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_volume` (
  `cvid` bigint(20) NOT NULL AUTO_INCREMENT,
  `cv_name` varchar(5000) NOT NULL,
  `cv_uid_fk` bigint(20) NOT NULL,
  `cv_space` bigint(20) NOT NULL,
  `cv_csid_fk` bigint(20) DEFAULT NULL,
  `cv_status` int(11) NOT NULL,
  `cv_creation_date` varchar(30) NOT NULL,
  `cv_update_date` varchar(30) NOT NULL,
  `cv_bootable` int(11) NOT NULL,
  `cv_serverid` varchar(5000) DEFAULT NULL,
  `cv_idcid_fk` bigint(20) NOT NULL,
  `cv_osname` varchar(5000) DEFAULT NULL,
  `cv_osid` varchar(500) DEFAULT NULL,
  `cv_is_snapshot` int(11) NOT NULL DEFAULT 0,
  `cv_type` varchar(50) NOT NULL DEFAULT 'sas',
  `cv_mountpoint` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`cvid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_volume`
--

LOCK TABLES `tbl_cloud_volume` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_volume` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_volume` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cloud_vxlan`
--

DROP TABLE IF EXISTS `tbl_cloud_vxlan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cloud_vxlan` (
  `cvid` bigint(20) NOT NULL AUTO_INCREMENT,
  `cvname` varchar(5000) NOT NULL,
  `cv_iprange` varchar(18) NOT NULL,
  `cv_gateway` varchar(11) NOT NULL,
  `cv_gateaway_ip` varchar(18) NOT NULL,
  `cv_dhcppool` varchar(5000) NOT NULL,
  `cv_dns` varchar(5000) NOT NULL,
  `cv_cnid_fk` bigint(20) DEFAULT 0,
  `cv_uid_fk` bigint(20) NOT NULL,
  `cv_idcid_fk` bigint(20) NOT NULL,
  `cv_serverid` varchar(500) DEFAULT NULL,
  `cv_dhcp` int(11) NOT NULL,
  PRIMARY KEY (`cvid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cloud_vxlan`
--

LOCK TABLES `tbl_cloud_vxlan` WRITE;
/*!40000 ALTER TABLE `tbl_cloud_vxlan` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cloud_vxlan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_cluster_details`
--

DROP TABLE IF EXISTS `tbl_cluster_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_cluster_details` (
  `clusterdetails_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cd_source` mediumtext NOT NULL,
  `cd_weight` int(11) NOT NULL,
  `cd_port` int(11) NOT NULL,
  `cd_cl_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`clusterdetails_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_cluster_details`
--

LOCK TABLES `tbl_cluster_details` WRITE;
/*!40000 ALTER TABLE `tbl_cluster_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_cluster_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clusters`
--

DROP TABLE IF EXISTS `tbl_clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_clusters` (
  `cluster_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cl_name` text NOT NULL,
  `cl_uid_fk` bigint(20) NOT NULL,
  `cl_protocol` varchar(10) NOT NULL,
  `cl_method` varchar(500) NOT NULL,
  `cl_domain_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`cluster_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clusters`
--

LOCK TABLES `tbl_clusters` WRITE;
/*!40000 ALTER TABLE `tbl_clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_clusters_websites`
--

DROP TABLE IF EXISTS `tbl_clusters_websites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_clusters_websites` (
  `clusterwebsite_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cw_cl_id_fk` bigint(20) NOT NULL,
  `cw_ws_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`clusterwebsite_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_clusters_websites`
--

LOCK TABLES `tbl_clusters_websites` WRITE;
/*!40000 ALTER TABLE `tbl_clusters_websites` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_clusters_websites` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_credit_details`
--

DROP TABLE IF EXISTS `tbl_credit_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_credit_details` (
  `cd_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cd_description` text NOT NULL,
  `cd_amount` bigint(11) NOT NULL,
  `cd_uid_fk` int(11) NOT NULL,
  `cd_date` varchar(30) NOT NULL,
  `cd_type` int(11) unsigned NOT NULL COMMENT '1-CDN Usage\r\n2-Support Plan\r\n3-FireWall Plan\r\n4-Waf Plan\r\n5-live Stream\r\n6-Video Streaming\r\n7-Add Payment \r\n8-SSL Certificate',
  `cd_tr_id_fk` int(11) unsigned NOT NULL DEFAULT 0 COMMENT 'transaction ID foreign KEY',
  `cd_current_balance` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`cd_id`),
  UNIQUE KEY `cd_id_2` (`cd_id`),
  KEY `cd_id` (`cd_id`),
  KEY `cd_tr_id_fk` (`cd_tr_id_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_credit_details`
--

LOCK TABLES `tbl_credit_details` WRITE;
/*!40000 ALTER TABLE `tbl_credit_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_credit_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_creditbalance`
--

DROP TABLE IF EXISTS `tbl_creditbalance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_creditbalance` (
  `cb_id` int(11) NOT NULL AUTO_INCREMENT,
  `cb_user_id` int(11) NOT NULL,
  `cb_balance` bigint(20) NOT NULL,
  `cb_lastchecked` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cb_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_creditbalance`
--

LOCK TABLES `tbl_creditbalance` WRITE;
/*!40000 ALTER TABLE `tbl_creditbalance` DISABLE KEYS */;
INSERT INTO `tbl_creditbalance` (`cb_id`, `cb_user_id`, `cb_balance`, `cb_lastchecked`) VALUES (1,2,0,0);
/*!40000 ALTER TABLE `tbl_creditbalance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_defaultpages`
--

DROP TABLE IF EXISTS `tbl_defaultpages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_defaultpages` (
  `dpid` bigint(20) NOT NULL AUTO_INCREMENT,
  `dp_wid_fk` bigint(20) NOT NULL,
  `dp_underconstruction` varchar(2000) DEFAULT NULL,
  `dp_firewall` varchar(2000) DEFAULT NULL,
  `dp_waf` varchar(2000) DEFAULT NULL,
  `dp_ratelimit` varchar(2000) DEFAULT NULL,
  `dp_servererror` varchar(2000) DEFAULT NULL,
  `dp_underconstruction_status` varchar(5000) DEFAULT NULL,
  `dp_firewall_status` text DEFAULT NULL,
  `dp_waf_status` text DEFAULT NULL,
  `dp_ratelimit_status` text DEFAULT NULL,
  `dp_servererror_status` text DEFAULT NULL,
  PRIMARY KEY (`dpid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_defaultpages`
--

LOCK TABLES `tbl_defaultpages` WRITE;
/*!40000 ALTER TABLE `tbl_defaultpages` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_defaultpages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_details_price`
--

DROP TABLE IF EXISTS `tbl_details_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_details_price` (
  `dpid` int(11) NOT NULL AUTO_INCREMENT,
  `dp_category` varchar(500) NOT NULL,
  `dp_price` bigint(20) NOT NULL,
  `dp_type` varchar(500) NOT NULL,
  PRIMARY KEY (`dpid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_details_price`
--

LOCK TABLES `tbl_details_price` WRITE;
/*!40000 ALTER TABLE `tbl_details_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_details_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_dns_dnssec`
--

DROP TABLE IF EXISTS `tbl_dns_dnssec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_dns_dnssec` (
  `ddid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ddsec` varchar(250) NOT NULL,
  `dd_did_fk` bigint(20) NOT NULL,
  `dd_status` int(11) NOT NULL COMMENT '1- active 2- disable',
  `dd_publickey` varchar(128) NOT NULL,
  PRIMARY KEY (`ddid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_dns_dnssec`
--

LOCK TABLES `tbl_dns_dnssec` WRITE;
/*!40000 ALTER TABLE `tbl_dns_dnssec` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_dns_dnssec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_dns_queue`
--

DROP TABLE IF EXISTS `tbl_dns_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_dns_queue` (
  `qname` varchar(5000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `qtype` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_dns_queue`
--

LOCK TABLES `tbl_dns_queue` WRITE;
/*!40000 ALTER TABLE `tbl_dns_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_dns_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_dns_record_balancer`
--

DROP TABLE IF EXISTS `tbl_dns_record_balancer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_dns_record_balancer` (
  `drbid` bigint(20) NOT NULL AUTO_INCREMENT,
  `drb_drid_fk` bigint(20) NOT NULL,
  `drb_ip` varchar(5000) NOT NULL,
  `drb_country` varchar(5000) NOT NULL,
  `drb_weight` int(11) NOT NULL,
  `drb_ttl` int(11) NOT NULL,
  PRIMARY KEY (`drbid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_dns_record_balancer`
--

LOCK TABLES `tbl_dns_record_balancer` WRITE;
/*!40000 ALTER TABLE `tbl_dns_record_balancer` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_dns_record_balancer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_dns_record_types`
--

DROP TABLE IF EXISTS `tbl_dns_record_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_dns_record_types` (
  `dns_rt_id` int(11) NOT NULL AUTO_INCREMENT,
  `dns_rt_name` varchar(50) DEFAULT NULL,
  `dns_rt_canproxy` int(11) DEFAULT NULL,
  `dns_rt_isactive` int(11) NOT NULL,
  `dns_rt_pattern` text DEFAULT NULL,
  PRIMARY KEY (`dns_rt_id`),
  UNIQUE KEY `dns_f_name` (`dns_rt_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_dns_record_types`
--

LOCK TABLES `tbl_dns_record_types` WRITE;
/*!40000 ALTER TABLE `tbl_dns_record_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_dns_record_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_dns_record_types_parameters`
--

DROP TABLE IF EXISTS `tbl_dns_record_types_parameters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_dns_record_types_parameters` (
  `dns_rtp_id` int(11) NOT NULL AUTO_INCREMENT,
  `dns_rtp_name` varchar(500) NOT NULL,
  `dns_rtp_expression` text NOT NULL,
  `dns_rtp_isactive` int(11) NOT NULL,
  `dns_record_types_id_fk` int(11) NOT NULL,
  PRIMARY KEY (`dns_rtp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_dns_record_types_parameters`
--

LOCK TABLES `tbl_dns_record_types_parameters` WRITE;
/*!40000 ALTER TABLE `tbl_dns_record_types_parameters` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_dns_record_types_parameters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_domains`
--

DROP TABLE IF EXISTS `tbl_domains`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_domains` (
  `domain_id` int(11) NOT NULL AUTO_INCREMENT,
  `d_name` text NOT NULL,
  `d_user_id_fk` int(11) NOT NULL,
  `d_status` int(11) NOT NULL COMMENT '0- domain disabled\r\n1- domain activated\r\n2- domain deleted',
  `d_reg_date` varchar(30) NOT NULL,
  `d_hash` varchar(5000) NOT NULL DEFAULT '0',
  `d_ddns` int(11) NOT NULL DEFAULT 0,
  `d_plan` varchar(5) NOT NULL DEFAULT 'free',
  `d_defaultwid` bigint(20) NOT NULL DEFAULT 0,
  `d_lastupdate` datetime DEFAULT current_timestamp(),
  `dnote` varchar(5000) DEFAULT '{ "adminnote":"", "suspendnote":""}',
  `d_orderid` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_domains`
--

LOCK TABLES `tbl_domains` WRITE;
/*!40000 ALTER TABLE `tbl_domains` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_domains` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_domains_logs`
--

DROP TABLE IF EXISTS `tbl_domains_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_domains_logs` (
  `dlid` bigint(20) NOT NULL AUTO_INCREMENT,
  `dl_did_fk` bigint(20) NOT NULL,
  `dl_start` datetime NOT NULL,
  `dl_end` datetime DEFAULT NULL,
  `dl_plan` varchar(50) NOT NULL,
  PRIMARY KEY (`dlid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_domains_logs`
--

LOCK TABLES `tbl_domains_logs` WRITE;
/*!40000 ALTER TABLE `tbl_domains_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_domains_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_domains_ns_records`
--

DROP TABLE IF EXISTS `tbl_domains_ns_records`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_domains_ns_records` (
  `dnrid` bigint(20) NOT NULL AUTO_INCREMENT,
  `dnr_d_id_fk` bigint(20) NOT NULL,
  `dnr_type` varchar(10) NOT NULL,
  `dnr_name` varchar(5000) DEFAULT NULL,
  `dnr_ip` varchar(500) DEFAULT NULL,
  `dnr_ttl` bigint(20) DEFAULT NULL,
  `dnr_proxied` int(2) DEFAULT NULL,
  `dnr_priority` bigint(20) DEFAULT NULL COMMENT 'MX\r\nSRV',
  `dnr_port` int(11) DEFAULT 0 COMMENT 'SRV',
  `dnr_weight` int(11) DEFAULT NULL COMMENT 'SRV',
  `dnr_value` text DEFAULT NULL COMMENT 'TXT\r\nPTR',
  `dnr_protocol` varchar(20) DEFAULT NULL,
  `dnr_service` varchar(5000) DEFAULT NULL,
  PRIMARY KEY (`dnrid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_domains_ns_records`
--

LOCK TABLES `tbl_domains_ns_records` WRITE;
/*!40000 ALTER TABLE `tbl_domains_ns_records` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_domains_ns_records` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_financial_invoice_byday`
--

DROP TABLE IF EXISTS `tbl_financial_invoice_byday`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_financial_invoice_byday` (
  `iidd` bigint(20) NOT NULL AUTO_INCREMENT,
  `idcdn` bigint(20) NOT NULL DEFAULT 0,
  `idlive` bigint(20) NOT NULL DEFAULT 0,
  `idcloud` bigint(20) NOT NULL DEFAULT 0,
  `idvod` bigint(20) NOT NULL DEFAULT 0,
  `idlivewebrtc` int(11) NOT NULL DEFAULT 0,
  `idstarttime` datetime NOT NULL,
  `idendtime` datetime NOT NULL,
  `id_uid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`iidd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_financial_invoice_byday`
--

LOCK TABLES `tbl_financial_invoice_byday` WRITE;
/*!40000 ALTER TABLE `tbl_financial_invoice_byday` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_financial_invoice_byday` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_financial_invoice_byhour`
--

DROP TABLE IF EXISTS `tbl_financial_invoice_byhour`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_financial_invoice_byhour` (
  `iid` bigint(20) NOT NULL AUTO_INCREMENT,
  `icdn` bigint(20) NOT NULL DEFAULT 0,
  `ilive` bigint(20) NOT NULL DEFAULT 0,
  `icloud` bigint(20) NOT NULL DEFAULT 0,
  `ivod` bigint(20) NOT NULL DEFAULT 0,
  `ilivewebrtc` int(11) NOT NULL DEFAULT 0,
  `istarttime` datetime NOT NULL,
  `iendtime` datetime NOT NULL,
  `i_uid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`iid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_financial_invoice_byhour`
--

LOCK TABLES `tbl_financial_invoice_byhour` WRITE;
/*!40000 ALTER TABLE `tbl_financial_invoice_byhour` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_financial_invoice_byhour` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_financial_invoice_bymonth`
--

DROP TABLE IF EXISTS `tbl_financial_invoice_bymonth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_financial_invoice_bymonth` (
  `iidm` bigint(20) NOT NULL AUTO_INCREMENT,
  `imcdn` bigint(20) NOT NULL DEFAULT 0,
  `imlive` bigint(20) NOT NULL DEFAULT 0,
  `imcloud` bigint(20) NOT NULL DEFAULT 0,
  `imvod` bigint(20) NOT NULL DEFAULT 0,
  `imlivewebrtc` int(11) NOT NULL DEFAULT 0,
  `imstarttime` datetime NOT NULL,
  `imendtime` datetime NOT NULL,
  `im_uid_fk` bigint(20) NOT NULL,
  `im_current` bigint(2) NOT NULL,
  `im_tax` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`iidm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_financial_invoice_bymonth`
--

LOCK TABLES `tbl_financial_invoice_bymonth` WRITE;
/*!40000 ALTER TABLE `tbl_financial_invoice_bymonth` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_financial_invoice_bymonth` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_financial_invoicedetails_byday`
--

DROP TABLE IF EXISTS `tbl_financial_invoicedetails_byday`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_financial_invoicedetails_byday` (
  `fiddid` bigint(20) NOT NULL AUTO_INCREMENT,
  `fidd_starttime` datetime NOT NULL,
  `fidd_endtime` datetime NOT NULL,
  `fidd_calculateditem` varchar(5000) NOT NULL,
  `fidd_itid_fk` bigint(20) NOT NULL,
  `fidd_details` mediumtext NOT NULL,
  `fidd_price` bigint(20) NOT NULL,
  `fidd_count` bigint(20) NOT NULL,
  `fidd_sid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`fiddid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_financial_invoicedetails_byday`
--

LOCK TABLES `tbl_financial_invoicedetails_byday` WRITE;
/*!40000 ALTER TABLE `tbl_financial_invoicedetails_byday` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_financial_invoicedetails_byday` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_financial_invoicedetails_byhour`
--

DROP TABLE IF EXISTS `tbl_financial_invoicedetails_byhour`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_financial_invoicedetails_byhour` (
  `fidid` bigint(20) NOT NULL AUTO_INCREMENT,
  `fid_starttime` datetime NOT NULL,
  `fid_endtime` datetime NOT NULL,
  `fid_calculateditem` varchar(5000) NOT NULL,
  `fid_itid_fk` bigint(20) NOT NULL,
  `fid_details` mediumtext NOT NULL,
  `fid_price` bigint(20) NOT NULL,
  `fid_count` bigint(20) NOT NULL,
  `fid_sid_fk` bigint(20) NOT NULL,
  `fid_updated` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`fidid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_financial_invoicedetails_byhour`
--

LOCK TABLES `tbl_financial_invoicedetails_byhour` WRITE;
/*!40000 ALTER TABLE `tbl_financial_invoicedetails_byhour` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_financial_invoicedetails_byhour` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_financial_invoicedetails_bymonth`
--

DROP TABLE IF EXISTS `tbl_financial_invoicedetails_bymonth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_financial_invoicedetails_bymonth` (
  `fidmid` bigint(20) NOT NULL AUTO_INCREMENT,
  `fidm_starttime` datetime NOT NULL,
  `fidm_endtime` datetime NOT NULL,
  `fidm_calculateditem` varchar(5000) NOT NULL,
  `fidm_itid_fk` bigint(20) NOT NULL,
  `fidm_details` mediumtext NOT NULL,
  `fidm_price` bigint(20) NOT NULL,
  `fidm_count` bigint(20) NOT NULL,
  `fidm_sid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`fidmid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_financial_invoicedetails_bymonth`
--

LOCK TABLES `tbl_financial_invoicedetails_bymonth` WRITE;
/*!40000 ALTER TABLE `tbl_financial_invoicedetails_bymonth` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_financial_invoicedetails_bymonth` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_financial_invoicetreebyday`
--

DROP TABLE IF EXISTS `tbl_financial_invoicetreebyday`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_financial_invoicetreebyday` (
  `fitdid` bigint(20) NOT NULL AUTO_INCREMENT,
  `fitddecription` varchar(5000) DEFAULT NULL,
  `fitdprice` bigint(20) NOT NULL,
  `fitd_iidd_fk` bigint(20) NOT NULL,
  `fitd_ifield` varchar(5000) NOT NULL,
  `fitd_sid` bigint(20) NOT NULL,
  `fitd_sname` varchar(5000) NOT NULL,
  `fitd_starttime` datetime NOT NULL,
  `fitd_endtime` datetime NOT NULL,
  PRIMARY KEY (`fitdid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_financial_invoicetreebyday`
--

LOCK TABLES `tbl_financial_invoicetreebyday` WRITE;
/*!40000 ALTER TABLE `tbl_financial_invoicetreebyday` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_financial_invoicetreebyday` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_financial_invoicetreebyhour`
--

DROP TABLE IF EXISTS `tbl_financial_invoicetreebyhour`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_financial_invoicetreebyhour` (
  `fitid` bigint(20) NOT NULL AUTO_INCREMENT,
  `fitdecription` varchar(5000) DEFAULT NULL,
  `fitprice` bigint(20) NOT NULL,
  `fit_iid_fk` bigint(20) NOT NULL,
  `fit_ifield` varchar(5000) NOT NULL,
  `fit_sid` bigint(20) NOT NULL,
  `fit_sname` varchar(5000) NOT NULL,
  `fit_starttime` datetime DEFAULT NULL,
  `fit_endtime` datetime DEFAULT NULL,
  PRIMARY KEY (`fitid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_financial_invoicetreebyhour`
--

LOCK TABLES `tbl_financial_invoicetreebyhour` WRITE;
/*!40000 ALTER TABLE `tbl_financial_invoicetreebyhour` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_financial_invoicetreebyhour` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_financial_invoicetreebymonth`
--

DROP TABLE IF EXISTS `tbl_financial_invoicetreebymonth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_financial_invoicetreebymonth` (
  `fitmid` bigint(20) NOT NULL AUTO_INCREMENT,
  `fitmdecription` varchar(5000) DEFAULT NULL,
  `fitmprice` bigint(20) NOT NULL,
  `fitm_iidm_fk` bigint(20) NOT NULL,
  `fitm_ifield` varchar(5000) NOT NULL,
  `fitm_sid` bigint(20) NOT NULL,
  `fitm_sname` varchar(5000) NOT NULL,
  `fitm_starttime` datetime NOT NULL,
  `fitm_endtime` datetime NOT NULL,
  PRIMARY KEY (`fitmid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_financial_invoicetreebymonth`
--

LOCK TABLES `tbl_financial_invoicetreebymonth` WRITE;
/*!40000 ALTER TABLE `tbl_financial_invoicetreebymonth` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_financial_invoicetreebymonth` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_freessl`
--

DROP TABLE IF EXISTS `tbl_freessl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_freessl` (
  `freessl_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fs_websiteid` bigint(20) NOT NULL,
  `fs_sp_id_fk` bigint(20) NOT NULL,
  `fs_cert` varchar(5000) NOT NULL,
  `fs_privatekey` varchar(5000) NOT NULL,
  `fs_cabundle` varchar(5000) NOT NULL,
  `fs_expiredate` datetime DEFAULT NULL,
  PRIMARY KEY (`freessl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_freessl`
--

LOCK TABLES `tbl_freessl` WRITE;
/*!40000 ALTER TABLE `tbl_freessl` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_freessl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_freessl_request`
--

DROP TABLE IF EXISTS `tbl_freessl_request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_freessl_request` (
  `fsrid` bigint(20) NOT NULL AUTO_INCREMENT,
  `fsr_wid` bigint(20) NOT NULL,
  `fsr_date` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`fsrid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_freessl_request`
--

LOCK TABLES `tbl_freessl_request` WRITE;
/*!40000 ALTER TABLE `tbl_freessl_request` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_freessl_request` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_gzip`
--

DROP TABLE IF EXISTS `tbl_gzip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_gzip` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `gstatus` varchar(10) NOT NULL,
  `g_wid_fk` bigint(11) NOT NULL,
  PRIMARY KEY (`gid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_gzip`
--

LOCK TABLES `tbl_gzip` WRITE;
/*!40000 ALTER TABLE `tbl_gzip` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_gzip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_header_queue`
--

DROP TABLE IF EXISTS `tbl_header_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_header_queue` (
  `domain` varchar(5000) NOT NULL,
  `content` varchar(5000) NOT NULL,
  `action` varchar(20) NOT NULL,
  `location` varchar(5000) NOT NULL,
  `priority` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_header_queue`
--

LOCK TABLES `tbl_header_queue` WRITE;
/*!40000 ALTER TABLE `tbl_header_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_header_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_headertobackend`
--

DROP TABLE IF EXISTS `tbl_headertobackend`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_headertobackend` (
  `htb_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `htb_name` varchar(5000) NOT NULL,
  `htb_value` varchar(5000) NOT NULL,
  `htb_wid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`htb_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_headertobackend`
--

LOCK TABLES `tbl_headertobackend` WRITE;
/*!40000 ALTER TABLE `tbl_headertobackend` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_headertobackend` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_headertoclient`
--

DROP TABLE IF EXISTS `tbl_headertoclient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_headertoclient` (
  `htc_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `htc_name` varchar(5000) NOT NULL,
  `htc_value` varchar(5000) NOT NULL,
  `htc_wid_fk` int(11) NOT NULL,
  PRIMARY KEY (`htc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_headertoclient`
--

LOCK TABLES `tbl_headertoclient` WRITE;
/*!40000 ALTER TABLE `tbl_headertoclient` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_headertoclient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_hideheader`
--

DROP TABLE IF EXISTS `tbl_hideheader`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_hideheader` (
  `hh_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `hh_name` varchar(5000) NOT NULL,
  `hh_wid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`hh_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_hideheader`
--

LOCK TABLES `tbl_hideheader` WRITE;
/*!40000 ALTER TABLE `tbl_hideheader` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_hideheader` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_hotlink_protection_main`
--

DROP TABLE IF EXISTS `tbl_hotlink_protection_main`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_hotlink_protection_main` (
  `hlpid` bigint(20) NOT NULL AUTO_INCREMENT,
  `hlp_wid_fk` bigint(20) NOT NULL,
  `hlp_allowed_domain` text NOT NULL,
  `hlp_allowedmethod` varchar(5000) DEFAULT NULL,
  PRIMARY KEY (`hlpid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_hotlink_protection_main`
--

LOCK TABLES `tbl_hotlink_protection_main` WRITE;
/*!40000 ALTER TABLE `tbl_hotlink_protection_main` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_hotlink_protection_main` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_hotlink_protection_subfolder`
--

DROP TABLE IF EXISTS `tbl_hotlink_protection_subfolder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_hotlink_protection_subfolder` (
  `hlpsfid` bigint(20) NOT NULL AUTO_INCREMENT,
  `hlp_sfid_fk` bigint(20) NOT NULL,
  `hlp_sfallowed_domain` text NOT NULL,
  `hlp_sfallowedmethod` varchar(5000) DEFAULT NULL,
  PRIMARY KEY (`hlpsfid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_hotlink_protection_subfolder`
--

LOCK TABLES `tbl_hotlink_protection_subfolder` WRITE;
/*!40000 ALTER TABLE `tbl_hotlink_protection_subfolder` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_hotlink_protection_subfolder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_iframe_restriction`
--

DROP TABLE IF EXISTS `tbl_iframe_restriction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_iframe_restriction` (
  `irid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ir_wid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`irid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_iframe_restriction`
--

LOCK TABLES `tbl_iframe_restriction` WRITE;
/*!40000 ALTER TABLE `tbl_iframe_restriction` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_iframe_restriction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_iframesubfolder_restriction`
--

DROP TABLE IF EXISTS `tbl_iframesubfolder_restriction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_iframesubfolder_restriction` (
  `irsfid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ir_sfid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`irsfid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_iframesubfolder_restriction`
--

LOCK TABLES `tbl_iframesubfolder_restriction` WRITE;
/*!40000 ALTER TABLE `tbl_iframesubfolder_restriction` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_iframesubfolder_restriction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_input_queue`
--

DROP TABLE IF EXISTS `tbl_input_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_input_queue` (
  `iqid` bigint(20) NOT NULL AUTO_INCREMENT,
  `iq_input` varchar(20000) NOT NULL,
  `iqtime` datetime NOT NULL,
  PRIMARY KEY (`iqid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_input_queue`
--

LOCK TABLES `tbl_input_queue` WRITE;
/*!40000 ALTER TABLE `tbl_input_queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_input_queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_livestream_domain`
--

DROP TABLE IF EXISTS `tbl_livestream_domain`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_livestream_domain` (
  `lsdid` bigint(20) NOT NULL AUTO_INCREMENT,
  `lsdname` varchar(5000) NOT NULL,
  `lsd_uid_fk` bigint(20) NOT NULL,
  `lsd_status` int(11) NOT NULL,
  PRIMARY KEY (`lsdid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_livestream_domain`
--

LOCK TABLES `tbl_livestream_domain` WRITE;
/*!40000 ALTER TABLE `tbl_livestream_domain` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_livestream_domain` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_livestream_stream`
--

DROP TABLE IF EXISTS `tbl_livestream_stream`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_livestream_stream` (
  `lssid` bigint(20) NOT NULL AUTO_INCREMENT,
  `lssname` varchar(5000) NOT NULL,
  `lssframerate` int(11) NOT NULL,
  `lssbitrate` varchar(50) NOT NULL,
  `lsshls` varchar(50) NOT NULL,
  `lssdash` varchar(11) NOT NULL,
  `lssaccess` varchar(5000) NOT NULL,
  `record` int(11) NOT NULL,
  `lsstype` varchar(4) NOT NULL,
  `lsspushurl` varchar(5000) NOT NULL,
  `lssstreamkey` varchar(64) NOT NULL,
  `lss_lsdid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`lssid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_livestream_stream`
--

LOCK TABLES `tbl_livestream_stream` WRITE;
/*!40000 ALTER TABLE `tbl_livestream_stream` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_livestream_stream` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_logchecker`
--

DROP TABLE IF EXISTS `tbl_logchecker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_logchecker` (
  `lcid` bigint(20) NOT NULL AUTO_INCREMENT,
  `lc_name` varchar(5000) NOT NULL,
  `lc_lastdate` datetime NOT NULL,
  PRIMARY KEY (`lcid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_logchecker`
--

LOCK TABLES `tbl_logchecker` WRITE;
/*!40000 ALTER TABLE `tbl_logchecker` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_logchecker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_main_cache`
--

DROP TABLE IF EXISTS `tbl_main_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_main_cache` (
  `mcid` bigint(20) NOT NULL AUTO_INCREMENT,
  `mc_wid_fk` bigint(20) NOT NULL,
  `mc_type` varchar(10) DEFAULT NULL,
  `mc_browsercache_ttl` varchar(10) NOT NULL,
  `mc_servercache_ttl` varchar(10) NOT NULL,
  PRIMARY KEY (`mcid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_main_cache`
--

LOCK TABLES `tbl_main_cache` WRITE;
/*!40000 ALTER TABLE `tbl_main_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_main_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_main_restriction`
--

DROP TABLE IF EXISTS `tbl_main_restriction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_main_restriction` (
  `miid` bigint(20) NOT NULL AUTO_INCREMENT,
  `mi_default` varchar(10) NOT NULL,
  `mi_ip` mediumtext NOT NULL,
  `mi_country` mediumtext NOT NULL,
  `mi_websiteid` bigint(20) NOT NULL,
  `mi_desc` varchar(5000) NOT NULL,
  PRIMARY KEY (`miid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_main_restriction`
--

LOCK TABLES `tbl_main_restriction` WRITE;
/*!40000 ALTER TABLE `tbl_main_restriction` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_main_restriction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_middle_response`
--

DROP TABLE IF EXISTS `tbl_middle_response`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_middle_response` (
  `mr_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `mr_send_time` varchar(5000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `mr_response_time` varchar(5000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `mr_response` varchar(5000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `mr_diff` varchar(5000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`mr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_middle_response`
--

LOCK TABLES `tbl_middle_response` WRITE;
/*!40000 ALTER TABLE `tbl_middle_response` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_middle_response` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_minifywebsite`
--

DROP TABLE IF EXISTS `tbl_minifywebsite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_minifywebsite` (
  `mwid` bigint(20) NOT NULL AUTO_INCREMENT,
  `mw_js` int(11) DEFAULT NULL,
  `mw_css` int(11) DEFAULT NULL,
  `mw_html` int(11) DEFAULT NULL,
  `mw_wid_fk` bigint(20) NOT NULL,
  `mw_gzip` int(11) NOT NULL DEFAULT 1,
  `mw_resizeimage` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`mwid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_minifywebsite`
--

LOCK TABLES `tbl_minifywebsite` WRITE;
/*!40000 ALTER TABLE `tbl_minifywebsite` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_minifywebsite` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_nameserver_pool`
--

DROP TABLE IF EXISTS `tbl_nameserver_pool`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_nameserver_pool` (
  `nsid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ns1` mediumtext NOT NULL,
  `ns2` mediumtext NOT NULL,
  `organize` int(11) NOT NULL,
  `nsip1` varchar(20) NOT NULL,
  `nsip2` varchar(20) NOT NULL,
  `ns_ispublic` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`nsid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_nameserver_pool`
--

LOCK TABLES `tbl_nameserver_pool` WRITE;
/*!40000 ALTER TABLE `tbl_nameserver_pool` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_nameserver_pool` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_orders`
--

DROP TABLE IF EXISTS `tbl_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_orders` (
  `oid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid_fk` bigint(20) NOT NULL,
  `date` datetime NOT NULL DEFAULT current_timestamp(),
  `orderid` varchar(5000) NOT NULL,
  PRIMARY KEY (`oid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_orders`
--

LOCK TABLES `tbl_orders` WRITE;
/*!40000 ALTER TABLE `tbl_orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ratelimit_main`
--

DROP TABLE IF EXISTS `tbl_ratelimit_main`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ratelimit_main` (
  `rlid` bigint(20) NOT NULL AUTO_INCREMENT,
  `rlname` varchar(5000) NOT NULL,
  `rltimerate` varchar(1) NOT NULL,
  `rlrate` int(11) NOT NULL,
  `rlburst` int(11) NOT NULL,
  `rlburstcount` int(11) NOT NULL,
  `rlipranges` mediumtext NOT NULL,
  `rl_wid_fk` bigint(20) NOT NULL,
  `rl_desc` varchar(2000) NOT NULL,
  PRIMARY KEY (`rlid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ratelimit_main`
--

LOCK TABLES `tbl_ratelimit_main` WRITE;
/*!40000 ALTER TABLE `tbl_ratelimit_main` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ratelimit_main` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ratelimit_new`
--

DROP TABLE IF EXISTS `tbl_ratelimit_new`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ratelimit_new` (
  `rln_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rln_ips` varchar(5000) NOT NULL,
  `rln_description` varchar(5000) NOT NULL,
  `rln_requestcount` int(11) NOT NULL,
  `rln_timerate` int(11) NOT NULL,
  `rln_timeformat` varchar(1) NOT NULL,
  `rln_blockedbytimerange` int(11) NOT NULL,
  `rln_blockedbytimeformat` varchar(1) NOT NULL,
  `rln_wid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`rln_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ratelimit_new`
--

LOCK TABLES `tbl_ratelimit_new` WRITE;
/*!40000 ALTER TABLE `tbl_ratelimit_new` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ratelimit_new` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ratelimit_new_subfolder`
--

DROP TABLE IF EXISTS `tbl_ratelimit_new_subfolder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ratelimit_new_subfolder` (
  `rlsf_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rlsf_ips` varchar(5000) NOT NULL,
  `rlsf_description` varchar(5000) NOT NULL,
  `rlsf_requestcount` int(11) NOT NULL,
  `rlsf_timerate` int(11) NOT NULL,
  `rlsf_timeformat` varchar(1) NOT NULL,
  `rlsf_blockedbytimerange` int(11) NOT NULL,
  `rlsf_blockedbytimeformat` varchar(1) NOT NULL,
  `rlsf_sfid_fk` bigint(20) NOT NULL,
  `rlsf_priority` int(11) NOT NULL,
  PRIMARY KEY (`rlsf_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ratelimit_new_subfolder`
--

LOCK TABLES `tbl_ratelimit_new_subfolder` WRITE;
/*!40000 ALTER TABLE `tbl_ratelimit_new_subfolder` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ratelimit_new_subfolder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ratelimit_subfolder`
--

DROP TABLE IF EXISTS `tbl_ratelimit_subfolder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ratelimit_subfolder` (
  `rlsfid` bigint(20) NOT NULL AUTO_INCREMENT,
  `rlsfname` varchar(5000) NOT NULL,
  `rlsftimerate` varchar(1) NOT NULL,
  `rlsfrate` int(11) NOT NULL,
  `rlsfburst` int(11) NOT NULL,
  `rlsfburstcount` int(11) NOT NULL,
  `rlsfipranges` mediumtext NOT NULL,
  `rl_sfid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`rlsfid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ratelimit_subfolder`
--

LOCK TABLES `tbl_ratelimit_subfolder` WRITE;
/*!40000 ALTER TABLE `tbl_ratelimit_subfolder` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ratelimit_subfolder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_sessions`
--

DROP TABLE IF EXISTS `tbl_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_sessions` (
  `ssid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ss_token` varchar(128) NOT NULL,
  `ss_uid_fk` bigint(20) NOT NULL,
  `ss_expiredate` varchar(50) NOT NULL,
  PRIMARY KEY (`ssid`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_sessions`
--

LOCK TABLES `tbl_sessions` WRITE;
/*!40000 ALTER TABLE `tbl_sessions` DISABLE KEYS */;
INSERT INTO `tbl_sessions` (`ssid`, `ss_token`, `ss_uid_fk`, `ss_expiredate`) VALUES (2,'kpJS17SdKmBV4VhGWF1LLviSyOJF90UpTJLpdaSWc6rEP5baOPjnn5Z2lcI9tzJd',2,'1402/03/19 13:35:54'),
(21,'xTX0KXvvi6cWKgPXq0DSTGCmQ70bwknz2mjhcQtX08u8QXicteRpgNe5PkNom6fI',2,'1402/03/18 01:03:46'),
(22,'QGYqd9PBX9ivKUEj2GC4kWBQn5KlTPOUa0J9WGkhZorwy3i5y7ui2Fmg4W8sbpb6',2,'1402/03/18 01:06:02'),
(23,'21k9t3FffayFNHlY2BG3FA5EydfztK34oHRSARiFv3Xtil2N14j32ekSZP0SEGdn',2,'1402/03/20 00:21:13'),
(24,'AuQrT83f87wfOsrpMj08mUBKlXOTVjJ3JNkDA7Kfj4pXy4jVKRQLe9Mn5mKbhdxb',2,'1402/03/20 00:23:00'),
(25,'vZxGyVSfacOf23myyRkVhfa3PFp5zEPqtbyyqhkTbTCad7q2Wh4N1ieQEBEY9RD5',2,'1402/03/20 01:02:22');
/*!40000 ALTER TABLE `tbl_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_setting`
--

DROP TABLE IF EXISTS `tbl_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_setting` (
  `sid` int(11) NOT NULL AUTO_INCREMENT,
  `sname` varchar(5000) NOT NULL,
  `svalue` text NOT NULL,
  PRIMARY KEY (`sid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_setting`
--

LOCK TABLES `tbl_setting` WRITE;
/*!40000 ALTER TABLE `tbl_setting` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_setting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_sms_logs`
--

DROP TABLE IF EXISTS `tbl_sms_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_sms_logs` (
  `slid` bigint(20) NOT NULL AUTO_INCREMENT,
  `slcontent` varchar(5000) NOT NULL,
  `sl_status` int(11) NOT NULL,
  `sl_log` varchar(5000) NOT NULL,
  `sl_time` datetime DEFAULT NULL,
  PRIMARY KEY (`slid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_sms_logs`
--

LOCK TABLES `tbl_sms_logs` WRITE;
/*!40000 ALTER TABLE `tbl_sms_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_sms_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ssl_hsts`
--

DROP TABLE IF EXISTS `tbl_ssl_hsts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ssl_hsts` (
  `shid` bigint(20) NOT NULL AUTO_INCREMENT,
  `sh_wid_fk` bigint(20) NOT NULL,
  `sh_status` int(11) NOT NULL,
  `sh_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`shid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ssl_hsts`
--

LOCK TABLES `tbl_ssl_hsts` WRITE;
/*!40000 ALTER TABLE `tbl_ssl_hsts` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ssl_hsts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ssl_pools`
--

DROP TABLE IF EXISTS `tbl_ssl_pools`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ssl_pools` (
  `sslpoolsid` bigint(20) NOT NULL AUTO_INCREMENT,
  `sp_uid_fk` bigint(20) NOT NULL,
  `sp_cert` text NOT NULL,
  `sp_cabundle` text NOT NULL,
  `sp_privatekey` text NOT NULL,
  `sp_startdate` varchar(30) NOT NULL,
  `sp_expiredate` varchar(30) NOT NULL,
  `sp_domain` varchar(5000) NOT NULL,
  `sp_altdomain` text NOT NULL,
  `sp_name` text NOT NULL,
  `sp_issuername` text NOT NULL,
  `sp_did_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`sslpoolsid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ssl_pools`
--

LOCK TABLES `tbl_ssl_pools` WRITE;
/*!40000 ALTER TABLE `tbl_ssl_pools` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ssl_pools` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ssl_tls`
--

DROP TABLE IF EXISTS `tbl_ssl_tls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ssl_tls` (
  `stid` bigint(20) NOT NULL AUTO_INCREMENT,
  `st_wid_fk` bigint(20) NOT NULL,
  `st_status` varchar(50) NOT NULL,
  PRIMARY KEY (`stid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ssl_tls`
--

LOCK TABLES `tbl_ssl_tls` WRITE;
/*!40000 ALTER TABLE `tbl_ssl_tls` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ssl_tls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ssl_websites`
--

DROP TABLE IF EXISTS `tbl_ssl_websites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ssl_websites` (
  `sslwebsites_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sw_sp_id_fk` bigint(20) NOT NULL,
  `sw_ws_id_fk` bigint(20) NOT NULL,
  `sw_status` varchar(500) NOT NULL,
  `sw_ssl_status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`sslwebsites_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ssl_websites`
--

LOCK TABLES `tbl_ssl_websites` WRITE;
/*!40000 ALTER TABLE `tbl_ssl_websites` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ssl_websites` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_autominify`
--

DROP TABLE IF EXISTS `tbl_subdfolder_autominify`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_autominify` (
  `sfam_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfam_value` varchar(50) NOT NULL,
  `sfam_sf_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`sfam_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_autominify`
--

LOCK TABLES `tbl_subdfolder_autominify` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_autominify` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_autominify` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_browsercachettl`
--

DROP TABLE IF EXISTS `tbl_subdfolder_browsercachettl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_browsercachettl` (
  `sfbct_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfbct_value` varchar(10) NOT NULL,
  `sfbct_sf_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`sfbct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_browsercachettl`
--

LOCK TABLES `tbl_subdfolder_browsercachettl` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_browsercachettl` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_browsercachettl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_cachelevel`
--

DROP TABLE IF EXISTS `tbl_subdfolder_cachelevel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_cachelevel` (
  `sfcl_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfcl_level` int(11) NOT NULL,
  `sfcl_sf_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`sfcl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_cachelevel`
--

LOCK TABLES `tbl_subdfolder_cachelevel` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_cachelevel` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_cachelevel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_connection_timeout`
--

DROP TABLE IF EXISTS `tbl_subdfolder_connection_timeout`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_connection_timeout` (
  `sfmcto_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfmcto_sfid_fk` bigint(20) NOT NULL,
  `sfmcto_connect` int(11) NOT NULL DEFAULT 60,
  `sfmcto_send` int(11) NOT NULL DEFAULT 300,
  `sfmcto_read` int(11) NOT NULL DEFAULT 100,
  PRIMARY KEY (`sfmcto_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_connection_timeout`
--

LOCK TABLES `tbl_subdfolder_connection_timeout` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_connection_timeout` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_connection_timeout` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_countrymanagement`
--

DROP TABLE IF EXISTS `tbl_subdfolder_countrymanagement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_countrymanagement` (
  `sfcm_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfcm_default` varchar(50) NOT NULL,
  `sfcm_country` varchar(700) NOT NULL,
  `sfcm_sf_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`sfcm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_countrymanagement`
--

LOCK TABLES `tbl_subdfolder_countrymanagement` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_countrymanagement` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_countrymanagement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_forcehttps`
--

DROP TABLE IF EXISTS `tbl_subdfolder_forcehttps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_forcehttps` (
  `sffh_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sffh_value` int(11) NOT NULL,
  `sffh_sf_id_fk` int(11) NOT NULL,
  PRIMARY KEY (`sffh_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_forcehttps`
--

LOCK TABLES `tbl_subdfolder_forcehttps` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_forcehttps` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_forcehttps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_headertobackend`
--

DROP TABLE IF EXISTS `tbl_subdfolder_headertobackend`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_headertobackend` (
  `sfhtb_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfhtb_name` varchar(5000) NOT NULL,
  `sfhtb_value` varchar(5000) NOT NULL,
  `sfhtb_sfcl_sf_id_fk` int(11) NOT NULL,
  PRIMARY KEY (`sfhtb_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_headertobackend`
--

LOCK TABLES `tbl_subdfolder_headertobackend` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_headertobackend` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_headertobackend` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_headertoclient`
--

DROP TABLE IF EXISTS `tbl_subdfolder_headertoclient`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_headertoclient` (
  `sfhtc_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfhtc_name` varchar(500) NOT NULL,
  `sfhtc_value` varchar(5000) NOT NULL,
  `sfhtc_sfcl_sf_id_fk` int(11) NOT NULL,
  PRIMARY KEY (`sfhtc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_headertoclient`
--

LOCK TABLES `tbl_subdfolder_headertoclient` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_headertoclient` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_headertoclient` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_ipmanagement`
--

DROP TABLE IF EXISTS `tbl_subdfolder_ipmanagement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_ipmanagement` (
  `sfim_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfim_default` varchar(50) NOT NULL,
  `sfim_ip` varchar(7000) NOT NULL,
  `sfim_sf_id_fk` int(11) NOT NULL,
  PRIMARY KEY (`sfim_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_ipmanagement`
--

LOCK TABLES `tbl_subdfolder_ipmanagement` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_ipmanagement` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_ipmanagement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_redirecturl`
--

DROP TABLE IF EXISTS `tbl_subdfolder_redirecturl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_redirecturl` (
  `sfru_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfru_status` int(11) NOT NULL,
  `sfru_newurl` varchar(5000) NOT NULL,
  `sfru_sf_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`sfru_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_redirecturl`
--

LOCK TABLES `tbl_subdfolder_redirecturl` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_redirecturl` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_redirecturl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_removeheader`
--

DROP TABLE IF EXISTS `tbl_subdfolder_removeheader`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_removeheader` (
  `sfrh_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfrh_name` varchar(5000) NOT NULL,
  `sfrh_sf_id_fk` int(11) NOT NULL,
  PRIMARY KEY (`sfrh_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_removeheader`
--

LOCK TABLES `tbl_subdfolder_removeheader` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_removeheader` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_removeheader` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_securitylevel`
--

DROP TABLE IF EXISTS `tbl_subdfolder_securitylevel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_securitylevel` (
  `sfsl_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfsl_value` int(11) NOT NULL,
  `sfsl_sf_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`sfsl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_securitylevel`
--

LOCK TABLES `tbl_subdfolder_securitylevel` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_securitylevel` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_securitylevel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_servercachettl`
--

DROP TABLE IF EXISTS `tbl_subdfolder_servercachettl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_servercachettl` (
  `sfsct_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfsct_value` varchar(20) NOT NULL,
  `sfsct_sf_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`sfsct_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_servercachettl`
--

LOCK TABLES `tbl_subdfolder_servercachettl` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_servercachettl` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_servercachettl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_slicing`
--

DROP TABLE IF EXISTS `tbl_subdfolder_slicing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_slicing` (
  `sfs_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfs_sf_id_fk` bigint(20) NOT NULL,
  `sfs_state` int(11) NOT NULL,
  PRIMARY KEY (`sfs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_slicing`
--

LOCK TABLES `tbl_subdfolder_slicing` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_slicing` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_slicing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subdfolder_waflevel`
--

DROP TABLE IF EXISTS `tbl_subdfolder_waflevel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subdfolder_waflevel` (
  `sfwl_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfwl_level` int(11) NOT NULL,
  `sfwl_sf_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`sfwl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subdfolder_waflevel`
--

LOCK TABLES `tbl_subdfolder_waflevel` WRITE;
/*!40000 ALTER TABLE `tbl_subdfolder_waflevel` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subdfolder_waflevel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subfolder`
--

DROP TABLE IF EXISTS `tbl_subfolder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subfolder` (
  `subfolder_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sf_name` text NOT NULL,
  `sf_cl_id_fk` bigint(20) NOT NULL,
  `sf_ws_id_fk` bigint(20) NOT NULL,
  `sf_rules` text NOT NULL,
  `sf_priority` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`subfolder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subfolder`
--

LOCK TABLES `tbl_subfolder` WRITE;
/*!40000 ALTER TABLE `tbl_subfolder` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subfolder` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subfolder_cachecontrol`
--

DROP TABLE IF EXISTS `tbl_subfolder_cachecontrol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subfolder_cachecontrol` (
  `sfccid` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfcc_sfid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`sfccid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subfolder_cachecontrol`
--

LOCK TABLES `tbl_subfolder_cachecontrol` WRITE;
/*!40000 ALTER TABLE `tbl_subfolder_cachecontrol` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subfolder_cachecontrol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_subfolder_hostheader`
--

DROP TABLE IF EXISTS `tbl_subfolder_hostheader`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_subfolder_hostheader` (
  `sfh_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sfh_sfd_fk` bigint(20) NOT NULL,
  `sfh_host` varchar(500) NOT NULL,
  PRIMARY KEY (`sfh_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_subfolder_hostheader`
--

LOCK TABLES `tbl_subfolder_hostheader` WRITE;
/*!40000 ALTER TABLE `tbl_subfolder_hostheader` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_subfolder_hostheader` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_sublinktohttps`
--

DROP TABLE IF EXISTS `tbl_sublinktohttps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_sublinktohttps` (
  `slhid` bigint(20) NOT NULL AUTO_INCREMENT,
  `sln_websiteid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`slhid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_sublinktohttps`
--

LOCK TABLES `tbl_sublinktohttps` WRITE;
/*!40000 ALTER TABLE `tbl_sublinktohttps` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_sublinktohttps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_support_plans`
--

DROP TABLE IF EXISTS `tbl_support_plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_support_plans` (
  `spid` bigint(20) NOT NULL AUTO_INCREMENT,
  `spname` varchar(5000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `spprice` bigint(20) NOT NULL,
  PRIMARY KEY (`spid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_support_plans`
--

LOCK TABLES `tbl_support_plans` WRITE;
/*!40000 ALTER TABLE `tbl_support_plans` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_support_plans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_support_plans_users`
--

DROP TABLE IF EXISTS `tbl_support_plans_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_support_plans_users` (
  `spuid` bigint(20) NOT NULL AUTO_INCREMENT,
  `spu_uidfk` bigint(20) NOT NULL,
  `spu_spid_fk` bigint(20) NOT NULL,
  `spu_expiredate` datetime NOT NULL,
  PRIMARY KEY (`spuid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_support_plans_users`
--

LOCK TABLES `tbl_support_plans_users` WRITE;
/*!40000 ALTER TABLE `tbl_support_plans_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_support_plans_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ticket_attachment`
--

DROP TABLE IF EXISTS `tbl_ticket_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ticket_attachment` (
  `taid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ta_atid_fk` bigint(20) NOT NULL,
  `ta_tid_fk` bigint(20) NOT NULL,
  `ta_type` int(11) NOT NULL COMMENT '1-OpenTicket\r\n2-Ticket Reply',
  PRIMARY KEY (`taid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ticket_attachment`
--

LOCK TABLES `tbl_ticket_attachment` WRITE;
/*!40000 ALTER TABLE `tbl_ticket_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ticket_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ticket_dept`
--

DROP TABLE IF EXISTS `tbl_ticket_dept`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ticket_dept` (
  `tdid` int(11) NOT NULL AUTO_INCREMENT,
  `td_name` mediumtext NOT NULL,
  `td_description` mediumtext NOT NULL,
  `td_status` int(11) NOT NULL COMMENT '0- disable\r\n1- active\r\n2- deleted',
  PRIMARY KEY (`tdid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ticket_dept`
--

LOCK TABLES `tbl_ticket_dept` WRITE;
/*!40000 ALTER TABLE `tbl_ticket_dept` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ticket_dept` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ticket_log`
--

DROP TABLE IF EXISTS `tbl_ticket_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ticket_log` (
  `tlid` bigint(20) NOT NULL AUTO_INCREMENT,
  `tl_date_time` varchar(30) NOT NULL,
  `tl_description` text NOT NULL,
  `tl_tid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`tlid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ticket_log`
--

LOCK TABLES `tbl_ticket_log` WRITE;
/*!40000 ALTER TABLE `tbl_ticket_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ticket_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_ticket_replies`
--

DROP TABLE IF EXISTS `tbl_ticket_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_ticket_replies` (
  `trid` bigint(20) NOT NULL AUTO_INCREMENT,
  `tr_description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `tr_type` int(11) NOT NULL COMMENT '1-Ticket reply\r\n2-Admin note',
  `tr_admin_id_fk` int(11) NOT NULL,
  `tr_datetime` varchar(30) NOT NULL,
  `tr_tid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`trid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_ticket_replies`
--

LOCK TABLES `tbl_ticket_replies` WRITE;
/*!40000 ALTER TABLE `tbl_ticket_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_ticket_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_tickets`
--

DROP TABLE IF EXISTS `tbl_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_tickets` (
  `tid` bigint(20) NOT NULL AUTO_INCREMENT,
  `t_title` mediumtext NOT NULL,
  `t_description` text NOT NULL,
  `t_user_id_fk` bigint(20) NOT NULL,
  `t_admin_id_fk` int(11) NOT NULL DEFAULT 0,
  `t_td_id_fk` int(11) NOT NULL,
  `t_opendate` varchar(30) NOT NULL,
  `t_status` int(11) NOT NULL COMMENT '1-open\r\n2-inprogress\r\n3-assigned\r\n4-closed\r\n5-answered\r\n6-customer-reply',
  `t_lastreply` varchar(30) NOT NULL,
  `t_user_seen` int(11) NOT NULL COMMENT '0-bold\r\n1-regular',
  `t_assignedtoadmin` bigint(20) NOT NULL DEFAULT 0,
  `t_services` varchar(500) NOT NULL,
  PRIMARY KEY (`tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_tickets`
--

LOCK TABLES `tbl_tickets` WRITE;
/*!40000 ALTER TABLE `tbl_tickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_transactions`
--

DROP TABLE IF EXISTS `tbl_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_transactions` (
  `tr_id` int(11) NOT NULL AUTO_INCREMENT,
  `tr_date` varchar(30) NOT NULL,
  `tr_amount` bigint(20) NOT NULL,
  `tr_uid_fk` int(11) NOT NULL,
  `tr_bgw_id_fk` int(11) NOT NULL,
  `tr_status` int(11) NOT NULL COMMENT '0-unpaid\r\n1-paid\r\n2-cancelled\r\n3-refunded',
  `tr_verifycode` varchar(500) DEFAULT NULL,
  `tr_verify_time` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`tr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_transactions`
--

LOCK TABLES `tbl_transactions` WRITE;
/*!40000 ALTER TABLE `tbl_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_underattack`
--

DROP TABLE IF EXISTS `tbl_underattack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_underattack` (
  `uaid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ua_wid_fk` bigint(20) NOT NULL,
  `ua_status` bigint(20) NOT NULL,
  `ua_ttl` int(11) NOT NULL,
  PRIMARY KEY (`uaid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_underattack`
--

LOCK TABLES `tbl_underattack` WRITE;
/*!40000 ALTER TABLE `tbl_underattack` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_underattack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_unsuspend_temp`
--

DROP TABLE IF EXISTS `tbl_unsuspend_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_unsuspend_temp` (
  `tut_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tut_uid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`tut_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_unsuspend_temp`
--

LOCK TABLES `tbl_unsuspend_temp` WRITE;
/*!40000 ALTER TABLE `tbl_unsuspend_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_unsuspend_temp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_user_announce`
--

DROP TABLE IF EXISTS `tbl_user_announce`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_user_announce` (
  `uaid` int(11) NOT NULL AUTO_INCREMENT,
  `ua_uid_fk` bigint(20) NOT NULL,
  `ua_state` varchar(500) NOT NULL,
  `ua_count` int(11) NOT NULL,
  `ua_date` datetime NOT NULL,
  PRIMARY KEY (`uaid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_user_announce`
--

LOCK TABLES `tbl_user_announce` WRITE;
/*!40000 ALTER TABLE `tbl_user_announce` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user_announce` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_user_log`
--

DROP TABLE IF EXISTS `tbl_user_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_user_log` (
  `ulid` bigint(20) NOT NULL AUTO_INCREMENT,
  `uldesc` varchar(5000) NOT NULL,
  `ulold` varchar(5000) NOT NULL,
  `ulnew` varchar(5000) NOT NULL,
  `uldatetime` datetime NOT NULL,
  `ulaction` varchar(10) NOT NULL,
  `ul_uid_fk` bigint(20) NOT NULL,
  `ul_ip` varchar(128) NOT NULL,
  PRIMARY KEY (`ulid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_user_log`
--

LOCK TABLES `tbl_user_log` WRITE;
/*!40000 ALTER TABLE `tbl_user_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_user_nameserver`
--

DROP TABLE IF EXISTS `tbl_user_nameserver`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_user_nameserver` (
  `unsid` bigint(20) NOT NULL AUTO_INCREMENT,
  `uns_user_id_fk` bigint(20) NOT NULL,
  `uns_ns_id_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`unsid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_user_nameserver`
--

LOCK TABLES `tbl_user_nameserver` WRITE;
/*!40000 ALTER TABLE `tbl_user_nameserver` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user_nameserver` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_user_needed_balance`
--

DROP TABLE IF EXISTS `tbl_user_needed_balance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_user_needed_balance` (
  `unb_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `unb_uid_fk` bigint(20) NOT NULL,
  `unb_datetime` datetime NOT NULL,
  `unb_services` varchar(50000) NOT NULL,
  `unb_price` bigint(20) NOT NULL,
  PRIMARY KEY (`unb_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_user_needed_balance`
--

LOCK TABLES `tbl_user_needed_balance` WRITE;
/*!40000 ALTER TABLE `tbl_user_needed_balance` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user_needed_balance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_user_organize`
--

DROP TABLE IF EXISTS `tbl_user_organize`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_user_organize` (
  `uoid` bigint(20) NOT NULL AUTO_INCREMENT,
  `uo_economic_number` varchar(500) NOT NULL,
  `uo_national_code` varchar(500) NOT NULL,
  `uo_company_name` mediumtext NOT NULL,
  `uo_register_number` varchar(5000) NOT NULL,
  `uo_postalcode` bigint(20) NOT NULL,
  `uo_address` mediumtext NOT NULL,
  `uo_uid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`uoid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_user_organize`
--

LOCK TABLES `tbl_user_organize` WRITE;
/*!40000 ALTER TABLE `tbl_user_organize` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user_organize` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_user_resetpassword`
--

DROP TABLE IF EXISTS `tbl_user_resetpassword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_user_resetpassword` (
  `urpid` bigint(20) NOT NULL AUTO_INCREMENT,
  `urphash` varchar(256) DEFAULT NULL,
  `urpsmscode` varchar(5) DEFAULT NULL,
  `urp_uid_fk` bigint(20) NOT NULL,
  `urp_expiredate` varchar(30) NOT NULL,
  PRIMARY KEY (`urpid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_user_resetpassword`
--

LOCK TABLES `tbl_user_resetpassword` WRITE;
/*!40000 ALTER TABLE `tbl_user_resetpassword` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user_resetpassword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_user_setting`
--

DROP TABLE IF EXISTS `tbl_user_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_user_setting` (
  `usid` bigint(20) NOT NULL AUTO_INCREMENT,
  `us_uid_fk` bigint(20) NOT NULL,
  `us_2fa` int(11) NOT NULL,
  `us_2fa_value` varchar(20) NOT NULL,
  `us_financial` int(11) NOT NULL,
  `us_financial_endofcredit` varchar(20) NOT NULL,
  `us_financial_invoice` varchar(20) NOT NULL,
  `us_servers` int(11) NOT NULL,
  `us_server_create` varchar(20) NOT NULL,
  `us_server_delete` varchar(20) NOT NULL,
  `us_server_deactive` varchar(20) NOT NULL,
  `us_onenter` int(11) NOT NULL,
  `us_onenter_successlogin` varchar(20) NOT NULL,
  `us_onenter_unsuccesslogin` varchar(20) NOT NULL,
  PRIMARY KEY (`usid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_user_setting`
--

LOCK TABLES `tbl_user_setting` WRITE;
/*!40000 ALTER TABLE `tbl_user_setting` DISABLE KEYS */;
INSERT INTO `tbl_user_setting` (`usid`, `us_uid_fk`, `us_2fa`, `us_2fa_value`, `us_financial`, `us_financial_endofcredit`, `us_financial_invoice`, `us_servers`, `us_server_create`, `us_server_delete`, `us_server_deactive`, `us_onenter`, `us_onenter_successlogin`, `us_onenter_unsuccesslogin`) VALUES (1,2,0,'',0,'sms','email',0,'sms','sms','email,sms',0,'email,sms','sms');
/*!40000 ALTER TABLE `tbl_user_setting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_users`
--

DROP TABLE IF EXISTS `tbl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_users` (
  `uid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uname` varchar(500) NOT NULL,
  `ufamily` varchar(700) NOT NULL,
  `umail` varchar(500) NOT NULL,
  `unationalid` varchar(10) NOT NULL,
  `uindividual` int(11) NOT NULL COMMENT '1- indivual            2- organize',
  `ustatus` int(11) NOT NULL COMMENT '0-user not verified 1- user verified 2- user disabled 3- user deleted 4- user email verified 5- user mobile verified 45- mobile not verified - email verified 54- mobile verified - email not verified',
  `umobile` varchar(12) NOT NULL,
  `usessionkey` varchar(1000) NOT NULL,
  `upass` varchar(500) NOT NULL,
  `ucredit` bigint(20) NOT NULL DEFAULT 500000,
  `ulastlogin` varchar(500) NOT NULL,
  `uregistrationdate` varchar(500) NOT NULL,
  `ulastloginip` varchar(20) NOT NULL,
  `uexp_session` varchar(20) DEFAULT NULL,
  `unote` text DEFAULT NULL,
  `uat_id_fk` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `usetting` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`uid`),
  UNIQUE KEY `unationalid` (`unationalid`),
  UNIQUE KEY `umobile` (`umobile`),
  UNIQUE KEY `umail` (`umail`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_users`
--

LOCK TABLES `tbl_users` WRITE;
/*!40000 ALTER TABLE `tbl_users` DISABLE KEYS */;
INSERT INTO `tbl_users` (`uid`, `uname`, `ufamily`, `umail`, `unationalid`, `uindividual`, `ustatus`, `umobile`, `usessionkey`, `upass`, `ucredit`, `ulastlogin`, `uregistrationdate`, `ulastloginip`, `uexp_session`, `unote`, `uat_id_fk`, `usetting`) VALUES (1,'masoudtest','test2','mail.centralhost@gmail.com','0018360459',1,1,'09905280839','qZpvmDCEfHvEYfB7X2E2k0kOO4p1wDB5YKgLA2IXe09e7Q5ixtTYkObPXlJIf09m','e807f1fcf82d132f9bb018ca6738a19f',500000,'1402-02-29 16:10:43','2023-05-19 16:07:26','2.2.2.2','1402/03/19 13:35:54',NULL,NULL,'{}'),
(2,'masoudtest11','test211','test11@gmail.com','0017330459',1,1,'09905880839','vZxGyVSfacOf23myyRkVhfa3PFp5zEPqtbyyqhkTbTCad7q2Wh4N1ieQEBEY9RD5','25f9e794323b453885f5181f1b624d0b',500000,'1402-03-18 01:02:22','2023-05-19 16:28:33','85.104.193.164','1402/03/20 00:23:09',NULL,NULL,'{}'),
(3,'test4','test4','test4@gmail.com','0017330432',1,0,'09905880810','gJAlTTN2zoyPeuED3OGOUEV6pMCLJpuYDs2YCfGioQC6xyqZv8ujIdBFrwPNYMf5','e807f1fcf82d132f9bb018ca6738a19f',500000,'1402-02-30 16:37:43','2023-05-19 18:43:52','2.2.2.2','1402/03/19 13:35:54',NULL,NULL,'{}'),
(4,'test5','test5','test5@gmail.com','0017330440',1,0,'09905880811','jWonxYjUs4H05fFwxCM3W5ZE0eUyBrqxXTmgEG3uitlfaPTQtXDoX8QjTYC3HEbm','4d5a6fffde37fd4c9d26cdd04ca64a0a',500000,'1402-02-29 18:49:53','2023-05-19 18:49:20','2.2.2.2','1402/03/19 13:35:54',NULL,NULL,'{}'),
(5,'testa','testa','testa@gmail.com','0147852315',1,0,'09131114457','Z4yKf6dHrgag7YLBXOrz9dWvlxJj6NIcJF0UGXtFaclZfs54xg4s7MbdMaW13rWF','c445fa82f7c36d10c14d7a8950550abd',500000,'2023-05-20 13:54:23','2023-05-20 13:54:23','85.104.193.72','1402/03/19 13:35:54',NULL,NULL,'{}'),
(6,'testb','testB','testb@gmail.com','1271908425',1,0,'09101452369','YEkAqALwV6xF4JVAJMQUxb1Upaslc9LcA2sHsJ1Llt7bkx0bxs2kyWmyf3YDMKdk','c445fa82f7c36d10c14d7a8950550abd',500000,'2023-05-20 14:21:29','2023-05-20 14:21:29','85.104.193.72','1402/03/19 13:35:54',NULL,NULL,'{}'),
(7,'test100','test100','test100@gmail.com','1111912378',1,0,'09139905060','eEgMY3ijAgpng4kwevgARcsRgvzKbhFUGkL4MsME6XLmZbblCL2gOYzqWaSji1Iz','f926b91963b91e3e46d68f694ac5f4d5',500000,'2023-05-20 15:30:38','2023-05-20 15:30:38','85.104.193.72','1402/03/19 13:35:54',NULL,NULL,'{}');
/*!40000 ALTER TABLE `tbl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_userverification`
--

DROP TABLE IF EXISTS `tbl_userverification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_userverification` (
  `uvid` int(11) NOT NULL AUTO_INCREMENT,
  `uvmobile_status` int(4) NOT NULL,
  `uvmobile_code` varchar(8) NOT NULL,
  `uvemail_status` int(4) NOT NULL,
  `uvemail_code` text NOT NULL,
  `uv_uid_fk` int(11) NOT NULL,
  `uv_mobile_date_verify` varchar(40) DEFAULT NULL,
  `uv_email_date_verify` varchar(40) DEFAULT NULL,
  `uv_expire_date_verify` varchar(30) NOT NULL,
  PRIMARY KEY (`uvid`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_userverification`
--

LOCK TABLES `tbl_userverification` WRITE;
/*!40000 ALTER TABLE `tbl_userverification` DISABLE KEYS */;
INSERT INTO `tbl_userverification` (`uvid`, `uvmobile_status`, `uvmobile_code`, `uvemail_status`, `uvemail_code`, `uv_uid_fk`, `uv_mobile_date_verify`, `uv_email_date_verify`, `uv_expire_date_verify`) VALUES (1,0,'7850',1,'4340',1,NULL,NULL,'1402/02/29 16:08:26'),
(2,0,'7938',1,'5761',2,NULL,NULL,'1402/02/29 16:29:33'),
(3,0,'5025',1,'9791',3,NULL,NULL,'1402/02/29 18:44:52'),
(4,0,'9908',1,'2514',4,NULL,NULL,'1402/02/29 18:50:20'),
(5,0,'7855',1,'1062',5,NULL,NULL,'1402/02/30 13:55:23'),
(6,0,'9516',1,'2341',6,NULL,NULL,'1402/02/30 14:22:29'),
(7,0,'8720',1,'2864',7,NULL,NULL,'1402/02/30 15:31:38');
/*!40000 ALTER TABLE `tbl_userverification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_vod_channels`
--

DROP TABLE IF EXISTS `tbl_vod_channels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_vod_channels` (
  `vc_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `vc_name` varchar(5000) NOT NULL,
  `vc_did_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`vc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_vod_channels`
--

LOCK TABLES `tbl_vod_channels` WRITE;
/*!40000 ALTER TABLE `tbl_vod_channels` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_vod_channels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_vod_domain`
--

DROP TABLE IF EXISTS `tbl_vod_domain`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_vod_domain` (
  `vdid` bigint(20) NOT NULL AUTO_INCREMENT,
  `vdname` varchar(5000) NOT NULL,
  `vd_uid_fk` bigint(20) NOT NULL,
  `vd_status` int(11) NOT NULL,
  PRIMARY KEY (`vdid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_vod_domain`
--

LOCK TABLES `tbl_vod_domain` WRITE;
/*!40000 ALTER TABLE `tbl_vod_domain` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_vod_domain` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_vod_folders`
--

DROP TABLE IF EXISTS `tbl_vod_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_vod_folders` (
  `vfid` bigint(20) NOT NULL AUTO_INCREMENT,
  `vf_parentid` bigint(20) NOT NULL,
  `vfname` varchar(5000) NOT NULL,
  `vf_cidfk` bigint(20) NOT NULL,
  `vf_creationdate` varchar(30) NOT NULL,
  `vf_updatedate` varchar(30) NOT NULL,
  PRIMARY KEY (`vfid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_vod_folders`
--

LOCK TABLES `tbl_vod_folders` WRITE;
/*!40000 ALTER TABLE `tbl_vod_folders` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_vod_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_vod_video`
--

DROP TABLE IF EXISTS `tbl_vod_video`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_vod_video` (
  `vvid` bigint(20) NOT NULL AUTO_INCREMENT,
  `vv_name` varchar(4000) NOT NULL,
  `vv_framerate` int(11) NOT NULL,
  `vv_resolution` varchar(500) NOT NULL,
  `vv_hls` varchar(5) NOT NULL,
  `vv_hls_rates` varchar(500) NOT NULL,
  `vv_dash` varchar(5) NOT NULL,
  `vv_dash_rate` varchar(500) NOT NULL,
  `vv_mp4` varchar(5) NOT NULL,
  `vv_mp4_rate` varchar(500) NOT NULL,
  `vv_watermark` varchar(30) NOT NULL,
  `vv_watermark_image` varchar(500) NOT NULL,
  `watermark_position` varchar(500) NOT NULL,
  `vv_url` varchar(600) NOT NULL,
  `vv_thtime` varchar(50) NOT NULL,
  `vv_subtitle` varchar(50) NOT NULL,
  `vv_subtitle_files` varchar(500) NOT NULL,
  `vv_referer` varchar(5000) NOT NULL,
  `vv_vfid_fk` bigint(20) NOT NULL,
  `vv_length` varchar(60) NOT NULL,
  `vv_status` int(11) NOT NULL,
  `vv_hls_bitrate` varchar(500) NOT NULL,
  `vv_dash_bitrate` varchar(500) NOT NULL,
  `vv_mp4_bitrate` varchar(500) NOT NULL,
  `vv_hls_audio_bitrate` varchar(500) NOT NULL,
  `vv_dash_audio_bitrate` varchar(500) NOT NULL,
  `vv_mp4_audio_bitrate` varchar(500) NOT NULL,
  PRIMARY KEY (`vvid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_vod_video`
--

LOCK TABLES `tbl_vod_video` WRITE;
/*!40000 ALTER TABLE `tbl_vod_video` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_vod_video` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_vod_watermark`
--

DROP TABLE IF EXISTS `tbl_vod_watermark`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_vod_watermark` (
  `vwid` int(11) NOT NULL AUTO_INCREMENT,
  `vw_filename` varchar(5000) NOT NULL,
  `vw_domainid` bigint(20) NOT NULL,
  `vw_title` varchar(5000) NOT NULL,
  `vw_description` varchar(5000) NOT NULL,
  PRIMARY KEY (`vwid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_vod_watermark`
--

LOCK TABLES `tbl_vod_watermark` WRITE;
/*!40000 ALTER TABLE `tbl_vod_watermark` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_vod_watermark` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_waf`
--

DROP TABLE IF EXISTS `tbl_waf`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_waf` (
  `wid` bigint(20) NOT NULL AUTO_INCREMENT,
  `w_ws_id_fk` bigint(20) NOT NULL,
  `w_level` int(11) NOT NULL,
  `w_disabled_rules_l1` text NOT NULL,
  `w_disabled_rules_l2` text NOT NULL,
  `w_disabled_urules_l1` text DEFAULT NULL,
  `w_disabled_urules_l2` text DEFAULT NULL,
  PRIMARY KEY (`wid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_waf`
--

LOCK TABLES `tbl_waf` WRITE;
/*!40000 ALTER TABLE `tbl_waf` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_waf` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_waf_customrules`
--

DROP TABLE IF EXISTS `tbl_waf_customrules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_waf_customrules` (
  `wcrid` bigint(20) NOT NULL AUTO_INCREMENT,
  `wcr_websiteid` bigint(20) NOT NULL,
  `wcr_rulename` varchar(50) NOT NULL,
  `wcr_rulekey` varchar(1200) NOT NULL,
  `wcr_rulevalue` varchar(1200) NOT NULL,
  `wcr_waf_level` int(11) NOT NULL,
  PRIMARY KEY (`wcrid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_waf_customrules`
--

LOCK TABLES `tbl_waf_customrules` WRITE;
/*!40000 ALTER TABLE `tbl_waf_customrules` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_waf_customrules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_waf_disabled_rules`
--

DROP TABLE IF EXISTS `tbl_waf_disabled_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_waf_disabled_rules` (
  `wdr_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `wdr_waf_level` int(11) NOT NULL,
  `wdr_ruleid` text NOT NULL,
  `wdr_server_ruleid` text NOT NULL,
  `wdr_websiteid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`wdr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_waf_disabled_rules`
--

LOCK TABLES `tbl_waf_disabled_rules` WRITE;
/*!40000 ALTER TABLE `tbl_waf_disabled_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_waf_disabled_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_waf_rules`
--

DROP TABLE IF EXISTS `tbl_waf_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_waf_rules` (
  `wr_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `wr_rule_id` bigint(20) NOT NULL,
  `wr_rule_description` mediumtext NOT NULL,
  `wr_waflevel` int(11) NOT NULL,
  `wr_urule_id` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`wr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_waf_rules`
--

LOCK TABLES `tbl_waf_rules` WRITE;
/*!40000 ALTER TABLE `tbl_waf_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_waf_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_website_alias`
--

DROP TABLE IF EXISTS `tbl_website_alias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_website_alias` (
  `wsaid` bigint(20) NOT NULL AUTO_INCREMENT,
  `wsa_dnrid_fk` bigint(20) NOT NULL,
  `wsa_wsid_fk` bigint(20) NOT NULL,
  PRIMARY KEY (`wsaid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_website_alias`
--

LOCK TABLES `tbl_website_alias` WRITE;
/*!40000 ALTER TABLE `tbl_website_alias` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_website_alias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_websites`
--

DROP TABLE IF EXISTS `tbl_websites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_websites` (
  `wsid` bigint(20) NOT NULL AUTO_INCREMENT,
  `ws_domainid_fk` bigint(20) NOT NULL,
  `ws_recordname` text NOT NULL,
  `ws_stauts` int(11) NOT NULL,
  `wsplan` varchar(100) DEFAULT 'free' COMMENT 'free - com - pro - org',
  `ws_activedate` datetime NOT NULL DEFAULT current_timestamp(),
  `ws_default_firewall` varchar(5) NOT NULL DEFAULT 'allow',
  `ws_www` varchar(6) NOT NULL DEFAULT 'off',
  PRIMARY KEY (`wsid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_websites`
--

LOCK TABLES `tbl_websites` WRITE;
/*!40000 ALTER TABLE `tbl_websites` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_websites` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_freespan`
--

DROP TABLE IF EXISTS `user_freespan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_freespan` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `product` enum('CDN','CLOUD','LIVE','VOD') NOT NULL,
  `type` enum('TRAFFIC','REQUEST','COUNT') NOT NULL,
  `limit` bigint(20) unsigned DEFAULT NULL,
  `usage` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_freespan_user_id_foreign` (`user_id`),
  CONSTRAINT `user_freespan_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`uid`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_freespan`
--

LOCK TABLES `user_freespan` WRITE;
/*!40000 ALTER TABLE `user_freespan` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_freespan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `websites`
--

DROP TABLE IF EXISTS `websites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `websites` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `domain_id` bigint(20) unsigned DEFAULT NULL,
  `recordname` varchar(255) NOT NULL,
  `status` enum('active','delete') NOT NULL,
  `firewall_default` enum('allow','block') NOT NULL,
  `www_status` enum('www','nonwww','off') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `websites_domain_id_foreign` (`domain_id`),
  CONSTRAINT `websites_domain_id_foreign` FOREIGN KEY (`domain_id`) REFERENCES `domains` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `websites`
--

LOCK TABLES `websites` WRITE;
/*!40000 ALTER TABLE `websites` DISABLE KEYS */;
/*!40000 ALTER TABLE `websites` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'panelkeloncloud_maindb'
--

--
-- Dumping routines for database 'panelkeloncloud_maindb'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-11-25  3:41:27
