<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class CLOUD_SERVER_ADMIN
{
	public static function GetListOfREscueImage()
	{
		$list = [
			"centos7" => ["id" => "b1fc5bb2-c765-423b-8cf0-2560e64f71b3", "user" => "centos"],
			"ubuntu18" => ["id" => "6394d747-4504-445d-a8bd-a1df34e3a50c", "user" => "ubuntu"]
		];
		return $list;
	}
	public static function GetRescue($token, $serverid, $os)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $serverid);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$maxcountofRebuild = 10;
		if (CLOUD_REQUEST_ADMIN::GetCountOfRequest($serverid, "get_rescue") > $maxcountofRebuild) {
			return ["status" => "error", "message" => "دفعات استفاده از تغییر سیستم عامل " . $maxcountofRebuild . " بار در ماه است"];
		}

		$getlistofOS = self::GetListOfREscueImage();
		if (!isset($getlistofOS[$os])) {
			return ["status" => "error", "message" => "سیستم عامل درخواستی شما اشتباه است"];
		}
		$serverid = $u["data"][0]["cs_serverid"];
		$sid = $u["data"][0]["csid"];
		$idc = $u["data"][0]["cs_idcid_fk"];
		$ip = $u["data"][0]["cs_ip"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		//check server has active rescue
		if (CLOUD_REQUEST_ADMIN::CheckServerCanGetNewRequest($sid, "get_rescue")["status"] == "duplicated") {
			return ["status" => "error", "message" => "شما یک درخواست Rescue باز برای این سرور دارید"];
		}
		$pass = self::GenerateHash(2, 8);

		$requestid = CLOUD_REQUEST_ADMIN::GetNewRequestID($sid, "get_rescue", $serverid)["id"];
		$resposneData = API_CLOUD_SERVER_ADMIN::GetRescue(
			$m,
			$idc,
			$serverid,
			$pass,
			$requestid,
			$getlistofOS[$os]["id"]
		);
		CLOUD_REQUEST_ADMIN::UpdateResponse($requestid, json_encode($resposneData["data"]));
		self::UpdateServerStatus($serverid, "pendingrescue", true);



		$mailTemplate = '
		%s عزیز،
		<br />
		سرور ابری Rescue درخواستی شما در میزبان کلود با جزئیات زیر ساخته شد:
		<br />
		سیستم عامل: %s
		<br />
		نام کاربری سیستم عامل: %s
		<br />
		رمز عبور پیش فرض سرور شما: %s
		<br />
		IP سرور شما : %s
		<br />
			';
		$nowDate = jDateTime::date("Y/m/d");
		$nowtime = jDateTime::date(" H:i:s");
		$OsUser = 	$getlistofOS[$os]["user"];
		$mailtitle = " درخواست Rescue سرور ابری جدید  در میزبان کلود";

		$mailTemplate = sprintf(
			$mailTemplate,
			$usersDetails["userdetail"][0]["uname"],
			$os,
			$OsUser,
			$pass,
			$ip
		);

		$o = EMAILCLASS::SendEmailPanel($mail, $mailtitle, $mailTemplate, "success");
		return [
			"status" => "success",
			"message" => "درخواست شما با موفقیت انجام شد",
			"password" => $pass
		];
	}
	public static function GetUnRescue($token, $serverid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $serverid);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($u["data"][0]["cs_status"] != "10") {
			return ["status" => "error", "message" => "Rescue برای شما فعال نیست"];
		}
		$serverid = $u["data"][0]["cs_serverid"];
		$sid = $u["data"][0]["csid"];
		$idc = $u["data"][0]["cs_idcid_fk"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		//check server has active rescue
		$getrequestinfo = CLOUD_REQUEST_ADMIN::CheckServerCanGetNewRequest($sid, "get_rescue");
		if ($getrequestinfo["status"] != "duplicated") {
			return [
				"status" => "error",
				"message" => "شما Rescue فعال ندارید"
			];
		}
		$requestid = $getrequestinfo["data"][0]["cr_request_id"];
		$data = $getrequestinfo["data"][0]["cr_response"];
		$oldid = $getrequestinfo["data"][0]["cr_tempid"];
		$resposneData = API_CLOUD_SERVER_ADMIN::GetUnRescue(
			$m,
			$idc,
			$serverid,
			$data,
			$requestid,
			$oldid
		);
		self::UpdateServerStatus($serverid, "pendingrescue", true);
		return [
			"status" => "success",
			"message" => "درخواست شما با موفقیت انجام شد",
		];
	}
	public static function ActivateRescue($requestid, $newid, $oldid, $newvolumeid)
	{
		$requestinfo = CLOUD_REQUEST_ADMIN::ChecKRequestDuplicated($requestid);
		$sid = $requestinfo["data"][0]["cr_sid_fk"];
		$idcid = $requestinfo["data"][0]["cs_idcid_fk"];
		$uid = $requestinfo["data"][0]["cs_uid_fk"];
		self::UpdateServerStatus($oldid, "rescued", true);
		self::UpdateServerStatus($newid, "rescued", true);
		self::UpdateServerDetailsFromAPI("cs_serverid", $newid, $sid);
		CLOUD_VOLUME_ADMIN::AddValumeRescue("rescue", "20", $uid, $idcid, $sid, $newvolumeid);
		return ["status" => "success"];
	}
	public static function DeActivateRescue($requestid, $newid, $oldid)
	{
		$requestinfo = CLOUD_REQUEST_ADMIN::ChecKRequestDuplicated($requestid);
		$sid = $requestinfo["data"][0]["cr_sid_fk"];
		self::UpdateServerDetailsFromAPI("cs_serverid", $newid, $sid);
		self::UpdateServerStatus($newid, "active", true);
		$uid = $requestinfo["data"][0]["cs_uid_fk"];
		CLOUD_VOLUME_ADMIN::RemoveValumeRescue($sid, $uid);
		CLOUD_REQUEST_ADMIN::CloseRequest($requestid);
		return ["status" => "success"];
	}
	public static function FinishOsReload($input)
	{
		$requestinfo = CLOUD_REQUEST_ADMIN::ChecKRequestDuplicated($input["request_id"]);
		$sid = $requestinfo["data"][0]["cr_sid_fk"];
		$newserverid = $input["server"];
		$volumeid = $input["volume"];

		// $Oldvolumeid = $input["Oldvolumeid"];
		CLOUD_VOLUME_ADMIN::UpdateServerIDAfterOSReinstall('', $volumeid, $sid);
		self::UpdateServerDetailsFromAPI("cs_serverid", $newserverid, $sid);
		CLOUD_LOGS_ADMIN::AddLog($sid, "Rebuild server");
		self::ChangeServerStatus($sid, 1);
		CLOUD_REQUEST_ADMIN::UpdateResponse($input["request_id"], json_encode($input));
		return ["status" => "success"];
	}
	public static function GetServerByID($id)
	{
		$sql = "SELECT *,     CASE
		WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
		WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
		WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
		WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
		WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
		WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
		WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
		WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
		WHEN " . $GLOBALS['cs_status'] . "=8 THEN  'build'
		WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'pending_rescue'
		WHEN " . $GLOBALS['cs_status'] . "=10 THEN  'rescued'
			END as server_Status 	 FROM tbl_cloud_server,tbl_users WHERE cs_uid_fk=uid AND csid=" . $id;
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetServerByIDBackend($id)
	{
		$sql = "SELECT *,     CASE
		WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
		WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
		WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
		WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
		WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
		WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
		WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
		WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
		WHEN " . $GLOBALS['cs_status'] . "=8 THEN  'build'
		WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'pending_rescue'
		WHEN " . $GLOBALS['cs_status'] . "=10 THEN  'rescued'
			END as server_Status 	 FROM tbl_cloud_server,tbl_users WHERE cs_uid_fk=uid AND cs_serverid='" . $id . "'";

		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return $listOfRecordType;
	}
	public static function ReturnListOfSuspendedServer($uid)
	{
		$sql = "SELECT * FROM `tbl_cloud_server`,tbl_users WHERE cs_uid_fk=uid AND `cs_status` = 3 AND cs_uid_fk =" . $uid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return $listOfRecordType;
	}
	public static function RunDisableServersByBalance($uid)
	{
		// 	0- pending 1- active 2- off 3- suspend 4- pause 5- deleted 6- build 7- shutdown
		$s = [];
		$i = 0;
		if (count($uid) == 0)
			return;
		foreach ($uid as $u) {
			// if($i==0){
			//     $s.=" cs_uid_fk =".$u["uid"];
			// }
			// else{
			//     $s.=" or  cs_uid_fk =".$u["uid"];
			//}
			array_push($s, $u["uid"]);
			$i++;
		}
		$m = implode(',', $s);

		//          select  * from tbl_cloud_server,tbl_users
		//  where cs_uid_fk = uid and
		//  cs_status IN  (7,1,2,4) AND

		//                               cs_uid_fk IN (7,16,14,11)

		$sql = "SELECT * FROM tbl_cloud_server,tbl_users WHERE cs_uid_fk = uid AND cs_status IN (7,1,2,4) AND cs_uid_fk IN (" . $m . ")";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
			return $result;
		} else {
			$listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
		}
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function CheckServerCreated($token, $serverid)
	{

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		$serverDetails = self::GetServerDetail($token, $serverid);
		self::GetServerState($token, $serverDetails["data"][0]["IDCID"], $serverid);
		$serverDetails = self::GetServerDetail($token, $serverid);

		return $serverDetails;
	}
	public static function checkNameDuplicated($uid, $name, $idc)
	{
		$sql = "SELECT * FROM tbl_cloud_server where " . $GLOBALS['cs_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cs_idcid_fk'] . "=" . $idc . " AND csname ='" . $name . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
			return $result;
		} else {
			$listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
		}
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function GenerateReport($token, $id, $base, $requesttime)
	{

		$validTime = [
			"5m" => "-5 minutes",
			"30m" => "-30 minutes",
			"1h" => "-1 hours",
			"3h" => "-3 hours",
			"6h" => "-6 hours",
			"12h" => "-12 hours",
			"24h" => "-24 hours",
			"1w" => "-7 days",
			"1m" => "-30 days"
		];
		if (!isset($validTime[$requesttime]))
			return ["status" => "error", "message" => "بازه زمانی ارسالی نامعتبر است"];

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$getminute = date('i');
		// if (intVal($getminute) < 15)
		//     $getminute = "00";
		// else if (intVal($getminute) >= 15 && intVal($getminute) < 30)
		//     $getminute = "15";

		// else if (intVal($getminute) >= 30 && intVal($getminute) < 45)
		//     $getminute = "30";

		// else
		//     $getminute = "45";

		$end = date('Y-m-d H:i:s');
		$start = date('Y-m-d H:i:s', strtotime($validTime[$requesttime]));
		$expiretime = date('Y-m-d H:i:s', strtotime("+5 minutes"));
		$ip = $u["data"][0]["cs_ip"];
		$folderpath = $GLOBALS["RootFiles"] . "/cloud/reports/";
		$output = "";
		if ($requesttime != "5m") {
			if (!file_exists($folderpath . $ip)) {
				mkdir($folderpath . $ip, 0777);
				//folder created
				if (!file_exists($folderpath . $ip . "/" . $base)) {
					mkdir($folderpath . $ip . "/" . $base, 0777);
				} else {
					//folder already exist
					if (!file_exists($folderpath . $ip . "/" . $base . "/" . $requesttime . ".txt")) {
						file_put_contents($folderpath . $ip . "/" . $base . "/" . $requesttime . ".txt", "");
					} else {
						//file already exist
						$output = file_get_contents($folderpath . $ip . "/" . $base . "/" . $requesttime . ".txt");
					}
				}
			} else {
				//folder already exist
				if (!file_exists($folderpath . $ip . "/" . $base)) {
					mkdir($folderpath . $ip . "/" . $base, 0777);
				} else {
					//folder already exist
					if (!file_exists($folderpath . $ip . "/" . $base . "/" . $requesttime . ".txt")) {
						file_put_contents($folderpath . $ip . "/" . $base . "/" . $requesttime . ".txt", "");
					} else {
						//folder already exist
						$output = file_get_contents($folderpath . $ip . "/" . $base . "/" . $requesttime . ".txt");
					}
				}
			}
			$outArr = json_decode($output, true);
			if (isset($outArr["expiredate"]) && $outArr["expiredate"] > $end) {
				$out = $outArr["data"];
				$out["expirecache"] = $outArr["expiredate"];
				return $out;
			}
		}


		$params = [
			"5m" => ["period" => "5m", "step_size" => "5s"],
			"30m" => ["period" => "5m", "step_size" => "5s"],
			"1h" => ["period" => "5m", "step_size" => "5s"],
			"3h" => ["period" => "15m", "step_size" => "60s"],
			"6h" => ["period" => "15m", "step_size" => "60s"],
			"12h" => ["period" => "15m", "step_size" => "60s"],
			"24h" => ["period" => "30m", "step_size" => "120s"],
			"1w" => ["period" => "30m", "step_size" => "360s"],
			"1m" => ["period" => "60m", "step_size" => "500s"],
		];


		$s = API_CLOUD_SERVER_ADMIN::GetCloudServerReportUsage(

			$u["data"][0]["cs_serverid"],
			$m,
			$u["data"][0]["cs_idcid_fk"],
			$start,
			$end,
			$base,
			$params[$requesttime]["period"],
			$params[$requesttime]["step_size"]
		);
		if (isset($s["data"]["result"][0]["values"])) {
			$vls = [];
			foreach ($s["data"]["result"][0]["values"] as $v) {
				$vls[] = [gmdate("Y-m-d H:i:s", $v[0]), $v[1]];
			}
			$s = [
				"status" => "success",
				"message" => "درخواست شما با موفقیت انجام شد",
				"from" => "cache",
				"ip" => $ip,
				"send" => ["min" => $getminute, "end" => $end, "start" => $start],
				"data" => $vls //$s["data"]["result"][0]["values"]
			];
			$s1 = [
				"status" => "success",
				"message" => "درخواست شما با موفقیت انجام شد",
				"from" => "online",
				"ip" => $ip,
				"send" => ["min" => $getminute, "end" => $end, "start" => $start],
				"data" => $vls //$s["data"]["result"][0]["values"]
			];
			$sa = ["expiredate" => $expiretime, "data" => $s];

			if ($requesttime != "5m")
				file_put_contents($folderpath . $ip . "/" . $base . "/" . $requesttime . ".txt", json_encode($sa));
			return $s1;
		} else
			return ["status" => "error", "message" => "اطلاعاتی در دسترس نیست", "send" => ["min" => $getminute, "end" => $end, "start" => $start]];
	}
	public static function GetAllIDCandCountOfServer($token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		$sql = "select ciid,ci_name,ci_faname,(
            select count(csid) as CountOfserver from tbl_cloud_server where cs_uid_fk =" . $uid . " AND cs_status=1 and cs_idcid_fk=ciid
            ) as ServerCount  from tbl_cloud_idc
            where ci_status=1";

		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return [
			"status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
			"data" => $listOfRecordType
		];
	}
	public static function GetListOfActiveServer($uid = "0")
	{
		$where = "";
		if ($uid != "0") {
			$where = " AND cs_uid_fk=" . $uid;
		}
		$sql = "SELECT  	cs_uid_fk  as uid," . $GLOBALS['csid'] . " as ServerID," . $GLOBALS['csname'] . " as ServerName,
        " . $GLOBALS['cs_ip'] . " as ServerIP, IF(" .
			$GLOBALS['cs_additionalip'] . " =0, 'NoAdditionalIP', 'AdditionalIP') as AdditionalIP ,
                    CASE
                    WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
                    WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
                    WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'shutdown'
                    WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
                    WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
                    WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
                    WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
                    WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
                    WHEN " . $GLOBALS['cs_status'] . "=8 THEN  'pending_rescue'
                    WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'rescued'

            END as server_Status ," .
			$GLOBALS['cs_startdate'] . " as ServerStartDate," . $GLOBALS['cs_lastupdate'] . " as ServerLastUpdate,
        " . $GLOBALS['cs_ram'] . " as ServerRam," . $GLOBALS['cs_vcpu'] . " as ServerVCPU," .
			$GLOBALS['cs_hard'] . " as ServerHard
        from " . $GLOBALS["cloud_server_tablename"] . "

        where cs_test=0 and " . $GLOBALS['cs_status'] . " IN (1,2,4,7,9,10) and cs_ip!='0'  " . $where;

		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();


		$pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("CloudServer");
		$i = 0;
		$ssdprice = 0;
		$nvmeprice = 0;
		$sasprice = 0;
		$ramprice = 0;
		$cpuprice = 0;
		foreach ($pricelist["data"] as $ls) {
			switch ($ls["dp_category"]) {
				case "ssd":
					$ssdprice = intVal($ls["dp_price"]);
					break;
				case "nvme":
					$nvmeprice = intVal($ls["dp_price"]);
					break;
				case "sas":
					$sasprice = intVal($ls["dp_price"]);
					break;
				case "cpu":
					$cpuprice = intVal($ls["dp_price"]);
					break;
				case "ram":
					$ramprice = intVal($ls["dp_price"]);
					break;
			}
		}

		for ($i = 0; $i < count($listOfRecordType); $i++) {
			if ($listOfRecordType[$i]["AdditionalIP"] == "AdditionalIP") {
				$listOfRecordType[$i]["AdditionalIP"] = CLOUD_ADDITIONALIP_ADMIN::GetList($listOfRecordType[$i]["ServerID"]);
			}
		}
		for ($i = 0; $i < count($listOfRecordType); $i++) {
			$listOfRecordType[$i]["ramprice"] = 0;
			$listOfRecordType[$i]["cpuprice"] = 0;
			if ($listOfRecordType[$i]["server_Status"] != "shutdown") {
				$listOfRecordType[$i]["ramprice"] = $listOfRecordType[$i]["ServerVCPU"] * $cpuprice;
				$listOfRecordType[$i]["cpuprice"] = $listOfRecordType[$i]["ServerRam"] * $ramprice;
			}
			$listOfRecordType[$i]["Volumes"] = CLOUD_VOLUME_ADMIN::GetOneByServerID($listOfRecordType[$i]["ServerID"], 0);
		}

		$volumes = CLOUD_VOLUME_ADMIN::GetAllUnattachedVolume();
		$snapshots = CLOUD_VOLUME_ADMIN::GetAllSnapshot();
		return [
			"status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
			"data" => $listOfRecordType,
			"volume" => $volumes,
			"snapshots" => $snapshots

		];
	}
	public static function GetminimalServerForUser($uid, $mainpage = false)
	{
		$sql = "SELECT CONCAT(csname , cs_ip ) as servername,cs_ip as ip,csname as name,csid as id,cs_status as status FROM `tbl_cloud_server` WHERE cs_uid_fk=" . $uid;
		if ($mainpage)
			$sql = "SELECT csid,csname , cs_ip ,CASE
                        WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
                        WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
                        WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
                        WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
                        WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
                        WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
                        WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
                        WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
						WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'pending_rescue'
						WHEN " . $GLOBALS['cs_status'] . "=10 THEN  'rescued'
                END as server_Status FROM `tbl_cloud_server` WHERE cs_uid_fk=" . $uid;

		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return ["status" => "success", "data" => $listOfRecordType];
	}
	public static function GetminimalServerForUserWithToken($token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$sql = "SELECT CONCAT(csname , cs_ip ) as servername,cs_ip as ip,csname as name,csid as id,cs_status as status FROM `tbl_cloud_server` WHERE cs_uid_fk=" . $uid;
		$sql = "SELECT  CONCAT(csname , cs_ip ) as servername, CASE
                        WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
                        WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
                        WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
                        WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
                        WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
                        WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
                        WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
                        WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
						WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'pending_rescue'
						WHEN " . $GLOBALS['cs_status'] . "=10 THEN  'rescued'
                END as server_Status,cs_ip as ip,csname as name,csid as id,cs_status as status FROM `tbl_cloud_server` WHERE cs_uid_fk=" . $uid;

		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return ["status" => "success", "data" => $listOfRecordType];
	}
	public static function GetServerForUser($uid, $mainpage = false)
	{
		$sql = "SELECT *, CONCAT(csname , cs_ip ) as servername FROM `tbl_cloud_server` WHERE cs_uid_fk=" . $uid;
		if ($mainpage)
			$sql = "SELECT csid,csname , cs_ip ,CASE
                        WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
                        WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
                        WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
                        WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
                        WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
                        WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
                        WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
                        WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
						WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'pending_rescue'
						WHEN " . $GLOBALS['cs_status'] . "=10 THEN  'rescued'
                END as server_Status FROM `tbl_cloud_server` WHERE cs_uid_fk=" . $uid;

		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetServerState($token, $idc)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$servers = [];
		$output = [];
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		if (strpos($idc, ",") !== FALSE) {
			$idcs = explode(",", $idc);
			foreach ($idcs as $i) {
				$q = CLOUD_IDC_ADMIN::GetOneByID($i);
				if ($q["status"] == "error") {
					return ["status" => "error", "message" => "دیتاسنتر ارسالی اشتباه است"];
				}
				$servers[] = $q;
			}
		} else {
			$servers[] = CLOUD_IDC_ADMIN::GetOneByID($idc);
		}


		foreach ($servers as $s) {
			$idcid = $s["data"][0]["ciid"];
			$serversINIDC = API_CLOUD_SERVER_ADMIN::GetAllServerDetailFromAPI($m, $idcid);
			$p = [];
			if (is_array($serversINIDC) && count($serversINIDC) > 0) {
				foreach ($serversINIDC as $l) {
					if (isset($l["status"]) && $l["status"] != "error") {
						$state =  self::GetServerByIDBackend($l["id"]);
						if (isset($state[0]["server_Status"])) {
							if ($state != "pending_rescue" && $state != "rescued") {
								$p[] = self::UpdateServerStatus($l["id"], $l["status"]);
							}
						}
					}
				}
			}
			$output[$s["data"][0]["ci_name"]] = $p;
		}
		return self::GetList($token, $idc);
		// }
		// else {
		//     $serversINIDC = API_CLOUD_SERVER_ADMIN::GetServerDetailFromAPI($m, $idc, $serverid);
		//     $p = [];
		//     foreach ($serversINIDC as $l) {
		//         if (isset($l["status"]) && $l["status"] != "error") {
		//             $p[] = self::UpdateServerStatus($l["id"], $l["status"]);
		//         }
		//     }
		// }
	}
	public static function UpdateServerStatus($sid, $status, $force = false)
	{
		$serverstatus = [
			"active" => "1", "shutoff" => "2", "paused" => "4", "suspended" => "3", "error" => "0",
			"build" => "6", "pendingrescue" => "9", "rescued" => "10"
		];
		$where = "";
		$sstatus = $serverstatus[strtolower($status)];
		if (!$force) {
			$stat = self::GetServerByIDBackend($sid);
			if ($stat[0]["server_Status"] == 'pending_rescue' || $stat[0]["server_Status"] == 'rescued') {
				if ($status != "rescued" || $status != "pending_rescue")
					return "faild";
			}
		}
		if ($force) {
			// $where =" and cs_status NOT IN (9,10)";
		}
		$sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] .
			" SET  	cs_status =" . $sstatus . " where
			 cs_serverid='" . $sid . "' " . $where;
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
	}
	public static function GetList($token, $idc)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$sql = "SELECT " . $GLOBALS['csid'] . " as ServerID," . $GLOBALS['csname'] . " as ServerName,cs_test as istest,
        " . $GLOBALS['cs_ip'] . " as ServerIP, IF(" . $GLOBALS['cs_additionalip'] . " =0, 'NoAdditionalIP', 'AdditionalIP') as AdditionalIP ,
                    CASE
                    WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
                    WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
                    WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
                    WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
                    WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
                    WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
                    WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
                    WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
                    WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'pending_rescue'
                    WHEN " . $GLOBALS['cs_status'] . "=10 THEN  'rescued'
            END as server_Status ,
            CASE
                    WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'معلق'
                    WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'فعال'
                    WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'خاموش'
                    WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'مسدود'
                    WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'توقف'
                    WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'حذف شده'
                    WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'در حال ساخت'
                    WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'خاموش'
                    WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'در حال ساخت Rescue'
                    WHEN " . $GLOBALS['cs_status'] . "=10 THEN  'Rescue'
            END as server_StatusFa ,ci_name,CASE
                    WHEN " . $GLOBALS['cs_osname'] . "='36' THEN  'Fedora'
                    WHEN " . $GLOBALS['cs_osname'] . "='15.4' THEN  'OpenSuse'
                    WHEN " . $GLOBALS['cs_osname'] . "='V16.04' THEN  'Ubuntu'
                    WHEN " . $GLOBALS['cs_osname'] . "='V18.04' THEN  'Ubuntu'
                    WHEN " . $GLOBALS['cs_osname'] . "='V20.04' THEN  'Ubuntu'
                    WHEN " . $GLOBALS['cs_osname'] . "='V22.04' THEN  'Ubuntu'
                    WHEN " . $GLOBALS['cs_osname'] . "='2012' THEN  'Windows'
                    WHEN " . $GLOBALS['cs_osname'] . "='2016' THEN  'Windows'
                    WHEN " . $GLOBALS['cs_osname'] . "='2019' THEN  'Windows'
                    WHEN " . $GLOBALS['cs_osname'] . "='2022' THEN  'Windows'
                    WHEN " . $GLOBALS['cs_osname'] . "='V7.9' THEN  'Centos'
                    WHEN " . $GLOBALS['cs_osname'] . "='V8' THEN  'Centos'
                    WHEN " . $GLOBALS['cs_osname'] . "='8.6' THEN  'RockyLinux'
                    WHEN " . $GLOBALS['cs_osname'] . "='9' THEN  'Debian'
                    WHEN " . $GLOBALS['cs_osname'] . "='10' THEN  'Debian'
                    WHEN " . $GLOBALS['cs_osname'] . "='11' THEN  'Debian'
                    WHEN " . $GLOBALS['cs_osname'] . "='Arch' THEN  'Arch'
            END as   os,

            " .
			$GLOBALS['cs_startdate'] . " as ServerStartDate," . $GLOBALS['cs_lastupdate'] . " as ServerLastUpdate,
        " . $GLOBALS['cs_ram'] . " as ServerRam," . $GLOBALS['cs_vcpu'] . " as ServerVCPU," . $GLOBALS['cs_hard'] . " as ServerHard ,cs_idcid_fk
        from " . $GLOBALS["cloud_server_tablename"] . " ,tbl_cloud_idc
        where cs_idcid_fk = ciid and " . $GLOBALS['cs_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cs_idcid_fk'] . " IN (" . $idc . ") order by  	csid desc";
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();

		for ($i = 0; $i < count($listOfRecordType); $i++) {
			if ($listOfRecordType[$i]["AdditionalIP"] == "AdditionalIP") {
				$listOfRecordType[$i]["AdditionalIP"] = CLOUD_ADDITIONALIP_ADMIN::GetList($listOfRecordType[$i]["ServerID"]);
			}
		}
		return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
	}
	public static function UserCanAccessToServer($uid, $sid)
	{

		$sql = "SELECT *,
        CASE
                    WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
                    WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
                    WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
                    WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
                    WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
                    WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
                    WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
                    WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
                    WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'pending_rescue'
                    WHEN " . $GLOBALS['cs_status'] . "=10 THEN 'rescued'
            END as server_Status

         FROM " . $GLOBALS["cloud_server_tablename"]
			. " WHERE " . $GLOBALS['cs_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['csid'] . "=" . $sid;


		$conn = GetConnection();
		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
			return $result;
		} else {
			$listOfRecordType = [
				"status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
				"data" => mysqli_fetch_all($result, MYSQLI_ASSOC)
			];
		}
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function HardReboot($token, $id)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		API_CLOUD_SERVER_ADMIN::RunHardReboot($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
		CLOUD_LOGS_ADMIN::AddLog($id, "Hard reboot");
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function SoftReboot($token, $id)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		API_CLOUD_SERVER_ADMIN::RunSoftReboot($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
		CLOUD_LOGS_ADMIN::AddLog($id, "Soft reboot");
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function ChangePassword($token, $id, $password)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}

		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		// $r = TOOLS_ADMIN::checkPassword($password);
		// if ($r != "success") {
		//     return ["status" => "error", "message" => $r];
		// };
		$m = API_CLOUD_SERVER_ADMIN::RunChangePassword($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"], $password);
		if ($m["status"] == "error") {
			return $m;
		}
		CLOUD_LOGS_ADMIN::AddLog($id, "ChangePassword");
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function RebuildServer($token, $serverid, $os)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $serverid);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$maxcountofRebuild = 10;
		if (CLOUD_REQUEST_ADMIN::GetCountOfRequest($serverid, "Osreload") > $maxcountofRebuild) {
			return ["status" => "error", "message" => "دفعات استفاده از تغییر سیستم عامل " . $maxcountofRebuild . " بار در ماه است"];
		}
		// if ($u["data"][0]["cs_status"] != "1" || $u["data"][0]["cs_status"] != "1"  || $u["data"][0]["cs_status"] != "1" ) {
		//     return ["status" => "error", "message" => "سرور شما در وضعیت فعال نیست و وامکان تغییر ندارد"];
		// }
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$osimage = CLOUD_FLAVOR_ADMIN::ReturnOSID($os);
		if ($osimage["status"] == "error") {
			return ["status" => "error", $osimage, "message" => "سیستم عامل درخواستی شما اشتباه است"];
		}
		if ($u["data"][0]["cs_test"] == "1") {
			if (self::GetCountOfRebuildServer($serverid) > 3) {
				return ["status" => "error", "message" => "حداکثر تعداد نصب مجدد سیستم عامل 3 دفعه می باشد"];
			}
		} else {
			if (self::GetCountOfRebuildServer($serverid) > 10) {
				return ["status" => "error", "message" => "حداکثر تعداد نصب مجدد سیستم عامل 10 دفعه می باشد"];
			}
		}
		if ($u["data"][0]["cs_status"] == "8" ||  $u["data"][0]["cs_status"] == "9") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		$pass = self::GenerateHash();

		$oss = CLOUD_FLAVOR_ADMIN::ReturnAllOS()["oss"][$os];

		$password = "#ps1\nnet user Administrator " . $pass;
		if ($oss == "Windows")
			$password = "#ps1\nnet user Administrator " . $pass;
		else if (strtoupper($oss) == "ubuntu")
			$password = "#cloud-config\napt:\n  preserve_sources_list: false\n  primary:\n    - arches:\n      - amd64\n      uri: \"http://ir.archive.ubuntu.com/ubuntu/\"\n  security:\n    - arches:\n      - amd64\n      uri: \"http://security.ubuntu.com/ubuntu\"\npassword: " . $pass . "\nchpasswd: { expire: False }\nssh_pwauth: True";
		else
			$password = "#cloud-config\npassword: " . $pass . "\nchpasswd: { expire: False }\nssh_pwauth: True";


		$vlsta = CLOUD_VOLUME_ADMIN::GetOneByServerID($serverid, 0);
		// return [$vlsta,$u ,$vlsta["data"][0]["cv_type"]];
		$requestid = CLOUD_REQUEST_ADMIN::GetNewRequestID($u["data"][0]["csid"], "Osreload", $serverid)["id"];

		$Oldvolumeid = API_CLOUD_SERVER_ADMIN::GetServerDetailFromAPI(
			$m,
			$u["data"][0]["cs_idcid_fk"],
			$u["data"][0]["cs_serverid"]
		)["volumes"][0]["volume_id"];
		$r = API_CLOUD_SERVER_ADMIN::RunRebuildOS(
			$m,
			$u["data"][0]["cs_serverid"],
			$osimage["os"],
			$u["data"][0]["cs_idcid_fk"],
			$vlsta["data"][0]["cv_type"],
			$password,
			$requestid,
			$Oldvolumeid
		);
		$mn = json_decode($r, true);
		// if (isset($mn["status"]) && $mn["status"] == "error") {
		// 	return ["status" => "error", "message" => "خطا در بازسازی سیستم عامل"];
		// }
		$sql = "update tbl_cloud_server set   `cs_additional` = JSON_SET(cs_additional, '$.email.password', '" . $pass . "'),
		`cs_additional` = JSON_SET(cs_additional, '$.data.passowrd', '" . $password . "') ,
		`cs_additional` = JSON_SET(cs_additional, '$.email.oss', '" . $oss . "') ,
		`cs_additional` = JSON_SET(cs_additional, '$.password', '" . $pass . "')
		where  `csid` = " . $serverid;
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		// $newserverid = $mn["server"];
		// $volumeid = $mn["volume"];
		self::UpdateServerDetailsFromAPI("cs_osid", $osimage["os"], $serverid);
		// CLOUD_VOLUME_ADMIN::UpdateServerIDAfterOSReinstall($Oldvolumeid, $volumeid, $serverid);
		// self::UpdateServerDetailsFromAPI("cs_serverid", $newserverid, $serverid);
		self::UpdateServerDetailsFromAPI("cs_osname", $osimage["osname"], $serverid);
		// CLOUD_LOGS_ADMIN::AddLog($serverid, "Rebuild server");
		self::ChangeServerStatus($serverid, 6);

		$sql = "SELECT uname,tbl_cloud_idc.*," . $GLOBALS['csid'] . " as ServerID," . $GLOBALS['cs_osname'] . " as OSName," . $GLOBALS['csname'] . " as ServerName,
        " . $GLOBALS['cs_ip'] . " as ServerIP, IF(" . $GLOBALS['cs_additionalip'] . " =0, 'NoAdditionalIP', 'AdditionalIP') as AdditionalIP ,cs_firewall as Firewall,
                    CASE
                WHEN " . $GLOBALS['cs_status'] . "=0 THEN 'pending'
                WHEN " . $GLOBALS['cs_status'] . "=1 THEN 'active'
                WHEN " . $GLOBALS['cs_status'] . "=2 THEN 'off'
                WHEN " . $GLOBALS['cs_status'] . "=3 THEN 'suspended'
                WHEN " . $GLOBALS['cs_status'] . "=4 THEN 'pause'
                WHEN " . $GLOBALS['cs_status'] . "=5 THEN 'deleted'
                WHEN " . $GLOBALS['cs_status'] . "=6 THEN 'build'
                WHEN " . $GLOBALS['cs_status'] . "=7 THEN 'shutdown'
                WHEN " . $GLOBALS['cs_status'] . "=8 THEN 'build'
				WHEN " . $GLOBALS['cs_status'] . "=9 THEN 'pending_rescue'
				WHEN " . $GLOBALS['cs_status'] . "=10 THEN 'rescued'
            END as server_Status ,cs_status," .
			$GLOBALS['cs_startdate'] . " as ServerStartDate ,ci_name as IDCName,ci_faname as IDCFaName,
            cs_status,cs_additional ," . $GLOBALS["cs_idcid_fk"] . " as IDCID," . $GLOBALS["cs_serverid"] . " as BackID," . $GLOBALS['cs_lastupdate'] . " as ServerLastUpdate,
        " . $GLOBALS['cs_ram'] . " as ServerRam," . $GLOBALS['cs_vcpu'] . " as ServerVCPU," . $GLOBALS['cs_hard'] . " as ServerHard
        from " . $GLOBALS["cloud_server_tablename"] . " ,tbl_cloud_idc,tbl_users
        where uid=cs_uid_fk and " . $GLOBALS['cs_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['csid']  . "=" . $serverid . " AND ciid=cs_idcid_fk";
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$l = $listOfRecordType[0]["cs_additional"];
		$crdet = json_decode(preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $l), true);


		$mailTemplate = '
        %s عزیز،
        <br />
        سرور ابری درخواستی شما در میزبان کلود با جزئیات زیر بازسازی شد:
        <br />
        دیتاسنتر: %s
        <br />
        سیستم عامل: %s
        <br />
        <br />
        نام کاربری سیستم عامل شما : %s
        <br />
        رمز عبور پیش فرض سرور شما: %s
        <br />
        IP سرور شما : %s
        <br />
            ';
		$ip = $listOfRecordType[0]["ServerIP"];

		$nowDate = jDateTime::date("Y/m/d");
		$nowtime = jDateTime::date(" H:i:s");
		$OsUser = strtolower($crdet["email"]["oss"]);
		if (strtolower($crdet["email"]["oss"]) == "windows") {
			$OsUser = "administrator";
		}
		$mailTemplate = sprintf(
			$mailTemplate,
			$listOfRecordType[0]["uname"],
			$listOfRecordType[0]["ci_faname"],
			$crdet["email"]["oss"],
			$OsUser,
			$pass,
			$ip
		);
		EMAILCLASS::SendEmailPanel($mail, "بازسازی سرور در میزبان کلود", $mailTemplate, "success");

		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function RestoreSnapShot($token, $serverid, $snapshotid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $serverid);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($u["data"][0]["cs_status"] != "1") {
			return ["status" => "error", "message" => "سرور شما در وضعیت فعال نیست و وامکان تغییر ندارد"];
		}
		$n = CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid, $snapshotid);
		if ($u["data"][0]["cs_status"] == "9" ||  $u["data"][0]["cs_status"] == "10") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		API_CLOUD_SERVER_ADMIN::RunRestoreSnapshot(
			$m,
			$u["data"][0]["cs_serverid"],
			$n["data"][0]["cv_serverid"],
			$u["data"][0]["cs_idcid_fk"]
		);
		self::ChangeServerStatus($serverid, 6);
		self::UpdateServerDetailsFromAPI("cs_osid", $n["data"][0]["cv_osid"], $serverid);
		self::UpdateServerDetailsFromAPI("cs_osname", $n["data"][0]["cv_osname"], $serverid);
		CLOUD_LOGS_ADMIN::AddLog($serverid, "Restore snapshot");
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function GetVNC($token, $id)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		$i = API_CLOUD_SERVER_ADMIN::RunGetVNCConsole($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
		CLOUD_LOGS_ADMIN::AddLog($id, "GetVNC");
		$i = str_replace("http://31.25.90.40:65290", "https://vnc.mizbancloud.com", $i);
		// $l=https:/vnc.mizbancloud.com:65290
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "console" => $i];
	}
	public static function ChangeServerStatus($id, $status)
	{
		$sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] . " SET  " . $GLOBALS['cs_status']
			. "='" . $status . "' WHERE " . $GLOBALS['csid'] . "=" . $id;
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		if ($status == "1")
			self::SetLastUpdateServer($id);

		if ($status == "3")
			self::SetLastUpdateServer($id);
	}
	public static function UnsuspendedServer($uid)
	{
		$allServers = self::ReturnListOfSuspendedServer($uid);
		if (count($allServers) > 0) {
			foreach ($allServers as $l) {

				$idc = $l["cs_idcid_fk"];
				$mail = $l["umail"];
				$ip = $l["cs_ip"];
				$serverid = $l["csid"];
				$mailTemplate = '
                کاربر گرامی، %s <br/>
					سرور ابری شما با IP : %s  در میزبان کلود، در تاریخ %s ساعت %s  فعال شد.
					<br/>
					<br/>';
				$uname = $l["uname"] . "." . $l["ufamily"];
				$nowDate = jDateTime::date("Y/m/d");
				$nowtime = jDateTime::date(" H:i:s");
				$mailTemplate = sprintf($mailTemplate, $uname, $ip, $nowDate, $nowtime);
				$params = [
					"param1" => $uname,
					"param4" => $ip
				];
				$o = EMAILCLASS::SendEmailPanel($mail, " فعال شدن سرور ابری    " . $ip . " در میزبان کلود", $mailTemplate, "error");

				$m = str_replace("@", "", $mail);
				$m = str_replace(".", "", $m);

				API_CLOUD_SERVER_ADMIN::RunUnPauseServer($serverid, $m, $idc);

				self::ChangeServerStatus($serverid, 1);
				self::SetLastUpdateServer($serverid);
				CLOUD_LOGS_ADMIN::AddLog($serverid, "SusPend server");
				//  LOGS_ADMIN::AddLog("انسداد سرور " .$ip , self::GetServerByID($id)[0]["cs_uid_fk"], 0, "", "users");
			}
		}
	}
	public static function SuspendServerinternal($id, $mail, $serverid, $idcid, $uname, $ip)
	{
		$serverDet = self::GetServerByID($serverid);
		$idc = $serverDet[0]["cs_idcid_fk"];
		$mailTemplate = '
            کاربر گرامی، %s <br/>
            سرور ابری شما با نام %s به علت منفی شدن اعتبار کیف پولتان در میزبان کلود، در تاریخ %s ساعت %s غیرفعال شد.
            <br/>
            جهت فعالسازی مجدد این سرویس، نسبت به افزایش اعتبار کیف پول خود در میزبان کلود اقدام کرده و سپس سرور مورد نظر را مجدداً فعال کنید.
            <br/>
            ';
		$uname = $serverDet[0]["uname"] . "." . $serverDet[0]["ufamily"];
		$nowDate = jDateTime::date("Y/m/d");
		$nowtime = jDateTime::date(" H:i:s");
		$mailTemplate = sprintf($mailTemplate, $uname, $ip, $nowDate, $nowtime);
		$params = [
			"param1" => $uname,
			"param4" => $ip
		];
		$usetting = USERSETTING_ADMIN::GetOneByID($serverDet[0]["uid"]);
		if ($usetting["data"]["us_servers"] == "true") {
			if ($usetting["data"]["deactive_server"] == "email,sms") {
				EMAILCLASS::SendEmailPanel($mail, "غیر فعال شدن سرور ابری    " . $ip . " در میزبان کلود", $mailTemplate, "error", "bgs50v7l4v", $params, $serverDet[0]["umobile"]);
			} else if ($usetting["data"]["deactive_server"] == "sms,email") {
				EMAILCLASS::SendEmailPanel($mail, "غیر فعال شدن سرور ابری    " . $ip . " در میزبان کلود", $mailTemplate, "error", "bgs50v7l4v", $params, $serverDet[0]["umobile"]);
			} else if ($usetting["data"]["deactive_server"] == "sms") {
				EMAILCLASS::SendEmailPanel("", "غیر فعال شدن سرور ابری    " . $ip . " در میزبان کلود", $mailTemplate, "error", "bgs50v7l4v", $params, $serverDet[0]["umobile"]);
			} else if ($usetting["data"]["deactive_server"] == "email") {
				EMAILCLASS::SendEmailPanel($mail, "غیر فعال شدن سرور ابری    " . $ip . " در میزبان کلود", $mailTemplate, "error");
			}
		}

		//$o= EMAILCLASS::SendEmailPanel($mail,"غیر فعال شدن سرور ابری    ".$ip." در میزبان کلود",$mailTemplate,"error","bgs50v7l4v",$params,$serverDet[0]["umobile"]);

		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$outpai = API_CLOUD_SERVER_ADMIN::RunPauseServer($serverDet[0]["cs_serverid"], $m, $idc);
		self::ChangeServerStatus($serverid, 3);
		self::SetLastUpdateServer($serverid);
		CLOUD_LOGS_ADMIN::AddLog($serverid, "SusPend server");
		//  LOGS_ADMIN::AddLog("انسداد سرور " .$ip , self::GetServerByID($id)[0]["cs_uid_fk"], 0, "", "users");

		// return $mailTemplate;
		return ["status" => "success", $mailTemplate, "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function PauseServer($token, $id)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($u["data"][0]["cs_status"] != "1") {
			return ["status" => "error", "message" => "سرور شما در حالت فعال نیست"];
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		API_CLOUD_SERVER_ADMIN::RunPauseServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
		self::ChangeServerStatus($id, 4);
		CLOUD_LOGS_ADMIN::AddLog($id, "Pause server");
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function UnPauseServer($token, $id)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($u["data"][0]["cs_status"] != "4") {
			return ["status" => "error", "message" => "سرور شما در حالت توقف نیست"];
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		API_CLOUD_SERVER_ADMIN::RunUnPauseServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
		self::ChangeServerStatus($id, 1);
		CLOUD_LOGS_ADMIN::AddLog($id, "UnPause Server");
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function ChangeServerHostname($token, $id, $hostname)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);

		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($u["data"][0]["cs_status"] != "1") {
			return ["status" => "error", "message" => "وضعیت سرور شما  در حالت فعال نیست و شما امکان تغییر هاست نیم را ندارید"];
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		if (!preg_match("/^[a-zA-z0-9.]*$/", $hostname)) {
			return ["status" => "error", "message" => "هاست نیم ارسالی شما نامعتبر است"];
		}

		$sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] . " SET  " . $GLOBALS['csname']
			. "='" . $hostname . "' WHERE " . $GLOBALS['csid'] . "=" . $id;

		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		API_CLOUD_SERVER_ADMIN::RunChangeHostname($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"], $hostname);
		CLOUD_LOGS_ADMIN::AddLog($id, "Change server Hostname");
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function SetLastUpdateServer($id)
	{
		$now = jDateTime::date("Y/m/d H:i:s");

		$sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] . " SET  " . $GLOBALS['cs_lastupdate']
			. "='" . $now . "' WHERE " . $GLOBALS['csid'] . "=" . $id;

		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
	}
	public static function DeleteServer($token, $id, $uid = 0, $mail = "", $uname = "", $mobile = "0")
	{
		if ($token != "12") {
			$usersDetails = USERS_ADMIN::GetOneByToken($token);
			if ($usersDetails["status"] == "error") {
				return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
			}
			$uid = $usersDetails["userdetail"][0]["uid"];
			$mail = $usersDetails["userdetail"][0]["umail"];
			$uname =  $usersDetails["userdetail"][0]["uname"] . "." . $usersDetails["userdetail"][0]["ufamily"];
			$mobile = $usersDetails["userdetail"][0]["umobile"];
		}
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);

		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		// if ($u["data"][0]["cs_status"] == "5") {
		// 	return ["status" => "error", "message" => "این سرور قبلا حذف شده است"];
		// }


		//check mounted volume
		$countVolumeMounted = CLOUD_VOLUME_ADMIN::GetVolumeMountedToserver($id);
		if ($countVolumeMounted > 1) {
			return [
				"status" => "error",
				$countVolumeMounted,
				"message" => "ابتدا هارد های اضافه شده به سرور را لغو اتصال نمایید سپس اقدام به حذف سرور نمایید",
				"state" => "storage"
			];
		}





		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		self::ChangeServerStatus($id, "5");
		self::SetLastUpdateServer($id);
		CLOUD_LOGS_ADMIN::AddLog($id, "Delete server");
		$sd = self::GetServerByID($id)[0];

		$nowDate = jDateTime::date("Y/m/d");
		$nowtime = jDateTime::date(" H:i:s");

		$mailTemplate = "%s عزیز
            <br />
            سرور مجازی شما با ip : %s در میزبان کلود حذف شد ";
		$mailTemplate = sprintf($mailTemplate, $uname, $sd["cs_ip"]);
		$params = [
			"param1" => $uname,
			"param4" => $sd["cs_ip"]
		];

		$usetting = USERSETTING_ADMIN::GetOneByID($uid);
		if ($usetting["data"]["servers"] == "true") {
			if ($usetting["data"]["delete_server"] == "email,sms") {
				$o = EMAILCLASS::SendEmailPanel(
					$mail,
					"حذف سرور مجازی در میزبان کلود",
					$mailTemplate,
					"success",
					"dnc1ul27hub96bw",
					$params,
					$mobile
				);
			} else if ($usetting["data"]["delete_server"] == "sms,email") {
				$o = EMAILCLASS::SendEmailPanel(
					$mail,
					"حذف سرور مجازی در میزبان کلود",
					$mailTemplate,
					"success",
					"dnc1ul27hub96bw",
					$params,
					$mobile
				);
			} else if ($usetting["data"]["delete_server"] == "sms") {
				$o = EMAILCLASS::SendEmailPanel(
					"",
					"حذف سرور مجازی در میزبان کلود",
					$mailTemplate,
					"success",
					"dnc1ul27hub96bw",
					$params,
					$mobile
				);
			} else if ($usetting["data"]["delete_server"] == "email") {
				$o = EMAILCLASS::SendEmailPanel(
					$mail,
					"حذف سرور مجازی در میزبان کلود",
					$mailTemplate,
					"success"
				);
			}
		}
		API_CLOUD_SERVER_ADMIN::RunDeleteServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
		USER_NEEDED_BALANCE_ADMIN::AddUserDetails($uid);
		if ($sd["cs_test"] == "1")
			CLOUD_FINANCIAL_LOGS_ADMIN::UpdateFromDB($uid, "delete server");
		CLOUD_VOLUME_ADMIN::DeleteVolumeByServer($id);
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function InternalDeleteServer($token, $id, $uid = 0, $mail = "", $uname = "", $mobile = "0")
	{

		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$countVolumeMounted = CLOUD_VOLUME_ADMIN::InternalGetVolumeMountedToserver($id);
		if ($countVolumeMounted[0]["cnt"] > 0) {
			foreach ($countVolumeMounted as $c) {
				// API_CLOUD_VOLUME_ADMIN::RunRemoveVolume($c["cv_serverid"],$m ,$c["cv_idcid_fk"]);
				CLOUD_VOLUME_ADMIN::RemoveVolume("12", $c["cvid"], $uid);
			}
		}
		self::ChangeServerStatus($id, "5");
		self::SetLastUpdateServer($id);
		CLOUD_LOGS_ADMIN::AddLog($id, "Delete server");
		$sd = self::GetServerByID($id)[0];
		$nowDate = jDateTime::date("Y/m/d");
		$nowtime = jDateTime::date(" H:i:s");
		$mailTemplate = "%s عزیز
            <br />
            سرور مجازی شما با ip : %s در میزبان کلود حذف شد ";
		$mailTemplate = sprintf($mailTemplate, $uname, $sd["cs_ip"]);
		$params = [
			"param1" => $uname,
			"param4" => $sd["cs_ip"]
		];
		$usetting = USERSETTING_ADMIN::GetOneByID($uid);
		if ($usetting["data"]["servers"] == "true") {
			if ($usetting["data"]["delete_server"] == "email,sms") {
				$o = EMAILCLASS::SendEmailPanel(
					$mail,
					"حذف سرور مجازی در میزبان کلود",
					$mailTemplate,
					"success",
					"dnc1ul27hub96bw",
					$params,
					$mobile
				);
			} else if ($usetting["data"]["delete_server"] == "sms,email") {
				$o = EMAILCLASS::SendEmailPanel(
					$mail,
					"حذف سرور مجازی در میزبان کلود",
					$mailTemplate,
					"success",
					"dnc1ul27hub96bw",
					$params,
					$mobile
				);
			} else if ($usetting["data"]["delete_server"] == "sms") {
				$o = EMAILCLASS::SendEmailPanel(
					"",
					"حذف سرور مجازی در میزبان کلود",
					$mailTemplate,
					"success",
					"dnc1ul27hub96bw",
					$params,
					$mobile
				);
			} else if ($usetting["data"]["delete_server"] == "email") {
				$o = EMAILCLASS::SendEmailPanel(
					$mail,
					"حذف سرور مجازی در میزبان کلود",
					$mailTemplate,
					"success"
				);
			}
		}
		API_CLOUD_SERVER_ADMIN::RunDeleteServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
		USER_NEEDED_BALANCE_ADMIN::AddUserDetails($uid);
		if ($sd["cs_test"] == "1")
			CLOUD_FINANCIAL_LOGS_ADMIN::UpdateFromDB($uid, "delete server");
		CLOUD_VOLUME_ADMIN::DeleteVolumeByServer($id);
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function GetOneByID($token, $vid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		$sql = "SELECT " . $GLOBALS['cvid'] . " as VolumeID," . $GLOBALS['cs_osname'] . " as OSName," . $GLOBALS['cv_name'] . " as VolumeName,
        " . $GLOBALS['cv_space'] . " as VolumeSpace, IF(" . $GLOBALS['cv_status'] . " =1, 'inuse', 'notinuse') as VolumeStatus ,
                IF(" . $GLOBALS['cv_bootable'] . " =1,'bootable', 'notbootable') as BootableVolume ," .
			$GLOBALS['cv_creation_date'] . " as VolumeCreationDate," . $GLOBALS['cv_update_date'] . " as VolumeUpdatedDate,
        csname as ServerHostName from " . $GLOBALS["cloud_volume_tablename"] . "
        LEFT JOIN tbl_cloud_server ON cv_csid_fk=csid
        where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cvid'] . "=" . $vid;

		$conn = GetConnection();
		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
			return $result;
		} else {
			$listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
		}
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function RemoveKey($token, $id)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$sshkeys = self::GetOneByID($token, $id);
		if ($sshkeys["status"] != "success") {
			return ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		// $sql = "DELETE FROM " . $GLOBALS["cloud_sshkey_tablename"] . " WHERE sk_serverid='" . $sshkeys["data"][0]["hashkey"]."'";
		// $conn = GetConnection();
		// $conn->query($sql);
		$id = API_CLOUD_SSHKEY_ADMIN::RunRemoveSSHKEY($sshkeys["data"][0]["hashkey"], $m, $sshkeys["data"][0]["idc"]);
		//  $conn->close();
		CLOUD_LOGS_ADMIN::AddLog($id, "Remove Key from server");
		return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد", $id];
	}
	public static function ShutDownServer($token, $id)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($u["data"][0]["cs_status"] != "1") {
			return ["status" => "error", "message" => "سرور شما در حالت روشن نیست"];
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		API_CLOUD_SERVER_ADMIN::RunShutDownServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
		self::ChangeServerStatus($id, 7);
		CLOUD_LOGS_ADMIN::AddLog($id, "Shutdown server");
		CLOUD_FINANCIAL_LOGS_ADMIN::UpdateFromDB($uid, "shutodwn server");

		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function StartServer($token, $id)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($u["data"][0]["cs_status"] != "7" && $u["data"][0]["cs_status"] != 2) {
			return ["status" => "error", "message" => "سرور شما در حالت خاموش نیست"];
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		API_CLOUD_SERVER_ADMIN::RunStartServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"]);
		self::ChangeServerStatus($id, 1);
		CLOUD_LOGS_ADMIN::AddLog($id, "Start server");
		CLOUD_FINANCIAL_LOGS_ADMIN::UpdateFromDB($uid, "start server");

		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function GetMainVolume($token, $sid, $idc)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $sid);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$serverid = $u["data"][0]["cs_serverid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$volumelist = CLOUD_VOLUME_ADMIN::GetAllVolume($m, $idc);
		$vl = json_decode($volumelist, true);
		$state = [];
		foreach ($vl as $l) {
			if (isset($l["attachments"][0]["server_id"]) && $l["attachments"][0]["server_id"] == $serverid) {
				if ($l["attachments"][0]["device"] == "/dev/vda") {
					$state[$l["name"]] = "attachedto > " . $l["attachments"][0]["device"];
					return  CLOUD_VOLUME_ADMIN::GetMainVolumeForServer($l["attachments"][0]["id"], $idc);
					return  [
						"status" => "success",
						"id" => $l["attachments"][0]["id"]
					];
				}
			}
		}
		return ["status" => "error"];
	}
	public static function ResizeServer($token, $id, $cpu, $ram)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $id);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($u["data"][0]["cs_test"] == "1") {
			return ["status" => "error", "message" => "سرور تست امکان افزایش منابع را ندارد"];
		}
		if ($u["data"][0]["cs_status"] != "1") {
			return ["status" => "error", "message" => "سرور شما در حالت روشن نیست"];
		}
		if (filter_var($ram, FILTER_VALIDATE_INT) === false) {
			return ["status" => "error", "message" => "میزان رم ارسالی نامعتبر است"];
		}
		if (filter_var($cpu, FILTER_VALIDATE_INT) === false) {
			return ["status" => "error", "message" => "میزان CPU ارسالی نامعتبر است"];
		}
		if ($u["data"][0]["cs_status"] == "9" ||  $u["data"][0]["cs_status"] == "10") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		$hard = $u["data"][0]["cs_hard"];
		$credit = $usersDetails["credit"];
		$vls = CLOUD_VOLUME_ADMIN::GetOneByServerID($id, 0);
		if (!isset($vls["data"][0]["cv_type"])) {
			return ["status" => "error", "message" => "خطا در دریافت اطلاعات نوع هارد"];
		}
		$minimumCredit = self::CheckMiniCredit($ram, $cpu, $hard, $vls["data"][0]["cv_type"], $credit);
		if ($minimumCredit["status"] == "error") {
			return $minimumCredit;
		}
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] . " SET  " . $GLOBALS['cs_ram']
			. "='" . $ram . "'," . $GLOBALS['cs_vcpu'] . "='" . $cpu . "' WHERE " . $GLOBALS['csid'] . "=" . $id;
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		$flavordid = CLOUD_FLAVOR_ADMIN::ReturnFLAVORID($ram, $cpu);
		API_CLOUD_SERVER_ADMIN::RunResizeServer($u["data"][0]["cs_serverid"], $m, $u["data"][0]["cs_idcid_fk"], $flavordid["package"]);
		self::ChangeServerStatus($id, 1);
		CLOUD_LOGS_ADMIN::AddLog($id, "resize server");
		USER_NEEDED_BALANCE_ADMIN::AddUserDetails($uid);
		if ($u["data"][0]["cs_test"] == "1")
			CLOUD_FINANCIAL_LOGS_ADMIN::UpdateFromDB($uid, "resize server");
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function ResizeServerVolume($serverid, $volume)
	{
		$sql = "UPDATE tbl_cloud_server set cs_hard='" . $volume . "' where cs_serverid='" . $serverid . "'";
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		return $sql;
	}
	public static function AttachInternalInterface($token, $serverid, $privatenetworkid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", $usersDetails, "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $serverid);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($u["data"][0]["cs_status"] == "9" ||  $u["data"][0]["cs_status"] == "10") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}

		$n = CLOUD_PRIVATENETWORKS_ADMIN::UserCanAccessToPrivateNetwork($uid, $privatenetworkid);
		if ($n["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این شبکه را ندارید"];
		}
		$ip = API_CLOUD_SERVER_ADMIN::RunAttachInternalNetwork(
			$m,
			$u["data"][0]["cs_idcid_fk"],
			$u["data"][0]["cs_serverid"],
			$n["data"][0]["cv_serverid"]
		);

		$rip = json_decode($ip, true);
		if (isset($rip["status"]) && $rip["status"] == "error") {
			return ["status" => "error", "message" => $rip["exceptions"]];
		}

		$rip = json_decode($ip, true)[0]["ip_address"];
		$returnedid = CLOUD_ADDITIONALIP_ADMIN::AddIP($serverid, json_decode($ip, true)[0]["ip_address"], 0)["id"];
		$a = API_CLOUD_SERVER_ADMIN::GetInterfaceList(
			$m,
			$u["data"][0]["cs_idcid_fk"],
			$u["data"][0]["cs_serverid"]
		);
		$x = json_decode($a, true);
		$list = $x["interfaces"];
		$r = CLOUD_ADDITIONALIP_ADMIN::UpdateFromAPI($returnedid, $rip, $list);
		self::UpdateServerDetailsFromAPI("cs_additionalip", 1, $serverid);
		CLOUD_NETWORKSERVER_ADMIN::AddNetWorkToServer($serverid, 0, $privatenetworkid);
		CLOUD_LOGS_ADMIN::AddLog($serverid, "Attach Internal Network");
		return ["status" => "success", "id" => $returnedid, "ip" => $rip, "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function AttachPublicInterface($token, $serverid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$u = CLOUD_SERVER_ADMIN::UserCanAccessToServer($uid, $serverid);
		if ($u["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($u["data"][0]["cs_status"] == "9" ||  $u["data"][0]["cs_status"] == "10") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		$ip = API_CLOUD_SERVER_ADMIN::RunAttachPublicNetworkNetwork(
			$m,
			$u["data"][0]["cs_idcid_fk"],
			$u["data"][0]["cs_serverid"]
		);

		$rip = json_decode($ip, true)[0]["ip_address"];
		$returnedid = CLOUD_ADDITIONALIP_ADMIN::AddIP($serverid, json_decode($ip, true)[0]["ip_address"], 1)["id"];
		$a = API_CLOUD_SERVER_ADMIN::GetInterfaceList(
			$m,
			$u["data"][0]["cs_idcid_fk"],
			$u["data"][0]["cs_serverid"]
		);
		$x = json_decode($a, true);
		$list = $x["interfaces"];
		$r = CLOUD_ADDITIONALIP_ADMIN::UpdateFromAPI($returnedid, $rip, $list);
		self::UpdateServerDetailsFromAPI("cs_additionalip", 1, $serverid);
		CLOUD_NETWORKSERVER_ADMIN::AddNetWorkToServer($serverid, 1, 0);
		CLOUD_LOGS_ADMIN::AddLog($serverid, "Attach public interface");
		USER_NEEDED_BALANCE_ADMIN::AddUserDetails($uid);
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function DetachInternalInterface($token, $ipid, $serverid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$c = self::UserCanAccessToServer($uid, $serverid);
		if ($c["data"][0]["cs_status"] == "10" ||  $c["data"][0]["cs_status"] == "9") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		if ($c["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$b = CLOUD_ADDITIONALIP_ADMIN::DeleteAdditionalIP($ipid, $serverid);
		if ($b["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این IP را ندارید"];
		}
		if (!isset($b["data"]["data"][0]["ca_serverid"])) {
			return ["status" => "error", "message" => "خطا در مقادیر ورودی"];
		}
		$s = API_CLOUD_SERVER_ADMIN::RunDetachInternalNetwork(
			$m,
			$c["data"][0]["cs_idcid_fk"],
			$c["data"][0]["cs_serverid"],
			$b["data"]["data"][0]["ca_serverid"]
		);
		$f = json_decode($s, true);
		if (isset($f["result"]) && $f["result"] == "success") {
			if (CLOUD_ADDITIONALIP_ADMIN::ReturnCountOfAdditionalIps($serverid) == "0") {
				self::UpdateServerDetailsFromAPI("cs_additionalip", 0,  $serverid);
			}
			CLOUD_NETWORKSERVER_ADMIN::DeleteNetWorkFromServer($serverid, 0, $ipid);
			CLOUD_LOGS_ADMIN::AddLog($serverid, "Detach internal network");
			return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
		}
		return ["status" => "error", "data" => $f, "message" => "خطا در انجام درخواست"];
	}
	public static function DetachPublicInterface($token, $ipid, $serverid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$c = self::UserCanAccessToServer($uid, $serverid);

		if ($c["data"][0]["cs_status"] == "10" ||  $c["data"][0]["cs_status"] == "9") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		if ($c["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$b = CLOUD_ADDITIONALIP_ADMIN::DeleteAdditionalIP($ipid, $serverid);
		if ($b["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این IP را ندارید"];
		}
		API_CLOUD_SERVER_ADMIN::RunDetachPublicNetwork(
			$m,
			$c["data"][0]["cs_idcid_fk"],
			$c["data"][0]["cs_serverid"],
			$b["data"]["data"][0]["ca_serverid"]
		);

		if (CLOUD_ADDITIONALIP_ADMIN::ReturnCountOfAdditionalIps($serverid) == "0") {
			self::UpdateServerDetailsFromAPI("cs_additionalip", 0,  $serverid);
		}

		CLOUD_NETWORKSERVER_ADMIN::DeleteNetWorkFromServer($serverid, 0, $ipid);
		CLOUD_LOGS_ADMIN::AddLog($serverid, "Detach public network");

		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function UpdateServerDetailsFromAPI($field, $value, $id)
	{
		$sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] . " SET " . $GLOBALS[$field] . "='" . $value . "'
                where " . $GLOBALS['csid'] . "=" . $id;
		$conn = GetConnection();
		mysqli_query($conn, $sql);
		$conn->close();
	}
	public static function GetInternalServerDetails($token, $id, $i = "false")
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$umail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		$sql = "SELECT uname,tbl_cloud_idc.*," . $GLOBALS['csid'] . " as ServerID," . $GLOBALS['cs_osname'] . " as OSName," . $GLOBALS['csname'] . " as ServerName,
        " . $GLOBALS['cs_ip'] . " as ServerIP, IF(" . $GLOBALS['cs_additionalip'] . " =0, 'NoAdditionalIP', 'AdditionalIP') as AdditionalIP ,cs_firewall as Firewall,
                    CASE
                WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
                WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
                WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
                WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
                WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
                WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
                WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
                WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
                WHEN " . $GLOBALS['cs_status'] . "=8 THEN  'build'
				WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'pending_rescue'
				WHEN " . $GLOBALS['cs_status'] . "=10 THEN  'rescued'
            END as server_Status ,cs_status," .
			$GLOBALS['cs_startdate'] . " as ServerStartDate ,ci_name as IDCName,ci_faname as IDCFaName,
            cs_status,cs_additional ," . $GLOBALS["cs_idcid_fk"] . " as IDCID," . $GLOBALS["cs_serverid"] . " as BackID," . $GLOBALS['cs_lastupdate'] . " as ServerLastUpdate,
        " . $GLOBALS['cs_ram'] . " as ServerRam," . $GLOBALS['cs_vcpu'] . " as ServerVCPU," . $GLOBALS['cs_hard'] . " as ServerHard
        from " . $GLOBALS["cloud_server_tablename"] . " ,tbl_cloud_idc,tbl_users

        where uid=cs_uid_fk and " . $GLOBALS['cs_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['csid']  . "=" . $id . " AND ciid=cs_idcid_fk";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
			return $result;
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			if ($i == "false" && ($listOfRecordType[0]["server_Status"] == "pending_rescue" || $listOfRecordType[0]["server_Status"] == "rescued")) {
				return self::GetInternalServerDetails($token, $id, "true");
			}
			$listOfRecordType[0]["os"] = CLOUD_FLAVOR_ADMIN::ReturnAllOS()["oss"][$listOfRecordType[0]["OSName"]];
			$n = [];
			if ($i == "false") {
				$n = API_CLOUD_SERVER_ADMIN::GetServerDetailFromAPI(
					$m,
					$listOfRecordType[0]["IDCID"],
					$listOfRecordType[0]["BackID"]
				);
			}
			$status = "";
			$m = str_replace("@", "", $mail);
			$m = str_replace(".", "", $m);
			if ($listOfRecordType[0]["cs_status"] == "5") {
				return ["status" => "error", "message" => "سرور مورد حذف شده است"];
			}
			if ($listOfRecordType[0]["BackID"] == "") {
				return ["status" => "error", "message" => "خطا در ایجاد سرور"];
			}
			if ($listOfRecordType[0]["server_Status"] == "deleted") {
			} else if ($listOfRecordType[0]["server_Status"] == "build") {


				$l = $listOfRecordType[0]["cs_additional"];
				$crdet = json_decode(preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $l), true);
				$vlid = $crdet["vlid"];
				$m = str_replace("@", "", $mail);
				$m = str_replace(".", "", $m);
				$idcid = $listOfRecordType[0]["IDCID"];
				$vlstatus = API_CLOUD_VOLUME_ADMIN::RunGetVolumeDetails($vlid, $m, $idcid);
				$vls = json_decode($vlstatus, true);
				$vl = 0;
				if ($vls["status"] != "available" && $vls["status"] != "in-use") {
					return ["status" => "pending", "vlstatus" => $vls, "vl" => $vlid, "data" => $listOfRecordType, "message" => "سرور در حال ایجاد است"];
				}
				$vl = 0;
				$scr = [
					"name" => $crdet["data"]["name"],
					"osimage" => $crdet["data"]["osimage"],
					"m" => $crdet["data"]["m"],
					"idc" => $crdet["data"]["idc"],
					"idcinfo" => $crdet["data"]["idcinfo"],
					"flavorid" => $crdet["data"]["flavorid"],
					"sshkeyid" => $crdet["data"]["sshkey"],
					"networks" => $crdet["data"]["network"],
					"defaultsecuritygroup" => $crdet["data"]["securitygroup"],
					"vid" => $crdet["data"]["vid"],
					"password" => $crdet["data"]["passowrd"],
					"ip" => $crdet["data"]["ip"],
					$crdet
				];
				if ($listOfRecordType[0]["cs_status"] == "8") {


					$outapi =  API_CLOUD_SERVER_ADMIN::RunCreateServer(
						$scr["name"],
						$scr["osimage"],
						$scr["m"],
						$scr["idc"],
						$scr["flavorid"],
						$scr["sshkeyid"],
						$scr["networks"],
						$scr["defaultsecuritygroup"],
						$scr["vid"],
						$scr["idcinfo"],
						$scr["password"],
						$scr["ip"]
					);
					self::UpdateServerDetailsFromAPI("cs_serverid", $outapi["id"], $id);
					self::ChangeServerStatus($id, "6");
					if ($scr["sshkeyid"] == 0) {
						$sshkey = "0";
					}

					$GLOBALS['cs_networkid'] = "cs_networkid";
					$GLOBALS['cs_sshkey'] = "cs_sshkey";
					$GLOBALS['cs_firewall'] = "cs_firewall";
					$GLOBALS['cs_osid'] = "cs_osid";
					$GLOBALS['cs_osname'] = "cs_osname";

					if (array_key_exists("status", $outapi)) {
						if ($outapi["status"] == "error") {
							API_CLOUD_VOLUME_ADMIN::RunRemoveVolume($scr["vid"], $mail, $scr["idc"]);
							return ["status" => "error", "message" => "خطا در انجام درخواست"];
						}
					}

					CLOUD_LOGS_ADMIN::AddLog($id, "Create server");
				}


				$status = $n["status"];
				if ($status == "ACTIVE") {
					// CLOUD_VOLUME_ADMIN::UpdateServerID($crdet["lastVolumeID"], $listOfRecordType[0]["BackID"]);
					self::UpdateServerDetailsFromAPI("cs_status", 1, $id);



					$ip = $n["ips"]["public-1"][0]["addr"];
					self::UpdateServerDetailsFromAPI("cs_ip", $ip, $id);
					$mailTemplate = '
                    %s عزیز،
                    <br />
                    سرور ابری  درخواستی شما در میزبان کلود با جزئیات زیر ساخته شد:
                    <br />
                    دیتاسنتر: %s
                    <br />
                    سیستم عامل: %s
                    <br />
                    <br />
                    نام کاربری سیستم عامل شما : %s
                    <br />
                    رمز عبور پیش فرض سرور شما: %s
                    <br />
                    IP سرور شما : %s
                    <br />
                        ';
					$nowDate = jDateTime::date("Y/m/d");
					$nowtime = jDateTime::date(" H:i:s");
					$OsUser = strtolower($crdet["email"]["oss"]);
					if (strtolower($crdet["email"]["oss"]) == "windows") {
						$OsUser = "administrator";
					}
					$mailTemplate = sprintf(
						$mailTemplate,
						$listOfRecordType[0]["uname"],
						$listOfRecordType[0]["ci_faname"],
						$crdet["email"]["oss"] . " " . $crdet["email"]["osversion"],
						$OsUser,
						$crdet["email"]["password"],
						$ip
					);
					if ($crdet["metadata"]["HA_Enabled"] == "true") {
						API_CLOUD_SERVER_ADMIN::RunSetMetaData($m,  $n["id"], "HA_Enabled", "True", $idcid);
					} else {
						API_CLOUD_SERVER_ADMIN::RunDeleteMetaData($m,  $n["id"], "HA_Enabled", $idcid);
					}
					$o = EMAILCLASS::SendEmailPanel($mail, " سفارش سرور ابری جدید  در میزبان کلود", $mailTemplate, "success");
				}
				if ($status == "ERROR") {
					//ROLLBACK
					API_CLOUD_VOLUME_ADMIN::RunRemoveVolume($vlid, $mail, $idcid);
					CLOUD_VOLUME_ADMIN::RemoveVolume($token, $crdet["lastVolumeID"], $listOfRecordType[0]["uid"]);
					self::DeleteServer($token, $id, $listOfRecordType[0]["uid"]);
					return ["status" => "error", "message" => "خطا در انجام درخواست"];
				}
			} else {
				$f = explode(",", $listOfRecordType[0]["Firewall"]);
				$fs = [];
				foreach ($f as $s) {
					array_push($fs, CLOUD_FIREWALL_ADMIN::GetOneByID($s));
				}
				unset($listOfRecordType[0]["Firewall"]);
				$afw = CLOUD_SECURITYGROUPSTOSERVER_ADMIN::GetList($id);
				$listOfRecordType[0]["Firewall"] = $fs;
				$listOfRecordType[0]["AdditionalFirewall"] = $afw;
				$vl = CLOUD_VOLUME_ADMIN::GetOneByServerID($id, 0);
				$sn = CLOUD_VOLUME_ADMIN::GetOneByServerID($id, 1);
				$pv = CLOUD_NETWORKSERVER_ADMIN::GetlistByServerID($id, 0);
				$listOfRecordType[0]["volume"] = $vl;
				$listOfRecordType[0]["snapshot"] = $sn;
				$listOfRecordType[0]["privatenetwork"] = $pv;
				if ($listOfRecordType[0]["AdditionalIP"] == "AdditionalIP") {
					$listOfRecordType[0]["AdditionalIP"] =
						CLOUD_ADDITIONALIP_ADMIN::GetList($listOfRecordType[0]["ServerID"]);
				}

				$ls = [
					"status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
					"data" => $listOfRecordType
				];
			}
		}
		$ls = [
			"status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
			"data" => $listOfRecordType
		];
		if ($i == "false") {
			self::UpdateServerStatus($listOfRecordType[0]["BackID"], $n["status"]);
			return self::GetInternalServerDetails($token, $id, "true");
		}
		$conn->close();
		return $ls;
	}
	public static function GetServerDetail($token, $id)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$umail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);

		$sql = "SELECT uname,tbl_cloud_idc.*,cs_test as istest," . $GLOBALS['csid'] . " as ServerID," . $GLOBALS['cs_osname'] . " as OSName," . $GLOBALS['csname'] . " as ServerName,
        " . $GLOBALS['cs_ip'] . " as ServerIP, IF(" . $GLOBALS['cs_additionalip'] . " =0, 'NoAdditionalIP', 'AdditionalIP') as AdditionalIP ,cs_firewall as Firewall,
                    CASE
                WHEN " . $GLOBALS['cs_status'] . "=0 THEN  'pending'
                WHEN " . $GLOBALS['cs_status'] . "=1 THEN  'active'
                WHEN " . $GLOBALS['cs_status'] . "=2 THEN  'off'
                WHEN " . $GLOBALS['cs_status'] . "=3 THEN  'suspended'
                WHEN " . $GLOBALS['cs_status'] . "=4 THEN  'pause'
                WHEN " . $GLOBALS['cs_status'] . "=5 THEN  'deleted'
                WHEN " . $GLOBALS['cs_status'] . "=6 THEN  'build'
                WHEN " . $GLOBALS['cs_status'] . "=7 THEN  'shutdown'
                WHEN " . $GLOBALS['cs_status'] . "=8 THEN  'build'
				WHEN " . $GLOBALS['cs_status'] . "=9 THEN  'pending_rescue'
				WHEN " . $GLOBALS['cs_status'] . "=10 THEN  'rescued'
            END as server_Status ,cs_status," .
			$GLOBALS['cs_startdate'] . " as ServerStartDate ,ci_name as IDCName,ci_faname as IDCFaName,
            cs_status,cs_additional ," . $GLOBALS["cs_idcid_fk"] . " as IDCID," . $GLOBALS["cs_serverid"] . " as BackID," . $GLOBALS['cs_lastupdate'] . " as ServerLastUpdate,
        " . $GLOBALS['cs_ram'] . " as ServerRam," . $GLOBALS['cs_vcpu'] . " as ServerVCPU," . $GLOBALS['cs_hard'] . " as ServerHard,cs_additional as AdditionalData
        from " . $GLOBALS["cloud_server_tablename"] . " ,tbl_cloud_idc,tbl_users

        where uid=cs_uid_fk and " . $GLOBALS['cs_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['csid']  . "=" . $id . " AND ciid=cs_idcid_fk";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
			return $result;
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$listOfRecordType[0]["os"] = CLOUD_FLAVOR_ADMIN::ReturnAllOS()["oss"][$listOfRecordType[0]["OSName"]];
			$f = explode(",", $listOfRecordType[0]["Firewall"]);
			$fs = [];
			foreach ($f as $s) {
				array_push($fs, CLOUD_FIREWALL_ADMIN::GetOneByID($s));
			}
			unset($listOfRecordType[0]["Firewall"]);
			$afw = CLOUD_SECURITYGROUPSTOSERVER_ADMIN::GetList($id);
			$listOfRecordType[0]["Firewall"] = $fs;
			$listOfRecordType[0]["AdditionalFirewall"] = $afw;
			$vl = CLOUD_VOLUME_ADMIN::GetOneByServerID($id, 0);
			$sn = CLOUD_VOLUME_ADMIN::GetOneByServerID($id, 1);
			$pv = CLOUD_NETWORKSERVER_ADMIN::GetlistByServerID($id, 0);
			$listOfRecordType[0]["volume"] = $vl;
			$listOfRecordType[0]["snapshot"] = $sn;
			$listOfRecordType[0]["privatenetwork"] = $pv;
			if ($listOfRecordType[0]["AdditionalIP"] == "AdditionalIP") {
				$listOfRecordType[0]["AdditionalIP"] =
					CLOUD_ADDITIONALIP_ADMIN::GetList($listOfRecordType[0]["ServerID"]);
			}
			// if ($listOfRecordType[0]["server_Status"] != "build") {
			//     return  self::GetInternalServerDetails($token, $id);
			// }
			$hd = str_replace("\n", "\\n", $listOfRecordType[0]["AdditionalData"]);

			$addData = json_decode($hd, true);

			$l = $listOfRecordType[0]["cs_additional"];
			$crdet = json_decode(preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $l), true);
			$vlid = $crdet["vlid"];
			$m = str_replace("@", "", $mail);
			$m = str_replace(".", "", $m);
			$idcid = $listOfRecordType[0]["IDCID"];
			$vlstatus = API_CLOUD_VOLUME_ADMIN::RunGetVolumeDetails($vlid, $m, $idcid);
			$vls = json_decode($vlstatus, true);
			$vl = 0;
			$hd = str_replace("\n", "\\n", $listOfRecordType[0]["AdditionalData"]);

			$addData = json_decode($hd, true);

			if (isset($addData["metadata"]["HA_Enabled"])) {
				$listOfRecordType[0]["HA_Enabled"] = $addData["metadata"]["HA_Enabled"];
			} else {
				$listOfRecordType[0]["HA_Enabled"] =  "false";
			}
			if (isset($addData["metadata"]["HA_Enabled"])) {
				$listOfRecordType[0]["HA_Enabled"] = $addData["metadata"]["HA_Enabled"];
			} else {
				$listOfRecordType[0]["HA_Enabled"] =  "false";
			}
			$vl = 0;
			$scr = [
				"name" => $crdet["data"]["name"],
				"osimage" => $crdet["data"]["osimage"],
				"m" => $crdet["data"]["m"],
				"idc" => $crdet["data"]["idc"],
				"idcinfo" => $crdet["data"]["idcinfo"],
				"flavorid" => $crdet["data"]["flavorid"],
				"sshkeyid" => $crdet["data"]["sshkey"],
				"networks" => $crdet["data"]["network"],
				"defaultsecuritygroup" => $crdet["data"]["securitygroup"],
				"vid" => $crdet["data"]["vid"],
				"password" => $crdet["data"]["passowrd"],
				"ip" => $crdet["data"]["ip"],
				$crdet
			];


			if (isset($addData["metadata"]["HA_Enabled"])) {
				$listOfRecordType[0]["HA_Enabled"] = $addData["metadata"]["HA_Enabled"];
			} else {
				$listOfRecordType[0]["HA_Enabled"] =  "false";
			}
			unset($listOfRecordType[0]["AdditionalData"]);

			$status = "";
			$m = str_replace("@", "", $mail);
			$m = str_replace(".", "", $m);
			if (
				$listOfRecordType[0]["server_Status"] == "pending_rescue" ||
				$listOfRecordType[0]["server_Status"] == "rescued"
			) {
				return  [
					"status" => "success",
					"message" => "اطلاعات با موفقیت دریافت شد",
					// "n" => $n,
					"data" => $listOfRecordType
				];
			}
			if ($listOfRecordType[0]["cs_status"] == "5") {
				return ["status" => "error", "message" => "سرور مورد حذف شده است"];
			}
			if ($listOfRecordType[0]["BackID"] == "") {
				return ["status" => "error", "message" => "خطا در ایجاد سرور"];
			}

			if ($listOfRecordType[0]["server_Status"] == "deleted") {
			}

			if ($listOfRecordType[0]["server_Status"] == "build") {
				$n =   API_CLOUD_SERVER_ADMIN::GetServerDetailFromAPI(
					$m,
					$listOfRecordType[0]["IDCID"],
					$listOfRecordType[0]["BackID"]
				);

				if ($listOfRecordType[0]["cs_status"] == "8") {


					$outapi =  API_CLOUD_SERVER_ADMIN::RunCreateServer(
						$scr["name"],
						$scr["osimage"],
						$scr["m"],
						$scr["idc"],
						$scr["flavorid"],
						$scr["sshkeyid"],
						$scr["networks"],
						$scr["defaultsecuritygroup"],
						$scr["vid"],
						$scr["idcinfo"],
						$scr["password"],
						$scr["ip"]
					);
					self::UpdateServerDetailsFromAPI("cs_serverid", $outapi["id"], $id);
					self::ChangeServerStatus($id, "6");
					if ($scr["sshkeyid"] == 0) {
						$sshkey = "0";
					}

					$GLOBALS['cs_networkid'] = "cs_networkid";
					$GLOBALS['cs_sshkey'] = "cs_sshkey";
					$GLOBALS['cs_firewall'] = "cs_firewall";
					$GLOBALS['cs_osid'] = "cs_osid";
					$GLOBALS['cs_osname'] = "cs_osname";

					if (array_key_exists("status", $outapi)) {
						if ($outapi["status"] == "error") {
							API_CLOUD_VOLUME_ADMIN::RunRemoveVolume($scr["vid"], $mail, $scr["idc"]);
							return ["status" => "error", "message" => "خطا در انجام درخواست"];
						}
					}

					CLOUD_LOGS_ADMIN::AddLog($id, "Create server");
				}


				$status = $n["status"];
				if ($status == "ACTIVE") {
					// CLOUD_VOLUME_ADMIN::UpdateServerID($crdet["lastVolumeID"], $listOfRecordType[0]["BackID"]);
					self::UpdateServerDetailsFromAPI("cs_status", 1, $id);



					$ip = $n["ips"]["public-1"][0]["addr"];
					self::UpdateServerDetailsFromAPI("cs_ip", $ip, $id);
					$mailTemplate = '
                    %s عزیز،
                    <br />
                    سرور ابری  درخواستی شما در میزبان کلود با جزئیات زیر ساخته شد:
                    <br />
                    دیتاسنتر: %s
                    <br />
                    سیستم عامل: %s
                    <br />
                    نام کاربری سیستم عامل: %s
                    <br />
                    رمز عبور پیش فرض سرور شما: %s
                    <br />
                    IP سرور شما : %s
                    <br />
                        ';
					$nowDate = jDateTime::date("Y/m/d");
					$nowtime = jDateTime::date(" H:i:s");
					$OsUser = strtolower($crdet["email"]["oss"]);
					if (strtolower($crdet["email"]["oss"]) == "windows") {
						$OsUser = "administrator";
					}
					$mailtitle = " سفارش سرور ابری جدید  در میزبان کلود";
					if ($listOfRecordType[0]["istest"] == "1") {
						$ip = $ip . "<br />**سرور شما تست برای 24 ساعت است و بعد از این زمان به صورت خودکار حذف خواهد شد ";
						$mailtitle = "سفارش سرور ابری تست یک روزه";
					}
					$mailTemplate = sprintf(
						$mailTemplate,
						$listOfRecordType[0]["uname"],
						$listOfRecordType[0]["ci_faname"],
						$crdet["email"]["oss"] . " " . $crdet["email"]["osversion"],
						$OsUser,
						$crdet["email"]["password"],
						$ip
					);
					if ($crdet["metadata"]["HA_Enabled"] == "true") {
						API_CLOUD_SERVER_ADMIN::RunSetMetaData($m,  $n["id"], "HA_Enabled", "True", $idcid);
					} else {
						API_CLOUD_SERVER_ADMIN::RunDeleteMetaData($m,  $n["id"], "HA_Enabled", $idcid);
					}
					$o = EMAILCLASS::SendEmailPanel($mail, $mailtitle, $mailTemplate, "success");
					// CLOUD_FINANCIAL_LOGS_ADMIN::AddRecord($uid, $plan, $comment);
					if ($listOfRecordType[0]["istest"] != "1")
						CLOUD_FINANCIAL_LOGS_ADMIN::UpdateFromDB($uid, "خرید سرور جدید");
				}
				if ($status == "ERROR") {
					//ROLLBACK
					API_CLOUD_VOLUME_ADMIN::RunRemoveVolume($vlid, $mail, $idcid);
					CLOUD_VOLUME_ADMIN::RemoveVolume($token, $crdet["lastVolumeID"], $listOfRecordType[0]["uid"]);
					self::DeleteServer($token, $id, $listOfRecordType[0]["uid"]);
					return ["status" => "error", "message" => "خطا در انجام درخواست"];
				}


				if ($vls["status"] != "available" && $vls["status"] != "in-use") {
					return [
						"status" => "pending",
						"vlstatus" => $vls,
						"vl" => $vlid,
						"data" => $listOfRecordType,
						"message" => "سرور در حال ایجاد است"
					];
				}
			}

			return  [
				"status" => "success",
				"message" => "اطلاعات با موفقیت دریافت شد",
				// "n" => $n,
				"data" => $listOfRecordType
			];
		}


		$conn->close();
		return;
	}

	public static function AttachFirewallToServer($token, $serverid, $fwid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$fw = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $fwid);
		if ($fw["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
		}
		$sd = self::UserCanAccessToServer($uid, $serverid);
		if ($sd["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($sd["data"][0]["cs_test"] == "8" ||  $sd["data"][0]["cs_test"] == "9") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		$fwsd = CLOUD_SECURITYGROUPSTOSERVER_ADMIN::CheckFirewallIsInUse($fwid, $serverid);
		if ($fwsd == "1") {
			return ["status" => "error", $fwsd, "message" => " شما قبلا این فایروال را در سرور اضافه نموده اید"];
		}
		$sfwid = $fw["data"][0]["cf_serverid"];
		$ssid = $sd["data"][0]["cs_serverid"];
		API_CLOUD_SERVER_ADMIN::RunAttachFirewallToServer($m, $ssid, $sfwid, $sd["data"][0]["cs_idcid_fk"]);
		CLOUD_LOGS_ADMIN::AddLog($serverid, "Attach firewall");
		CLOUD_SECURITYGROUPSTOSERVER_ADMIN::AddFireWallToServer($serverid, $fwid);

		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function DetachFirewallToServer($token, $serverid, $fwid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$fw = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $fwid);
		if ($fw["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
		}
		$sd = self::UserCanAccessToServer($uid, $serverid);
		if ($sd["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($sd["data"][0]["cs_test"] == "8" ||  $sd["data"][0]["cs_test"] == "9") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		$fwsd = CLOUD_SECURITYGROUPSTOSERVER_ADMIN::CheckFirewallIsUsable($fwid, $serverid);
		if ($fwsd == "0") {
			return ["status" => "error", "message" => "شما هنوز این فایروال را به سرور اضافه نکرده اید"];
		}

		$sfwid = $fw["data"][0]["cf_serverid"];
		$ssid = $sd["data"][0]["cs_serverid"];
		CLOUD_SECURITYGROUPSTOSERVER_ADMIN::DeleteFirewallFromServer($serverid, $fwid);
		API_CLOUD_SERVER_ADMIN::RunDetachFirewallToServer($m, $ssid, $sfwid, $sd["data"][0]["cs_idcid_fk"]);
		CLOUD_LOGS_ADMIN::AddLog($serverid, "Detach Firewall");

		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function AttachVolumeToServer($token, $serverid, $vlid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$fw = CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid, $vlid);
		if ($fw["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این Volume را ندارید"];
		}
		$sd = self::UserCanAccessToServer($uid, $serverid);
		if ($sd["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($sd["data"][0]["cs_test"] == "8" ||  $sd["data"][0]["cs_test"] == "9") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		$fwsd = CLOUD_VOLUME_ADMIN::CheckVolumeIsUsable($vlid);

		if ($fwsd["data"][0]["VolumeID"] != "0") {
			return ["status" => "error", "message" => "شما قبلا این هارد را به صرور دیگری ا ضافه نموده اید"];
		}

		$sfwid = $fw["data"][0]["cv_serverid"];
		$ssid = $sd["data"][0]["cs_serverid"];
		$s = API_CLOUD_SERVER_ADMIN::RunAttachVolumeToServer($m, $ssid, $sfwid, $sd["data"][0]["cs_idcid_fk"]);
		$res = json_decode($s, true);
		if (isset($res["status"]) && $res["status"] == "error") {
			return ["status" => "error", "message" => $res["exceptions"], $res];
		}
		CLOUD_VOLUME_ADMIN::UpdateVPSID($vlid, $serverid);
		CLOUD_LOGS_ADMIN::AddLog($serverid, "Attach Volume");
		return ["status" => "success", $s, "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function DetachVolumeToServer($token, $serverid, $vlid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$fw = CLOUD_VOLUME_ADMIN::UserCanAccessToVolume($uid, $vlid);
		if ($fw["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این Volume را ندارید"];
		}
		$sd = self::UserCanAccessToServer($uid, $serverid);
		if ($sd["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		if ($sd["data"][0]["cs_test"] == "8" ||  $sd["data"][0]["cs_test"] == "9") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		$fwsd = CLOUD_VOLUME_ADMIN::CheckVolumeIsUsable($vlid);

		if ($fwsd["data"][0]["VolumeID"] != $serverid) {
			return ["status" => "error", "message" => "شما امکان دسترسی به این هارد را ندارید"];
		}

		$sfwid = $fw["data"][0]["cv_serverid"];
		$ssid = $sd["data"][0]["cs_serverid"];
		$r = API_CLOUD_SERVER_ADMIN::RunDetachVolumeToServer($m, $ssid, $sfwid, $sd["data"][0]["cs_idcid_fk"]);
		$res = json_decode($r, true);
		if (isset($res["status"]) && $res["status"] == "error") {
			if ($res["exceptions"][0]  == "Cannot detach a root device volume") {
				$res["exceptions"][0] = "دیسک اصلی  متصل به سرور قابل حذف نمیباشد.";
				// return ["status" => "error", "message" => ];
			}
			return ["status" => "error", $res, "message" => $res["exceptions"][0]];
		}
		CLOUD_VOLUME_ADMIN::UpdateVPSIDNull($vlid);
		CLOUD_VOLUME_ADMIN::UpdateNamePathToNull($vlid);
		CLOUD_LOGS_ADMIN::AddLog($serverid, "Detach Volume");
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function SetHAEnabled($token, $serverid, $status)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$validStatus = ["true", "false"];
		if (!in_array($status, $validStatus)) {
			return ["status" => "error", "message" => "وضعیت ارسالی نامعتبر است"];
		}
		$serverDet = self::GetServerByID($serverid);
		$sid = $serverDet[0]["cs_serverid"];
		$idc = $serverDet[0]["cs_idcid_fk"];
		if ($serverDet[0]["cs_test"] == "8" ||  $serverDet[0]["cs_test"] == "9") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		$mail = $serverDet[0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$hd = str_replace("\n", "\\n", $serverDet[0]["cs_additional"]);
		$additionalData = json_decode($hd, true);
		if (isset($additionalData["metadata"]["HA_Enabled"])) {
			if ($additionalData["metadata"]["HA_Enabled"] == $status)
				return ["status" => "success", "message" => "درخواست شما انجام شد"];
			else {
				unset($additionalData["metadata"]["HA_Enabled"]);
				$additionalData["metadata"]["HA_Enabled"] = $status;
				$na = json_encode($additionalData);
				$sql = "Update tbl_cloud_server set cs_additional='" . $na . "' WHERE csid=" . $serverid;
				$conn = GetConnection();
				$conn->query($sql);
				$conn->close();
				if ($status == "true") {
					API_CLOUD_SERVER_ADMIN::RunSetMetaData($m, $sid, "HA_Enabled", "True", $idc);
				} else {
					API_CLOUD_SERVER_ADMIN::RunDeleteMetaData($m, $sid, "HA_Enabled", $idc);
				}
			}
		} else {
			$additionalData["metadata"]["HA_Enabled"] = $status;
			$na = json_encode($additionalData);
			$sql = "Update tbl_cloud_server set cs_additional='" . $na . "' WHERE csid=" . $serverid;
			$conn = GetConnection();
			$conn->query($sql);
			$conn->close();
			if ($status == "true") {
				API_CLOUD_SERVER_ADMIN::RunSetMetaData($m, $sid, "HA_Enabled",  "True", $idc);
			} else {
				API_CLOUD_SERVER_ADMIN::RunDeleteMetaData($m, $sid, "HA_Enabled", $idc);
			}
		}

		return ["status" => "success", "message" => "درخواست شما انجام شد"];
		// select JSON_UNQUOTE(JSON_EXTRACT(cs_additional, '$.metadata.HA_Enabled')) as scope from tbl_cloud_server
		//update tbl_cloud_server set cs_additional = JSON_SET(cs_additional, "$.metadata.HA_Enabled", "True") ;
	}
	public static function SetLastCalc($serverid)
	{
		$starttime =  jDateTime::date("Y/m/d H:00:00");
		$sql = "UPDATE " . $GLOBALS["cloud_server_tablename"] . " SET  " . $GLOBALS['cs_lastcalc']
			. "='" . $starttime . "' WHERE " . $GLOBALS['csid'] . "=" . $serverid;

		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
	}
	public static function ServerTestIsUsed($uid)
	{
		$sql = "SELECT * FROM `tbl_cloud_server` WHERE cs_test=1 and cs_uid_fk=" . $uid;
		$conn = GetConnection();
		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "success", "message" => "اطلاعات ارسالی نامعتبر است"];
			return $result;
		} else {
			$listOfRecordType = ["status" => "error", "message" => "شما پیش از این سرور رایگان یک روزه دریافت نموده اید"];
		}
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function CheckMiniCredit($ram, $cpu, $hard, $storage_type, $credit)
	{
		$pricelist = FINANCIAL_PRICE_ADMIN::GetPriceList();
		$sum = 0;
		$out = [];
		foreach ($pricelist["data"] as $d) {
			if ($d["dp_type"] == "CloudServer") {
				if ($d["dp_category"] == "ram") {
					$sum = $sum + (intVal($d["dp_price"]) * 120 * (intVal($ram)));
					$out["ram"]["price"] = $d["dp_price"];
					$out["ram"]["count"] = $ram;
					$out["ram"]["sum"] = intVal($d["dp_price"]) * 120 * (intVal($ram));
				} else if ($d["dp_category"] == "cpu") {
					$sum = $sum + (intVal($d["dp_price"]) * 120 * (intVal($cpu)));
					$out["cpu"]["price"] = $d["dp_price"];
					$out["cpu"]["count"] = $cpu;
					$out["cpu"]["sum"] = intVal($d["dp_price"]) * 120 * (intVal($cpu));
				} else if ($d["dp_category"] == $storage_type) {
					$sum = $sum + (intVal($d["dp_price"]) * 120 * (intVal($hard)));
					$out["hard"]["price"] = $d["dp_price"];
					$out["hard"]["count"] = $hard;
					$out["hard"]["sum"] = intVal($d["dp_price"]) * 120 * (intVal($hard));
				}
			}
		}
		if (intVal($credit) < $sum) {
			return ["status" => "error", "message" => "حداقل اعتبار برای خرید این سرور مبلغ " . number_format($sum) . " ریال است"];
		} else {
			return ["status" => "success"];
		}
	}
	public static function CreateServer($token, $idc, $osname, $name, $ram, $cpu, $hard, $sshkey, $network, $firewall, $snapshot, $snapshotid, $test, $storagetype, $autoPilot)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		if (self::checkNameDuplicated($uid, $name, $idc)["status"] == "success") {
			return [
				"status" => "error", "message" => "نام سرور درخواستی شما تکراری است "
			];
		}
		if ($test == "1") {
			$canGetNewTestServer = self::ServerTestIsUsed($uid);
			if ($canGetNewTestServer["status"] == "error") {
				return $canGetNewTestServer;
			}
			$storagetype = "ssd";
		} else {
			$chc = self::CheckMiniCredit($ram, $cpu, $hard, $storagetype, $usersDetails["credit"]);
			if ($chc["status"] == "error")
				return $chc;
		}
		if (!in_array($autoPilot, ["true", "false"])) {
			return ["status" => "error", "message" => "مقدار ارسالی برای Auto Pilot اشتباه است"];
		}

		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		if (!preg_match("/^[a-zA-z0-9.]*$/", $name)) {
			return ["status" => "error", "message" => "هاست نیم ارسالی شما نامعتبر است"];
		}
		if ($snapshotid == "default") {

			$osimage = CLOUD_FLAVOR_ADMIN::ReturnOSID($osname);
			if ($osimage["status"] == "error") {
				return ["status" => "error", $osimage, "message" => "سیستم عامل درخواستی شما اشتباه است"];
			}
		}

		if (filter_var($ram, FILTER_VALIDATE_INT) === false) {
			return ["status" => "error", "message" => "میزان رم ارسالی نامعتبر است"];
		}
		if (filter_var($cpu, FILTER_VALIDATE_INT) === false) {
			return ["status" => "error", "message" => "میزان CPU ارسالی نامعتبر است"];
		}
		if (filter_var($hard, FILTER_VALIDATE_INT) === false) {
			return ["status" => "error", "message" => "میزان هارد ارسالی نامعتبر است"];
		}
		if (filter_var($sshkey, FILTER_VALIDATE_INT) === false) {
			return ["status" => "error", "message" => "SSH KEY ارسالی نامعتبر است"];
		}

		if ($network != "public") {
			$n = explode(",", $network);
			if ($n[0] != "private") {
				return ["status" => "error", "message" => "شبکه درخواستی شما نامعتبر است"];
			}
			if (!array_key_exists(1, $n)) {
				return ["status" => "error", "message" => "شناسه شبکه خصوصی ارسالی نامعتبر است"];
			}
			$c = CLOUD_PRIVATENETWORKS_ADMIN::GetOneByID($token, $n[1]);

			if ($c["status"] == "error") {
				return ["status" => "error", "message" => "شما اجازه دسترسی به این شبکه را ندارید"];
			}
		}
		$f = explode(",", $firewall);

		$defaultsecuritygroup = [];
		foreach ($f as $a) {
			if ($a != "default") {
				$b = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $a);

				if ($b["status"] == "error") {
					return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
				}

				array_push($defaultsecuritygroup, $b["data"][0]["cf_serverid"]);
			} else {
				$projectinfo = CLOUD_PROJECT_ADMIN::GetDefaultSecurityGroup($uid, $idc);
				if ($projectinfo["data"][0]["cp_default_Security_group"] == null) {

					$projectinfo = CLOUD_PROJECT_ADMIN::GetDataFromAPI($uid, $idc);
				}
				$defaultsecuritygroup = $projectinfo["data"][0]["cp_default_Security_group"];
			}
		}


		$idcInfo = CLOUD_IDC_ADMIN::GetOneByID($idc);

		if ($idcInfo["status"] != "success") {
			return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
		}
		$sshdetails = CLOUD_SSHKEYS_ADMIN::GetOneByID($token, $sshkey);
		$volumeinfo = [];
		if ($snapshotid != "default") {

			$sndet = CLOUD_VOLUME_ADMIN::GetOneByID($token, $snapshotid);
			if ($sndet["status"] == "error")
				return $sndet;


			$osimage = CLOUD_FLAVOR_ADMIN::ReturnOSID($sndet["data"][0]["cv_osname"]);
			if ($osimage["status"] == "error") {
				return ["status" => "error", $osimage, "message" => "سیستم عامل درخواستی شما اشتباه است"];
			}
			$osname = $sndet["data"][0]["cv_osname"];
			$volumeinfo = CLOUD_VOLUME_ADMIN::AddVolumeWithSnapShot(
				$token,
				$name,
				$hard,
				$idc,
				$sndet["data"][0]["cv_osname"],
				$sndet["data"][0]["cv_osid"],
				$sndet["data"][0]["sid"],
				$sndet["data"][0]["sid"],
				$storagetype
			);
			$osimage["os"] = $sndet["data"][0]["cv_osid"];
		} else {
			$volumeinfo = CLOUD_VOLUME_ADMIN::AddVolumeAndAttachToServer($token, $name, $hard, $idc, $osname, $osimage["os"], $storagetype);
		}
		if ($volumeinfo["status"] == "error") {
			if ($volumeinfo["message"][0] == "Invalid input received: Volume size '25'GB cannot be smaller than the snapshot size 60GB. They must be >= original snapshot size.") {
				$volumeinfo["message"][0] = "حجم هارد درخواستی شما کمتر از هارد اسنپ شات است";
			}
			if (substr($volumeinfo["message"][0], 0, 52) == "Invalid input received: Invalid volume_type provided") {
				$volumeinfo["message"][0] = "نوع هارد درخواستی شما با نوع هارد اسنپ شات یکسان نیست";
			}
			return $volumeinfo;
		}
		$vid = $volumeinfo["vid"];
		$lastVolumeID = $volumeinfo["id"];

		$publicNetwork = CLOUD_IDC_ADMIN::GetOneByID($idc)["data"][0]["ci_public_network"];
		$now = jDateTime::date("Y/m/d H:i:s");
		$image_id = "";
		$sshkeyid = 0;
		$pass = self::GenerateHash();

		$oss = CLOUD_FLAVOR_ADMIN::ReturnAllOS()["oss"][$osname];
		$password = "";
		if ($sshkey == 0) {
			if ($oss == "Windows")
				$password = "#ps1\\nnet user Administrator " . $pass;
			else if (strtoupper($oss) == "ubuntu")
				$password = "#cloud-config\napt:\n  preserve_sources_list: false\n  primary:\n    - arches:\n      - amd64\n      uri: \"http://ir.archive.ubuntu.com/ubuntu/\"\n  security:\n    - arches:\n      - amd64\n      uri: \"http://security.ubuntu.com/ubuntu\"\npassword: " . $pass . "\nchpasswd: { expire: False }\nssh_pwauth: True";
			else
				$password =  "#cloud-config\\npassword: " . $pass . "\\nchpasswd: { expire: False }\\nssh_pwauth: True";
			$sshkeyid = "";
		} else {
			$pass = "use public ssh key";
			$sshkeyid = $sshdetails["data"][0]["name"];
			if ($oss == "Windows") {
				return ["status" => "error", "message" => "امکان استفاده از SSH KEY در سیستم عامل ویندوز نمیباشد "];
			}
		}
		// return $volumeinfo;
		if ($test == "1") {
			$ram = "1";
			$cpu = "1";
			$hard = "25";
		}
		$flavor_id = CLOUD_FLAVOR_ADMIN::ReturnFLAVORID($ram, $cpu)["package"];

		$idcinfo = CLOUD_IDC_ADMIN::GetOneByID($idc);
		// $pass=self:: GenerateHash();

		$uname = $usersDetails["userdetail"][0]["uname"];
		$networks = [
			"net-id" => $publicNetwork,
			"v4-fixed-ip" => ""
		];
		$additinal = [
			"password" => $pass,
			"vlid" =>  $vid,
			"lastVolumeID" => $lastVolumeID,
			"data" => [
				"name" => utf8_encode($name),
				"osimage" => $osimage["os"],
				"m" => $m,
				"idc" => $idc,
				"flavorid" => $flavor_id,
				"sshkey" => $sshkeyid,
				"network" => [$networks],
				"securitygroup" => $defaultsecuritygroup,
				"vid" => $vid,
				"idcinfo" => $idcinfo["data"][0]["ci_storagetype"],
				"passowrd" => $password,
				"ip" => ""
			],
			"email" => [
				"uname" => utf8_encode($uname),
				"idcname" => utf8_encode($idcInfo["data"][0]["ci_faname"]),
				"osversion" => $osname,
				"oss" => $oss,
				"ram" => $ram,
				"cpu" => $cpu,
				"hard" => $hard,
				"bw" => "unlimited",
				"password" => $pass
			], "metadata" =>
			["HA_Enabled" => $autoPilot]
		];




		$orderid = DOMAINS_ADMIN::AddOrder($uid)["orderid"];

		$starttime =  jDateTime::date("Y/m/d H:00:00");
		$sql = "INSERT INTO " . $GLOBALS["cloud_server_tablename"] . " VALUES (0,'" . $name
			. "','" . $uid . "','0','" . $idc . "','8','0','" . $ram . "','" . $cpu . "','" . $hard . "','0','"
			. $now . "','" . $now . "','" . $publicNetwork . "','" . $sshkey . "','" . $firewall . "','" . $osimage["os"] . "','" . $osname . "','" . $test
			. "','" . json_encode($additinal) . "','" . $orderid . "')";

		$conn = GetConnection();
		if ($conn->query($sql) === TRUE) {
		}



		$last_id = $conn->insert_id;

		CLOUD_VOLUME_ADMIN::UpdateServerID($lastVolumeID, $last_id);


		$f = explode(",", $firewall);

		$defaultsecuritygroup = [];
		foreach ($f as $a) {
			if ($a != "default") {
				$b = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $a);

				if ($b["status"] == "error") {
					return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
				}
				CLOUD_SECURITYGROUPSTOSERVER_ADMIN::AddFireWallToServer($last_id, $a);
				# array_push($defaultsecuritygroup , $b["data"][0]["cf_serverid"]);
			} else {
				$projectinfo = CLOUD_PROJECT_ADMIN::GetDefaultSecurityGroup($uid, $idc);
				if ($projectinfo["data"][0]["cp_default_Security_group"] == null) {

					$projectinfo = CLOUD_PROJECT_ADMIN::GetDataFromAPI($uid, $idc);
				}
				CLOUD_SECURITYGROUPSTOSERVER_ADMIN::AddFireWallToServer($last_id, $projectinfo["data"][0]["cp_default_Security_group"]);
				#$defaultsecuritygroup = $projectinfo["data"][0]["cp_default_Security_group"];
			}
		}
		$err = $conn->error;
		// $id = API_CLOUD_SSHKEY_ADMIN::RunCreateAPISSHKEY( $sid,$pubkey,$m,$idc);
		$conn->close();

		return ["status" => "success", $err, $sql, "id" => $last_id, "message" => "درخواست شما با موفقیت انجام شد"];














		sleep(10);
		$outapi =  API_CLOUD_SERVER_ADMIN::RunCreateServer(
			$name,
			$osimage["os"],
			$m,
			$idc,
			$flavor_id,
			$sshkeyid,
			[$publicNetwork],
			$defaultsecuritygroup,
			$vid,
			$idcinfo["data"][0]["ci_storagetype"],
			$password,
			$storagetype
		); //
		if ($sshkey == 0) {
			$sshkey = "0";
		}

		$GLOBALS['cs_networkid'] = "cs_networkid";
		$GLOBALS['cs_sshkey'] = "cs_sshkey";
		$GLOBALS['cs_firewall'] = "cs_firewall";
		$GLOBALS['cs_osid'] = "cs_osid";
		$GLOBALS['cs_osname'] = "cs_osname";

		if (array_key_exists("status", $outapi)) {
			if ($outapi["status"] == "error") {
				// $delete   $vid
				API_CLOUD_VOLUME_ADMIN::RunRemoveVolume($vid, $mail, $idc);
				return ["status" => "error", $volumeinfo, $outapi, "message" => "خطا در انجام درخواست"];
			}
		}
		$starttime =  jDateTime::date("Y/m/d H:00:00");
		$sql = "INSERT INTO " . $GLOBALS["cloud_server_tablename"] . " VALUES (0,'" . $name
			. "','" . $uid . "','" . $outapi["id"] . "','" . $idc . "','6','0','" . $ram . "','" . $cpu . "','" . $hard . "','0','"
			. $now . "','" . $now . "','" . $publicNetwork . "','" . $sshkey . "','" . $firewall . "','" . $osimage["os"] . "','" . $osname . "','" . $test . "')";

		$conn = GetConnection();
		$conn->query($sql);
		$last_id = $conn->insert_id;
		$f = explode(",", $firewall);

		$defaultsecuritygroup = [];
		foreach ($f as $a) {
			if ($a != "default") {
				$b = CLOUD_FIREWALL_ADMIN::UserCanAccessToFireWall($uid, $a);

				if ($b["status"] == "error") {
					return ["status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
				}
				CLOUD_SECURITYGROUPSTOSERVER_ADMIN::AddFireWallToServer($last_id, $a);
				# array_push($defaultsecuritygroup , $b["data"][0]["cf_serverid"]);
			} else {
				$projectinfo = CLOUD_PROJECT_ADMIN::GetDefaultSecurityGroup($uid, $idc);
				if ($projectinfo["data"][0]["cp_default_Security_group"] == null) {

					$projectinfo = CLOUD_PROJECT_ADMIN::GetDataFromAPI($uid, $idc);
				}
				CLOUD_SECURITYGROUPSTOSERVER_ADMIN::AddFireWallToServer($last_id, $projectinfo["data"][0]["cp_default_Security_group"]);
				#$defaultsecuritygroup = $projectinfo["data"][0]["cp_default_Security_group"];
			}
		}

		// $id = API_CLOUD_SSHKEY_ADMIN::RunCreateAPISSHKEY( $sid,$pubkey,$m,$idc);
		$conn->close();
		CLOUD_VOLUME_ADMIN::UpdateServerID($lastVolumeID, $outapi["id"]);
		CLOUD_LOGS_ADMIN::AddLog($last_id, "Create server");

		LOGS_ADMIN::AddLog(" ایجاد سرور جدید " . $name, $usersDetails["userdetail"][0]["uid"], 0, "", "users");
		USER_NEEDED_BALANCE_ADMIN::AddUserDetails($uid);
		return ["status" => "success", "test" => $test, "id" => $last_id, "message" => "اطلاعات با موفقیت ثبت شد"];
	}
	public static function GenerateHash($m = 2, $n = 8)
	{
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$string = '';


		for ($i = 0; $i < $m; $i++) {
			for ($j = 0; $j < $n; $j++) {
				$string .= $characters[mt_rand(0, strlen($characters) - 1)];
			}
			// if($i==0)
			//     $string .="@";
			// else
			//     $string .="#";
		}


		return $string;
	}
	public static function GetSnapShot($token, $serverid, $sname)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$c = self::UserCanAccessToServer($uid, $serverid);
		if ($c["data"][0]["cs_status"] == "8" ||  $c["data"][0]["cs_status"] == "9") {
			return ["status" => "error", "message" => "سرور در حالت Rescue است و امکان تغییر سیستم عامل را ندارید"];
		}
		if ($c["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$ssid = $c["data"][0]["cs_serverid"];
		$ss = API_CLOUD_SNAPSHOT_ADMIN::RunCreateAPISNAPSHOT($ssid, $sname, $m, $c["data"][0]["cs_idcid_fk"]);

		$snapshots = json_decode($ss, true);
		$j = json_decode(API_CLOUD_VOLUME_ADMIN::RunGetAllVolume($m, $c["data"][0]["cs_idcid_fk"]), true);
		$volumeTypes = ["__DEFAULT__" => "ssd", "nvme" => "nvme", "sas" => "sas"];
		foreach ($j as $m) {
			//bc181509-4889-4e44-8e1f-ec091196cdd0
			if (isset($m["attachments"][0]["attached_at"])) {
				if ($m["attachments"][0]["server_id"] == $c["data"][0]["cs_serverid"]) {
					foreach ($snapshots["snapshots"] as $s) {
						if (str_contains($s["name"], $m["attachments"][0]["device"])) {
							$s = CLOUD_VOLUME_ADMIN::AddSnapShotVolume(
								$uid,
								$s["name"],
								$m["size"],
								$c["data"][0]["cs_idcid_fk"],
								$s["id"],
								$c["data"][0]["cs_osname"],
								$c["data"][0]["cs_osid"],
								$serverid,
								$volumeTypes[$m["volume_type"]]
							);



							// echo $s["name"] .
							//     ">>>>snapshotid:>>>" .
							//     $s["id"] . ">>>>" .
							//     $m["attachments"][0]["device"] . ">>>>volume id :" .
							//     $m["id"] . ">>>>" .
							//     $m["volume_type"] . ">>>>size:" .
							//     $m["size"]
							//     . "\n";
						}
					}
					// echo $m["attachments"][0]["device"] . "\n";
				}
			}
		}







		// $p = json_decode($ss, true);
		// if (isset($p["snapshots"])) {
		//     foreach ($p["snapshots"] as $k) {
		//     }
		// }


		// $r = API_CLOUD_SNAPSHOT_ADMIN::RunGetSnapShotList($m, $c["data"][0]["cs_idcid_fk"]);


		// $m = json_decode($r, true);
		// array_multisort(array_column($m, "created_at"), SORT_DESC, $m);

		// $id = $p["snapshots"][0]["id"];
		// $name = $p["snapshots"][0]["name"];
		// $space = $m[0]["size"];
		// $s = CLOUD_VOLUME_ADMIN::AddSnapShotVolume(
		//     $uid,
		//     $name,
		//     $space,
		//     $c["data"][0]["cs_idcid_fk"],
		//     $id,
		//     $c["data"][0]["cs_osname"],
		//     $c["data"][0]["cs_osid"],
		//     $serverid
		// );

		$vl = CLOUD_VOLUME_ADMIN::GetOneByServerID($serverid, 0);
		$sn = CLOUD_VOLUME_ADMIN::GetListOfByIDC($c["data"][0]["cs_idcid_fk"], 1);
		CLOUD_LOGS_ADMIN::AddLog($serverid, "Get SnapShot");
		USER_NEEDED_BALANCE_ADMIN::AddUserDetails($uid);
		return ["status" => "success", "id" => "", "space" => "0", "snapshot" => $sn, "volumes" => $vl, "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function GetListOfSnapShots($token, $serverid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$c = self::UserCanAccessToServer($uid, $serverid);

		if ($c["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$ssid = $c["data"][0]["cs_serverid"];
		return CLOUD_VOLUME_ADMIN::GetOneByServerID($serverid, 1);
	}
	public static function GetListOfSnapShotsWitoutUser($serverid)
	{
		return CLOUD_VOLUME_ADMIN::GetOneByServerID($serverid, 1);
	}
	public static function ServerMonitoring($token, $serverid, $field)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$mail = $usersDetails["userdetail"][0]["umail"];
		$m = str_replace("@", "", $mail);
		$m = str_replace(".", "", $m);
		$c = self::UserCanAccessToServer($uid, $serverid);

		if ($c["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این سرور را ندارید"];
		}
		$ssid = $c["data"][0]["cs_serverid"];
		return API_CLOUD_SERVER_ADMIN::MonitoringServer($serverid, $m, $c["data"][0]["cs_idcid_fk"], $field);
	}
	public static function GetCountOfRebuildServer($serverid)
	{
		$sql = "SELECT COUNT(cldate) as cnt from " . $GLOBALS["tbl_cloud_log"] . " WHERE cl_sid_fk='" . $serverid . "' and cldesc='Rebuild server'";
		$conn = GetConnection();
		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$conn->close();
			return 0;
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$conn->close();
			return $listOfRecordType[0]["cnt"];
		}
	}
}
