<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class CLOUD_BACKUP_ADMIN
{

    public static function GetList($token,$idcid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT " . $GLOBALS['cbid'] . " as BackupID," . $GLOBALS['cb_name'] . " as BackupName,
        " . $GLOBALS['cb_date'] . " as BackupDate," . $GLOBALS['cb_size'] . " as BackupSize from " . $GLOBALS["cloud_backup_tablename"] . "
                where " . $GLOBALS['cb_uid_fk'] . "=" . $uid." AND ".$GLOBALS['cb_idcid_fk']."=".$idcid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد"
        ,
        "data" => $listOfRecordType];
    }
    public static function RemoveVolume($token,$id ){

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        if (CLOUD_BACKUP_ADMIN::UserCanAccessToBackup($uid, $id)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فضای ذخیره سازی را ندارید"];
        }
        $vdet = CLOUD_BACKUP_ADMIN::GetOneByID($token, $id);
        $idc= $vdet["data"][0]["idc"];
        $sid= $vdet["data"][0]["sid"];
       // $status=$vdet["data"][0]["VolumeStatus"];
        if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }

        $now = jDateTime::date("Y/m/d H:i:s");

        //$sql = "DELETE FROM   " . $GLOBALS["cloud_volume_tablename"] . " WHERE "  . $GLOBALS['cvid'] . "=" . $id;
        //$conn = GetConnection();
       // $conn->query($sql);
       // $conn->close();
         API_CLOUD_BACKUP_ADMIN::RunRemoveBackup($sid, $m,$idc);
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }
    public static function GetOneByID($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT " . $GLOBALS['cbid'] . " as BackupID," . $GLOBALS['cb_name'] . " as BackupName,
        " . $GLOBALS['cb_date'] . " as BackupDate," . $GLOBALS['cb_size'] . " as BackupSize,
        " . $GLOBALS['cb_serverid'] . " as sid," . $GLOBALS['cb_idcid_fk'] . " as idc from " . $GLOBALS["cloud_backup_tablename"] . "
                where " . $GLOBALS['cb_uid_fk'] . "=" . $uid;

        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function UserCanAccessToBackup($uid, $id)
    {
        $sql = "SELECT *
        from " . $GLOBALS["cloud_backup_tablename"] . " WHERE " . $GLOBALS['cb_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cbid'] . "=" . $id;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد", $id];
    }
    public static function CheckDuplicatedName($uid, $name)
    {
        $sql = "SELECT * FROM " . $GLOBALS["cloud_backup_tablename"] . " WHERE " . $GLOBALS['cb_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cb_name'] . "='" . $name . "'";

        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است یا نام بکاپ درخواستی شما تکراری است",  $sql];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }

    public static function CreateBackup($token, $name, $serverid, $idcid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        if (filter_var($space, FILTER_VALIDATE_INT) === false) {
            return ["status" => "error", "message" => "مقدار ارسالی برای فضای دیسک اشتباه است"];
        }

        if (CLOUD_VOLUME_ADMIN::CheckDuplicatedName($uid, $name)["status"] == "success") {
            return ["status" => "error", "message" => "نام دیسک انتخابی شما تکراری است"];
        }
        if (CLOUD_IDC_ADMIN::GetOneByID($idcid)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        $now = jDateTime::date("Y/m/d H:i:s");

        $sql = "INSERT INTO " . $GLOBALS["cloud_volume_tablename"] . " VALUES (0,'" . $name
            . "','" . $uid . "','" . $space . "','','0','" . $now . "','" . $now . "',0,''," . $idcid . ")";

        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        $id = API_CLOUD_VOLUME_ADMIN::RunCreateAPIVOLUME($name, $name, $m, $idcid, $space, "");
        $conn->close();
        CLOUD_VOLUME_ADMIN::UpdateIDFromAPI($last_id, $id);
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
    }
    public static function UpdateIDFromAPI($id, $serverid)
    {
        $sql = "UPDATE " . $GLOBALS["cloud_volume_tablename"] . " SET " . $GLOBALS['cv_serverid'] . "='" . $serverid
            . "' WHERE " . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
}
