<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/transactions/transactions_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/creditdetails/admin/creditdetails_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/paymentgateways/admin/paymentgateways_admin_class.php';

class TRANSACTIONS_ADMIN
{

    public static function GetList()
    {
        $sql = "SELECT * FROM " . $GLOBALS["transactions_tablename"];
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetRecordWithParameter($fieldname, $fieldvalue)
    {
        /**
         * @param $activerecord
         * @return mixed
         */
        $sql = "SELECT * FROM " . $GLOBALS["transactions_tablename"] .
            " WHERE " . $GLOBALS[$fieldname] . " LIKE '%" . $fieldvalue . "%'";
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["result" => "null"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneByID($uid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["transactions_tablename"] . ",tbl_users,tbl_creditbalance,tbl_bank_gateway
         where bgw_id = 	tr_bgw_id_fk  and  cb_user_id=uid and  tr_uid_fk=uid and " . $GLOBALS['tr_id'] . "=" . $uid;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "data" => []];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetListByToken($Token)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($Token);

        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT tr_id,tr_date as requestDate,
                    tr_amount as Amount,
                    (
    CASE
      WHEN tr_status = 0 THEN 'تایید نشده'
      WHEN tr_status = 1 THEN 'تایید شده'
     END) AS PaymentStatus,
       tr_verifycode as BankVerifyCode,
        tr_verify_time as BankVerifyTime ,bgw_name as BankName
        from " . $GLOBALS["transactions_tablename"] . "," .
            $GLOBALS["paymentgateways_tablename"] .
            " WHERE " . $GLOBALS['tr_uid_fk'] . "=" . $uid . " AND " .
            $GLOBALS['bgw_id'] . "=" . $GLOBALS['tr_bgw_id_fk']
            . " order by " . $GLOBALS['tr_id'] . " DESC";
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
                         $result = ["status" => "success", "data" => [], "message" => "کاربر مورد نظر یافت نشد یا اعتبار ورود به پایان رسیده است"];
            return $result;
        } else {
                         $resp = mysqli_fetch_all($result, MYSQLI_ASSOC);
            for ($i = 0; $i < count($resp); $i++) {
                $resp[$i]["pid"] = md5($resp[$i]["tr_id"]);
                //  unset($resp[$i]["tr_id"]);
                // $resp[$i]["pid"]=$resp[$i]["tr_id"];
            }
            unset($resp["tr_id"]);

            $listOfRecordType = [
                "status" => "success",
                "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $resp
            ];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function AddRecord($token, $amount, $bgw_id, $url)
    {

        $uinfo = USERS_ADMIN::GetOneByToken($token);
        //  return $uinfo;
        if ($uinfo["status"] == "error") {
                         $res  = ["status" => "error", "message" => "کاربر مورد نظر یافت نشد یا کاربر تایید نشده است"];
            return $res;
        } else {
            $gatewayDetails = paymentgateways_ADMIN::GetOneByID($bgw_id);
            if ($gatewayDetails["status"] == "error") {
                VARS_ADMIN::ReturnHeaders(400);
                $res  = ["message" => "درگاه مورد نظر یافت نشد ", $gatewayDetails];
                return $res;
            } else {
                $conn = GetConnection();

                $sql = "INSERT INTO " . $GLOBALS['transactions_tablename'] . "(" . $GLOBALS['tr_date'] . "," .
                    $GLOBALS['tr_amount'] . "," . $GLOBALS['tr_uid_fk'] . "," .
                    $GLOBALS['tr_bgw_id_fk'] . "," . $GLOBALS['tr_status']
                    . ") VALUES ('%s',%s,%s,%s,%s)";

                $datetime = jDateTime::date("Y/m/d H:i:s");

                $sql = sprintf($sql, $datetime, $amount, $uinfo["userdetail"][0]["uid"], $bgw_id, 0);

                if ($conn->query($sql) === TRUE) {
                    $nid = $conn->insert_id;
                    $enc = TOOLS_ADMIN::encrypt($nid, "");
                    $response = ["status" => "success", "data" => [
                        "url" => $GLOBALS["apidomain"] . "/paymentgateway/" . $gatewayDetails["data"][0]["bgw_path"] . "/" .
                            $gatewayDetails["data"][0]["bgw_path"] . ".php?url=" . $url . "&id=" . $nid . "&enc=" . $enc
                    ]];
                    return $response;
                } else {
                    $response = ["status" => "error", "message" => "" .  $conn->error];
                    return $response;
                }

                $conn->close();
            }
        }
    }
    public static function AcceptTransaction($id, $verifytransactionid)
    {
        $TransactionDetails = TRANSACTIONS_ADMIN::GetOneByID($id);

        if ($TransactionDetails["data"][0]["tr_status"] == "165")
            return;
        $now = jDateTime::date("Y-m-d H:i:s");
        $sql = "UPDATE " . $GLOBALS["transactions_tablename"] .
            " SET " . $GLOBALS['tr_status'] . "=1," .
            $GLOBALS['tr_verifycode'] . "='" . $verifytransactionid
            . "'," . $GLOBALS['tr_verify_time'] . "='" . $now . "' WHERE " .
            $GLOBALS['tr_id'] . "=" . $id;
        $conn = GetConnection();

        if ($conn->query($sql) === TRUE) {
            $TransactionDetails = TRANSACTIONS_ADMIN::GetOneByID($id);
            $desc = "پرداخت مبلغ : " . $TransactionDetails["data"][0]["tr_amount"] . " از طریق  " .
                $TransactionDetails["data"][0]["bgw_name"] . " در تاریخ :" .
                $TransactionDetails["data"][0]["tr_verify_time"] . " با کد پیگیری : " .
                $verifytransactionid;
            //$cd_description,$cd_amount,$cd_uid_fk,$cd_type
            $r = CREADITDETAILS_ADMIN::AddCreditDetails(
                $desc,
                $TransactionDetails["data"][0]["tr_amount"],
                $TransactionDetails["data"][0]["tr_uid_fk"],
                7
            );
            $starttime = jDateTime::date("Y/m/d 00:00:00", strtotime("-2 day"));
            $s = "SELECT * FROM tbl_financial_invoice_byday where idstarttime > '" . $starttime . "' and  id_uid_fk =" . $TransactionDetails["data"][0]["tr_uid_fk"];
            $p = $conn->query($s);
            $m = mysqli_fetch_all($p, MYSQLI_ASSOC);
            $sum = 0;
            if (count($m) == 0) {
            } else {
                $i = 0;
                foreach ($m as $c) {
                    if ($i > 1)
                        continue;
                    else {
                        $sum = $sum + intVal($c["idcdn"]) + intVal($c["idlive"]) + intVal($c["idcloud"]) + intVal($c["idvod"]) + intVal($c["idlivewebrtc"]);
                    }
                    $i++;
                }
            }
            $currentBalance = $r["balance"]["balance"];
            if ($currentBalance > $sum) {
                USERS_ADMIN::CheckAndAddAnnounce($TransactionDetails["data"][0]["tr_uid_fk"], "checkneededbalance", "true");
            }
            $mailTemplate = "%s عزیز،
                            <br />
                ضمن تشکر از پرداخت شما در میزبان کلود، اعتبار کیف پول شما به میزان %s ریال با موفقیت افزایش یافت.
                <br />
                موجودی اعتبار در کیف پول شما: %s ریال
                <br />
                شماره تراکنش: %s
                <br />
                شماره پیگیری: %s
                <br />
                زمان انجام تراکنش: %s
                <br />
                ";
            $params = [
                "param1" => $TransactionDetails["data"][0]["uname"] . " " . $TransactionDetails["data"][0]["ufamily"],
                "param4" => number_format($TransactionDetails["data"][0]["tr_amount"])
            ];
            if (intVal($r["balance"]["balance"]) >= 0 && intVal($TransactionDetails["data"][0]["cb_balance"]) < 0) {
                //SEND CURL REQUEST:::::::::
                // $curl = curl_init();
                // curl_setopt($curl, CURLOPT_URL, $GLOBALS["apidomain"] . "/queue/unsuspendservice.php");
                // curl_setopt($curl, CURLOPT_POST, TRUE);
                // curl_setopt($curl, CURLOPT_POSTFIELDS, "id=" . $TransactionDetails["data"][0]["tr_uid_fk"]);
                // curl_setopt($curl, CURLOPT_USERAGENT, 'api');
                // curl_setopt($curl, CURLOPT_TIMEOUT, 1);
                // curl_setopt($curl, CURLOPT_HEADER, 0);
                // curl_setopt($curl, CURLOPT_RETURNTRANSFER, false);
                // curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
                // curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
                // curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
                // curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
                // curl_exec($curl);
                // curl_close($curl);

				//ADD USER TO UNSUSPEND SERVICE

				CDNSUSPENDTEMPLATE_ADMIN::AddUserToUnsuspendList($TransactionDetails["data"][0]["tr_uid_fk"]);
                // DOMAINNSRECORD_ADMIN::RunActivateCDNforRecord($TransactionDetails["data"][0]["tr_uid_fk"]);
                // CLOUD_SERVER_ADMIN::UnsuspendedServer($TransactionDetails["data"][0]["tr_uid_fk"]);
            }
            $mailTemplate = sprintf(
                $mailTemplate,
                $TransactionDetails["data"][0]["uname"] . " " . $TransactionDetails["data"][0]["ufamily"],
                number_format($TransactionDetails["data"][0]["tr_amount"]),
                number_format($r["balance"]["balance"]),
                $id,
                $verifytransactionid,
                $TransactionDetails["data"][0]["tr_date"]
            );
            $o = EMAILCLASS::SendEmailPanel($TransactionDetails["data"][0]["umail"], "افزایش اعتبار موفق در میزبان کلود    ", $mailTemplate, "success", "l0e23ysq1r", $params, $TransactionDetails["data"][0]["umobile"]);

            $conn->close();
            return $r;
        } else {
            $conn->close();
            return;
        }
    }
}
