<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class CLUSTERS_ADMIN
{
    public static function CheckClusterForDownGrade($domainID, $currentPlan, $newPlan)
    {

        if (isset(ReturnPlans()[$currentPlan]["cluster"])) {
            if (!isset(ReturnPlans()[$newPlan]["cluster"])) {
                $sql = "SELECT * FROM tbl_domains,`tbl_clusters` WHERE cl_domain_id_fk=domain_id and domain_id=" . $domainID;
                $conn = GetConnection();
                $result = $conn->query($sql);
                if (!$result || mysqli_num_rows($result) == 0) {
                    $listOfRecordType = ["status" => "success"];
                    $conn->close();
                } else {
                    $r = mysqli_fetch_all($result, MYSQLI_ASSOC);

                    $conn->close();
                    return ["status" => "error", "message" => "شما برای این دامنه کلاستر ایجاد نموده اید"];
                }
                return ["status" => "success"];
            }
        }
        return ["status" => "success"];
    }
    public static function CheckClusterIsInUse($clusterid)
    {
        //LEVEL1 CHECK FOR WEBSITE
        $sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain from tbl_clusters_websites,tbl_websites,tbl_domains,tbl_clusters
         WHERE cw_cl_id_fk=" . $clusterid . " AND domain_id=ws_domainid_fk and cw_ws_id_fk=wsid and cl_domain_id_fk=domain_id and cluster_id=cw_cl_id_fk  ";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain from tbl_subfolder,tbl_websites,tbl_domains,tbl_clusters
         WHERE sf_cl_id_fk=" . $clusterid . " AND domain_id=ws_domainid_fk and sf_ws_id_fk=wsid and cl_domain_id_fk=domain_id and cluster_id=sf_cl_id_fk ";
            $result2 = $conn->query($sql2);
            if (!$result2 || mysqli_num_rows($result2) == 0) {
                $output = ["status" => "notinuse"];
            } else {
                $output = ["status" => "inuse", "type" => "subfolder", "data" => mysqli_fetch_all($result2, MYSQLI_ASSOC)];
            }
        } else {
            $sql2 = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain from tbl_subfolder,tbl_websites,tbl_domains,tbl_clusters
               WHERE sf_cl_id_fk=" . $clusterid . " AND domain_id=ws_domainid_fk and sf_ws_id_fk=wsid and cl_domain_id_fk=domain_id and cluster_id=sf_cl_id_fk ";
            $result2 = $conn->query($sql2);
            if (!$result2 || mysqli_num_rows($result2) == 0) {
                $output = ["status" => "inuse", "type" => "website", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
            } else {
                $output = ["status" => "inuse", "type" => "website", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC), "subfolder" => mysqli_fetch_all($result2, MYSQLI_ASSOC)];
                // $output = ["status" => "inuse", "type" => "subfolder", "data" => mysqli_fetch_all($result2, MYSQLI_ASSOC)];
            }
            // $output = ["status" => "inuse", "type" => "website", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $conn->close();
        return $output;
    }
    public static function DeleteCluster($token, $clusterid)
    {
        //Check cluster is in use
        if (CLUSTERS_ADMIN::CheckClusterIsInUse($clusterid)["status"] == "inuse") {
            return ["status" => "error", "message" => "کلاستر درخواستی شما در سایتی در حال استفاده است و امکان حذف آن نیست"];
        }
        // REMOVE CLUSTERDETAILS
        $clusterlist = CLUSTERSDETAILS_ADMIN::Clusterdetailswithlist($clusterid);
        if (array_key_exists("data", $clusterlist)) {
            foreach ($clusterlist["data"] as $c) {
                CLUSTERSDETAILS_ADMIN::DeleteClusterDetails($token, $c["id"], $clusterid);
            }
        }

        $sql = "DELETE FROM " . $GLOBALS["clusters_tablename"] . " WHERE " . $GLOBALS['cluster_id'] . "=" . $clusterid;

        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();

        return ["status" => "success", "message" => "اطلاعات با موفقیت حذف شد"];
    }
    public static function CheckClusterIsInUseForWebsite($clusterid, $websiteid)
    {
        //LEVEL1 CHECK FOR WEBSITE
        $sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain from tbl_clusters_websites,tbl_websites,tbl_domains,tbl_clusters
         WHERE cw_cl_id_fk=" . $clusterid . " AND domain_id=ws_domainid_fk and cw_ws_id_fk=wsid and cl_domain_id_fk=domain_id and cluster_id=cw_cl_id_fk";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain from tbl_subfolder,tbl_websites,tbl_domains,tbl_clusters
        WHERE sf_cl_id_fk=" . $clusterid . " AND domain_id=ws_domainid_fk and sf_ws_id_fk=wsid and cl_domain_id_fk=domain_id and cluster_id=sf_cl_id_fk";
            $result2 = $conn->query($sql2);
            if (!$result2 || mysqli_num_rows($result2) == 0) {
                $output = ["status" => "notinuse"];
            } else {
                $output = ["status" => "inuse", "type" => "subfolder", "data" => mysqli_fetch_all($result2, MYSQLI_ASSOC)];
            }
        } else {
            $output = ["status" => "inuse", "type" => "website", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $conn->close();
        return $output;
    }
    public static function CheckClusterIsInUseForWebsiteForSubFolderwithoutOwn($clusterid, $websiteid, $subfolderid)
    {
        //LEVEL1 CHECK FOR WEBSITE
        $sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain from tbl_clusters_websites,tbl_websites,tbl_domains,tbl_clusters
             WHERE cw_cl_id_fk=" . $clusterid . " AND domain_id=ws_domainid_fk and cw_ws_id_fk=wsid and cl_domain_id_fk=domain_id and cluster_id=cw_cl_id_fk and subfolder_id!=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain from tbl_subfolder,tbl_websites,tbl_domains,tbl_clusters
            WHERE sf_cl_id_fk=" . $clusterid . " AND domain_id=ws_domainid_fk and sf_ws_id_fk=wsid and cl_domain_id_fk=domain_id and cluster_id=sf_cl_id_fk and wsid=" . $websiteid . " AND subfolder_id!=" . $subfolderid;
            $result2 = $conn->query($sql2);
            if (!$result2 || mysqli_num_rows($result2) == 0) {
                $output = ["status" => "notinuse"];
            } else {
                $output = ["status" => "inuse", "type" => "subfolder", "data" => mysqli_fetch_all($result2, MYSQLI_ASSOC)];
            }
        } else {
            $output = ["status" => "inuse", "type" => "website", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $conn->close();
        return $output;
    }
    public static function CheckClusterIsInUseForWebsiteForSubFolder($clusterid, $websiteid)
    {
        //LEVEL1 CHECK FOR WEBSITE
        $sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain from tbl_clusters_websites,tbl_websites,tbl_domains,tbl_clusters
             WHERE cw_cl_id_fk=" . $clusterid . " AND domain_id=ws_domainid_fk and cw_ws_id_fk=wsid and cl_domain_id_fk=domain_id and cluster_id=cw_cl_id_fk  and ";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain from tbl_subfolder,tbl_websites,tbl_domains,tbl_clusters
            WHERE sf_cl_id_fk=" . $clusterid . " AND domain_id=ws_domainid_fk and sf_ws_id_fk=wsid and cl_domain_id_fk=domain_id and cluster_id=sf_cl_id_fk and wsid=" . $websiteid;
            $result2 = $conn->query($sql2);
            if (!$result2 || mysqli_num_rows($result2) == 0) {
                $output = ["status" => "notinuse"];
            } else {
                $output = ["status" => "inuse", "type" => "subfolder", "data" => mysqli_fetch_all($result2, MYSQLI_ASSOC)];
            }
        } else {
            $output = ["status" => "inuse", "type" => "website", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $conn->close();
        return $output;
    }
    public static function UpdateAPI($clusterid, $clname, $protocols, $method, $value)
    {
        if (CLUSTERS_ADMIN::CheckClusterIsInUse($clusterid)["status"] == "inuse") {
            $cldet = CLUSTERS_ADMIN::ClusterOneWithoutToken($clusterid)($clusterid);
            //  $dmn=TOOLS_ADMIN::ReturnDomainName($websiteaccess);
        }
    }
    public static function AddClustersToPool($token, $clname, $protocols, $method, $domainid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $clusterNameChecked = CLUSTERS_ADMIN::CheckDuplicateName($token, $clname, $domainid);
        if ($clusterNameChecked["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", CLUSTERS_ADMIN::CheckDuplicateName($token, $clname, $domainid), "message" =>
            "نام کلاستر درخواستی شما تکراری است"];
        }
        $validmethod = ["least_conn", "ip_hash", "round_robin"];
        if (!in_array(strtolower($method), $validmethod)) {
            return [
                "status" => "error",
                "message" => "مقدار ارسالی برای متد نامعتبر است"
            ];
        }


        $uid = $usersDetails["userdetail"][0]["uid"];
        $daccess = DOMAINS_ADMIN::CheckDomainOwnerID($domainid, $uid);

        $planwebsite = $daccess["data"][0]["d_plan"];
        $plans = ReturnPlans();
        if (isset($plans[$planwebsite])) {
            if (isset($plans[$planwebsite]["cluster"])) {
                if (intVal($plans[$planwebsite]["cluster"]) < intVal($clusterNameChecked["countofRec"]) + 1) {
                    return ["status" => "error", "message" => "شما استفاده از کلاسترینگ  را ندارید و باید پلان سایت خود را ارتقا دهید ",
                        "plans"=>CheckPlanRequest("cluster")
                    ];
                }
            } else {
                return ["status" => "error", "message" => "شما استفاده از کلاسترینگ  را ندارید و باید پلان سایت خود را ارتقا دهید ",
                    "plans"=>CheckPlanRequest("cluster")
                ];
            }
        } else {
            return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
        }
        if (intVal($clusterNameChecked["countofRec"]) + 1 > 20) {
            return ["status" => "error", "message" => "شما امکان افزودن کلاستر جدید ندارید"];
        }
        $sql = "INSERT INTO " . $GLOBALS["clusters_tablename"] . " (" .
            $GLOBALS['cl_name'] . "," . $GLOBALS['cl_uid_fk'] . "," . $GLOBALS['cl_protocol'] . "," . $GLOBALS['cl_method'] . "," . $GLOBALS['cl_domain_id_fk'] . ") VALUES(
             '%s',%s,'%s','%s','%s')";

        $sql = sprintf($sql, $clname, $uid, $protocols, $method, $domainid);

        $conn = GetConnection();
        $result = $conn->query($sql);

        $listOfRecordType = ["status" => "success", "message" =>
        "کلاستر شما با موفقیت افزوده شد", "id" => $conn->insert_id];
        $conn->close();
        // $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
        return $listOfRecordType;
    }
    public static function GetCountOfRecord($domainid)
    {
        $sql = "SELECT count(cluster_id) as cnt from " . $GLOBALS["clusters_tablename"]
            . " WHERE " . $GLOBALS["cl_domain_id_fk"] . "=" . $domainid;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);

        return $listOfRecordType[0]["cnt"];
    }
    public static function Clusterlist($token, $websiteid, $countofrecord, $page)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $countOfRecord = self::GetCountOfRecord($uid);
        $fsr = ($page - 1) * $countofrecord;
        $enr = $page * $countofrecord;
        $countOfpageRecordInPage = $countofrecord;
        $a = $countOfRecord / $countOfpageRecordInPage;

        if ($countOfRecord > $countofrecord) {
            $countofpage = intdiv($countOfRecord, $countOfpageRecordInPage);
            if (!is_int($a))
                $countofpage = $countofpage + 1;
        } else {
            $countofpage = 1;
        }

        $sql = "SELECT cluster_id as id,cl_protocol as protocol ,cl_method as method  ,cl_name as name from " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . " AND " .
            $GLOBALS['cl_domain_id_fk'] . "=" . $websiteid .
            " LIMIT " . $fsr . "," . $countofrecord;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);

            $result = ["status" => "error", "message" => "شما هنوز کلاستری ایجاد نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            // VARS_ADMIN::ReturnHeaders(200);
            $m = [];
            for ($i = 0; $i < count($list); $i++) {
                $m[$i] = $list[$i];
                $m[$i]["subcluster"] = CLUSTERSDETAILS_ADMIN::Clusterdetailswithlist($list[$i]["id"], $list[$i]["protocol"]);
            }

            $listOfRecordType = [
                "status" => "success",
                "currentpage" => $page,
                "countofpage" => $countofpage,
                "countofrecord" => $countofrecord,
                "message" => "اطلاعات با موفقیت دریافت شد", "data" => $m
            ];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckDuplicateName($token, $clname, $did = 0)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT *,(SELECT count(cluster_id) as countofRecrod from tbl_clusters where " . $GLOBALS['cl_domain_id_fk'] . "=" . $did . ") as countofRec from " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_domain_id_fk'] . "=" . $did . " AND " . $GLOBALS['cl_name'] . "='" . $clname . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);

            $result = ["status" => "success", "countofRec"=>"0"];

        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $result = ["status" => "error","countofRec"=> self::GetCountOfRecord($did)];
        }

        $conn->close();
        return $result;
    }
    public static function CheckDuplicateNameWithoutOwn($uid, $clname, $id)
    {

        $sql = "SELECT * FROM " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cl_name'] . "='" . $clname . "' AND " .
            $GLOBALS['cluster_id'] . "!=" . $id;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);

            $result = ["status" => "success"];
            return $result;
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function CheckUserCanAccessToCluster($token, $id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "success", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT cl_name as name,cl_protocol as protocol,cl_method as method  from " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . " AND " . $GLOBALS['cluster_id'] . "=" . $id;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "success"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $cldt = CLUSTERSDETAILS_ADMIN::Clusterdetailswithlist($id);

            $result = ["status" => "error", "data" => ["cluster" => $list, "details" => $cldt]];
        }

        $conn->close();
        return $result;
    }
    public static function UpdateClusters($token, $id, $clname, $protocols, $method)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $cluster = CLUSTERS_ADMIN::CheckClusterIsInUse($id);
        $clusterDet = CLUSTERSDETAILS_ADMIN::GetClusterWithDetails($token, $id);

        //  if(CLUSTERS_ADMIN::CheckDuplicateNameWithoutOwn($uid,$clname,$id)["status"]=="error"){
        //      // VARS_ADMIN::ReturnHeaders(400);
        //      return ["status"=>"error","message"=>
        //      "نام کلاستر شما تکراری است"
        //      ,$clusterDet];
        //  }
        $sql = "UPDATE " . $GLOBALS["clusters_tablename"] . " SET " .
            $GLOBALS['cl_protocol'] . "='%s'," . $GLOBALS['cl_method'] . "='%s' WHERE " . $GLOBALS['cl_uid_fk'] . "=%s and " . $GLOBALS['cluster_id'] . "=" . $id;

        $sql = sprintf($sql, $protocols, $method, $uid);

        $conn = GetConnection();
        $result = $conn->query($sql);
        // VARS_ADMIN::ReturnHeaders(200);
        $listOfRecordType = ["status" => "success", $method, "message" =>
        "کلاستر شما با موفقیت ویرایش شد"];
        $cls = CLUSTERS_ADMIN::CheckClusterIsInUse($id);
        $m = "";
        if ($cls["status"] == "inuse") {
            foreach ($cls["data"] as $l) {
                $dmn = TOOLS_ADMIN::ReturnDomainNameForCluster($l);
                $outValue = "";
                foreach ($clusterDet["subcluster"] as $m) {
                    $outValue .=  $m["weight"] . "-" . $m["source"] . "-" . $m["port"] . ";";
                }
                $det = substr($outValue, 0, -1);

                API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $l["cl_name"], $det, $l["cl_method"], $l["cl_protocol"]);
            }
        }

        $conn->close();
        return  $listOfRecordType;
    }
    public static function ClusterOneWithoutToken($clusterid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cluster_id'] . "=" . $clusterid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeadersState(300);
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این کلاستر را ندارید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            // VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = ["status" => "success", "data" => $list, "details" => CLUSTERSDETAILS_ADMIN::Clusterdetailswithlist($clusterid)];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function ClusterOne($token, $clusterid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT * FROM " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . "  and " . $GLOBALS['cluster_id'] . "=" . $clusterid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeadersState(300);
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این کلاستر را ندارید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            // VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = ["status" => "success", "data" => $list, "details" => CLUSTERSDETAILS_ADMIN::Clusterdetailswithlist($clusterid)];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function ClusterGetOne($clusterid)
    {

        $sql = "SELECT * FROM " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cluster_id'] . "=" . $clusterid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeadersState(300);
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این کلاستر را ندارید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            // VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = ["status" => "success", "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneWithDetails($token, $clusterid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT * FROM " . $GLOBALS["clusters_tablename"] . " WHERE "
            . $GLOBALS['cl_uid_fk'] . "=" . $uid . "  and " . $GLOBALS['cluster_id'] . "=" . $clusterid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeadersState(300);
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این کلاستر را ندارید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            // VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = ["status" => "success", "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
}
