<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/changeresourcetohttps/changeresourcetohttps_filed_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';

class ChangeResourceToHttps_ADMIN
{

    public static function GetWebsiteChangeResourceToHttps($token, $websiteid)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "SELECT crthid as ir FROM " . $GLOBALS["changeresourcetohttps_tablename"] .
            " WHERE " . $GLOBALS["crth_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success",
                "message"=>"درخواست شما با  موفقیت انجام شد ",

                "data" => ["changeresourcetohttps" => "deactive"]
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "message"=>"درخواست شما با  موفقیت انجام شد ",
                "data" => ["changeresourcetohttps" => "active"]
            ];
            $conn->close();
        }

        return $listOfRecordType;
    }

    public static function UpdateWebsiteChangeResourceToHttps($token, $websiteid,$status="active")
    {
        if($status!="active")
            return  self::RemoveChangeResourceToHttps($token, $websiteid);

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $b=SSLWEBSITES_ADMIN::CheckWebSiteHasSSL($websiteid);
        if($b["status"]=="error"){
            return ["status" => "error", "message" => "شما SSL فعال برای این دامنه ندارید"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["changeresourcetohttps_tablename"] .
            " WHERE " . $GLOBALS["crth_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["changeresourcetohttps_tablename"] . " (" . $GLOBALS['crth_wid_fk'] . ")
                                                            VALUE (" . $websiteid . ")";

        $conn->query($ins);
        $conn->close();

        $dmn=TOOLS_ADMIN::ReturnDomainName($websitesOwner);
        API_REDIRECTSUBLINKTOHTTPS_ADMIN::RunCreateAPIREDIRECTSUBLINKTOHTTPS($dmn);
        LOGS_ADMIN::AddLog("تغییر در انتقال لینک های داخلی به https ".$dmn,$uid, 0, "", "users");

        } else {
            self::RemoveChangeResourceToHttps($token, $websiteid);
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای این بخش ایجاد نکرده اید"
            ];
        }

        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }

    public static function RemoveChangeResourceToHttps($token, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید" ];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["changeresourcetohttps_tablename"] .
            " WHERE " . $GLOBALS["crth_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای فشرده سازی ایجاد نکرده اید "
            ];
            $conn->close();
        } else {
            $sql = "DELETE  FROM " . $GLOBALS["changeresourcetohttps_tablename"]
                 . " WHERE " . $GLOBALS["crth_wid_fk"] . "=" . $websiteid;
            $result = $conn->query($sql);
            $conn->close();
            $dmn=TOOLS_ADMIN::ReturnDomainName($websitesOwner);
            API_REDIRECTSUBLINKTOHTTPS_ADMIN::RunDisableAPIREDIRECTSUBLINKTOHTTPS($dmn);
            LOGS_ADMIN::AddLog("حذف در انتقال لینک های داخلی به https ".$dmn,$uid, 0, "", "users");
            $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];

        }

        return $listOfRecordType;
    }
}
