<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/wafcustomrules/wafcustomrules_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';

class BACKENDSTATUS_ADMIN
{
    public static function ReturnServers()
    {
        $listofservers = [
            "Edge-MN01" => "http://185.49.231.2:81/status?format=json&status=down",
            "Edge-MN02" => "http://185.49.231.3:81/status?format=json&status=down",
            "Edge-TIC01" => "http://5.160.200.146:81/status?format=json&status=down",
            "Edge-TIC02" => "http://5.160.200.147:81/status?format=json&status=down",
            "Edge-AT01" => "http://62.204.61.133:81/status?format=json&status=down",
            "Edge-AT02" => "http://62.204.61.134:81/status?format=json&status=down",
            "Edge-NL01" => "http://160.20.152.108:81/status?format=json&status=down",
            "Edge-CHI01" => "http://162.251.60.138:81/status?format=json&status=down",
        ];
        return $listofservers;
    }
    public static function getDataFromServers($serverurl)
    {
        $ch = curl_init();
        $headers = array(
            'Accept: application/json',
            'Content-Type: application/json',
        );
        curl_setopt($ch, CURLOPT_URL, $serverurl);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $body = '{}';

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        // Timeout in seconds
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);

        $authToken = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $header = substr($authToken, 0, $header_size);
        $body = substr($authToken, $header_size);
        if ($httpcode != "200") {
            return
                ["servers" => ["total" => 30, "generation" => "45", "server" => []]];
        } else {
            $c = json_decode(preg_replace('/,\s*]/', ']', $body), true);

            return  $c;
        }
    }

    public static function GetDataFromDB()
    {
        $selectAll = "SELECT DISTINCT(`bl_upstreamname`),`blid`,`bl_edgeserver`,`bl_ip`,`bl_lastchecked`,`bl_status`,`bl_start` FROM `tbl_backendlog` where bl_status='Down' ORDER BY `bl_lastchecked` DESC ";
        // $selectAll = "SELECT * FROM tbl_backendlog where bl_status='Down'";
        $conn = GetConnectionLog();
        $result = $conn->query($selectAll);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "error", "state" => "201",
                "message" => "اطلاعاتی یافت نشد"
            ];
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success", "state" => "200",
                "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $list
            ];
        }
        return $listOfRecordType;
    }
    public static function RetuernDataFromServer()
    {
        $listofservers = self::ReturnServers();
        $l = [];
        foreach ($listofservers as $k => $j) {
            $l[$k] = self::getDataFromServers($j);
        }
        $i = 0;
        $g = [];
        foreach ($listofservers as $k => $j) {
            if ($i == 0) {
                // $g=$l[$k]["servers"]["server"]["upstream"];
                foreach ($l[$k]["servers"]["server"] as $p) {
                    $g[$p["upstream"] . "------" . $p["name"]]["count"] = 1;
                    $g[$p["upstream"] . "------" . $p["name"]]["servers"] = $k;
                }
            } else {
                foreach ($l[$k]["servers"]["server"] as $p) {
                    if (isset($g[$p["upstream"] . "------" . $p["name"]])) {
                        $g[$p["upstream"] . "------" . $p["name"]]["count"] = $g[$p["upstream"] . "------" . $p["name"]]["count"] + 1;
                        $g[$p["upstream"] . "------" . $p["name"]]["servers"] = $g[$p["upstream"] . "------" . $p["name"]]["servers"] . "," . $k;
                    } else {
                        $g[$p["upstream"] . "------" . $p["name"]]["count"] =  1;
                        $g[$p["upstream"] . "------" . $p["name"]]["servers"] = $k;
                    }
                }
            }
            $i++;
        }
        return $g;
    }
    public static function UpdateData()
    {
        $g = self::RetuernDataFromServer();
        $listOfRecordType = self::GetDataFromDB();
        if ($listOfRecordType["status"] == "success") {
            //CHECK AND UPDATE
            foreach ($listOfRecordType["data"] as $d) {

                if (isset($g[$d["bl_upstreamname"] . "------" . $d["bl_ip"]])) {

                    //     echo "hast>>>".$d["bl_edgeserver"]."------".$d["bl_ip"]."<br />";
                    // }else{
                    //     echo "nist>>>".$d["bl_edgeserver"]."------".$d["bl_ip"]."<br />";
                    // }
                    //UPDATE date time

                    if ($g[$d["bl_upstreamname"] . "------" . $d["bl_ip"]]["servers"] == $d["bl_edgeserver"]) {
                        // return ["bb",$d];
                        $now = date("Y-m-d H:i:s");
                        foreach (explode(",", $g[$d["bl_upstreamname"] . "------" . $d["bl_ip"]]["servers"]) as $s) {
                            $sql = "UPDATE tbl_backendlog SET bl_edgeserver='222" . $s . "',bl_ip='"
                                . $d["bl_ip"] . "',
                                       bl_lastchecked='" . $now . "' where blid='" . $d["blid"] . "'";
                            $conn = GetConnectionLog();
                            $conn->query($sql);
                            $conn->close();
                        }
                    } else {
                        // return ["aa",$d];
                        $backendSErvers = explode(",", $g[$d["bl_upstreamname"] . "------" . $d["bl_ip"]]["servers"]);
                        $DownbackendSErvers =  json_decode($d["bl_edgeserver"], true);
                        $outputArr = [];
                        // foreach ($DownbackendSErvers as $pp) {
                        //     return $pp;
                        //     // echo $pp.">>>>".json_encode($backendSErvers)."<br />";
                        //     if (!in_array($pp, $backendSErvers)) {
                        //         $kk = [];
                        //         array_push($kk, $pp);
                        //         // echo json_encode($pp,true);
                        //         // var_dump($backendSErvers);
                        //         // echo "<br />".$pp."<br />";
                        //         $now = date("Y-m-d H:i:s");
                        //         $sql = "INSERT INTO tbl_backendlog VALUES('" . self::guidv4(openssl_random_pseudo_bytes(16)) . "','12" .
                        //             json_encode($kk) . "','" . $d["bl_ip"] . "',
                        //       '" . $now . "','up','" . $now . "','" . $d["bl_upstreamname"] . "')";
                        //         $conn = GetConnectionLog();
                        //         $conn->query($sql);
                        //         $conn->close();
                        //     }
                        // }
                        $now = date("Y-m-d H:i:s");
                        $kkll = explode(",", $g[$d["bl_upstreamname"] . "------" . $d["bl_ip"]]["servers"]);
                        foreach ($kkll as $pl) {
                            $sql = "UPDATE tbl_backendlog SET bl_lastchecked='" . $now . "' where blid='" . $d["blid"] . "'";
                            $conn = GetConnectionLog();
                            $conn->query($sql);
                            $conn->close();
                        }
                    }
                    //  unset($g[$d["bl_upstreamname"] . "------" . $d["bl_ip"]]);
                } else {
                    // return ["notselected",$d,$g];
                    //set up
                    // $edgeArr=explode("------",$m);
                    $now = date("Y-m-d H:i:s");
                    // $sql = "UPDATE tbl_backendlog SET bl_status='up' where blid='" . $d["blid"] . "'";
                    $sql = "INSERT INTO tbl_backendlog VALUES('" . TOOLS_ADMIN::guidv4(openssl_random_pseudo_bytes(16)) . "','" .
                        $d["bl_edgeserver"] . "','" . $d["bl_ip"] . "',
                             '" . $now . "','up','" . $now . "','" . $d["bl_upstreamname"] . "')";
                    $conn = GetConnectionLog();
                    $conn->query($sql);
                    $conn->close();
                }
            }
        } else {
            //INSERT
            foreach ($g as $m => $n) {
                $srvs = explode(",", $n["servers"]);

                foreach ($srvs as $ss) {
                    $edgeArr = explode("------", $m);
                    $now = date("Y-m-d H:i:s");
                    $sql = "INSERT INTO tbl_backendlog VALUES('" . TOOLS_ADMIN::guidv4(openssl_random_pseudo_bytes(16)) . "','" . $ss . "','" . $edgeArr[1] . "',
            '" . $now . "','Down','" . $now . "','" . $edgeArr[0] . "')";

                    $conn = GetConnectionLog();
                    $conn->query($sql);
                    $conn->close();
                }
            }
        }
        return $g;
    }
    public static function CheckDownDomainUpstream()
    {
        $listofservers = self::ReturnServers();
        $l = [];
        foreach ($listofservers as $k => $j) {
            $l[$k] = self::getDataFromServers($j);
        }
        $i = 0;
        $g = [];
        foreach ($listofservers as $k => $j) {
            if ($i == 0) {
                // $g=$l[$k]["servers"]["server"]["upstream"];
                foreach ($l[$k]["servers"]["server"] as $p) {
                    $g[$p["upstream"] . "------" . $p["name"]]["count"] = 1;
                    $g[$p["upstream"] . "------" . $p["name"]]["servers"] = $k;
                }
            } else {
                foreach ($l[$k]["servers"]["server"] as $p) {
                    if (isset($g[$p["upstream"] . "------" . $p["name"]])) {
                        $g[$p["upstream"] . "------" . $p["name"]]["count"] = $g[$p["upstream"] . "------" . $p["name"]]["count"] + 1;
                        $g[$p["upstream"] . "------" . $p["name"]]["servers"] = $g[$p["upstream"] . "------" . $p["name"]]["servers"] . "," . $k;
                    } else {
                        $g[$p["upstream"] . "------" . $p["name"]]["count"] =  1;
                        $g[$p["upstream"] . "------" . $p["name"]]["servers"] = $k;
                    }
                }
            }
            $i++;
        }
        return $l;

        foreach ($c["servers"]["server"] as $m) {
            //print_r($m);
            // echo "<h1>".$i."</h1>";
            // echo "<br /><br />";
            // echo $m["upstream"];
            $p = explode(".", explode("_", $m["upstream"])[1]);
            // print_r($p);
            // echo "<br /><br />";
            $s = "";
            $j = count($p) - 1;
            while ($j >= 0) {
                $s = $p[$j] . "." . $s;
                // echo $p[$j];
                if (substr($s, -1) == ".")
                    $s = substr($s, 0, strlen($s) - 1);
                // echo $s."<br /><br />";
                $sql = "SELECT * FROM tbl_domains,tbl_users where d_user_id_fk=uid and d_name='" . $s . "' and d_status!=2";
                $conn = GetConnection();
                $re = $conn->query($sql);
                $list = mysqli_fetch_all($re, MYSQLI_ASSOC);
                if (count($list) == 0) {
                    // echo "<a style='color:red'>user not found</a><br />";
                } else {
                    // echo "<a style='color:green'>user found</a><br />";
                    // print_r($list);
                    break;
                }
                $j--;
                // echo  "<br /><br />";
            }
            // echo "<br /><br />";
            // echo count($p);
            // echo "<br /><br />";
            // $i++;
        }
    }
    public static function ReturnForWebsiteAPI($token, $status, $timerange, $upstreamname, $edgeservers)
    {
        $usersDetails =USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] != "success") {
            return $usersDetails;
        }

        $validstatus = ["Down", 'up'];
        if (!in_array($status, $validstatus)) {
            return ["status" => "error", $status, "message" => "خطا در وضعیت ارسالی"];
        }
        $validtimerange = ["30m" => "-30 minutes", "1h" => "-1 hours", "3h" => "-3 hours", "6h" => "-6 hours",
         "12h" => "-12 hours", "1d" => "-1 days", "1w" => "-7 days", "1m" => "-1 month"];
        if (!array_key_exists($timerange, $validtimerange)) {
            return ["status" => "error", "message" => "خطا در زمان ارسالی"];
        }
        $startdate = date("Y/m/d H:i:s", strtotime($validtimerange[$timerange]));
        $whereupstream = "";
        if ($upstreamname != "all") {
            $whereupstream  = " AND bl_upstreamname='" . $upstreamname . "'";
        }
        $whereedge = "";
        if ($edgeservers != "all") {
            $whereedge = "NOT JSON_SEARCH(`bl_edgeserver`,'all','" . $edgeservers . "' ) IS NULL";
        }
        $sql = "SELECT * ,TIMEDIFF(`bl_lastchecked`,`bl_start`) as diff FROM tbl_backendlog where bl_status='" . $status . "'
        and bl_start>'" . $startdate . "'" . $whereupstream . $whereedge . " order by bl_lastchecked DESC";
        $conn = GetConnectionLog();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "error",
                "state" => "201",
                "message" => "اطلاعاتی یافت نشد"
            ];
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $rows = [];
            $i = 0;
            foreach ($list as $l) {
                $rows[$i]["blid"] = $l["blid"];
                $rows[$i]["edge-servers"] = $l["bl_edgeserver"];
                $rows[$i]["ip"] = $l["bl_ip"];
                $rows[$i]["lastchecked"] = $l["bl_lastchecked"];
                $rows[$i]["start"] = $l["bl_start"];
                $rows[$i]["upstreamname"] = $l["bl_upstreamname"];
                $rows[$i]["times"] = $l["diff"];

                $i++;
            }

            $listOfRecordType = [
                $sql,
                "status" => "success", "state" => "200",
                "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $rows
            ];
        }
        return $listOfRecordType;
    }
    public static function ReturnAllServerDown()
    {
    }
}
